/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.CompletionStyleUtil;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.editor.completion.FunctionDeclarationInsertHandler;
import com.jetbrains.cidr.lang.editor.completion.FunctionInsertHandler;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CallableInsertUtils {
    public static final Key<Boolean> ENABLED_PLACEHOLDERS_IN_TESTS = Key.create((String)"ENABLED_PLACEHOLDERS_IN_TESTS");

    public static void moveCaretToCallableBody(InsertionContext context) {
        Document document = context.getDocument();
        Editor editor = context.getEditor();
        CodeFoldingManager foldManager = CodeFoldingManager.getInstance((Project)context.getProject());
        foldManager.updateFoldRegions(editor);
        String documentText = document.getText();
        int bodyStart = documentText.indexOf("{", context.getStartOffset());
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)context.getProject());
        pdm.commitDocument(document);
        PsiFile file = pdm.getPsiFile(document);
        if (file != null) {
            PsiElement leaf = file.findElementAt(bodyStart);
            OCBlockStatement body = (OCBlockStatement)PsiTreeUtil.getContextOfType((PsiElement)leaf, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
            OCCodeInsightUtil.selectBody(editor, body);
        }
    }

    @NotNull
    public static InsertHandler<LookupElement> createHandler(@NotNull OCFunctionSymbol symbol, @Nullable PsiElement contextExpression, @NotNull Project project) {
        if (symbol == null) {
            CallableInsertUtils.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CallableInsertUtils.$$$reportNull$$$0(1);
        }
        if (contextExpression instanceof OCDeclarator) {
            FunctionDeclarationInsertHandler handler = new FunctionDeclarationInsertHandler(symbol);
            handler.calculateInsertion(OCResolveContext.forPsi(contextExpression));
            FunctionDeclarationInsertHandler functionDeclarationInsertHandler = handler;
            if (functionDeclarationInsertHandler == null) {
                CallableInsertUtils.$$$reportNull$$$0(2);
            }
            return functionDeclarationInsertHandler;
        }
        FunctionInsertHandler handler = new FunctionInsertHandler(symbol, contextExpression);
        handler.calculateInsertion(contextExpression != null ? OCResolveContext.forPsi(contextExpression) : OCResolveContext.forSymbol(symbol, project));
        FunctionInsertHandler functionInsertHandler = handler;
        if (functionInsertHandler == null) {
            CallableInsertUtils.$$$reportNull$$$0(3);
        }
        return functionInsertHandler;
    }

    public static boolean isReplaceCompletionBeforeParen(@NotNull InsertionContext context) {
        if (context == null) {
            CallableInsertUtils.$$$reportNull$$$0(4);
        }
        boolean tabBeforePar = false;
        if (CallableInsertUtils.isReplaceCompletion(context)) {
            CharSequence chars = context.getDocument().getCharsSequence();
            tabBeforePar = chars.length() > context.getTailOffset() && chars.charAt(context.getTailOffset()) == '(';
        }
        return tabBeforePar;
    }

    public static boolean isReplaceCompletion(@NotNull InsertionContext context) {
        if (context == null) {
            CallableInsertUtils.$$$reportNull$$$0(5);
        }
        return context.getCompletionChar() == '\t';
    }

    public static void addKernel(@NotNull InsertionContext context) {
        if (context == null) {
            CallableInsertUtils.$$$reportNull$$$0(6);
        }
        Document document = context.getDocument();
        context.commitDocument();
        document.insertString(context.getTailOffset(), (CharSequence)"<<<>>>");
    }

    public static void addParensIfRequired(@NotNull InsertionContext context, @NotNull LookupElement item, boolean hasParams) {
        if (context == null) {
            CallableInsertUtils.$$$reportNull$$$0(7);
        }
        if (item == null) {
            CallableInsertUtils.$$$reportNull$$$0(8);
        }
        CommonCodeStyleSettings styleSettings = CompletionStyleUtil.getCodeStyleSettings((InsertionContext)context);
        ParenthesesInsertHandler.getInstance((boolean)hasParams, (boolean)styleSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES, (styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES && hasParams ? 1 : 0) != 0, (boolean)true, (boolean)styleSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE).handleInsert(context, item);
    }

    public static boolean shouldInsertPlaceholders(@NotNull InsertionContext context) {
        if (context == null) {
            CallableInsertUtils.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() ? context.getProject().getUserData(ENABLED_PLACEHOLDERS_IN_TESTS) == Boolean.FALSE : !PluginUtils.hasAppCode()) {
            return false;
        }
        Document document = context.getDocument();
        int offset = context.getEditor().getCaretModel().getOffset();
        return offset < document.getTextLength() && document.getCharsSequence().charAt(offset) == ')';
    }

    public static void selectFirstPlaceholderIfPresent(@NotNull InsertionContext context) {
        if (context == null) {
            CallableInsertUtils.$$$reportNull$$$0(10);
        }
        Editor editor = context.getEditor();
        Project project = context.getProject();
        context.commitDocument();
        String documentText = context.getDocument().getText();
        int firstParamStart = documentText.indexOf("<#", context.getStartOffset());
        int firstParamEnd = documentText.indexOf("#>", firstParamStart);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (firstParamStart >= 0 && firstParamEnd >= 0 && firstParamStart < context.getTailOffset()) {
            selectionModel.setSelection(firstParamStart, firstParamEnd + 2);
        }
        OCChangeUtil.reformatTextIfNotInjected(context.getFile(), context.getStartOffset(), context.getTailOffset());
        CodeFoldingManager.getInstance((Project)project).updateFoldRegions(editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/completion/CallableInsertUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/CallableInsertUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReplaceCompletionBeforeParen";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReplaceCompletion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addKernel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addParensIfRequired";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertPlaceholders";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectFirstPlaceholderIfPresent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

