/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateStreamOutputOperatorContext;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0014J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0004H\u0014J.\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0014J\b\u0010!\u001a\u00020\bH\u0014J\b\u0010\"\u001a\u00020\bH\u0014J.\u0010#\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0014J\b\u0010$\u001a\u00020\u0016H\u0014J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020\bH\u0014J\b\u0010*\u001a\u00020\bH\u0014J6\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\f\u001a\u00020\r2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0014R\u0010\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/cidr/lang/generate/actions/OCGenerateStreamOutputOperatorHandler;", "Lcom/jetbrains/cidr/lang/generate/handlers/OCCCppGenerateHandlerBase;", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol;", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol;", "Lcom/jetbrains/cidr/lang/generate/actions/OCGenerateStreamOutputOperatorContext;", "<init>", "()V", "ostreamInclude", "", "myOStreamRefType", "Lcom/jetbrains/cidr/lang/types/OCType;", "getOStreamRefType", "file", "Lcom/intellij/psi/PsiFile;", "getReplacements", "", "Lcom/jetbrains/cidr/lang/generate/OCGenerateUtil$Replacement;", "location", "Lcom/jetbrains/cidr/lang/generate/OCCaretLocation;", "actionContext", "fields", "allowEmptySelection", "", "context", "checkExistingFunctions", "", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol;", "project", "Lcom/intellij/openapi/project/Project;", "doPerformAction", "", "chosenCandidates", "", "getAllDefinedText", "getExistingTabName", "doPerformActionInCommand", "shouldAutoFixImports", "evaluateActionContext", "parent", "element", "Lcom/intellij/psi/PsiElement;", "getActionTitle", "getMembersChooserTitle", "getSelectedCandidates", "editor", "Lcom/intellij/openapi/editor/Editor;", "candidates", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nOCGenerateStreamOutputOperatorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCGenerateStreamOutputOperatorHandler.kt\ncom/jetbrains/cidr/lang/generate/actions/OCGenerateStreamOutputOperatorHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1557#2:162\n1628#2,3:163\n1755#2,3:166\n*S KotlinDebug\n*F\n+ 1 OCGenerateStreamOutputOperatorHandler.kt\ncom/jetbrains/cidr/lang/generate/actions/OCGenerateStreamOutputOperatorHandler\n*L\n113#1:162\n113#1:163,3\n123#1:166,3\n*E\n"})
public class OCGenerateStreamOutputOperatorHandler
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateStreamOutputOperatorContext> {
    @NlsSafe
    @NotNull
    private final String ostreamInclude = ApplicationManager.getApplication().isUnitTestMode() ? "\"ostream.h\"" : "<ostream>";
    @Nullable
    private OCType myOStreamRefType;

    private final OCType getOStreamRefType(PsiFile file) {
        if (this.myOStreamRefType == null) {
            OCFunctionDeclaration oCFunctionDeclaration = (OCFunctionDeclaration)PsiTreeUtil.findChildOfType((PsiElement)OCElementFactory.codeFragment("#include " + this.ostreamInclude + "\nstd::ostream& __clion_dummy_foo();", file.getProject(), (PsiElement)file, false, false), OCFunctionDeclaration.class);
            this.myOStreamRefType = oCFunctionDeclaration != null ? oCFunctionDeclaration.getReturnType() : null;
        }
        return this.myOStreamRefType;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation location, @NotNull OCGenerateStreamOutputOperatorContext actionContext, @NotNull List<? extends OCDeclaratorSymbol> fields) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        PsiFile psiFile = location.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        OCType streamRefType = this.getOStreamRefType(psiFile);
        if (streamRefType == null) {
            OCLog.LOG.warn("Unable to locate ostream");
            return CollectionsKt.emptyList();
        }
        OCCppReferenceType selfCref = OCCppReferenceType.to(((OCStructSymbol)actionContext.getParent()).getType().cloneWithConstModifier(location.getProject()));
        OCResolveContext oCResolveContext = location.createContext();
        Intrinsics.checkNotNullExpressionValue((Object)oCResolveContext, (String)"createContext(...)");
        OCResolveContext context = oCResolveContext;
        Collection<String> collection = OCNameSuggester.suggestForType(OCSymbolKind.PARAMETER, ((OCStructSymbol)actionContext.getParent()).getType(), (PsiElement)location.getFile(), "", CollectionsKt.emptyList(), context);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"suggestForType(...)");
        String string = (String)CollectionsKt.firstOrNull((Iterable)collection);
        if (string == null) {
            string = "rhs";
        }
        String varName = string;
        String streamName = OCNamingConventionUtil.applyNamingConvention("os", OCSymbolKind.PARAMETER, location.getProject());
        OCFakeFunctionSymbolBuilder builder = new OCFakeFunctionSymbolBuilder("operator<<").setReturnType(streamRefType).setContainer((OCSymbolWithQualifiedName)actionContext.getParent()).setVisibility(OCVisibility.PUBLIC).setIsFriend(true).setIsOperator(true).addParam(streamRefType, streamName).addParam(selfCref, varName);
        PsiElement element = ((OCStructSymbol)actionContext.getParent()).locateDefinition(location.getProject());
        if (element == null || !(element instanceof OCStruct)) {
            return CollectionsKt.emptyList();
        }
        StringBuilder exprBuilder = new StringBuilder();
        ((OCStructSymbol)actionContext.getParent()).processBaseClasses(context, (arg_0, arg_1) -> OCGenerateStreamOutputOperatorHandler.getReplacements$lambda$0(exprBuilder, element, varName, arg_0, arg_1));
        for (OCDeclaratorSymbol list : fields) {
            String spaceIfNotFirst = ((CharSequence)exprBuilder).length() == 0 ? "" : " ";
            exprBuilder.append(" << \"" + spaceIfNotFirst + list.getName() + ": \" << " + varName + "." + list.getName());
        }
        String expr = !(((CharSequence)exprBuilder).length() == 0) ? streamName + " " + exprBuilder + ";\n" : "";
        List<OCGenerateUtil.Replacement> list = OCCppDefinitionsUtil.getNewFunctionsReplacements(location, (OCStructLike)element, actionContext.getParent(), CollectionsKt.listOf((Object)builder.get()), CollectionsKt.listOf((Object)("{\n" + expr + "return " + streamName + ";\n}")), this.getInlinePolicy((OCCppActionContext)actionContext));
        Intrinsics.checkNotNullExpressionValue(list, (String)"getNewFunctionsReplacements(...)");
        return list;
    }

    @Override
    protected boolean allowEmptySelection(@NotNull OCGenerateStreamOutputOperatorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Collection<OCFunctionSymbol> checkExistingFunctions(@NotNull Project project, @NotNull OCCaretLocation location, @NotNull OCGenerateStreamOutputOperatorContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] objectArray = new OCStructType[]{null, ((OCStructSymbol)context.getParent()).getType()};
        List<Pair<String, OCFunctionSymbol>> list = OCResolveUtil.findExistingFunctions(project, CollectionsKt.listOf((Object)"operator<<"), CollectionsKt.listOf((Object[])objectArray), (OCSymbol)context.getParent(), OCResolveContext.forSymbol((OCSymbol)context.getParent(), project));
        Intrinsics.checkNotNullExpressionValue(list, (String)"findExistingFunctions(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((OCFunctionSymbol)it.second);
        }
        Collection collection = (List)destination$iv$iv;
        return new ArrayList(collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull OCCaretLocation location, @NotNull OCGenerateStreamOutputOperatorContext actionContext, @NotNull List<OCDeclaratorSymbol> chosenCandidates) {
        boolean bl;
        OCGenerateStreamOutputOperatorContext oCGenerateStreamOutputOperatorContext;
        block4: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
            Intrinsics.checkNotNullParameter(chosenCandidates, (String)"chosenCandidates");
            PsiElement element = ((OCStructSymbol)actionContext.getParent()).locateDefinition(project);
            if (element == null || !(element instanceof OCStruct)) {
                return;
            }
            actionContext.setDeclarationFile(((OCStruct)element).getContainingOCFile());
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((OCStruct)element).getContainingOCFile(), OCIncludeDirective.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
            Iterable iterable = collection;
            oCGenerateStreamOutputOperatorContext = actionContext;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String text;
                    OCIncludeDirective it = (OCIncludeDirective)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it.getReferenceText(), (String)"getReferenceText(...)");
                    if (!(Intrinsics.areEqual((Object)text, (Object)"ostream") || Intrinsics.areEqual((Object)text, (Object)"iostream") || ApplicationManager.getApplication().isUnitTestMode() && Intrinsics.areEqual((Object)text, (Object)"ostream.h"))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean bl3 = bl;
        oCGenerateStreamOutputOperatorContext.setHasRequiredIncludes(bl3);
        super.doPerformAction(project, location, (OCCppActionContext)actionContext, chosenCandidates);
    }

    @Override
    @NotNull
    protected String getAllDefinedText() {
        String string = OCBundle.message("generate.stream.output.usages.all.defined", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    protected String getExistingTabName() {
        String string = OCBundle.message("generate.stream.output.usages.existing.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    protected void doPerformActionInCommand(@NotNull Project project, @NotNull OCCaretLocation location, @NotNull OCGenerateStreamOutputOperatorContext actionContext, @NotNull List<OCDeclaratorSymbol> chosenCandidates) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter(chosenCandidates, (String)"chosenCandidates");
        super.doPerformActionInCommand(project, location, (OCCppActionContext)actionContext, chosenCandidates);
        OCFile f = actionContext.getDeclarationFile();
        if (f != null && !actionContext.getHasRequiredIncludes()) {
            ApplicationManager.getApplication().runWriteAction(() -> OCGenerateStreamOutputOperatorHandler.doPerformActionInCommand$lambda$3(project, f, this));
        }
    }

    @Override
    protected boolean shouldAutoFixImports() {
        return false;
    }

    @Override
    @NotNull
    protected OCGenerateStreamOutputOperatorContext evaluateActionContext(@NotNull OCStructSymbol parent, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new OCGenerateStreamOutputOperatorContext(parent, element);
    }

    @Override
    @NotNull
    protected String getActionTitle() {
        String string = OCBundle.message("generate.stream.output.action.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    protected String getMembersChooserTitle() {
        String string = OCBundle.message("generate.stream.output.member.chooser.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    protected List<OCDeclaratorSymbol> getSelectedCandidates(@NotNull OCGenerateStreamOutputOperatorContext actionContext, @Nullable Editor editor, @NotNull PsiFile file, @NotNull List<? extends OCDeclaratorSymbol> candidates) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        return candidates;
    }

    private static final boolean getReplacements$lambda$0(StringBuilder $exprBuilder, PsiElement $element, String $varName, OCSymbol symbol, OCVisibility oCVisibility) {
        if (((CharSequence)$exprBuilder).length() > 0) {
            $exprBuilder.append(" << ' '");
        }
        String name = symbol.getType().getBestNameInContext($element);
        $exprBuilder.append(" << ").append("static_cast<const " + name + " &>(" + $varName + ")");
        return true;
    }

    private static final void doPerformActionInCommand$lambda$3(Project $project, OCFile $f, OCGenerateStreamOutputOperatorHandler this$0) {
        PsiDocumentManager.getInstance((Project)$project).commitAllDocuments();
        OCImportSymbolFix.addImportToFile($f, "#include " + this$0.ostreamInclude, OCImportSymbolFix.ImportStyle.INCLUDE, $f.getTextRange().getEndOffset());
    }
}

