/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.jetbrains.cidr.lang.OCLog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/AppCodeModuleErrorsTestChecker;", "", "<init>", "()V", "key", "Lcom/intellij/openapi/util/Key;", "", "isDisabled", "", "checkModules", "", "project", "Lcom/intellij/openapi/project/Project;", "forceCheckModules", "registerError", "errorMessage", "disable", "testRootDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.c"})
@TestOnly
public final class AppCodeModuleErrorsTestChecker {
    @NotNull
    public static final AppCodeModuleErrorsTestChecker INSTANCE = new AppCodeModuleErrorsTestChecker();
    @NotNull
    private static final Key<String> key;
    private static volatile boolean isDisabled;

    private AppCodeModuleErrorsTestChecker() {
    }

    public final void checkModules(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (isDisabled) {
            return;
        }
        this.forceCheckModules(project);
    }

    public final void forceCheckModules(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String data = (String)project.getUserData(key);
        if (data != null) {
            System.err.println(data);
            OCLog.LOG.error("Some Xcode modules were missing in prebuilt caches");
        }
    }

    public final void registerError(@NotNull Project project, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        String previousError = (String)project.getUserData(key);
        String newError = previousError != null ? previousError + "\n-------------------------------------------------\n" + errorMessage : errorMessage;
        project.putUserData(key, (Object)newError);
    }

    public final void disable(@NotNull Disposable testRootDisposable) {
        Intrinsics.checkNotNullParameter((Object)testRootDisposable, (String)"testRootDisposable");
        isDisabled = true;
        Disposer.register((Disposable)testRootDisposable, AppCodeModuleErrorsTestChecker::disable$lambda$0);
    }

    private static final void disable$lambda$0() {
        isDisabled = false;
    }

    static {
        Key key = Key.create((String)"AppCodeReportErrorsUserDataKey");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        AppCodeModuleErrorsTestChecker.key = key;
    }
}

