/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.parser;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.editor.CidrInjectionListener;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCParser;
import com.jetbrains.cidr.lang.parser.OCPsiElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import org.jetbrains.annotations.NotNull;

public class OCParserDefinition
implements ParserDefinition {
    private static final NotNullLazyKey<PsiFile, Project> DUMMY_FILE = NotNullLazyKey.createLazyKey((String)"PARSER_DEFINITION_DUMMY", project -> OCParserDefinition.createDummyFile(project));

    @NotNull
    public Lexer createLexer(Project project) {
        PsiFile file = (PsiFile)DUMMY_FILE.getValue((UserDataHolder)project);
        OCInclusionContext context = OCInclusionContext.empty(OCLanguageKindCalculator.calculateLanguageKindFast(file), file);
        return new OCPreprocessingLexer(context, null);
    }

    @NotNull
    public PsiParser createParser(Project project) {
        OCParser oCParser = OCParser.getInstance();
        if (oCParser == null) {
            OCParserDefinition.$$$reportNull$$$0(0);
        }
        return oCParser;
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = OCTokenTypes.OC_FILE;
        if (iFileElementType == null) {
            OCParserDefinition.$$$reportNull$$$0(1);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = OCLexerTokenTypes.WHITESPACES;
        if (tokenSet == null) {
            OCParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = OCLexerTokenTypes.PSI_BUILDER_COMMENTS;
        if (tokenSet == null) {
            OCParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = OCLexerTokenTypes.ALL_STRINGS;
        if (tokenSet == null) {
            OCParserDefinition.$$$reportNull$$$0(4);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof OCPsiElementType) {
            PsiElement psiElement = ((OCPsiElementType)type).createPsi(node);
            if (psiElement == null) {
                OCParserDefinition.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        return new ASTWrapperPsiElement(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            OCParserDefinition.$$$reportNull$$$0(6);
        }
        Project project = viewProvider.getManager().getProject();
        if (LanguageUtils.getInstance().isCppSupportDisabled(project)) {
            return new PsiPlainTextFileImpl(viewProvider);
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)project).getInjectionHost(viewProvider);
        if (host != null) {
            OCCodeFragmentImpl fragment = new OCCodeFragmentImpl(viewProvider, true, (IElementType)OCElementTypes.EXPRESSION_CODE_FRAGMENT);
            ((CidrInjectionListener)project.getMessageBus().syncPublisher(CidrInjectionListener.INJECTION_TOPIC)).didInject(fragment, host);
            OCCodeFragmentImpl oCCodeFragmentImpl = fragment;
            if (oCCodeFragmentImpl == null) {
                OCParserDefinition.$$$reportNull$$$0(7);
            }
            return oCCodeFragmentImpl;
        }
        return new OCFileImpl(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, @NotNull ASTNode right) {
        if (right == null) {
            OCParserDefinition.$$$reportNull$$$0(8);
        }
        IElementType typeLeft = OCElementUtil.getElementType(left);
        IElementType typeRight = OCElementUtil.getElementType(right);
        if (OCLexerTokenTypes.DIRECTIVES.contains(typeLeft) || OCLexerTokenTypes.DIRECTIVES.contains(typeRight)) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            if (spaceRequirements == null) {
                OCParserDefinition.$$$reportNull$$$0(9);
            }
            return spaceRequirements;
        }
        if (OCLexerTokenTypes.KEYWORDS.contains(typeLeft) && OCLexerTokenTypes.KEYWORDS.contains(typeRight)) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            if (spaceRequirements == null) {
                OCParserDefinition.$$$reportNull$$$0(10);
            }
            return spaceRequirements;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            OCParserDefinition.$$$reportNull$$$0(11);
        }
        return spaceRequirements;
    }

    private static PsiFile createDummyFile(@NotNull Project project) {
        if (project == null) {
            OCParserDefinition.$$$reportNull$$$0(12);
        }
        CLanguageKind kind = CLanguageKind.maxLanguage();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        String name = "dummy." + kind.getDefaultSourceExtension();
        return factory.createFileFromText(name, LanguageUtils.getInstance().getSlowLanguage(), (CharSequence)"");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 8, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/parser/OCParserDefinition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/parser/OCParserDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "spaceExistenceTypeBetweenTokens";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDummyFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 8, 12 -> new IllegalArgumentException(string);
        };
    }
}

