/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScopeService;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangePropertyAttributeIntentionAction
extends OCQuickFix {
    @NotNull
    final Project myProject;
    private final SmartPsiElementPointer<OCProperty> myPropertyPtr;
    private OCPropertySymbol myPropertySymbol;
    private final OCPropertySymbol.PropertyAttribute myOldAttr;
    private final OCPropertySymbol.PropertyAttribute myNewAttr;
    private String myNewValue;
    private String mySubject;

    public OCChangePropertyAttributeIntentionAction(OCPropertySymbol propertySymbol, @Nullable OCPropertySymbol.PropertyAttribute oldAttr, @Nullable OCPropertySymbol.PropertyAttribute newAttr, @Nullable String newValue, @NotNull Project project) {
        if (project == null) {
            OCChangePropertyAttributeIntentionAction.$$$reportNull$$$0(0);
        }
        this.mySubject = "property";
        this.myProject = project;
        this.myPropertyPtr = null;
        this.myPropertySymbol = propertySymbol;
        this.myOldAttr = oldAttr;
        this.myNewAttr = newAttr;
        this.myNewValue = newValue;
    }

    public OCChangePropertyAttributeIntentionAction(OCPropertySymbol propertySymbol, @Nullable OCPropertySymbol.PropertyAttribute oldAttr, @Nullable OCPropertySymbol.PropertyAttribute newAttr, @Nullable String newValue, String subject, @NotNull Project project) {
        if (project == null) {
            OCChangePropertyAttributeIntentionAction.$$$reportNull$$$0(1);
        }
        this(propertySymbol, oldAttr, newAttr, newValue, project);
        this.mySubject = subject;
    }

    public OCChangePropertyAttributeIntentionAction(OCProperty property, OCPropertySymbol.PropertyAttribute oldAttr, OCPropertySymbol.PropertyAttribute newAttr) {
        this.mySubject = "property";
        this.myProject = property.getProject();
        this.myPropertyPtr = OCElementUtil.createPsiElementPointer(property);
        this.myOldAttr = oldAttr;
        this.myNewAttr = newAttr;
    }

    private OCChangePropertyAttributeIntentionAction(OCProperty property, OCPropertySymbol propertySymbol, @Nullable OCPropertySymbol.PropertyAttribute oldAttr, @Nullable OCPropertySymbol.PropertyAttribute newAttr, @Nullable String newValue, @NotNull Project project) {
        if (project == null) {
            OCChangePropertyAttributeIntentionAction.$$$reportNull$$$0(2);
        }
        this.mySubject = "property";
        this.myProject = project;
        this.myPropertyPtr = OCElementUtil.createPsiElementPointer(property);
        this.myPropertySymbol = propertySymbol;
        this.myOldAttr = oldAttr;
        this.myNewAttr = newAttr;
        this.myNewValue = newValue;
    }

    @Override
    @NlsSafe
    protected String getTextInternal() {
        String prefix;
        String string = prefix = this.myPropertySymbol != null ? "' for " + this.myPropertySymbol.getNameWithKindLowercase(OCCompilationContext.create(this.myPropertySymbol, this.myProject)) : "'";
        if (this.myOldAttr == null) {
            return "Enable attribute '" + this.myNewAttr.getTokenName() + prefix;
        }
        if (this.myNewAttr == null) {
            return "Disable attribute '" + this.myOldAttr.getTokenName() + prefix;
        }
        if (this.myNewValue != null) {
            return "Change value of attribute '" + this.myOldAttr.getTokenName() + "' to '" + this.myNewValue + "'";
        }
        return "Change " + this.mySubject + " attribute '" + this.myOldAttr.getTokenName() + "' to '" + this.myNewAttr.getTokenName() + "'";
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.change.property.attribute.action", (Object[])new Object[0]);
        if (string == null) {
            OCChangePropertyAttributeIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        OCProperty property = this.myPropertyPtr != null ? (OCProperty)this.myPropertyPtr.getElement() : null;
        OCSearchScopeService scopeService = OCSearchScopeService.getInstance(this.myProject);
        return (property != null ? scopeService.isInProjectSources(property) : scopeService.isInProjectSources(this.myPropertySymbol)) && (this.myOldAttr != this.myNewAttr || this.myNewValue != null);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            OCChangePropertyAttributeIntentionAction.$$$reportNull$$$0(4);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCProperty property = OCChangePropertyAttributeIntentionAction.findPropertyDefinition(this.myPropertyPtr, this.myPropertySymbol, project);
        if (property == null) {
            return;
        }
        if (!file.isPhysical() && file != property.getContainingFile()) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(property.getContainingFile())) {
            return;
        }
        OCPropertyAttributesList attrList = property.getPropertyAttributesList();
        OCPropertyAttributesList newAttrList = null;
        OCPropertyAttribute newAttribute = null;
        if (this.myNewAttr != null) {
            newAttrList = OCElementFactory.propertyAttributeList(this.myNewAttr, this.myNewValue, (PsiElement)file);
            newAttribute = newAttrList.getAttributes().get(0);
        }
        if (attrList == null) {
            if (this.myNewAttr != null) {
                PsiElement prevSibling;
                OCDeclaration anchor = property.getDeclaration();
                PsiElement psiElement = prevSibling = anchor != null ? anchor.getPrevSibling() : null;
                if ("IBOutlet".equals(OCElementUtil.getTextWithMacros(prevSibling))) {
                    anchor = prevSibling;
                }
                property.addBefore(newAttrList, anchor);
            }
            return;
        }
        for (OCPropertyAttribute attribute : attrList.getAttributes()) {
            if (this.myOldAttr != null && Objects.equals(attribute.getName(), this.myOldAttr.getTokenName())) {
                if (newAttribute == null) {
                    OCChangeUtil.delete(attribute);
                } else if (this.myNewValue != null) {
                    attribute.setValue(this.myNewValue);
                } else {
                    attribute.replace(newAttribute);
                }
                return;
            }
            if (this.myNewAttr == null || !Objects.equals(attribute.getName(), this.myNewAttr.getTokenName())) continue;
            return;
        }
        if (newAttribute != null) {
            OCChangeUtil.add(attrList, newAttribute);
        }
    }

    @Nullable
    private static OCProperty findPropertyDefinition(@Nullable SmartPsiElementPointer<OCProperty> propertyPtr, @Nullable OCPropertySymbol propertySymbol, @NotNull Project project) {
        OCProperty property;
        if (project == null) {
            OCChangePropertyAttributeIntentionAction.$$$reportNull$$$0(5);
        }
        OCProperty oCProperty = property = propertyPtr != null ? (OCProperty)propertyPtr.getElement() : null;
        if (property == null && propertySymbol != null) {
            property = (OCProperty)PsiTreeUtil.getParentOfType((PsiElement)propertySymbol.locateDefinition(project), OCProperty.class);
        }
        return property;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            OCChangePropertyAttributeIntentionAction.$$$reportNull$$$0(6);
        }
        PsiElement elementInCopy = this.myPropertyPtr != null ? OCInspectionUtil.findSameElementInCopy(this.myPropertyPtr, (PsiFile)target) : null;
        return elementInCopy instanceof OCProperty ? new OCChangePropertyAttributeIntentionAction((OCProperty)elementInCopy, this.myPropertySymbol, this.myOldAttr, this.myNewAttr, this.myNewValue, this.myProject) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCChangePropertyAttributeIntentionAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCChangePropertyAttributeIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

