/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExtractAssignmentIntentionAction
extends OCPsiElementQuickFix<OCExpression> {
    private final SmartPsiElementPointer<?> myLeftOperandPtr;

    public OCExtractAssignmentIntentionAction(OCExpression expression, OCExpression leftOperand) {
        super(expression);
        this.myLeftOperandPtr = OCElementUtil.createPsiElementPointer(leftOperand);
    }

    @Override
    @IntentionFamilyName
    protected String getTextInternal() {
        return OCInspectionsBundle.message((String)"intention.family.name.extract.assignment", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getTextInternal();
        if (string == null) {
            OCExtractAssignmentIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean isAvailable(@NotNull OCExpression expression) {
        OCStatement condStatement;
        if (expression == null) {
            OCExtractAssignmentIntentionAction.$$$reportNull$$$0(1);
        }
        return !((condStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, OCStatement.class)) instanceof OCLoopStatement) || OCExtractAssignmentIntentionAction.getLoopBlock(expression) != null;
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCExpression expression) {
        OCStatement condStatement;
        if (expression == null) {
            OCExtractAssignmentIntentionAction.$$$reportNull$$$0(2);
        }
        if ((condStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, OCStatement.class)) == null) {
            return;
        }
        OCBlockStatement loopBlock = OCExtractAssignmentIntentionAction.getLoopBlock(expression);
        OCExpressionStatement statement = (OCExpressionStatement)OCElementFactory.statementFromText("1;", (PsiElement)file);
        statement.getExpression().replace(expression);
        expression.replace((PsiElement)OCElementUtil.getPsiElementByPointer(this.myLeftOperandPtr));
        if (loopBlock != null) {
            OCChangeUtil.add(loopBlock, statement.copy());
        }
        condStatement = OCChangeUtil.ensureParentIsBlockStatement(condStatement);
        OCChangeUtil.addBefore(condStatement.getParent(), statement, condStatement);
    }

    @Nullable
    private static OCBlockStatement getLoopBlock(OCExpression expression) {
        OCStatement condStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, OCStatement.class);
        if (condStatement instanceof OCLoopStatement) {
            OCStatement body = ((OCLoopStatement)condStatement).getBody();
            return body instanceof OCBlockStatement ? (OCBlockStatement)body : null;
        }
        return null;
    }

    @Override
    protected boolean shouldCommitAllDocuments() {
        return false;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            OCExtractAssignmentIntentionAction.$$$reportNull$$$0(3);
        }
        PsiElement expressionElementCopy = OCInspectionUtil.findSameElementInCopy((SmartPsiElementPointer)this.myElementPtr, (PsiFile)target);
        PsiElement leftOperandCopy = OCInspectionUtil.findSameElementInCopy(this.myLeftOperandPtr, (PsiFile)target);
        if (!(expressionElementCopy instanceof OCExpression) || !(leftOperandCopy instanceof OCExpression)) {
            return null;
        }
        return new OCExtractAssignmentIntentionAction((OCExpression)expressionElementCopy, (OCExpression)leftOperandCopy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCExtractAssignmentIntentionAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCExtractAssignmentIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

