/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;

public class OCMakeFunctionVirtualFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private final boolean isPure;
    private final boolean supportsConstexprVirtual;

    public OCMakeFunctionVirtualFix(@NotNull OCFunctionSymbol symbol, boolean pure, @NotNull Project project) {
        if (symbol == null) {
            OCMakeFunctionVirtualFix.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCMakeFunctionVirtualFix.$$$reportNull$$$0(1);
        }
        super(project, symbol);
        this.isPure = pure;
        PsiFile file = symbol.getContainingPsiFile(project);
        this.supportsConstexprVirtual = OCCompilerFeaturesHelper.supportsConstexprVirtual(file);
    }

    @Override
    public boolean isAvailable() {
        boolean isConstexprConsteval;
        boolean bl = isConstexprConsteval = ((OCFunctionSymbol)this.mySymbol).isConstexpr() || ((OCFunctionSymbol)this.mySymbol).isConsteval();
        if (isConstexprConsteval && !this.supportsConstexprVirtual) {
            return false;
        }
        return super.isAvailable() && ((OCFunctionSymbol)this.mySymbol).getParent() != null && !((OCFunctionSymbol)this.mySymbol).isCppConstructor() && !((OCFunctionSymbol)this.mySymbol).isFriendOrStatic() && !((OCFunctionSymbol)this.mySymbol).isTemplateSymbol();
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message((String)"intention.name.make.function.virtual", (Object[])new Object[]{((OCFunctionSymbol)this.mySymbol).getParent().getName(), ((OCFunctionSymbol)this.mySymbol).getName(), this.isPure ? 0 : 1});
    }

    @NotNull
    public String getFamilyName() {
        String string = OCBundle.message("quickfixes.make.function.virtual", new Object[0]);
        if (string == null) {
            OCMakeFunctionVirtualFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        OCFunctionDeclaration function;
        if (project == null) {
            OCMakeFunctionVirtualFix.$$$reportNull$$$0(3);
        }
        if ((function = ((OCFunctionSymbol)this.mySymbol).locateFunctionDefinition(project)) != null) {
            int offset;
            if (this.isPure) {
                offset = function.getDeclarator().getTextRange().getEndOffset();
                OCChangeUtil.changeText(function.getProject(), function.getContainingFile(), offset, 0, "= 0", true);
            }
            if (!((OCFunctionSymbol)this.mySymbol).isVirtual()) {
                offset = function.getTextRange().getStartOffset();
                OCChangeUtil.changeText(function.getProject(), function.getContainingFile(), offset, 0, "virtual ", true);
            }
        }
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        String oldSignature;
        if (project == null) {
            OCMakeFunctionVirtualFix.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            OCMakeFunctionVirtualFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            OCMakeFunctionVirtualFix.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)(oldSignature = OCElementUtil.getSignature((OCFunctionSymbol)this.mySymbol, project)))) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                OCMakeFunctionVirtualFix.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }
        StringBuilder builder = new StringBuilder();
        if (!((OCFunctionSymbol)this.mySymbol).isVirtual()) {
            builder.append("virtual ");
        }
        builder.append(oldSignature);
        if (this.isPure) {
            builder.append("= 0");
        }
        return new IntentionPreviewInfo.CustomDiff(file.getFileType(), oldSignature, builder.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCMakeFunctionVirtualFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCMakeFunctionVirtualFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }
}

