/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.refactoring.OCUsageViewDescriptor;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCEscalateVisibilityHelper;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScopeService;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCInlineActionHandlerBase<T extends PsiNamedElement>
extends InlineActionHandler {
    public static final Key<Boolean> SILENT_MODE = Key.create((String)"SILENT_MODE");
    @NlsSafe
    protected static final String SILENT_EXIT = "SILENT_EXIT";

    public boolean isEnabledForLanguage(Language l) {
        return l instanceof OCLanguage;
    }

    public void inlineElement(Project project, Editor editor, PsiElement psiElement) {
        PsiElement selectedUsage;
        PsiReference selectedUsageRef = TargetElementUtil.findReference((Editor)editor);
        if (selectedUsageRef != null) {
            selectedUsage = selectedUsageRef.getElement();
            if (selectedUsage instanceof OCDeclarator) {
                selectedUsage = null;
            }
        } else {
            selectedUsage = null;
        }
        this.inline(this.getElementToInline(psiElement), selectedUsage, editor, project.getUserData(SILENT_MODE) == Boolean.TRUE);
    }

    protected T getElementToInline(PsiElement psiElement) {
        return (T)((PsiNamedElement)psiElement);
    }

    public void invokeSilently(@NotNull T element, PsiElement selectedUsage) {
        if (element == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(0);
        }
        this.inline(element, selectedUsage, null, true);
    }

    public void inline(@NotNull T element, PsiElement selectedUsage, @Nullable Editor editor, boolean silentMode) {
        if (element == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(1);
        }
        this.inline(element, selectedUsage, null, editor, silentMode, !silentMode);
    }

    public void inline(@NotNull T element, PsiElement selectedUsage, @Nullable PsiElement predefinedValue, @Nullable Editor editor, boolean silentMode, boolean showDialog) {
        if (element == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(2);
        }
        Project project = element.getProject();
        String elementNameWithKind = this.getElementKind(element) + " \"" + element.getName() + "\"";
        String refactoringName = OCRefactoringBundle.message("dialog.title.inline", StringUtil.capitalize((String)elementNameWithKind));
        OCSearchScopeService scopeService = OCSearchScopeService.getInstance(project);
        if (!scopeService.isInProjectSources((PsiElement)(selectedUsage != null ? selectedUsage : element))) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element.default"), (String)refactoringName, null);
            return;
        }
        GlobalSearchScope scope = scopeService.getProjectSourcesScope();
        if (selectedUsage != null) {
            PsiFile file = selectedUsage.getContainingFile();
            PsiSearchHelper.SearchCostResult enoughToSearch = PsiSearchHelper.getInstance((Project)element.getProject()).isCheapEnoughToSearch(element.getName(), scope, file);
            if (enoughToSearch == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                scope = new LocalSearchScope((PsiElement)file);
            }
        }
        List<PsiElement> usages = this.findUsagesFromReferences((PsiElement)element, (SearchScope)scope);
        ArrayList<PsiElement> usagesInCurrentFile = new ArrayList<PsiElement>();
        boolean previewMode = false;
        boolean deleteElement = true;
        Ref elementData = new Ref();
        ArrayList<String> warnings = new ArrayList<String>();
        String notValidMessage = this.checkValidness(element, usages, selectedUsage, elementNameWithKind, editor, (Ref<PsiElement>)elementData, warnings, silentMode);
        if (notValidMessage != null) {
            if (!silentMode && !notValidMessage.equals(SILENT_EXIT)) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)notValidMessage, (String)refactoringName, null);
            }
            return;
        }
        if (showDialog) {
            boolean thereIsCurrentAndOtherUsages;
            boolean bl = thereIsCurrentAndOtherUsages = this.allowInlineSingleUsage() && selectedUsage != null && selectedUsage != element && usages.size() > 1;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                String[] stringArray;
                PsiFile currentFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                for (PsiElement usage : usages) {
                    if (!usage.getContainingFile().equals(currentFile)) continue;
                    usagesInCurrentFile.add(usage);
                }
                OCInlineActionHandlerBase.highlightUsages(project, editor, usagesInCurrentFile, EditorColors.SEARCH_RESULT_ATTRIBUTES);
                String message = OCRefactoringBundle.message("question.inline.usage", usages.size(), usages.size() == 1 ? 0 : 1, elementNameWithKind);
                if (thereIsCurrentAndOtherUsages) {
                    String[] stringArray2 = new String[4];
                    stringArray2[0] = OCRefactoringBundle.message("button.inline.current.usage", new Object[0]);
                    stringArray2[1] = OCRefactoringBundle.message("button.inline.all.usages.file", scope instanceof LocalSearchScope ? 0 : 1);
                    stringArray2[2] = OCRefactoringBundle.message("button.view.usages", new Object[0]);
                    stringArray = stringArray2;
                    stringArray2[3] = OCRefactoringBundle.message("button.cancel", new Object[0]);
                } else {
                    String[] stringArray3 = new String[3];
                    stringArray3[0] = OCRefactoringBundle.message("button.inline", new Object[0]);
                    stringArray3[1] = OCRefactoringBundle.message("button.view.usages", new Object[0]);
                    stringArray = stringArray3;
                    stringArray3[2] = OCRefactoringBundle.message("button.cancel", new Object[0]);
                }
                String[] options = stringArray;
                int answer = Messages.showDialog((String)message, (String)refactoringName, (String[])options, (int)0, (Icon)Messages.getQuestionIcon(), null);
                if (answer == options.length - 1 || answer == -1) {
                    OCInlineActionHandlerBase.showHighlightRemovalStatus(project);
                    return;
                }
                if (answer == options.length - 2) {
                    previewMode = true;
                } else if (answer == 0 && options.length == 4) {
                    usages = Collections.singletonList(selectedUsage);
                    deleteElement = false;
                }
                if (selectedUsage != null && this.allowInlineSingleUsage() && scope instanceof LocalSearchScope) {
                    deleteElement = false;
                }
            } else if (thereIsCurrentAndOtherUsages) {
                usages = Collections.singletonList(selectedUsage);
                deleteElement = false;
            }
        }
        if (usages.size() > 1) {
            this.sortUsages(usages);
        }
        InlineRefactoringProcessor processor2 = new InlineRefactoringProcessor(this, refactoringName, element, predefinedValue != null ? predefinedValue : (PsiElement)elementData.get(), usages, deleteElement, warnings, silentMode);
        processor2.setPreviewUsages(previewMode);
        processor2.execute();
        if (!silentMode && processor2.getFailMessage() != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)processor2.getFailMessage(), (String)refactoringName, null);
        }
    }

    @NotNull
    protected List<PsiElement> findUsagesFromReferences(@NotNull PsiElement target, @NotNull SearchScope scope) {
        if (target == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(4);
        }
        ArrayList<PsiElement> usages = new ArrayList<PsiElement>();
        ReferencesSearch.search((PsiElement)target, (SearchScope)scope, (boolean)false).asIterable().forEach(reference -> {
            PsiElement foundElementWithRefToTarget = reference.getElement();
            if (this.isRefElementForInline(target, foundElementWithRefToTarget)) {
                usages.add(foundElementWithRefToTarget);
            }
        });
        ArrayList<PsiElement> arrayList = usages;
        if (arrayList == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    protected boolean isRefElementForInline(@NotNull PsiElement target, @NotNull PsiElement foundElementWithRefToTarget) {
        if (target == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(6);
        }
        if (foundElementWithRefToTarget == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(7);
        }
        return foundElementWithRefToTarget != target && OCSearchScope.isInProjectSources(foundElementWithRefToTarget);
    }

    protected static void showHighlightRemovalStatus(Project project) {
        WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    protected static void highlightUsages(Project project, Editor editor, List<PsiElement> usages, TextAttributesKey textAttributes) {
        UIUtil.invokeLaterIfNeeded(() -> ReadAction.run(() -> {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            highlightManager.addOccurrenceHighlights(editor, usages.toArray(PsiElement.EMPTY_ARRAY), textAttributes, true, null);
        }));
    }

    protected boolean allowInlineSingleUsage() {
        return true;
    }

    protected boolean allowNoUsages() {
        return false;
    }

    protected void sortUsages(List<PsiElement> usages) {
        usages.sort((element1, element2) -> element2.getTextOffset() - element1.getTextOffset());
    }

    @Nullable
    @NlsContexts.DialogMessage
    protected String checkValidness(@NotNull T element, @NotNull List<PsiElement> usages, @Nullable PsiElement selectedUsage, @NotNull @NlsSafe String elementNameWithKind, @Nullable Editor editor, @NotNull Ref<PsiElement> elementData, @NotNull List<String> warnings, boolean silentMode) {
        if (element == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(8);
        }
        if (usages == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(9);
        }
        if (elementNameWithKind == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(10);
        }
        if (elementData == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(11);
        }
        if (warnings == null) {
            OCInlineActionHandlerBase.$$$reportNull$$$0(12);
        }
        if (!this.allowNoUsages() && usages.isEmpty() && !silentMode) {
            return OCRefactoringBundle.message("message.never.used", StringUtil.capitalize((String)elementNameWithKind));
        }
        return null;
    }

    @Nullable
    @Nls
    protected String checkUsageValid(PsiElement usage, T element) {
        return null;
    }

    protected List<T> getElementsToWrite(T element) {
        return Collections.singletonList(element);
    }

    @NlsSafe
    protected abstract String getElementKind(T var1);

    protected abstract void inlineUsage(PsiElement var1, T var2, PsiElement var3, Project var4, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> var5);

    protected void deleteElement(T element, PsiElement elementData) {
        OCChangeUtil.delete(element);
    }

    @NotNull
    protected abstract String getFeatureID();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/inline/OCInlineActionHandlerBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundElementWithRefToTarget";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementNameWithKind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementData";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/inline/OCInlineActionHandlerBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsagesFromReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeSilently";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inline";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesFromReferences";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isRefElementForInline";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkValidness";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private final class InlineRefactoringProcessor
    extends BaseRefactoringProcessor {
        private final @NlsContexts.Command String myRefactoringName;
        private final T myElement;
        private final UsageInfo[] myUsageInfos;
        private String myFailMessage;
        private final boolean mySilentMode;
        private final boolean myDeleteElement;
        private boolean myWasConflict;
        private final PsiElement myElementData;
        private final List<String> myWarnings;
        private final Set<PsiFile> myFilesToReparse;
        final /* synthetic */ OCInlineActionHandlerBase this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private InlineRefactoringProcessor(String refactoringName, T element, PsiElement elementData, List<PsiElement> usages, boolean deleteElement, List<String> warnings, boolean silentMode) {
            this.this$0 = (OCInlineActionHandlerBase)n;
            super(element.getProject(), EmptyRunnable.INSTANCE);
            this.myFilesToReparse = new HashSet<PsiFile>();
            this.myRefactoringName = refactoringName;
            this.myElement = element;
            this.myElementData = elementData;
            this.myDeleteElement = deleteElement;
            this.mySilentMode = silentMode;
            this.myUsageInfos = new UsageInfo[usages.size()];
            this.myWarnings = warnings;
            for (int i = 0; i < this.myUsageInfos.length; ++i) {
                this.myUsageInfos[i] = new UsageInfo(usages.get(i));
            }
            this.myWasConflict = false;
        }

        @NotNull
        protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
            if (usages == null) {
                InlineRefactoringProcessor.$$$reportNull$$$0(0);
            }
            return new OCUsageViewDescriptor((PsiElement)this.myElement, OCRefactoringBundle.message("dialog.message.elements.to", this.myRefactoringName));
        }

        protected UsageInfo @NotNull [] findUsages() {
            if (this.myUsageInfos == null) {
                InlineRefactoringProcessor.$$$reportNull$$$0(1);
            }
            return this.myUsageInfos;
        }

        @NotNull
        protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
            if (descriptor == null) {
                InlineRefactoringProcessor.$$$reportNull$$$0(2);
            }
            if (this.myDeleteElement && OCSearchScopeService.getInstance(this.myProject).isInProjectSources((PsiElement)this.myElement)) {
                List list = this.this$0.getElementsToWrite(this.myElement);
                if (list == null) {
                    InlineRefactoringProcessor.$$$reportNull$$$0(3);
                }
                return list;
            }
            List list = Collections.emptyList();
            if (list == null) {
                InlineRefactoringProcessor.$$$reportNull$$$0(4);
            }
            return list;
        }

        protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
            if (refUsages == null) {
                InlineRefactoringProcessor.$$$reportNull$$$0(5);
            }
            ArrayList<UsageInfo> filteredUsages = new ArrayList<UsageInfo>();
            MultiMap conflicts = new MultiMap();
            for (String warning : this.myWarnings) {
                conflicts.putValue(this.myElement, (Object)warning);
            }
            for (UsageInfo info : (UsageInfo[])refUsages.get()) {
                PsiElement usage = info.getElement();
                String message = this.this$0.checkUsageValid(usage, this.myElement);
                if (message != null) {
                    if (((UsageInfo[])refUsages.get()).length == 1) {
                        this.myFailMessage = message;
                        return false;
                    }
                    conflicts.putValue((Object)usage, (Object)message);
                    this.myWasConflict = true;
                    continue;
                }
                if (usage == null) continue;
                if (PsiTreeUtil.getParentOfType((PsiElement)usage, OCMacroCallArgument.class) != null) {
                    this.myFilesToReparse.add(usage.getContainingFile());
                }
                filteredUsages.add(info);
            }
            refUsages.set((Object)filteredUsages.toArray(UsageInfo.EMPTY_ARRAY));
            return this.mySilentMode || this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
        }

        protected void performRefactoring(UsageInfo @NotNull [] usages) {
            if (usages == null) {
                InlineRefactoringProcessor.$$$reportNull$$$0(6);
            }
            String featureID = this.this$0.getFeatureID();
            FeatureUsageTracker.getInstance().triggerFeatureUsed(featureID);
            HashMap<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility = new HashMap<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>>();
            for (UsageInfo usage : usages) {
                this.this$0.inlineUsage(usage.getElement(), this.myElement, this.myElementData, this.myProject, elemsToEscalateVisibility);
            }
            OCEscalateVisibilityHelper.ALL_ELEMENTS_TO_ESCALATE_VISIBILITY.set((UserDataHolder)this.myProject, elemsToEscalateVisibility);
            if (this.myDeleteElement && !this.myWasConflict && OCSearchScopeService.getInstance(this.myProject).isInProjectSources((PsiElement)this.myElement)) {
                this.this$0.deleteElement(this.myElement, this.myElementData);
            }
            for (PsiFile file : this.myFilesToReparse) {
                FileSymbolTablesCache.getInstance(this.myProject).scheduleReparseFile((OCFile)file);
            }
        }

        protected void performPsiSpoilingRefactoring() {
            OCBindUtil.escalateVisibilities(this.myProject, new VirtualFile[0]);
        }

        public void execute() {
            if (this.mySilentMode) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    Ref refUsages = Ref.create((Object)this.findUsages());
                    if (this.preprocessUsages((Ref<UsageInfo[]>)refUsages)) {
                        this.performRefactoring((UsageInfo[])refUsages.get());
                    }
                });
            } else {
                this.run();
            }
        }

        @NotNull
        protected String getCommandName() {
            String string = this.myRefactoringName;
            if (string == null) {
                InlineRefactoringProcessor.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NlsSafe
        public String getFailMessage() {
            return this.myFailMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 4, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/inline/OCInlineActionHandlerBase$InlineRefactoringProcessor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/inline/OCInlineActionHandlerBase$InlineRefactoringProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findUsages";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsToWrite";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createUsageViewDescriptor";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementsToWrite";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "preprocessUsages";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "performRefactoring";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 4, 7 -> new IllegalStateException(string);
            };
        }
    }
}

