/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.OCUniqueNameGenerator;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineLocalVarHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInlineMethodHandler
extends OCInlineActionHandlerBase<OCCallable> {
    @Override
    protected String getElementKind(OCCallable element) {
        return element.getKind().toStringLowercase();
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof OCCallable || element instanceof OCDeclarator && element.getParent() instanceof OCFunctionDeclaration;
    }

    @Override
    protected OCCallable getElementToInline(PsiElement psiElement) {
        OCSymbol symbol;
        OCCallable oCCallable = psiElement = psiElement instanceof OCCallable ? (OCCallable)psiElement : (OCCallable)psiElement.getParent();
        if (((OCCallable)psiElement).getBody() == null && (symbol = ((OCCallable)psiElement).getSymbol()) != null && symbol.isPredeclaration()) {
            PsiElement definition;
            Project project = psiElement.getProject();
            OCSymbol definitionSymbol = symbol.getDefinitionSymbol(project);
            PsiElement psiElement2 = definition = definitionSymbol != null ? definitionSymbol.locateDefinition(project) : null;
            if (definition instanceof OCMethod) {
                return (OCCallable)definition;
            }
            if (definition instanceof OCDeclarator) {
                return (OCCallable)definition.getParent();
            }
        }
        return (OCCallable)psiElement;
    }

    @Override
    protected boolean isRefElementForInline(@NotNull PsiElement target, @NotNull PsiElement foundElementWithRefToTarget) {
        if (target == null) {
            OCInlineMethodHandler.$$$reportNull$$$0(0);
        }
        if (foundElementWithRefToTarget == null) {
            OCInlineMethodHandler.$$$reportNull$$$0(1);
        }
        return target instanceof OCMethod ? foundElementWithRefToTarget != target : super.isRefElementForInline(target, foundElementWithRefToTarget);
    }

    @Override
    protected String checkValidness(@NotNull OCCallable callable, @NotNull List<PsiElement> usages, PsiElement selectedUsage, @NotNull String elementNameWithKind, Editor editor, @NotNull Ref<PsiElement> elementData, @NotNull List<String> warnings, boolean silentMode) {
        if (callable == null) {
            OCInlineMethodHandler.$$$reportNull$$$0(2);
        }
        if (usages == null) {
            OCInlineMethodHandler.$$$reportNull$$$0(3);
        }
        if (elementNameWithKind == null) {
            OCInlineMethodHandler.$$$reportNull$$$0(4);
        }
        if (elementData == null) {
            OCInlineMethodHandler.$$$reportNull$$$0(5);
        }
        if (warnings == null) {
            OCInlineMethodHandler.$$$reportNull$$$0(6);
        }
        if (callable.getKind() == OCCallableKind.BLOCK) {
            return OCRefactoringBundle.message("dialog.message.cannot.inline.blocks", new Object[0]);
        }
        if (callable.getBody() == null) {
            if (callable instanceof OCMethod) {
                OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)callable, OCClassDeclaration.class);
                if (clazz instanceof OCProtocol) {
                    return OCRefactoringBundle.message("dialog.message.cannot.inline.protocol.method", new Object[0]);
                }
                if (clazz instanceof OCInterface) {
                    return OCRefactoringBundle.message("dialog.message.interface.was.not.implemented", elementNameWithKind);
                }
            }
            if (callable.getBody() == null) {
                return OCRefactoringBundle.message("dialog.message.cannot.inline.with.empty.body", callable.getKind().toStringLowercase());
            }
        }
        if (usages.isEmpty() && !silentMode) {
            return OCRefactoringBundle.message("dialog.message.there.are.no.calls.in.project", elementNameWithKind);
        }
        OCInlineMethodHandler.checkMethodsHierarchy(callable, elementNameWithKind, warnings);
        return OCInlineMethodHandler.checkBadReturns(callable);
    }

    @Override
    protected String checkUsageValid(PsiElement usage, OCCallable element) {
        if (usage instanceof OCSelectorExpression) {
            return OCRefactoringBundle.message("cannot.inline.method.reference.in.selector.expression", new Object[0]);
        }
        if (usage instanceof XmlElement) {
            return OCRefactoringBundle.message("cannot.inline.method.reference.in.xml.file", new Object[0]);
        }
        if (usage instanceof OCPropertyAttribute) {
            return OCRefactoringBundle.message("cannot.inline.method.reference.in.property.attribute", new Object[0]);
        }
        if (usage instanceof OCReferenceElement && !(usage.getParent().getParent() instanceof OCCallExpression)) {
            return OCRefactoringBundle.message("cannot.inline.function.reference.in.non.call.expression", new Object[0]);
        }
        if ("Swift".equals(usage.getLanguage().getDisplayName())) {
            return OCRefactoringBundle.message("cannot.inline.usage.in.swift.code", new Object[0]);
        }
        if (PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)usage, (boolean)true)) {
            return OCRefactoringBundle.message("cannot.inline.recursive", element.getKind().toStringLowercase());
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    @NlsContexts.DialogMessage
    private static String checkBadReturns(OCCallable callable) {
        final String message = OCRefactoringBundle.message("dialog.message.cannot.inline.methods.with.return.statements.interrupting.execution.flow", new Object[0]);
        final @NlsContexts.DialogMessage Ref error = new Ref();
        OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer((PsiElement)callable, (TextRange)null);
        analyzer.buildControlFlowGraph();
        if (analyzer.getUnreachableCodeFinder().isDeadEndReached() && analyzer.getUnreachableCodeFinder().isReturnReached()) {
            return message;
        }
        new OCDataFlowAlgorithm(analyzer.getGraph()){

            @Override
            public void process() {
                for (OCNode node : this.myCfg.getExitNodes()) {
                    OCNode nodeAfterReturn = node.getNodeAfterReturn();
                    if (nodeAfterReturn == null) continue;
                    this.traverse(nodeAfterReturn, null, null, true);
                }
            }

            @Override
            protected boolean processNode(@NotNull OCNode node, OCSymbol symbol, boolean isForward, @Nullable OCInstruction startInstruction, OCInstruction endInstruction) {
                OCElementsRange range;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((range = node.getRange()) != null && !range.isEmpty()) {
                    error.set((Object)message);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/refactoring/inline/OCInlineMethodHandler$1", "processNode"));
            }
        }.process();
        return (String)error.get();
    }

    @Override
    protected void inlineUsage(PsiElement usage, OCCallable callable, PsiElement elementData, Project project, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        TextRange callableRange = callable.getTextRange();
        PsiFile fileCopy = (PsiFile)callable.getContainingFile().copy();
        OCSymbol symbol = callable.getSymbol();
        OCCallable callableCopy = (OCCallable)OCCodeInsightUtil.findElementAtRange(fileCopy, callableRange, callable.getClass(), true);
        List<PsiNamedElement> parameters = callableCopy.getParameters();
        Map<PsiNamedElement, List<PsiElement>> declaratorUsages = OCCodeInsightUtil.collectDeclarators(callableCopy).stream().collect(Collectors.toMap(declarator -> declarator, declarator -> OCCodeInsightUtil.getReferences(declarator)));
        boolean isDotCall = callable instanceof OCFunctionDeclaration && usage instanceof OCQualifiedExpression && ((OCQualifiedExpression)usage).getQualifyingTokenKind() == OCLexerTokenTypes.DOT;
        OCBindUtil.encodeContextInfo(callableCopy.getBody(), false);
        OCBindUtil.insertRedundantQualifiers(callableCopy.getBody(), isDotCall);
        OCExpression usageExpr = OCInlineMethodHandler.getCallExpression(usage);
        OCStatement anchor = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)usageExpr, OCStatement.class);
        if (anchor == null) {
            return;
        }
        TextRange usageRange = usageExpr.getTextRange().shiftRight(-anchor.getTextOffset());
        anchor = OCChangeUtil.ensureParentIsBlockStatement(anchor);
        usageExpr = (OCExpression)OCCodeInsightUtil.findElementAtRange(anchor.getContainingFile(), usageRange.shiftRight(anchor.getTextOffset()), usageExpr.getClass(), true);
        PsiElement parent = anchor.getParent();
        List<OCExpression> arguments = OCInlineMethodHandler.getArguments(usageExpr);
        OCExpression receiver = OCInlineMethodHandler.getReceiverExpression(usageExpr);
        boolean receiverHasSideEffects = receiver != null && OCCodeInsightUtil.hasSideEffects(receiver);
        ArrayList<OCDeclarator> newParamDeclarators = new ArrayList<OCDeclarator>();
        OCBlockStatement body = callableCopy.getBody();
        assert (body != null);
        assert (parameters != null);
        assert (parameters.size() >= arguments.size());
        if (callable instanceof OCMethod && !((OCMethod)callable).isInstanceMethod() && receiver != null) {
            OCSendMessageExpression classExpr = OCElementFactory.sendMessageExpression(Collections.singletonList("class"), usage);
            OCChangeUtil.replaceHandlingMacros(classExpr.getReceiverExpression(), receiver);
            receiver = classExpr;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            OCExpression argument;
            PsiNamedElement parameter = parameters.get(i);
            if (i < arguments.size()) {
                argument = arguments.get(i);
            } else if (parameter instanceof OCDeclarator && ((OCDeclarator)parameter).getInitializer() != null) {
                argument = ((OCDeclarator)parameter).getInitializer();
            } else {
                Ref argumentRef = Ref.create();
                int paramIndex = i;
                if (symbol instanceof OCFunctionSymbol) {
                    symbol.processAssociatedSymbols((Processor<OCSymbol>)((Processor)s -> {
                        List<OCDeclarator> params;
                        OCFunctionDeclaration definition;
                        OCFunctionDeclaration oCFunctionDeclaration = definition = s instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s).locateFunctionDefinition(project) : null;
                        if (definition != null && (params = definition.getParameters()) != null && paramIndex < params.size()) {
                            argumentRef.set((Object)params.get(paramIndex).getInitializer());
                            return argumentRef.isNull();
                        }
                        return true;
                    }), project);
                }
                if (argumentRef.isNull()) break;
                argument = (OCExpression)argumentRef.get();
            }
            OCType paramType = parameter instanceof OCDeclarator ? ((OCDeclarator)parameter).getType() : ((OCMethodSelectorPart)parameter).getType();
            OCDeclarator declarator2 = OCInlineMethodHandler.addVariable("<unnamed>".equals(parameter.getName()) ? "param" : parameter.getName(), paramType, argument, parent, anchor);
            if (!OCCodeInsightUtil.hasSideEffects(argument)) {
                newParamDeclarators.add(declarator2);
            }
            OCCodeInsightUtil.renameDeclaratorAndUsages(parameter, declarator2.getName(), declaratorUsages.get(parameter));
        }
        OCInlineMethodHandler.assignTemplateParameters(callableCopy, usageExpr, anchor, parent, declaratorUsages, newParamDeclarators);
        OCDeclarator receiverDeclarator = receiver != null ? OCInlineMethodHandler.addVariable("receiver", receiver.getResolvedType().getGuessedType(), receiver, parent, anchor) : null;
        OCDeclarator resultDeclarator = !callable.getReturnType().resolve(parent).isVoid() ? OCInlineMethodHandler.addVariable("result", callable.getReturnType(), null, parent, anchor) : null;
        String resultName = resultDeclarator != null ? resultDeclarator.getName() : "nullResult";
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        HashSet<PsiElement> elementsInBlocks = new HashSet<PsiElement>();
        OCInlineMethodHandler.collectElements(body, elements, elementsInBlocks);
        for (PsiElement psiElement : elements) {
            OCSymbol sym;
            if (psiElement instanceof OCReturnStatement && !elementsInBlocks.contains(psiElement)) {
                OCExpression returnExpr = ((OCReturnStatement)psiElement).getExpression();
                if (returnExpr != null) {
                    OCStatement assignStmt = OCElementFactory.statementFromText(resultName + "=b;", psiElement);
                    OCAssignmentExpression expression = (OCAssignmentExpression)((OCExpressionStatement)assignStmt).getExpression();
                    OCChangeUtil.replaceHandlingMacros(expression.getSourceExpression(), returnExpr);
                    OCChangeUtil.replaceHandlingMacros(psiElement, assignStmt);
                    continue;
                }
                OCChangeUtil.replaceHandlingMacros(psiElement, OCElementFactory.statementFromText(";", psiElement));
                continue;
            }
            if (psiElement instanceof OCReferenceExpression) {
                OCReferenceExpression refExpr = (OCReferenceExpression)psiElement;
                if (!refExpr.isSelfSuperOrThis() || receiverDeclarator == null) continue;
                refExpr.getReferenceElement().setNameOfIdentifier(receiverDeclarator.getName());
                continue;
            }
            if (!(psiElement instanceof OCDeclarator) || !((sym = ((OCDeclarator)psiElement).getSymbol()) instanceof OCDeclaratorSymbol)) continue;
            OCCodeInsightUtil.renameDeclaratorAndUsages((OCDeclarator)psiElement, OCUniqueNameGenerator.suggestUniqueName(sym, parent, project), declaratorUsages.get((OCDeclarator)psiElement));
        }
        PsiElement[] elementsToCopy = OCCodeInsightUtil.findStatementsAtRange(fileCopy, body.getTextRange().getStartOffset() + 1, body.getTextRange().getEndOffset() - 1, true);
        assert (elementsToCopy != null);
        for (PsiElement statement : elementsToCopy) {
            OCChangeUtil.addBefore(parent, statement, anchor);
        }
        OCInlineLocalVarHandler oCInlineLocalVarHandler = new OCInlineLocalVarHandler();
        PsiElement usageParent = OCParenthesesUtils.topmostParenthesized(usageExpr).getParent();
        if (usageExpr instanceof OCQualifiedExpression && usageParent instanceof OCAssignmentExpression && resultDeclarator == null || callable instanceof OCFunctionDeclaration && usageExpr.getParent() instanceof OCCallExpression) {
            usageParent = OCParenthesesUtils.topmostParenthesized((OCExpression)usageParent).getParent();
        }
        if (usageParent instanceof OCExpressionStatement) {
            OCChangeUtil.delete(usageParent);
        } else {
            OCReferenceExpression resultExpr = (OCReferenceExpression)OCElementFactory.expressionFromText(resultName, parent);
            OCExpression usageToReplace = OCInlineMethodHandler.getUsageToReplace(usageExpr);
            resultExpr = (OCReferenceExpression)OCChangeUtil.replaceHandlingMacros(usageToReplace, resultExpr);
            if (resultDeclarator != null) {
                oCInlineLocalVarHandler.invokeSilently(resultDeclarator, resultExpr.getReferenceElement());
            }
        }
        if (receiverDeclarator != null && !receiverHasSideEffects) {
            oCInlineLocalVarHandler.invokeSilently(receiverDeclarator, receiverDeclarator);
        }
        for (OCDeclarator declarator3 : newParamDeclarators) {
            oCInlineLocalVarHandler.invokeSilently(declarator3, declarator3);
        }
        OCImportSymbolFix.fixAllSymbolsRecursively(parent);
        OCBindUtil.decodeContextInfo(parent, null, elemsToEscalateVisibility);
        OCBindUtil.removeRedundantQualifiers(parent);
    }

    @Override
    protected void sortUsages(List<PsiElement> usages) {
        usages.sort((element1, element2) -> {
            if (Comparing.equal((Object)element1.getContainingFile(), (Object)element2.getContainingFile())) {
                OCExpression call1 = OCInlineMethodHandler.getCallExpression(element1);
                OCExpression call2 = OCInlineMethodHandler.getCallExpression(element2);
                if (call1 != null && call2 != null) {
                    if (PsiTreeUtil.isAncestor((PsiElement)call1, (PsiElement)call2, (boolean)true)) {
                        return 1;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)call2, (PsiElement)call1, (boolean)true)) {
                        return -1;
                    }
                }
            }
            return element1.getTextOffset() - element2.getTextOffset();
        });
    }

    static void checkMethodsHierarchy(OCCallable callable, String elementNameWithKind, List<@Nls String> warnings) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)callable.getSymbol(), finder, false, true, false, callable.getProject());
        if (finder.isFound()) {
            warnings.add(OCRefactoringBundle.message("element.has.inheritor", StringUtil.capitalize((String)elementNameWithKind), callable instanceof OCMethod ? 0 : 1));
        } else {
            OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)callable.getSymbol(), finder, true, false, false, callable.getProject());
            if (finder.isFound()) {
                warnings.add(OCRefactoringBundle.message("element.inherits.method", StringUtil.capitalize((String)elementNameWithKind), ((OCSymbolWithParent)finder.getFoundValue()).getParent().getNameWithKindLowercase(OCCompilationContext.create(callable))));
            }
        }
    }

    private static void collectElements(OCBlockStatement body, final List<PsiElement> elements, final Set<PsiElement> elementsInBlocks) {
        final Stack blocksStack = new Stack();
        body.accept(new OCVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                element.acceptChildren((PsiElementVisitor)this);
                elements.add(element);
                if (!blocksStack.isEmpty()) {
                    elementsInBlocks.add(element);
                }
            }

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
                blocksStack.push((Object)blockExpression);
                blockExpression.acceptChildren(this);
                blocksStack.pop();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/refactoring/inline/OCInlineMethodHandler$2", "visitElement"));
            }
        });
    }

    @Nullable
    private static OCExpression getCallExpression(PsiElement usage) {
        OCExpression usageExpr = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)usage, OCExpression.class, (boolean)false);
        if (usageExpr instanceof OCReferenceExpression) {
            usageExpr = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)usageExpr, OCCallExpression.class);
        }
        return usageExpr;
    }

    private static OCDeclarator addVariable(@NlsSafe String baseName, OCType type, @Nullable OCExpression initializer, PsiElement parent, PsiElement anchor) {
        String name = OCUniqueNameGenerator.suggestUniqueName(OCSymbolKind.LOCAL_VARIABLE, baseName, parent, parent.getProject());
        OCDeclarationStatement declStatement = OCElementFactory.declarationStatement(name, type, initializer, parent);
        declStatement = OCChangeUtil.addBefore(parent, declStatement, anchor);
        return declStatement.getDeclaration().getDeclarators().get(0);
    }

    @Nullable
    private static OCExpression getReceiverExpression(OCExpression usage) {
        if (usage instanceof OCSendMessageExpression) {
            return ((OCSendMessageExpression)usage).getReceiverExpression();
        }
        if (usage instanceof OCQualifiedExpression) {
            return ((OCQualifiedExpression)usage).getQualifier();
        }
        return null;
    }

    private static OCExpression getUsageToReplace(OCExpression usage) {
        if (usage instanceof OCQualifiedExpression && usage.getParent() instanceof OCCallExpression) {
            return (OCCallExpression)usage.getParent();
        }
        return usage;
    }

    private static List<OCExpression> getArguments(OCExpression usage) {
        if (usage instanceof OCCallExpression) {
            return ((OCCallExpression)usage).getArguments();
        }
        if (usage instanceof OCSendMessageExpression) {
            return ((OCSendMessageExpression)usage).getArgumentExpressions();
        }
        if (usage instanceof OCQualifiedExpression) {
            OCExpression receiver = OCParenthesesUtils.topmostParenthesized(usage);
            PsiElement parent = receiver.getParent();
            if (parent instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getReceiverExpression() == receiver) {
                return Collections.singletonList(((OCAssignmentExpression)parent).getSourceExpression());
            }
            if (parent instanceof OCCallExpression) {
                return ((OCCallExpression)parent).getArguments();
            }
            return Collections.emptyList();
        }
        assert (false) : usage.getClass();
        return null;
    }

    private static List<OCElement> getTemplateParameters(OCCallable callable) {
        OCTemplateParameterList parametersList;
        if (callable instanceof OCDeclaration && (parametersList = ((OCDeclaration)((Object)callable)).getTemplateParameterList()) != null) {
            return parametersList.getParameters();
        }
        return Collections.emptyList();
    }

    private static List<? extends OCElement> getTemplateArguments(OCExpression usageExpr) {
        OCTypeArgumentList argumentList;
        if (usageExpr instanceof OCCallExpression) {
            OCTypeArgumentList argumentList2;
            OCReferenceElement referenceElement;
            OCExpression call = ((OCCallExpression)usageExpr).getFunctionReferenceExpression();
            if (call instanceof OCReferenceExpression && (referenceElement = ((OCReferenceExpression)call).getReferenceElement()) != null && (argumentList2 = referenceElement.getTemplateArgumentList()) != null) {
                return argumentList2.getArguments();
            }
        } else if (usageExpr instanceof OCQualifiedExpression && (argumentList = ((OCQualifiedExpression)usageExpr).getTemplateArgumentList()) != null) {
            return argumentList.getArguments();
        }
        return Collections.emptyList();
    }

    private static void assignTemplateParameters(OCCallable callableCopy, OCExpression usageExpr, OCStatement anchor, PsiElement parent, Map<PsiNamedElement, List<PsiElement>> declaratorUsages, List<OCDeclarator> newParamDeclarators) {
        List<OCElement> parameters = OCInlineMethodHandler.getTemplateParameters(callableCopy);
        List<? extends OCElement> arguments = OCInlineMethodHandler.getTemplateArguments(usageExpr);
        for (int i = 0; i < parameters.size(); ++i) {
            OCType paramType;
            OCDeclarator paramDeclarator;
            OCElement parameter = parameters.get(i);
            if (!(parameter instanceof OCParameterDeclaration) || (paramDeclarator = ((OCParameterDeclaration)parameter).getDeclarator()) == null || (paramType = paramDeclarator.getType()).isVariadic()) continue;
            OCExpression argument = null;
            if (i < arguments.size()) {
                OCElement argElement = arguments.get(i);
                if (argElement instanceof OCExpression) {
                    argument = (OCExpression)argElement;
                }
            } else {
                argument = paramDeclarator.getInitializer();
            }
            if (argument == null) continue;
            OCDeclarator declarator = OCInlineMethodHandler.addVariable(paramDeclarator.getName(), paramType, argument, parent, anchor);
            if (!OCCodeInsightUtil.hasSideEffects(argument)) {
                newParamDeclarators.add(declarator);
            }
            OCCodeInsightUtil.renameDeclaratorAndUsages(paramDeclarator, declarator.getName(), declaratorUsages.get(paramDeclarator));
        }
    }

    @Override
    protected void deleteElement(OCCallable element, PsiElement elementData) {
        List<OCCallable> callables = OCInlineMethodHandler.collectSameDefinitions(element);
        for (OCCallable callable : callables) {
            OCChangeUtil.delete(callable);
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.inlineMethod";
    }

    @Override
    protected List<OCCallable> getElementsToWrite(OCCallable element) {
        return OCInlineMethodHandler.collectSameDefinitions(element);
    }

    private static List<OCCallable> collectSameDefinitions(OCCallable callable) {
        ArrayList<OCCallable> callables = new ArrayList<OCCallable>();
        OCSymbol symbol = callable.getSymbol();
        if (symbol != null) {
            Project project = callable.getProject();
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                PsiElement element;
                PsiElement psiElement = element = symbol1 != null ? symbol1.locateDefinition(project) : null;
                if (element instanceof OCCallable) {
                    callables.add((OCCallable)element);
                } else if (element != null && element.getParent() instanceof OCCallable) {
                    callables.add((OCCallable)element.getParent());
                }
                return true;
            }), project);
        } else {
            callables.add(callable);
        }
        return callables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundElementWithRefToTarget";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementNameWithKind";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnings";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/inline/OCInlineMethodHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRefElementForInline";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValidness";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

