/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.util;

import com.esotericsoftware.minlog.Log;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppBaseClauseList;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSuperClassRef;
import com.jetbrains.cidr.lang.quickfixes.OCChangeVisibilityIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public class OCElementsMover {
    private final boolean myAutoImport;

    public OCElementsMover(boolean autoImport) {
        this.myAutoImport = autoImport;
    }

    public OCElementsMover() {
        this(true);
    }

    public OCReferenceElement addBaseProtocol(@NotNull OCClassDeclaration clazz, String protocolName) {
        OCReferenceElement protocolReference;
        if (clazz == null) {
            OCElementsMover.$$$reportNull$$$0(0);
        }
        OCLog.LOG.assertTrue((protocolReference = OCElementFactory.referenceElementFromText(protocolName, clazz, true)) != null);
        OCProtocolList protocolList = clazz.getProtocolList();
        protocolReference = OCChangeUtil.add(protocolList, protocolReference, OCChangeUtil.PostponedFormatAction.NoFormat);
        if (this.myAutoImport) {
            OCImportSymbolFix.fixAllSymbolsRecursively(protocolReference);
        }
        return protocolReference;
    }

    public void removeBaseProtocol(@NotNull OCClassDeclaration clazz, String protocolName) {
        if (clazz == null) {
            OCElementsMover.$$$reportNull$$$0(1);
        }
        for (OCReferenceElement protocolRef : clazz.getProtocolList().getProtocols()) {
            if (!protocolName.equals(protocolRef.getName())) continue;
            OCChangeUtil.delete(protocolRef);
            return;
        }
        assert (false) : "Protocol " + protocolName + " was not found in " + clazz.getName();
    }

    public OCCppBaseClause addBaseClass(@NotNull OCStruct clazz, OCStructSymbol baseSymbol, OCVisibility visibility, boolean useShortName) {
        String typeName;
        String visibilityStr;
        OCStruct struct;
        OCCppBaseClauseList baseClausesList;
        if (clazz == null) {
            OCElementsMover.$$$reportNull$$$0(2);
        }
        if ((baseClausesList = (struct = (OCStruct)OCElementFactory.typeElementFromText("struct a: " + (visibilityStr = visibility != null && visibility != OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC ? visibility.toString() : "") + " " + (typeName = useShortName ? baseSymbol.getName() : baseSymbol.getType().getCanonicalName(OCResolveContext.forPsi(clazz))) + "{}", clazz).getFirstChild()).getBaseClausesList()) == null) {
            return null;
        }
        OCCppBaseClause clause = baseClausesList.getBaseClauses().get(0);
        clause = OCChangeUtil.add(clazz.getBaseClausesList(), clause, OCChangeUtil.PostponedFormatAction.NoFormat);
        if (this.myAutoImport) {
            OCImportSymbolFix.fixAllSymbolsRecursively(clause);
        }
        OCBindUtil.setShortestPossibleName(clause.getReferenceElement());
        return clause;
    }

    public void removeBaseClass(@NotNull OCStruct clazz, @NotNull OCStructSymbol baseSymbol, boolean checkIfExists) {
        if (clazz == null) {
            OCElementsMover.$$$reportNull$$$0(3);
        }
        if (baseSymbol == null) {
            OCElementsMover.$$$reportNull$$$0(4);
        }
        OCQualifiedName qualifiedName = baseSymbol.getQualifiedName();
        OCCppBaseClauseList baseClausesList = clazz.getBaseClausesList();
        if (baseClausesList == null) {
            return;
        }
        for (OCCppBaseClause clause : baseClausesList.getBaseClauses()) {
            OCReferenceElement element = clause.getReferenceElement();
            OCSymbol symbol = element != null ? element.resolveToSymbol() : null;
            if (!(symbol instanceof OCSymbolWithQualifiedName) || !((OCSymbolWithQualifiedName)symbol).getQualifiedName().equals(qualifiedName)) continue;
            OCChangeUtil.delete(clause);
            return;
        }
        if (checkIfExists) {
            Log.error((String)("Base " + baseSymbol.getNameWithKindLowercase(OCCompilationContext.create(clazz)) + " was not found in " + clazz.getName()));
        }
    }

    public OCReferenceElement setSuperClass(@NotNull OCClassDeclaration clazz, String superClassName) {
        if (clazz == null) {
            OCElementsMover.$$$reportNull$$$0(5);
        }
        OCSuperClassRef superClassRef = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c: " + superClassName + " @end", clazz)).getSuperClassRef();
        superClassRef = (OCSuperClassRef)clazz.getSuperClassRef().replace(superClassRef);
        if (this.myAutoImport) {
            OCImportSymbolFix.fixAllSymbolsRecursively(superClassRef.getReferenceElement());
        }
        return superClassRef.getReferenceElement();
    }

    public OCDeclarator addInstanceVariable(OCClassDeclaration clazz, OCInstanceVariableSymbol symbol, OCDeclaration declaration) {
        OCChangeVisibilityIntentionAction action = new OCChangeVisibilityIntentionAction(symbol, symbol.getVisibility(), OCCompilationContext.create(clazz));
        declaration = OCChangeUtil.add(clazz.getInstanceVariablesList(), declaration, OCChangeUtil.PostponedFormatAction.NoFormat);
        declaration = action.putToParent(symbol, declaration, clazz.getInstanceVariablesList());
        if (this.myAutoImport) {
            OCImportSymbolFix.fixAllSymbolsRecursively(declaration);
        }
        return declaration.getDeclarators().get(0);
    }

    public OCDeclaration addClassMemberVariable(OCStruct clazz, OCSymbolWithQualifiedName symbol, OCDeclaration declaration) {
        OCVisibility visibility = symbol.getVisibility();
        if (visibility != null) {
            OCChangeVisibilityIntentionAction action = new OCChangeVisibilityIntentionAction(symbol, visibility, OCCompilationContext.create(clazz));
            declaration = OCChangeUtil.add(clazz, declaration, OCChangeUtil.PostponedFormatAction.NoFormat);
            declaration = action.putToParent(symbol, declaration, clazz);
        } else {
            declaration = OCChangeUtil.add(clazz, declaration, OCChangeUtil.PostponedFormatAction.NoFormat);
        }
        if (this.myAutoImport) {
            OCImportSymbolFix.fixAllSymbolsRecursively(declaration);
        }
        return declaration;
    }

    public void removeSuperClass(OCClassDeclaration clazz) {
        OCChangeUtil.clear(clazz.getSuperClassRef());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSymbol";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/util/OCElementsMover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addBaseProtocol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeBaseProtocol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addBaseClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeBaseClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setSuperClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

