/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableListener;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCFileSymbolTableModificationTracker
extends SimpleModificationTracker
implements Disposable {
    private State state;
    public static final Logger LOG = Logger.getInstance(OCFileSymbolTableModificationTracker.class);

    public OCFileSymbolTableModificationTracker(@NotNull Project project) {
        if (project == null) {
            OCFileSymbolTableModificationTracker.$$$reportNull$$$0(0);
        }
        this.state = new State();
        project.getMessageBus().connect((Disposable)this).subscribe(OCFileSymbolTableListener.TOPIC, (Object)new OCFileSymbolTableListener(){

            @Override
            public void onFileHasNewSymbolTableInPack(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                OCFileSymbolTableModificationTracker.log("FST add ", virtualFile);
                OCFileSymbolTableModificationTracker.this.addFileWithNewSymbolTable(virtualFile);
            }

            @Override
            public void onFileHasInvalidSymbolTableInPack(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(1);
                }
                OCFileSymbolTableModificationTracker.log("FST remove ", virtualFile);
                OCFileSymbolTableModificationTracker.this.addFileWithInvalidTable(virtualFile);
            }

            @Override
            public void onAllSymbolTablesDropped() {
                OCFileSymbolTableModificationTracker.log("FST clear all", new Object[0]);
                OCFileSymbolTableModificationTracker.this.reset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "virtualFile";
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbolTableModificationTracker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileHasNewSymbolTableInPack";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileHasInvalidSymbolTableInPack";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void dispose() {
    }

    synchronized long attachAndReturnCurrentVersion(@NotNull OCGlobalProjectSymbolsCache.OCSymbols symbols) {
        if (symbols == null) {
            OCFileSymbolTableModificationTracker.$$$reportNull$$$0(1);
        }
        this.state.symbols = symbols;
        return this.getModificationCount();
    }

    synchronized void restoreStateOnCancel(@NotNull State canceledState, @NotNull OCGlobalProjectSymbolsCache.OCSymbols beforeBuildSymbols) {
        if (canceledState == null) {
            OCFileSymbolTableModificationTracker.$$$reportNull$$$0(2);
        }
        if (beforeBuildSymbols == null) {
            OCFileSymbolTableModificationTracker.$$$reportNull$$$0(3);
        }
        this.state.restore(canceledState, beforeBuildSymbols);
    }

    @NotNull
    synchronized StateAndVersion getStateAndReset() {
        State ret = this.state;
        this.state = new State();
        return new StateAndVersion(ret, this.getModificationCount());
    }

    synchronized void reset() {
        this.state = new State();
        this.incModificationCount();
    }

    synchronized void addFileWithNewSymbolTable(@NotNull VirtualFile file) {
        if (file == null) {
            OCFileSymbolTableModificationTracker.$$$reportNull$$$0(4);
        }
        this.state.filesWithNewSymbolTable.add(file);
        this.incModificationCount();
    }

    synchronized void addFileWithInvalidTable(@NotNull VirtualFile file) {
        if (file == null) {
            OCFileSymbolTableModificationTracker.$$$reportNull$$$0(5);
        }
        this.state.filesWithInvalidSymbolTable.add(file);
        this.incModificationCount();
    }

    public static OCFileSymbolTableModificationTracker getInstance(@NotNull Project project) {
        if (project == null) {
            OCFileSymbolTableModificationTracker.$$$reportNull$$$0(6);
        }
        return (OCFileSymbolTableModificationTracker)((Object)project.getService(OCFileSymbolTableModificationTracker.class));
    }

    public static void log(@NotNull String message, Object ... details) {
        if (message == null) {
            OCFileSymbolTableModificationTracker.$$$reportNull$$$0(7);
        }
        if (details == null) {
            OCFileSymbolTableModificationTracker.$$$reportNull$$$0(8);
        }
        LOG.debug(message, details);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canceledState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeBuildSymbols";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbolTableModificationTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "attachAndReturnCurrentVersion";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreStateOnCancel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileWithNewSymbolTable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileWithInvalidTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "log";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class State {
        public OCGlobalProjectSymbolsCache.OCSymbols symbols = null;
        public final Set<VirtualFile> filesWithNewSymbolTable = new HashSet<VirtualFile>();
        public final Set<VirtualFile> filesWithInvalidSymbolTable = new HashSet<VirtualFile>();

        public void restore(@NotNull State canceledState, @NotNull OCGlobalProjectSymbolsCache.OCSymbols beforeBuildSymbols) {
            if (canceledState == null) {
                State.$$$reportNull$$$0(0);
            }
            if (beforeBuildSymbols == null) {
                State.$$$reportNull$$$0(1);
            }
            this.filesWithNewSymbolTable.addAll(canceledState.filesWithNewSymbolTable);
            this.filesWithInvalidSymbolTable.addAll(canceledState.filesWithInvalidSymbolTable);
            assert (this.symbols == null);
            this.symbols = beforeBuildSymbols;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "canceledState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "beforeBuildSymbols";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbolTableModificationTracker$State";
            objectArray[2] = "restore";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class StateAndVersion {
        @NotNull
        public final State state;
        public final long version;

        public StateAndVersion(@NotNull State state, long version) {
            if (state == null) {
                StateAndVersion.$$$reportNull$$$0(0);
            }
            this.state = state;
            this.version = version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/cidr/lang/symbols/symtable/OCFileSymbolTableModificationTracker$StateAndVersion", "<init>"));
        }
    }
}

