/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.symbols.DeclarationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.ArcAnnotatedType;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.MachineModeAttribute;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeBuilder {
    @NotNull
    private final OCLanguageKind myFileKind;
    @NotNull
    private final OCInclusionContext myInclusionContext;
    @NotNull
    private final Project myProject;
    private OCType myCurrentType;
    private int longKeywords;
    private List<IElementType> myRefTokens;
    private List<IElementType> myFunctionRefTokens;
    private String @Nullable [] myProtocols;
    private boolean myIsTypedef;
    private boolean myWasLT;
    private boolean myWasConst;
    private boolean myIsInsideBrackets;
    private boolean myPassByReference;
    private boolean myConst;
    private boolean myVolatile;
    private boolean mySign;
    private boolean myUnsign;
    private boolean myWasComplex;
    private boolean myVariadic;
    private OCQualifiedName myPointerQualifier;
    private int myParLevel;
    private DeclarationContext myLocalContext;
    private OCQualifiedName myNamespaceQualifier;
    private String myName;
    private long myComplexOffset;
    private VirtualFile myVirtualFile;
    private List<OCTypeArgument> myTypeArguments;
    private MachineModeAttribute myModeAttribute;
    private static final OCExpressionSymbol[] EMPTY_ARRAY_LENGTHS = new OCExpressionSymbol[0];
    private OCExpressionSymbol[] myArrayLengths;
    @Nullable
    private OCExpressionSymbol myArrayLengthSymbol;
    private boolean myWasAuto;
    private boolean myIsKindof;
    private OCNullability myNullability;
    private boolean myAssumeNonNullOn;
    @Nullable
    private OCQualifiedName myTypeConstraint;

    public OCTypeBuilder(@NotNull OCLanguageKind fileKind, @NotNull OCInclusionContext inclusionContext, @NotNull DeclarationContext context, @NotNull Project project) {
        if (fileKind == null) {
            OCTypeBuilder.$$$reportNull$$$0(0);
        }
        if (inclusionContext == null) {
            OCTypeBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OCTypeBuilder.$$$reportNull$$$0(2);
        }
        if (project == null) {
            OCTypeBuilder.$$$reportNull$$$0(3);
        }
        this.longKeywords = 0;
        this.myRefTokens = new ArrayList<IElementType>();
        this.myFunctionRefTokens = new ArrayList<IElementType>();
        this.myProtocols = null;
        this.myIsTypedef = false;
        this.myWasLT = false;
        this.myWasConst = false;
        this.myIsInsideBrackets = false;
        this.myPassByReference = false;
        this.mySign = false;
        this.myUnsign = false;
        this.myParLevel = 0;
        this.myComplexOffset = -1L;
        this.myVirtualFile = null;
        this.myArrayLengths = EMPTY_ARRAY_LENGTHS;
        this.myArrayLengthSymbol = null;
        this.myWasAuto = false;
        this.myIsKindof = false;
        this.myNullability = null;
        this.myTypeConstraint = null;
        this.myFileKind = fileKind;
        this.myInclusionContext = inclusionContext;
        this.myLocalContext = context;
        this.myAssumeNonNullOn = context.isAssumeNonNull();
        if (context.isLambdaInitCapture()) {
            this.myWasAuto = true;
            this.myCurrentType = new OCAutoType();
        }
        this.myProject = project;
    }

    public void setLocalContext(@NotNull DeclarationContext localContext) {
        if (localContext == null) {
            OCTypeBuilder.$$$reportNull$$$0(4);
        }
        this.myLocalContext = localContext;
    }

    public void setOffset(VirtualFile virtualFile, long offset) {
        this.myVirtualFile = virtualFile;
        this.myComplexOffset = offset;
    }

    public void setPointerQualifier(OCQualifiedName pointerQualifier, VirtualFile virtualFile, long complexOffset) {
        this.myPointerQualifier = pointerQualifier;
        if (this.myComplexOffset == -1L) {
            this.myVirtualFile = virtualFile;
            this.myComplexOffset = complexOffset;
        }
    }

    public void learn(IElementType token) {
        this.learn(token, null, null, -1L);
    }

    public void learnNamespaceQualifier(OCQualifiedName qualifier) {
        this.myNamespaceQualifier = qualifier;
    }

    public void learn(IElementType token, @Nullable String tokenText, @Nullable VirtualFile file, long complexOffset) {
        List<IElementType> refTokens;
        List<IElementType> list = refTokens = this.isInsideParentheses() ? this.myFunctionRefTokens : this.myRefTokens;
        if (token == OCTokenTypes.MUL) {
            refTokens.add((IElementType)OCTokenTypes.MUL);
            this.myConst = false;
        } else if (token == OCTokenTypes.XOR) {
            refTokens.add((IElementType)OCTokenTypes.XOR);
            this.myConst = false;
        } else if (token == OCTokenTypes.AND) {
            refTokens.add((IElementType)OCTokenTypes.AND);
            this.myConst = false;
        } else if (token == OCTokenTypes.ANDAND) {
            refTokens.add((IElementType)OCTokenTypes.ANDAND);
            this.myConst = false;
        } else if (token == OCTokenTypes.CONST_KEYWORD) {
            refTokens.add((IElementType)OCTokenTypes.CONST_KEYWORD);
            this.myConst = true;
            this.myWasConst = true;
        } else if (token == OCTokenTypes.VOLATILE_KEYWORD) {
            refTokens.add((IElementType)OCTokenTypes.VOLATILE_KEYWORD);
            this.myVolatile = true;
        } else if (token == OCTokenTypes.LBRACKET) {
            this.myIsInsideBrackets = true;
        } else if (token == OCTokenTypes.RBRACKET) {
            this.myArrayLengths = (OCExpressionSymbol[])ArrayUtil.append((Object[])this.myArrayLengths, (Object)this.myArrayLengthSymbol);
            this.myArrayLengthSymbol = null;
            refTokens.add((IElementType)OCTokenTypes.LBRACKET);
            this.myIsInsideBrackets = false;
        } else if (token == OCTokenTypes.LPAR) {
            ++this.myParLevel;
        } else if (token == OCTokenTypes.RPAR) {
            --this.myParLevel;
        } else if (token == OCTokenTypes.ELLIPSIS) {
            if (this.myCurrentType == null && this.myName == null || !this.myFileKind.isCpp()) {
                this.myCurrentType = OCEllipsisType.instance();
            } else {
                this.myVariadic = true;
            }
        } else if (OCTokenTypes.NULLABILITY_KEYWORDS.contains(token)) {
            refTokens.add(token);
        } else if (OCTokenTypes.IN_SELECTOR_NULLABILITY_KEYWORDS.contains(token)) {
            this.myNullability = OCNullability.parseFrom(token);
        }
        if (this.isInsideParentheses()) {
            return;
        }
        if (token == OCTokenTypes.SIGNED_KEYWORD) {
            if (this.mySign) {
                this.error("duplicate 'signed'");
            }
            this.mySign = true;
            if (this.myUnsign) {
                this.error("'signed' and 'unsigned' specified together");
            }
            if (this.myCurrentType == OCIntType.CHAR || this.myCurrentType == OCIntType.UCHAR) {
                this.myCurrentType = OCIntType.SCHAR;
            } else if (this.myCurrentType == null || this.myWasAuto) {
                this.myCurrentType = OCIntType.INT;
            } else if (!(this.myCurrentType instanceof OCIntType)) {
                this.error("signed is only applicable to integer types!");
            }
        }
        if (token == OCTokenTypes.UNSIGNED_KEYWORD) {
            if (this.myUnsign) {
                this.error("duplicate 'unsigned'");
            }
            this.myUnsign = true;
            if (this.mySign) {
                this.error("'signed' and 'unsigned' specified together");
            }
            if (this.myCurrentType == OCIntType.CHAR || this.myCurrentType == OCIntType.SCHAR) {
                this.myCurrentType = OCIntType.UCHAR;
            } else if (this.myCurrentType == OCIntType.SHORT) {
                this.myCurrentType = OCIntType.USHORT;
            } else if (this.myCurrentType == null || this.myCurrentType == OCIntType.INT || this.myWasAuto) {
                this.myCurrentType = OCIntType.UINT;
            } else if (this.myCurrentType == OCIntType.LONG) {
                this.myCurrentType = OCIntType.ULONG;
            } else if (this.myCurrentType == OCIntType.LONGLONG) {
                this.myCurrentType = OCIntType.ULONGLONG;
            } else if (this.myCurrentType == OCIntType.__INT8) {
                this.myCurrentType = OCIntType.__UINT8;
            } else if (this.myCurrentType == OCIntType.__INT16) {
                this.myCurrentType = OCIntType.__UINT16;
            } else if (this.myCurrentType == OCIntType.__INT32) {
                this.myCurrentType = OCIntType.__UINT32;
            } else if (this.myCurrentType == OCIntType.__INT64) {
                this.myCurrentType = OCIntType.__UINT64;
            } else if (this.myCurrentType == OCIntType.INT128) {
                this.myCurrentType = OCIntType.UINT128;
            } else if (!(this.myCurrentType instanceof OCIntType)) {
                this.error("unsigned is only applicable to integer types!");
            }
        } else if (OCTokenTypes.AUTO_KEYWORDS.contains(token)) {
            this.myWasAuto = true;
            this.myCurrentType = new OCAutoType();
            this.myName = null;
            if (this.myLocalContext.getParent() instanceof OCStatement && ((OCStatement)this.myLocalContext.getParent()).getParent() instanceof OCLambdaExpression) {
                this.myCurrentType = new OCAutoType((OCLambdaExpression)((OCStatement)this.myLocalContext.getParent()).getParent(), this.myLocalContext.getParameterIndex());
            } else if (this.myLocalContext.getParameterIndex() != -1) {
                this.myCurrentType = new OCAutoType(null, this.myLocalContext.getParameterIndex());
            }
        } else if (token == OCTokenTypes.INT_KEYWORD && (this.myCurrentType == null || this.myCurrentType == OCIntType.INT || this.myWasAuto)) {
            this.updateIntegerWidth(OCIntType.INT, OCIntType.UINT);
        } else if (token == OCTokenTypes.CHAR_KEYWORD) {
            this.updateIntegerWidth(this.mySign ? OCIntType.SCHAR : OCIntType.CHAR, OCIntType.UCHAR);
        } else if (token == OCTokenTypes.SHORT_KEYWORD) {
            this.updateIntegerWidth(OCIntType.SHORT, OCIntType.USHORT);
        } else if (token == OCTokenTypes.LONG_KEYWORD) {
            ++this.longKeywords;
            if (this.myCurrentType == OCRealType.DOUBLE) {
                this.myCurrentType = OCRealType.LONG_DOUBLE;
            } else if (this.myCurrentType == null || this.myCurrentType == OCIntType.INT || this.myCurrentType == OCIntType.UINT || this.myWasAuto) {
                this.updateIntegerWidth(OCIntType.LONG, OCIntType.ULONG);
            } else if (this.longKeywords == 2) {
                this.updateIntegerWidth(OCIntType.LONGLONG, OCIntType.ULONGLONG);
            }
        } else if (token == OCTokenTypes.VOID_KEYWORD) {
            this.myCurrentType = OCVoidType.instance();
        } else if (token == OCTokenTypes._BOOL_KEYWORD) {
            this.myCurrentType = OCIntType.BOOL_NATIVE;
        } else if (token == OCTokenTypes.FLOAT_KEYWORD) {
            this.myCurrentType = this.myWasComplex ? OCRealType.COMPLEX_FLOAT : OCRealType.FLOAT;
        } else if (token == OCTokenTypes.DOUBLE_KEYWORD) {
            this.myCurrentType = this.myWasComplex ? (this.longKeywords > 0 ? OCRealType.COMPLEX_LONG_DOUBLE : OCRealType.COMPLEX_DOUBLE) : (this.longKeywords > 0 ? OCRealType.LONG_DOUBLE : OCRealType.DOUBLE);
        } else if (token == OCTokenTypes._COMPLEX_KEYWORD) {
            if (this.myCurrentType instanceof OCRealType) {
                this.myCurrentType = ((OCRealType)this.myCurrentType).cloneWithComplexModifier();
            }
            this.myWasComplex = true;
        } else if (token == OCTokenTypes.LT) {
            this.myWasLT = true;
        } else if (token != OCTokenTypes.GT) {
            if (token == OCTokenTypes.BOOL_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.BOOL_NATIVE;
            } else if (token == OCTokenTypes.WCHAR_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.WCHAR;
            } else if (token == OCTokenTypes.__WCHAR_T_KEYWORD) {
                this.myCurrentType = OCIntType.__WCHAR_T;
            } else if (token == OCTokenTypes.CHAR8_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.CHAR8;
            } else if (token == OCTokenTypes.CHAR16_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.CHAR16;
            } else if (token == OCTokenTypes.CHAR32_T_CPP_KEYWORD) {
                this.myCurrentType = OCIntType.CHAR32;
            } else if (token == OCTokenTypes.__INT8_KEYWORD) {
                this.updateIntegerWidth(OCIntType.__INT8, OCIntType.__UINT8);
            } else if (token == OCTokenTypes.__INT16_KEYWORD) {
                this.updateIntegerWidth(OCIntType.__INT16, OCIntType.__UINT16);
            } else if (token == OCTokenTypes.__INT32_KEYWORD) {
                this.updateIntegerWidth(OCIntType.__INT32, OCIntType.__UINT32);
            } else if (token == OCTokenTypes.__INT64_KEYWORD) {
                this.updateIntegerWidth(OCIntType.__INT64, OCIntType.__UINT64);
            } else if (token == OCTokenTypes.INT128_T_KEYWORD) {
                this.updateIntegerWidth(OCIntType.INT128, OCIntType.UINT128);
            } else if (token == OCTokenTypes.UINT128_T_KEYWORD) {
                this.myCurrentType = OCIntType.UINT128;
            } else if (token == OCTokenTypes.IDENTIFIER || token == OCElementTypes.EMPTY_NAME) {
                if (token == OCElementTypes.EMPTY_NAME && this.myWasAuto) {
                    this.myCurrentType = new OCAutoType();
                    return;
                }
                if (tokenText == null || !OCElementTypes.PARAMETER_TYPE_QUALIFIERS.contains(tokenText)) {
                    if (this.myProtocols != null && this.myWasLT) {
                        this.myProtocols = (String[])ArrayUtil.append((Object[])this.myProtocols, (Object)OCNamesInterner.intern((String)tokenText), String.class);
                    } else {
                        if (token == OCElementTypes.EMPTY_NAME && !this.myFileKind.isObjC()) {
                            this.myCurrentType = OCIntType.INT;
                            return;
                        }
                        this.myProtocols = ArrayUtilRt.EMPTY_STRING_ARRAY;
                        String string = this.myName = token == OCElementTypes.EMPTY_NAME ? "id" : OCNamesInterner.intern((String)tokenText);
                        if (this.myComplexOffset == -1L) {
                            this.myComplexOffset = complexOffset;
                            this.myVirtualFile = file;
                        }
                    }
                } else {
                    this.myPassByReference = true;
                }
            } else if (token == OCTokenTypes.TYPEDEF_KEYWORD) {
                this.myIsTypedef = true;
                this.myAssumeNonNullOn = false;
            } else if (ARCAttribute.isArcToken(token)) {
                this.learnArcKeyword(token);
            } else if (token == OCTokenTypes.KINDOF_KEYWORD) {
                this.myIsKindof = true;
            }
        }
    }

    public void learnAttributes(@NotNull List<String> attributeList) {
        if (attributeList == null) {
            OCTypeBuilder.$$$reportNull$$$0(5);
        }
        this.tryLearnArcAttributes(attributeList);
        this.tryLearnMachineMode(attributeList);
    }

    private void tryLearnArcAttributes(@NotNull List<String> attributeList) {
        ARCAttribute parsedAttribute;
        if (attributeList == null) {
            OCTypeBuilder.$$$reportNull$$$0(6);
        }
        if ((parsedAttribute = ARCAttribute.parseArcAttribute(attributeList)) != null) {
            this.learnArcKeyword((IElementType)parsedAttribute.getTokenType());
        }
    }

    private void learnArcKeyword(@NotNull IElementType arcToken) {
        if (arcToken == null) {
            OCTypeBuilder.$$$reportNull$$$0(7);
        }
        this.myRefTokens.add(arcToken);
    }

    private void tryLearnMachineMode(@NotNull List<String> attributeList) {
        MachineModeAttribute modeAttribute;
        if (attributeList == null) {
            OCTypeBuilder.$$$reportNull$$$0(8);
        }
        if ((modeAttribute = MachineModeAttribute.getModeAttribute(attributeList)) != null && this.myModeAttribute == null) {
            this.myModeAttribute = modeAttribute;
        }
    }

    public void learnArrayLengthSymbol(@Nullable OCExpressionSymbol symbol) {
        OCLog.LOG.assertTrue(this.myIsInsideBrackets);
        OCLog.LOG.assertTrue(this.myArrayLengthSymbol == null);
        this.myArrayLengthSymbol = symbol;
    }

    private void updateIntegerWidth(OCIntType signed, OCIntType unsigned) {
        if (this.myCurrentType == null || this.myWasAuto) {
            this.myCurrentType = signed;
            return;
        }
        if (this.myCurrentType instanceof OCIntType) {
            this.myCurrentType = ((OCIntType)this.myCurrentType).isSigned() ? signed : unsigned;
        } else {
            this.error("Illegal combination of type specifiers");
        }
    }

    public void updateArrayLength(int length) {
        if (this.myArrayLengths.length >= 1 && this.myArrayLengths[0] == null) {
            this.myArrayLengths[0] = OCArrayType.lengthFromInt(length);
        }
    }

    private void error(@NotNull String message) {
        if (message == null) {
            OCTypeBuilder.$$$reportNull$$$0(9);
        }
    }

    public OCType getResult() {
        return this.getResult(false);
    }

    public OCType getResult(boolean isFunctionReturnType) {
        OCType typeForMachineMode;
        OCType result;
        if (this.myName != null) {
            OCQualifiedName qualifiedName = this.myTypeArguments == null ? OCQualifiedName.interned(this.myNamespaceQualifier, this.myName) : new OCQualifiedNameWithArguments(this.myNamespaceQualifier, this.myName, this.myTypeArguments);
            this.myCurrentType = this.createReferenceType(qualifiedName);
        }
        List refTokens = this.myRefTokens;
        if (!isFunctionReturnType) {
            refTokens = ContainerUtil.concat(this.myRefTokens, this.myFunctionRefTokens);
            if (!(this.myFunctionRefTokens.isEmpty() || this.myFunctionRefTokens.contains(OCTokenTypes.CONST_KEYWORD) || this.myFunctionRefTokens.contains(OCTokenTypes.RBRACKET))) {
                this.myConst = false;
            }
        }
        if ((result = this.myCurrentType) == null) {
            OCType oCType = result = this.myFileKind.isObjC() ? OCIdType.pointerToID().cloneWithNullability(this.getNullability()) : OCIntType.INT;
        }
        if (result instanceof OCAutoType && this.myTypeConstraint != null) {
            ((OCAutoType)result).setTypeConstraintName(this.myTypeConstraint);
        }
        if (this.myModeAttribute != null && (typeForMachineMode = this.getNumericTypeForMachineMode(result, this.myModeAttribute)) != null) {
            result = typeForMachineMode;
        }
        result = this.getPointerType(result, refTokens);
        if (this.myVariadic) {
            result = new OCVariadicType(result);
        }
        return result;
    }

    protected OCReferenceType createReferenceType(OCQualifiedName qualifiedName) {
        OCReferenceTypeBuilder typeBuilder;
        PsiElement localContext = this.myLocalContext.getLocalContext();
        String[] protocols = this.myProtocols;
        if (localContext != null) {
            typeBuilder = new OCReferenceTypeBuilder(qualifiedName, localContext, this.myLocalContext.getParentSymbol(), this.myLocalContext.isBaseClause(), this.myVirtualFile, this.myComplexOffset);
        } else {
            OCSymbolWithQualifiedName symbol = this.myLocalContext != null ? this.myLocalContext.getParentSymbol() : null;
            boolean isBaseClause = this.myLocalContext != null && this.myLocalContext.isBaseClause();
            boolean isInsideTemplateArguments = this.myLocalContext != null && (this.myLocalContext.isInsideTemplateArguments() || this.myLocalContext.isTemplateValueParameter());
            boolean isSpecialization = this.myLocalContext != null && this.myLocalContext.isSpecialization();
            boolean skipBaseClasses = this.myLocalContext != null && this.myLocalContext.skipBaseClasses();
            typeBuilder = new OCReferenceTypeBuilder(qualifiedName, symbol, this.myVirtualFile, this.myComplexOffset, isBaseClause, isInsideTemplateArguments, isSpecialization, skipBaseClasses);
        }
        if (protocols != null) {
            typeBuilder.setProtocolNames(protocols);
        }
        typeBuilder.setARCAttribute(null);
        typeBuilder.setIsKindof(this.myIsKindof);
        if (this.myNullability != null) {
            typeBuilder.setNullability(this.myNullability);
        } else if (this.myAssumeNonNullOn) {
            typeBuilder.setNullability(OCNullability.NONNULL);
        }
        OCReferenceType type = typeBuilder.build();
        if (localContext == null) {
            this.myLocalContext.addSymbolReference((Pair<OCSymbolReference, Long>)Pair.create((Object)type.getReference(), (Object)this.myComplexOffset));
        }
        return type;
    }

    @Nullable
    private OCType getNumericTypeForMachineMode(@NotNull OCType result, @NotNull MachineModeAttribute modeAttribute) {
        boolean isProperIntOrRealType;
        if (result == null) {
            OCTypeBuilder.$$$reportNull$$$0(10);
        }
        if (modeAttribute == null) {
            OCTypeBuilder.$$$reportNull$$$0(11);
        }
        boolean bl = isProperIntOrRealType = modeAttribute.isIntegralType() ? result instanceof OCIntType : result instanceof OCRealType;
        if (!isProperIntOrRealType) {
            this.error("Machine mode '" + modeAttribute + "' applied to inappropriate type");
            return null;
        }
        return this.lookupTypeForSize(modeAttribute.getSizeInBytes(), ((OCNumericType)result).getBasicTypes());
    }

    @Nullable
    private <T extends OCNumericType> T lookupTypeForSize(short bytes, @NotNull List<T> types) {
        if (types == null) {
            OCTypeBuilder.$$$reportNull$$$0(12);
        }
        for (OCNumericType basicType : types) {
            if (basicType.getCTypeId().getBytes(null, this.myInclusionContext) != bytes) continue;
            return (T)basicType;
        }
        return null;
    }

    public OCType createFunction(OCType result, List<OCType> parameterTypes, List<String> parameterNames, boolean createPointers, boolean isConst, boolean isVolatile, boolean isLvalueFun, boolean isRvalueFun, OCExceptionSpecificationInfo exceptionSpecification) {
        if (parameterTypes != null) {
            result = new OCFunctionType(result, parameterTypes, parameterNames, isConst, isVolatile, isLvalueFun, isRvalueFun, exceptionSpecification);
            return createPointers ? this.getPointerType(result, this.myFunctionRefTokens) : result;
        }
        return result;
    }

    public void learnTypeArguments(List<OCTypeArgument> arguments) {
        this.myTypeArguments = arguments;
    }

    public void learnTypeConstraint(@NotNull OCQualifiedName typeConstraint) {
        if (typeConstraint == null) {
            OCTypeBuilder.$$$reportNull$$$0(13);
        }
        this.myTypeConstraint = typeConstraint;
    }

    private OCType getPointerType(OCType type, List<IElementType> refTokens) {
        int i = 0;
        int arrayLengthCounter = this.myArrayLengths.length - 1;
        ArcContext arcContext = new ArcContext();
        while (i < refTokens.size()) {
            IElementType token;
            if ((token = refTokens.get(i++)) == OCTokenTypes.CONST_KEYWORD) {
                type = type.cloneWithCVQualifiers(CVQualifiers.get(true, type.isVolatile()), this.myProject);
            } else if (token == OCTokenTypes.VOLATILE_KEYWORD) {
                type = type.cloneWithCVQualifiers(CVQualifiers.get(type.isConst(), true), this.myProject);
            } else if (token == OCTokenTypes.LBRACKET) {
                type = arrayLengthCounter >= 0 ? OCArrayType.to(type, this.myArrayLengths[arrayLengthCounter--], null) : OCArrayType.to(type, -1, null);
            } else if (token == OCTokenTypes.XOR) {
                type = OCBlockPointerType.blockPtr(type, null, this.getNullability(), false, false);
            } else if (token == OCTokenTypes.AND) {
                type = OCCppReferenceType.to(type);
            } else if (token == OCTokenTypes.ANDAND) {
                type = OCCppReferenceType.rvalue(type);
            } else if (token == OCTokenTypes.MUL) {
                type = OCPointerType.to(type, null, this.myPointerQualifier != null ? this.createReferenceType(this.myPointerQualifier) : null, this.getNullability(), false, false);
            } else if (OCTokenTypes.NULLABILITY_KEYWORDS.contains(token)) {
                type = type.cloneWithNullability(OCNullability.parseFrom(token));
            } else {
                arcContext.pushArcAttribute(token);
            }
            type = OCTypeBuilder.tryApplyArcAttributeToType(type, arcContext);
        }
        return type;
    }

    @NotNull
    private static OCType tryApplyArcAttributeToType(@NotNull OCType type, @NotNull ArcContext arcContext) {
        if (type == null) {
            OCTypeBuilder.$$$reportNull$$$0(14);
        }
        if (arcContext == null) {
            OCTypeBuilder.$$$reportNull$$$0(15);
        }
        if (type instanceof ArcAnnotatedType && ((ArcAnnotatedType)((Object)type)).getARCAttribute() == null) {
            OCType oCType = ((ArcAnnotatedType)((Object)type)).cloneWithArcAttribute(arcContext.popArcAttribute());
            if (oCType == null) {
                OCTypeBuilder.$$$reportNull$$$0(16);
            }
            return oCType;
        }
        OCType oCType = type;
        if (oCType == null) {
            OCTypeBuilder.$$$reportNull$$$0(17);
        }
        return oCType;
    }

    public OCTypeBuilder copy() {
        OCTypeBuilder answer = new OCTypeBuilder(this.myFileKind, this.myInclusionContext, this.myLocalContext, this.myProject);
        answer.myCurrentType = this.myCurrentType;
        answer.myName = this.myName;
        answer.myComplexOffset = this.myComplexOffset;
        answer.myVirtualFile = this.myVirtualFile;
        answer.myProtocols = this.myProtocols;
        answer.myRefTokens = new ArrayList<IElementType>(this.myRefTokens);
        answer.myIsTypedef = this.myIsTypedef;
        answer.myLocalContext = this.myLocalContext;
        answer.myPointerQualifier = this.myPointerQualifier;
        answer.myConst = this.myConst;
        answer.myVolatile = this.myVolatile;
        answer.mySign = this.mySign;
        answer.myUnsign = this.myUnsign;
        answer.myWasConst = this.myWasConst;
        answer.myWasAuto = this.myWasAuto;
        answer.myWasComplex = this.myWasComplex;
        answer.myArrayLengths = this.myArrayLengths;
        answer.myNamespaceQualifier = this.myNamespaceQualifier;
        answer.myTypeArguments = this.myTypeArguments;
        answer.myModeAttribute = this.myModeAttribute;
        answer.myIsKindof = this.myIsKindof;
        answer.myNullability = this.myNullability;
        answer.myAssumeNonNullOn = this.myAssumeNonNullOn;
        return answer;
    }

    public boolean isTypedef() {
        return this.myIsTypedef;
    }

    public boolean isPassByReference() {
        return this.myPassByReference;
    }

    public void learnBaseType(OCType type) {
        this.myCurrentType = type;
    }

    public boolean isConst() {
        return this.myConst;
    }

    public boolean isVolatile() {
        return this.myVolatile;
    }

    public boolean wasAuto() {
        return this.myWasAuto;
    }

    public boolean eraseWasConst() {
        boolean result = this.myWasConst;
        this.myWasConst = false;
        return result;
    }

    public boolean isInsideParentheses() {
        return this.myParLevel > 0;
    }

    @Nullable
    private OCNullability getNullability() {
        if (this.myNullability != null) {
            return this.myNullability;
        }
        return this.myAssumeNonNullOn ? OCNullability.NONNULL : null;
    }

    public boolean isInsideBrackets() {
        return this.myIsInsideBrackets;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inclusionContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localContext";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arcToken";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modeAttribute";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConstraint";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arcContext";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCTypeBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCTypeBuilder";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "tryApplyArcAttributeToType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setLocalContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "learnAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryLearnArcAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "learnArcKeyword";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryLearnMachineMode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNumericTypeForMachineMode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lookupTypeForSize";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "learnTypeConstraint";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryApplyArcAttributeToType";
                break;
            }
            case 16: 
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 17 -> new IllegalStateException(string);
        };
    }

    private static final class ArcContext {
        private ARCAttribute myCurrentArcAttribute = null;
        private boolean myIsArcAttributeProcessed = false;

        private ArcContext() {
        }

        public void pushArcAttribute(@NotNull IElementType token) {
            if (token == null) {
                ArcContext.$$$reportNull$$$0(0);
            }
            if (!this.myIsArcAttributeProcessed) {
                ARCAttribute parsedArcAttribute = ARCAttribute.getAttributeByToken(token);
                this.myCurrentArcAttribute = parsedArcAttribute != null ? parsedArcAttribute : this.myCurrentArcAttribute;
            }
        }

        @Nullable
        ARCAttribute popArcAttribute() {
            if (this.myCurrentArcAttribute != null) {
                this.myIsArcAttributeProcessed = true;
            }
            ARCAttribute arcAttribute = this.myCurrentArcAttribute;
            this.myCurrentArcAttribute = null;
            return arcAttribute;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/jetbrains/cidr/lang/types/OCTypeBuilder$ArcContext", "pushArcAttribute"));
        }
    }
}

