/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCFunctionType
extends OCTypeCompatibilityVisitor<OCFunctionType> {
    protected OCTypeCompatibilityVisitor_OCFunctionType(@NotNull OCFunctionType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        if (sourceType == null) {
            OCTypeCompatibilityVisitor_OCFunctionType.$$$reportNull$$$0(0);
        }
        if (resolveContext == null) {
            OCTypeCompatibilityVisitor_OCFunctionType.$$$reportNull$$$0(1);
        }
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCTypeCheckResult visitFunctionType(OCFunctionType type) {
        OCFunctionType functionType = (OCFunctionType)this.mySourceType;
        if (!this.isSuperTypeForFunctionChecks(type.getReturnType(), functionType.getReturnType())) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        }
        if (OCCodeInsightUtil.isInPlainOldC((PsiElement)this.myResolveContext.getFile()) && type.getParameterTypes(true).isEmpty()) {
            return OCTypeCheckResult.createOK();
        }
        if (type.getParameterTypes().size() != functionType.getParameterTypes().size()) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        }
        for (int i = 0; i < type.getParameterTypes().size(); ++i) {
            OCType selfArgumentType = type.getParameterTypes().get(i);
            OCType hisArgumentType = functionType.getParameterTypes().get(i);
            if (this.isSuperTypeForFunctionChecks(hisArgumentType, selfArgumentType)) continue;
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        }
        return OCTypeCheckResult.createOK();
    }

    @Override
    public OCTypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitPointerType(OCPointerType type) {
        OCTypeCheckResult result;
        OCType lTerminalType = type.getTerminalType();
        if (!lTerminalType.isUnknown() && !(lTerminalType instanceof OCFunctionType) && type.isPointerToPointerToObjectCompatible() && OCCompilerFeaturesHelper.isArcEnabled(this.myContext.getContainingFile()) && (result = this.checkArcBridgeCast(type, false)) != null) {
            return result;
        }
        boolean isCpp = ((OCFile)this.myContext.getContainingFile()).isCpp();
        if (type.getRefType() instanceof OCFunctionType && !(type instanceof OCBlockPointerType)) {
            return type.getRefType().checkCompatible(this.mySourceType, this.mySource, this.myContext, this.myResolveContext);
        }
        if (type.isPointerToVoid() && !isCpp) {
            return OCTypeCheckResult.createOK();
        }
        return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
    }

    @Override
    public OCTypeCheckResult visitStructType(OCStructType type) {
        if (type.getKind() == OCSymbolKind.ENUM && !type.isEnumClass()) {
            return this.checkAssignToEnum(type);
        }
        return this.checkStructCompatibleCtor(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "resolveContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor_OCFunctionType";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

