/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCExceptionSpecificationKind;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCArrayIndexExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCBinaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCastExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCommaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCConditionalExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerListExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNewExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNoexceptExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCQualifiedExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCThrowExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnaryExpressionSymbolBase;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCNoexceptEvaluatorHelper {
    @NotNull
    private final OCExpressionEvaluator.ValueEvaluator myEvaluator;
    @NotNull
    private OCResolveContext myContext;

    public OCNoexceptEvaluatorHelper(@NotNull OCExpressionEvaluator.ValueEvaluator evaluator, @NotNull OCResolveContext context) {
        if (evaluator == null) {
            OCNoexceptEvaluatorHelper.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCNoexceptEvaluatorHelper.$$$reportNull$$$0(1);
        }
        this.myEvaluator = evaluator;
        this.myContext = context;
    }

    public CanThrowResult canThrow(@Nullable OCExpressionSymbol E) {
        if (E instanceof OCThrowExpressionSymbol) {
            return CanThrowResult.Can;
        }
        if (E instanceof OCCastExpressionSymbol && ((OCCastExpressionSymbol)E).getCastKind() == OCCastKind.DYNAMIC_CAST) {
            return this.canDynamicCastThrow((OCCastExpressionSymbol)E);
        }
        if (E instanceof OCCallExpressionSymbol) {
            OCCallExpressionSymbol CE = (OCCallExpressionSymbol)E;
            OCType returnType = CE.getResolvedType(this.myContext);
            CanThrowResult CT = returnType.isMagicInside(this.myContext) ? CanThrowResult.Dependent : (CE.getCalleeSymbol() != null ? this.canCalleeThrow(CE.getCalleeSymbol()) : CanThrowResult.Can);
            if (CT == CanThrowResult.Can) {
                return CT;
            }
            return OCNoexceptEvaluatorHelper.mergeCanThrow(CT, this.canSubExprsThrow(CE));
        }
        if (!(E instanceof OCNewExpressionSymbol)) {
            if (E instanceof OCConditionalExpressionSymbol || E instanceof OCInitializerListExpressionSymbol || E instanceof OCQualifiedExpressionSymbol || E instanceof OCCommaExpressionSymbol || OCCastExpressionSymbol.isConstCast(E) || OCCastExpressionSymbol.isReinterpretCast(E)) {
                return this.canSubExprsThrow(E);
            }
            if (E instanceof OCUnaryExpressionSymbolBase || E instanceof OCBinaryExpressionSymbol || E instanceof OCArrayIndexExpressionSymbol || OCCastExpressionSymbol.isStaticCast(E) || OCCastExpressionSymbol.isCStyleCast(E)) {
                OCType exprType = E.getResolvedType(this.myContext);
                CanThrowResult CT = exprType.isMagicInside(this.myContext) ? CanThrowResult.Dependent : CanThrowResult.Cannot;
                return OCNoexceptEvaluatorHelper.mergeCanThrow(CT, this.canSubExprsThrow(E));
            }
            if (E instanceof OCReferenceExpressionSymbol || E instanceof OCVariadicPackExpressionSymbol) {
                return CanThrowResult.Cannot;
            }
            if (E instanceof OCLiteralExpressionSymbol || E instanceof OCNoexceptExpressionSymbol || E instanceof OCSizeofExpressionSymbol) {
                return CanThrowResult.Cannot;
            }
        }
        return CanThrowResult.Can;
    }

    public boolean isNothrow(OCFunctionType FT) {
        return this.isNothrow(FT, false);
    }

    public boolean isNothrow(OCFunctionType FT, boolean ResultIfDependent) {
        OCExceptionSpecificationInfo ESI = FT.getExceptionSpecification();
        OCExceptionSpecificationKind EST = ESI.getSpecificationKind();
        if (EST == OCExceptionSpecificationKind.DynamicNone || EST == OCExceptionSpecificationKind.BasicNoexcept) {
            return true;
        }
        if (EST == OCExceptionSpecificationKind.Dynamic && ResultIfDependent) {
            return ResultIfDependent;
        }
        if (EST != OCExceptionSpecificationKind.ComputedNoexcept) {
            return false;
        }
        CanThrowResult meaning = this.getNoexceptSpecMeaning(FT.getExceptionSpecification());
        if (meaning == CanThrowResult.Dependent) {
            return ResultIfDependent;
        }
        return meaning == CanThrowResult.Cannot;
    }

    private CanThrowResult canSubExprsThrow(OCExpressionSymbol E) {
        CanThrowResult res = CanThrowResult.Cannot;
        if (E instanceof OCCallExpressionSymbol) {
            OCCallExpressionSymbol call = (OCCallExpressionSymbol)E;
            for (OCExpressionSymbol arg : call.getArguments()) {
                if ((res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(arg))) != CanThrowResult.Can) continue;
                return res;
            }
            res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(call.getCalleeSymbol()));
        } else if (E instanceof OCQualifiedExpressionSymbol) {
            OCQualifiedExpressionSymbol qualExpr = (OCQualifiedExpressionSymbol)E;
            res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(qualExpr.getQualifier()));
        } else if (E instanceof OCBinaryExpressionSymbol) {
            OCBinaryExpressionSymbol binExpr = (OCBinaryExpressionSymbol)E;
            if ((res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(binExpr.getLeftOperand()))) == CanThrowResult.Can) {
                return res;
            }
            if ((res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(binExpr.getRightOperand()))) == CanThrowResult.Can) {
                return res;
            }
            OCFunctionSymbol symbol = binExpr.tryResolveOperator(this.myContext);
            if (symbol != null) {
                res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canCalleeThrow(symbol));
            }
        } else if (E instanceof OCUnaryExpressionSymbolBase) {
            OCUnaryExpressionSymbolBase unaryExpr = (OCUnaryExpressionSymbolBase)E;
            if ((res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(unaryExpr.getOperand()))) == CanThrowResult.Can) {
                return res;
            }
            OCFunctionSymbol symbol = unaryExpr.tryResolveOperator(this.myContext);
            if (symbol != null) {
                res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canCalleeThrow(symbol));
            }
        } else if (E instanceof OCConditionalExpressionSymbol) {
            OCConditionalExpressionSymbol condExpr = (OCConditionalExpressionSymbol)E;
            if ((res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(condExpr.getCondition()))) == CanThrowResult.Can) {
                return res;
            }
            if ((res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(condExpr.getLeftOperand()))) == CanThrowResult.Can) {
                return res;
            }
            res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(condExpr.getRightOperand()));
        } else if (E instanceof OCInitializerListExpressionSymbol) {
            OCInitializerListExpressionSymbol initListExpr = (OCInitializerListExpressionSymbol)E;
            for (OCExpressionSymbol initializer : initListExpr.getInitializerExpressions()) {
                if ((res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(initializer))) != CanThrowResult.Can) continue;
                return res;
            }
        } else if (E instanceof OCCommaExpressionSymbol) {
            OCCommaExpressionSymbol commaExpr = (OCCommaExpressionSymbol)E;
            if ((res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(commaExpr.getHeadExpression()))) == CanThrowResult.Can) {
                return res;
            }
            res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(commaExpr.getTailExpression()));
        } else if (E instanceof OCCastExpressionSymbol) {
            OCCastExpressionSymbol castExpr = (OCCastExpressionSymbol)E;
            res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(castExpr.getOperand()));
        } else if (E instanceof OCArrayIndexExpressionSymbol) {
            OCArrayIndexExpressionSymbol arraySubscriptionExpr = (OCArrayIndexExpressionSymbol)E;
            res = OCNoexceptEvaluatorHelper.mergeCanThrow(res, this.canThrow(arraySubscriptionExpr.getIndexSymbol()));
        }
        return res;
    }

    private CanThrowResult canDynamicCastThrow(OCCastExpressionSymbol DC) {
        assert (DC.getCastKind() == OCCastKind.DYNAMIC_CAST);
        CanThrowResult canThrowRes = CanThrowResult.Can;
        if (DC.getCastType().isMagicInside(this.myContext)) {
            canThrowRes = CanThrowResult.Dependent;
        } else if (!OCTypeUtils.isCppReferenceType(DC.getCastType())) {
            canThrowRes = CanThrowResult.Cannot;
        } else if (DC.getOperand() != null && DC.getOperand().getResolvedType(this.myContext).isMagicInside(this.myContext)) {
            canThrowRes = CanThrowResult.Dependent;
        }
        if (canThrowRes == CanThrowResult.Can) {
            return canThrowRes;
        }
        if (DC.getOperand() != null) {
            canThrowRes = OCNoexceptEvaluatorHelper.mergeCanThrow(canThrowRes, this.canThrow(DC.getOperand()));
        }
        return canThrowRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CanThrowResult canCalleeThrow(@Nullable OCSymbol callee) {
        OCType T;
        OCSymbol VD = callee;
        if (VD == null) {
            return CanThrowResult.Can;
        }
        if (VD instanceof OCExpressionSymbol) {
            if (VD instanceof OCQualifiedExpressionSymbol) {
                Pair<OCSymbol, OCType> symAndType = ((OCQualifiedExpressionSymbol)VD).getResolvedSymbolAndType(this.myContext);
                T = (OCType)symAndType.second;
                VD = (OCSymbol)symAndType.first;
            } else if (VD instanceof OCReferenceExpressionSymbol) {
                T = VD.getResolvedType(this.myContext);
                VD = ((OCReferenceExpressionSymbol)VD).resolveToSymbol(this.myContext);
            } else {
                T = VD.getResolvedType(this.myContext);
            }
        } else {
            T = VD.getResolvedType(this.myContext);
        }
        if (VD instanceof OCFunctionSymbol && VD.hasAttribute("nothrow")) {
            return CanThrowResult.Cannot;
        }
        OCFunctionType FT = OCTypeUtils.getAs(OCFunctionType.class, T);
        if (FT == null) {
            OCPointerType PT = OCTypeUtils.getAs(OCPointerType.class, T);
            if (PT != null) {
                FT = OCTypeUtils.getAs(OCFunctionType.class, PT.getRefType());
            } else {
                OCCppReferenceType RT = OCTypeUtils.getAs(OCCppReferenceType.class, T);
                if (RT != null) {
                    FT = OCTypeUtils.getAs(OCFunctionType.class, OCTypeUtils.getResolvedCppReferencedType(RT, this.myContext));
                }
            }
        }
        if (FT == null) {
            return CanThrowResult.Can;
        }
        OCResolveContext oldContext = this.myContext;
        try {
            if (VD instanceof OCSymbolWithSubstitution) {
                this.myContext = this.myContext.substitute(((OCSymbolWithSubstitution)((Object)VD)).getSubstitution());
            }
            CanThrowResult canThrowResult = this.isNothrow(FT) ? CanThrowResult.Cannot : CanThrowResult.Can;
            return canThrowResult;
        }
        finally {
            this.myContext = oldContext;
        }
    }

    private CanThrowResult getNoexceptSpecMeaning(OCExceptionSpecificationInfo ESI) {
        OCExceptionSpecificationKind EST = ESI.getSpecificationKind();
        if (EST == OCExceptionSpecificationKind.BasicNoexcept) {
            return CanThrowResult.Cannot;
        }
        if (EST != OCExceptionSpecificationKind.ComputedNoexcept) {
            return CanThrowResult.Can;
        }
        OCExpressionSymbol noexceptExpr = ESI.getNoexceptExpression();
        OCType exprType = noexceptExpr.getResolvedType(this.myContext);
        if (exprType.isMagicInside(this.myContext)) {
            return CanThrowResult.Dependent;
        }
        Object res = noexceptExpr.evaluate(new OCExpressionEvaluator.ValueEvaluator(this.myEvaluator, this.myContext));
        if (res instanceof Boolean && ((Boolean)res).booleanValue()) {
            return CanThrowResult.Cannot;
        }
        if (res instanceof Number && ((Number)res).intValue() != 0) {
            return CanThrowResult.Cannot;
        }
        return CanThrowResult.Can;
    }

    private static CanThrowResult mergeCanThrow(CanThrowResult CT1, CanThrowResult CT2) {
        return CT1.priority > CT2.priority ? CT1 : CT2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "evaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/util/OCNoexceptEvaluatorHelper";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum CanThrowResult {
        Cannot(0),
        Dependent(1),
        Can(2);

        public final int priority;

        private CanThrowResult(int priority) {
            this.priority = priority;
        }
    }
}

