/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCCommaExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCParenthesesUtils {
    public static final int SEND_MESSAGE_OUTER_PRECEDENCE = 1;
    public static final int POSTFIX_INCDEC_PRECEDENCE = 2;
    public static final int PREFIX_INCDEC_PRECEDENCE = 3;
    public static final int UNARY_OP_PRECEDENCE = 4;
    public static final int PM_OP_PRECEDENCE = 5;
    public static final int MULTIPLICATIVE_PRECEDENCE = 6;
    public static final int ADDITIVE_PRECEDENCE = 7;
    public static final int SHIFT_PRECEDENCE = 8;
    public static final int SPACESHIP_PRECEDENCE = 9;
    public static final int RELATIONAL_PRECEDENCE = 10;
    public static final int EQUALITY_PRECEDENCE = 11;
    public static final int BITWISE_AND_PRECEDENCE = 12;
    public static final int BITWISE_XOR_PRECEDENCE = 13;
    public static final int BITWISE_OR_PRECEDENCE = 14;
    public static final int LOGICAL_AND_PRECEDENCE = 15;
    public static final int LOGICAL_OR_PRECEDENCE = 16;
    public static final int TERNARY_OPERATOR_PRECEDENCE = 17;
    public static final int ASSIGNMENT_PRECEDENCE = 17;
    public static final int COMMA_PRECEDENCE = 18;
    public static final int SEND_MESSAGE_INNER_PRECEDENCE = 19;
    public static final int COMPOUND_INITIALIZER_PRECEDENCE = 20;
    private static final Map<OCElementType, Integer> BINARY_OPERATOR_PRECEDENCE = new HashMap<OCElementType, Integer>();

    private OCParenthesesUtils() {
    }

    public static int getPrecedence(OCElementType operator) {
        if (operator == OCLexerTokenTypes.EQ) {
            return 17;
        }
        if (OCLexerTokenTypes.UNARY_OPERATIONS.contains((IElementType)operator)) {
            return 4;
        }
        if (BINARY_OPERATOR_PRECEDENCE.containsKey(operator)) {
            return BINARY_OPERATOR_PRECEDENCE.get(operator);
        }
        throw new IllegalArgumentException("Unknown precedence of operator " + operator.getName());
    }

    public static int getBinaryPrecedence(OCElementType operator) {
        if (BINARY_OPERATOR_PRECEDENCE.containsKey(operator)) {
            return BINARY_OPERATOR_PRECEDENCE.get(operator);
        }
        throw new IllegalArgumentException("Unknown precedence of operator " + operator.getName());
    }

    public static int getPrecedence(OCExpression expression, boolean isInnerPrecedence) {
        if (expression instanceof OCParenthesizedExpression || expression instanceof OCLiteralExpression || expression instanceof OCReferenceExpression) {
            return 0;
        }
        if (expression instanceof OCPostfixExpression) {
            return 2;
        }
        if (expression instanceof OCQualifiedExpression || expression instanceof OCPrefixExpression || expression instanceof OCArraySelectionExpression || expression instanceof OCCallExpression) {
            return 3;
        }
        if (expression instanceof OCUnaryExpression || expression instanceof OCCastExpression || expression instanceof OCSizeofExpression) {
            return 4;
        }
        if (expression instanceof OCBinaryExpression) {
            return BINARY_OPERATOR_PRECEDENCE.get(((OCBinaryExpression)expression).getOperationSign());
        }
        if (expression instanceof OCConditionalExpression) {
            return 17;
        }
        if (expression instanceof OCAssignmentExpression) {
            return 17;
        }
        if (expression instanceof OCCommaExpression) {
            return 18;
        }
        if (expression instanceof OCSendMessageExpression) {
            return isInnerPrecedence ? 19 : 1;
        }
        if (expression instanceof OCCompoundInitializer) {
            return 20;
        }
        return -1;
    }

    private static boolean isDanglingElse(@NotNull OCStatement stmt) {
        PsiElement parent;
        if (stmt == null) {
            OCParenthesesUtils.$$$reportNull$$$0(0);
        }
        if ((parent = stmt.getParent()) instanceof OCIfStatement) {
            OCIfStatement ifStmt = (OCIfStatement)parent;
            if (ifStmt.getThenBranch() == stmt && ifStmt.getElseBranch() != null) {
                return true;
            }
            return OCParenthesesUtils.isDanglingElse(ifStmt);
        }
        if (parent instanceof OCStatementWithExpression) {
            return OCParenthesesUtils.isDanglingElse((OCStatement)parent);
        }
        return false;
    }

    private static boolean isShortIf(@Nullable OCStatement stmt) {
        if (stmt instanceof OCIfStatement) {
            OCStatement elseBranch = ((OCIfStatement)stmt).getElseBranch();
            return elseBranch == null || OCParenthesesUtils.isShortIf(elseBranch);
        }
        if (stmt instanceof OCStatementWithExpression) {
            OCStatement nestedStmt = ((OCStatementWithExpression)stmt).getBody();
            return OCParenthesesUtils.isShortIf(nestedStmt);
        }
        if (stmt instanceof OCCaseStatement) {
            OCStatement nestedStmt = ((OCCaseStatement)stmt).getStatement();
            return OCParenthesesUtils.isShortIf(nestedStmt);
        }
        return false;
    }

    public static boolean canStripBraces(@NotNull OCBlockStatement blockStatement) {
        List<OCStatement> statements;
        if (blockStatement == null) {
            OCParenthesesUtils.$$$reportNull$$$0(1);
        }
        if ((statements = blockStatement.getStatements()).size() != 1) {
            return false;
        }
        OCStatement nestedStmt = statements.get(0);
        return !OCParenthesesUtils.isShortIf(nestedStmt) || !OCParenthesesUtils.isDanglingElse(blockStatement);
    }

    @Nullable
    public static OCStatement stripBraces(@Nullable OCStatement branch) {
        if (branch instanceof OCBlockStatement) {
            OCBlockStatement block = (OCBlockStatement)branch;
            List<OCStatement> statements = block.getStatements();
            if (statements.size() == 1) {
                return statements.get(0);
            }
            return block;
        }
        return branch;
    }

    @NotNull
    public static OCParenthesizedExpression appendParentheses(@NotNull OCExpression expression) {
        if (expression == null) {
            OCParenthesesUtils.$$$reportNull$$$0(2);
        }
        OCParenthesizedExpression parent = (OCParenthesizedExpression)OCElementFactory.expressionFromText("(1)", expression, false);
        OCChangeUtil.replaceHandlingMacros(parent.getOperand(), expression);
        OCParenthesizedExpression oCParenthesizedExpression = parent;
        if (oCParenthesizedExpression == null) {
            OCParenthesesUtils.$$$reportNull$$$0(3);
        }
        return oCParenthesizedExpression;
    }

    public static PsiElement replaceExpressionAndRemoveAppendParentheses(@NotNull OCExpression oldElement, @NotNull OCExpression newElement) {
        if (oldElement == null) {
            OCParenthesesUtils.$$$reportNull$$$0(4);
        }
        if (newElement == null) {
            OCParenthesesUtils.$$$reportNull$$$0(5);
        }
        newElement = OCParenthesesUtils.diveIntoParenthesesButNotIntoMacroCall(newElement);
        while (oldElement.getParent() instanceof OCParenthesizedExpression) {
            oldElement = (OCExpression)oldElement.getParent();
        }
        return OCParenthesesUtils.replaceExpressionAndAppendParentheses(oldElement, newElement);
    }

    public static PsiElement replaceExpressionAndAppendParentheses(@NotNull OCExpression oldElement, @NotNull OCExpression newElement) {
        OCDeclaration declaration;
        if (oldElement == null) {
            OCParenthesesUtils.$$$reportNull$$$0(6);
        }
        if (newElement == null) {
            OCParenthesesUtils.$$$reportNull$$$0(7);
        }
        if (newElement instanceof OCCompoundInitializer && newElement.getParent() instanceof OCDeclarator && !(oldElement instanceof OCCompoundInitializer) && (declaration = (OCDeclaration)newElement.getParent().getParent()).getTypeElement() != null) {
            OCCastExpression cast = (OCCastExpression)OCElementFactory.expressionFromText("(int)1", newElement);
            OCChangeUtil.replaceHandlingMacros(cast.getTypeElement(), declaration.getTypeElement());
            OCChangeUtil.replaceHandlingMacros(cast.getOperand(), newElement);
            newElement = cast;
        }
        if (OCParenthesesUtils.isParenthesesNeededInReplacing(oldElement, newElement)) {
            return OCChangeUtil.replaceHandlingMacros(oldElement, OCParenthesesUtils.appendParentheses(newElement));
        }
        return OCChangeUtil.replaceHandlingMacros(oldElement, newElement);
    }

    public static boolean isParenthesesNeededInReplacing(@NotNull OCExpression oldElement, @NotNull OCExpression newElement) {
        PsiElement parent;
        if (oldElement == null) {
            OCParenthesesUtils.$$$reportNull$$$0(8);
        }
        if (newElement == null) {
            OCParenthesesUtils.$$$reportNull$$$0(9);
        }
        if ((parent = oldElement.getParent()) instanceof OCExpression) {
            int destPrecedence;
            int parentPrecedence = OCParenthesesUtils.getPrecedence((OCExpression)parent, true);
            if (parentPrecedence > (destPrecedence = OCParenthesesUtils.getPrecedence(newElement, false))) {
                return false;
            }
            if (parentPrecedence < destPrecedence) {
                return true;
            }
            if (parent instanceof OCConditionalExpression && newElement instanceof OCConditionalExpression && ((OCConditionalExpression)parent).getCondition() == oldElement) {
                return true;
            }
            if (parent instanceof OCAssignmentExpression && oldElement == ((OCAssignmentExpression)parent).getReceiverExpression()) {
                return true;
            }
            if (parent instanceof OCBinaryExpression && oldElement == ((OCBinaryExpression)parent).getRight()) {
                return OCParenthesesUtils.isParenthesesNeededInRightArgument((OCBinaryExpression)parent, newElement);
            }
            return false;
        }
        return false;
    }

    public static boolean isParenthesesNeededInRightArgument(OCBinaryExpression parent, OCExpression right) {
        if (right instanceof OCBinaryExpression) {
            OCBinaryExpression binSource = (OCBinaryExpression)right;
            if (parent.getOperationSign() == binSource.getOperationSign() && (binSource.getOperationSign() == OCLexerTokenTypes.ANDAND || binSource.getOperationSign() == OCLexerTokenTypes.OROR)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isParenthesesNeededInLeftArgument(@NotNull OCAssignmentExpression parentAssignmentExpression, @NotNull OCExpression leftExpression) {
        if (parentAssignmentExpression == null) {
            OCParenthesesUtils.$$$reportNull$$$0(10);
        }
        if (leftExpression == null) {
            OCParenthesesUtils.$$$reportNull$$$0(11);
        }
        if (leftExpression instanceof OCAssignmentExpression) {
            OCAssignmentExpression leftBinaryExpression = (OCAssignmentExpression)leftExpression;
            return OCLexerTokenTypes.ASSIGNMENT_OPERATIONS.contains((IElementType)leftBinaryExpression.getOperationSign()) && OCLexerTokenTypes.ASSIGNMENT_OPERATIONS.contains((IElementType)parentAssignmentExpression.getOperationSign());
        }
        return false;
    }

    @Nullable
    public static OCExpression diveIntoParenthesesAndCasts(@Nullable OCExpression expression) {
        return OCParenthesesUtils.diveIntoParenthesesAndCasts(expression, OCCastKind.values());
    }

    @Nullable
    public static OCExpression diveIntoParenthesesAndCasts(@Nullable OCExpression expression, OCCastKind @NotNull [] acceptableCasts) {
        if (acceptableCasts == null) {
            OCParenthesesUtils.$$$reportNull$$$0(12);
        }
        while (true) {
            OCCastExpression castExpression;
            if (expression instanceof OCParenthesizedExpression) {
                expression = ((OCParenthesizedExpression)expression).getOperand();
                continue;
            }
            if (!(expression instanceof OCCastExpression) || ArrayUtil.indexOf((Object[])acceptableCasts, (Object)((Object)(castExpression = (OCCastExpression)expression).getCastKind())) == -1) break;
            expression = castExpression.getOperand();
        }
        return expression;
    }

    @Nullable
    public static OCExpression diveIntoParenthesesButNotIntoMacroCall(@Nullable OCExpression expr) {
        if (expr instanceof OCParenthesizedExpression && !OCElementUtil.isPartOfMacroSubstitution(expr)) {
            return OCParenthesesUtils.diveIntoParenthesesButNotIntoMacroCall(((OCParenthesizedExpression)expr).getOperand());
        }
        return expr;
    }

    @Nullable
    public static OCTypeOwner diveIntoParentheses(@Nullable OCTypeOwner expr) {
        return expr instanceof OCExpression ? OCParenthesesUtils.diveIntoParentheses((OCExpression)expr) : expr;
    }

    @Nullable
    public static OCExpression diveIntoParentheses(@Nullable OCExpression expr) {
        if (expr instanceof OCParenthesizedExpression) {
            return OCParenthesesUtils.diveIntoParentheses(((OCParenthesizedExpression)expr).getOperand());
        }
        return expr;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement diveIntoParenthesesAndCasts(@Nullable PsiElement element) {
        if (element instanceof OCExpression) {
            return OCParenthesesUtils.diveIntoParenthesesAndCasts((OCExpression)element);
        }
        return element;
    }

    public static OCExpression topmostParenthesized(OCExpression expr) {
        if (expr.getParent() instanceof OCParenthesizedExpression) {
            return OCParenthesesUtils.topmostParenthesized((OCExpression)expr.getParent());
        }
        return expr;
    }

    public static boolean areExpressionsEquivalent(@Nullable OCExpression expr1, @Nullable OCExpression expr2, boolean differentMacrosAreEquivalent, @NotNull OCResolveContext context) {
        if (context == null) {
            OCParenthesesUtils.$$$reportNull$$$0(13);
        }
        expr1 = OCParenthesesUtils.diveIntoParentheses(expr1);
        expr2 = OCParenthesesUtils.diveIntoParentheses(expr2);
        return expr1 != null && expr2 != null && OCElementUtil.areElementsEquivalent(expr1, expr2, differentMacrosAreEquivalent, context);
    }

    public static boolean areExpressionsOpposite(OCExpression expr1, OCExpression expr2, boolean differentMacrosAreEquivalent, @NotNull OCResolveContext context) {
        if (context == null) {
            OCParenthesesUtils.$$$reportNull$$$0(14);
        }
        expr1 = OCParenthesesUtils.diveIntoParentheses(expr1);
        expr2 = OCParenthesesUtils.diveIntoParentheses(expr2);
        if (expr1 instanceof OCUnaryExpression && ((OCUnaryExpression)expr1).getOperationSign() == OCLexerTokenTypes.EXCL) {
            return OCParenthesesUtils.areExpressionsEquivalent(((OCUnaryExpression)expr1).getOperand(), expr2, differentMacrosAreEquivalent, context);
        }
        if (expr2 instanceof OCUnaryExpression && ((OCUnaryExpression)expr2).getOperationSign() == OCLexerTokenTypes.EXCL) {
            return OCParenthesesUtils.areExpressionsEquivalent(((OCUnaryExpression)expr2).getOperand(), expr1, differentMacrosAreEquivalent, context);
        }
        return false;
    }

    static {
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.DOT_MUL, 5);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.DEREF_MUL, 5);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.MUL, 6);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.DIV, 6);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.PERC, 6);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.PLUS, 7);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.MINUS, 7);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.LTLT, 8);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.GTGT, 8);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.SPACESHIP, 9);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.LT, 10);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.LTEQ, 10);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.GT, 10);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.GTEQ, 10);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.EQEQ, 11);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.EXCLEQ, 11);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.AND, 12);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.XOR, 13);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.OR, 14);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.ANDAND, 15);
        BINARY_OPERATOR_PRECEDENCE.put((OCElementType)OCLexerTokenTypes.OROR, 16);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStatement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCParenthesesUtils";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentAssignmentExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableCasts";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCParenthesesUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "appendParentheses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDanglingElse";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canStripBraces";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendParentheses";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionAndRemoveAppendParentheses";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionAndAppendParentheses";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isParenthesesNeededInReplacing";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isParenthesesNeededInLeftArgument";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "diveIntoParenthesesAndCasts";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "areExpressionsEquivalent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "areExpressionsOpposite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

