/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.dsl.translator;

import com.intellij.rml.dfa.RmlParseException;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Expr;
import com.intellij.rml.dfa.impl.rml.ast.ExprConst;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprBinary;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVar;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.ast.StmtAssign;
import com.intellij.rml.dfa.impl.rml.ast.StmtBreakpoint;
import com.intellij.rml.dfa.impl.rml.ast.StmtIf;
import com.intellij.rml.dfa.impl.rml.ast.StmtIncrementalize;
import com.intellij.rml.dfa.impl.rml.ast.StmtList;
import com.intellij.rml.dfa.impl.rml.ast.StmtPrint;
import com.intellij.rml.dfa.impl.rml.ast.StmtRelAssign;
import com.intellij.rml.dfa.impl.rml.dsl.translator.RmlBooleanExpressionTranslator;
import com.intellij.rml.dfa.impl.rml.dsl.translator.RmlRelationExpressionTranslator;
import com.intellij.rml.dfa.impl.rml.dsl.translator.RmlRelationExpressionTranslatorKt;
import com.intellij.rml.dfa.impl.rml.dsl.translator.RmlStatementBlockTranslator;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.rml.dsl.ast.RmlAssignStatement;
import com.intellij.rml.dfa.rml.dsl.ast.RmlBooleanVarAssignStatement;
import com.intellij.rml.dfa.rml.dsl.ast.RmlBreakpointStatement;
import com.intellij.rml.dfa.rml.dsl.ast.RmlIfStatement;
import com.intellij.rml.dfa.rml.dsl.ast.RmlIncrementalizeStatement;
import com.intellij.rml.dfa.rml.dsl.ast.RmlPrintStatement;
import com.intellij.rml.dfa.rml.dsl.ast.RmlStatement;
import com.intellij.rml.dfa.rml.dsl.ast.RmlStatementBlock;
import com.intellij.rml.dfa.rml.dsl.ast.RmlUseStatement;
import com.intellij.rml.dfa.utils.UtilsKt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/rml/dfa/impl/rml/dsl/translator/RmlStatementTranslator;", "", "context", "Lcom/intellij/rml/dfa/impl/rml/ast/Context;", "manager", "Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;", "<init>", "(Lcom/intellij/rml/dfa/impl/rml/ast/Context;Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;)V", "exprTranslator", "Lcom/intellij/rml/dfa/impl/rml/dsl/translator/RmlRelationExpressionTranslator;", "stmtBlockTranslator", "Lcom/intellij/rml/dfa/impl/rml/dsl/translator/RmlStatementBlockTranslator;", "boolExprTranslator", "Lcom/intellij/rml/dfa/impl/rml/dsl/translator/RmlBooleanExpressionTranslator;", "translate", "Lcom/intellij/rml/dfa/impl/rml/ast/Stmt;", "statement", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlStatement;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nRmlStatementTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RmlStatementTranslator.kt\ncom/intellij/rml/dfa/impl/rml/dsl/translator/RmlStatementTranslator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n37#2:125\n36#2,3:126\n1872#3,3:129\n1863#3,2:132\n1557#3:135\n1628#3,3:136\n1557#3:139\n1628#3,3:140\n1#4:134\n*S KotlinDebug\n*F\n+ 1 RmlStatementTranslator.kt\ncom/intellij/rml/dfa/impl/rml/dsl/translator/RmlStatementTranslator\n*L\n32#1:125\n32#1:126,3\n39#1:129,3\n49#1:132,2\n95#1:135\n95#1:136,3\n102#1:139\n102#1:140,3\n*E\n"})
public final class RmlStatementTranslator {
    @NotNull
    private final Context context;
    @NotNull
    private final VariablesManager manager;
    @NotNull
    private final RmlRelationExpressionTranslator exprTranslator;
    @NotNull
    private final RmlStatementBlockTranslator stmtBlockTranslator;
    @NotNull
    private final RmlBooleanExpressionTranslator boolExprTranslator;

    public RmlStatementTranslator(@NotNull Context context, @NotNull VariablesManager manager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.context = context;
        this.manager = manager;
        this.exprTranslator = new RmlRelationExpressionTranslator(this.context, this.manager);
        this.stmtBlockTranslator = new RmlStatementBlockTranslator(this.context, this.manager, this);
        this.boolExprTranslator = new RmlBooleanExpressionTranslator(this.context, this.manager);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Stmt translate(@NotNull RmlStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        RmlStatement rmlStatement = statement;
        if (rmlStatement instanceof RmlAssignStatement) {
            String relationName = ((RmlAssignStatement)statement).getRelationName();
            Collection $this$toTypedArray$iv = ((RmlAssignStatement)statement).getArgumentVars();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] argumentVars = thisCollection$iv.toArray(new String[0]);
            DomainType[] domainTypeArray = this.manager.getRelation(relationName);
            if (domainTypeArray == null) {
                throw new RmlParseException("Relation " + relationName + " is not registered in input/output/temp block", null, 2, null);
            }
            DomainType[] types = domainTypeArray;
            if (this.manager.isInputRelation(relationName)) {
                throw new RmlParseException("Cannot reassign input relation " + relationName, null, 2, null);
            }
            Iterable $this$forEachIndexed$iv = ((RmlAssignStatement)statement).getArgumentVars();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void varName;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int i = n;
                boolean bl = false;
                if (this.manager.containsDomain((String)varName)) {
                    throw new RmlParseException("In " + relationName + " variable " + (String)varName + " is already defined", null, 2, null);
                }
                this.manager.addDomain((String)varName, types[i]);
            }
            RelExpr expr = this.exprTranslator.translate(((RmlAssignStatement)statement).getExpr());
            Iterable $this$forEach$iv = ((RmlAssignStatement)statement).getArgumentVars();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String varName = (String)element$iv;
                boolean bl = false;
                if (!this.manager.wasDomainUsed(varName)) {
                    throw new RmlParseException("Variable " + varName + " of " + relationName + " is not used", null, 2, null);
                }
                this.manager.removeDomain(varName);
            }
            return switch (WhenMappings.$EnumSwitchMapping$0[((RmlAssignStatement)statement).getType().ordinal()]) {
                case 1 -> new StmtRelAssign(relationName, argumentVars, expr, this.context);
                case 2 -> RmlStatementTranslator.translate$makeAssignmentStmt(relationName, argumentVars, this, expr, 0);
                case 3 -> RmlStatementTranslator.translate$makeAssignmentStmt(relationName, argumentVars, this, expr, 3);
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        if (rmlStatement instanceof RmlIncrementalizeStatement) {
            StmtList initStmt = this.stmtBlockTranslator.translate(((RmlIncrementalizeStatement)statement).getInitBlock(), "Init");
            StmtList loopStmt = this.stmtBlockTranslator.translate(((RmlIncrementalizeStatement)statement).getLoopBlock(), "Loop");
            return new StmtIncrementalize(((RmlIncrementalizeStatement)statement).getRelationNames(), initStmt, loopStmt, this.context);
        }
        if (rmlStatement instanceof RmlIfStatement) {
            StmtList stmtList;
            StmtList trueStmt = RmlStatementBlockTranslator.translate$default(this.stmtBlockTranslator, ((RmlIfStatement)statement).getTrueBody(), null, 2, null);
            RmlStatementBlock rmlStatementBlock = ((RmlIfStatement)statement).getFalseBody();
            if (rmlStatementBlock != null) {
                RmlStatementBlock it = rmlStatementBlock;
                boolean bl = false;
                stmtList = RmlStatementBlockTranslator.translate$default(this.stmtBlockTranslator, it, null, 2, null);
            } else {
                stmtList = null;
            }
            StmtList falseStmt = stmtList;
            Expr conditionExpr = this.boolExprTranslator.translate(((RmlIfStatement)statement).getCondition());
            return new StmtIf(conditionExpr, trueStmt, falseStmt, this.context);
        }
        if (rmlStatement instanceof RmlBooleanVarAssignStatement) {
            int n = UtilsKt.toInt((boolean)((RmlBooleanVarAssignStatement)statement).getValue());
            return new StmtAssign(((RmlBooleanVarAssignStatement)statement).getVarName(), new ExprConst(n, this.context), this.context);
        }
        if (rmlStatement instanceof RmlUseStatement) {
            String relationName = ((RmlUseStatement)statement).getRelationName();
            if (this.manager.getRelation(relationName) == null) {
                throw new RmlParseException("Relation " + relationName + " is not registered in input/output/temp block", null, 2, null);
            }
            return new StmtList(new ArrayList(), this.context, "Use " + relationName);
        }
        if (rmlStatement instanceof RmlPrintStatement) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = ((RmlPrintStatement)statement).getArgs();
            boolean $i$f$map = false;
            Iterable expr = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                int n;
                void it;
                RmlPrintStatement.PrintArgument varName = (RmlPrintStatement.PrintArgument)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void i = it;
                if (i instanceof RmlPrintStatement.PrintArgument.RelationArgument) {
                    n = 1;
                } else if (i instanceof RmlPrintStatement.PrintArgument.StringArgument) {
                    n = 2;
                } else if (i instanceof RmlPrintStatement.PrintArgument.RelationCustomFunArgument) {
                    n = 7;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(n);
            }
            List printTypes = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            Iterable $this$map$iv2 = ((RmlPrintStatement)statement).getArgs();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Serializable serializable;
                void it;
                RmlPrintStatement.PrintArgument bl = (RmlPrintStatement.PrintArgument)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                void var14_46 = it;
                if (var14_46 instanceof RmlPrintStatement.PrintArgument.RelationArgument) {
                    serializable = (Serializable)((Object)((RmlPrintStatement.PrintArgument.RelationArgument)it).getName());
                } else if (var14_46 instanceof RmlPrintStatement.PrintArgument.StringArgument) {
                    serializable = (Serializable)((Object)((RmlPrintStatement.PrintArgument.StringArgument)it).getValue());
                } else if (var14_46 instanceof RmlPrintStatement.PrintArgument.RelationCustomFunArgument) {
                    serializable = (Serializable)new Pair((Object)((RmlPrintStatement.PrintArgument.RelationCustomFunArgument)it).getRelName(), RmlRelationExpressionTranslatorKt.translateCustomFunction(((RmlPrintStatement.PrintArgument.RelationCustomFunArgument)it).getFunction()));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(serializable);
            }
            List printValues = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
            String end = ((RmlPrintStatement)statement).getEnd();
            if (end != null) {
                printTypes.add(2);
                printValues.add(end);
            }
            return new StmtPrint(printTypes, printValues, this.context);
        }
        if (rmlStatement instanceof RmlBreakpointStatement) {
            return new StmtBreakpoint(this.context);
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final StmtRelAssign translate$makeAssignmentStmt(String relationName, String[] argumentVars, RmlStatementTranslator this$0, RelExpr expr, int type) {
        RelExprBinary body = new RelExprBinary(type, new RelExprVar(relationName, argumentVars, this$0.context), expr, this$0.context);
        return new StmtRelAssign(relationName, argumentVars, body, this$0.context);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RmlAssignStatement.OperationType.values().length];
            try {
                nArray[RmlAssignStatement.OperationType.ASSIGN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlAssignStatement.OperationType.UNITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlAssignStatement.OperationType.SUBTRACT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

