/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.scripts;

import com.intellij.openapi.util.Ref;
import com.intellij.rml.dfa.AnalysisPass;
import com.intellij.rml.dfa.RmlParseException;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.rml.BruteForceDomainsPool;
import com.intellij.rml.dfa.impl.rml.DomainPoolProfiler;
import com.intellij.rml.dfa.impl.rml.DomainPoolProfilerDummy;
import com.intellij.rml.dfa.impl.rml.SemiNaiveHandlerKt;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.dsl.translator.RmlProgramTranslator;
import com.intellij.rml.dfa.impl.scripts.RMLScriptDSL;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.impl.ui.ThreadCallback;
import com.intellij.rml.dfa.rml.dsl.ast.RmlProgram;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/rml/dfa/impl/scripts/RMLScriptDSLCompiler;", "", "<init>", "()V", "astNodeCounter", "Lcom/intellij/openapi/util/Ref;", "", "compile", "Lcom/intellij/rml/dfa/impl/scripts/RMLScriptDSL;", "name", "", "pass", "Lcom/intellij/rml/dfa/AnalysisPass;", "rmlProgram", "Lcom/intellij/rml/dfa/rml/dsl/ast/RmlProgram;", "typeManager", "Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;", "threadCallback", "Lcom/intellij/rml/dfa/impl/ui/ThreadCallback;", "domainPoolProfiler", "Lcom/intellij/rml/dfa/impl/rml/DomainPoolProfiler;", "intellij.rml.dfa.impl"})
public final class RMLScriptDSLCompiler {
    @NotNull
    private final Ref<Integer> astNodeCounter;

    public RMLScriptDSLCompiler() {
        Ref ref = Ref.create((Object)0);
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        this.astNodeCounter = ref;
    }

    @NotNull
    public final RMLScriptDSL compile(@NotNull String name, @NotNull AnalysisPass pass, @NotNull RmlProgram rmlProgram, @NotNull DomainTypeManager typeManager, @NotNull ThreadCallback threadCallback, @NotNull DomainPoolProfiler domainPoolProfiler) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
        Intrinsics.checkNotNullParameter((Object)rmlProgram, (String)"rmlProgram");
        Intrinsics.checkNotNullParameter((Object)typeManager, (String)"typeManager");
        Intrinsics.checkNotNullParameter((Object)threadCallback, (String)"threadCallback");
        Intrinsics.checkNotNullParameter((Object)domainPoolProfiler, (String)"domainPoolProfiler");
        try {
            VariablesManager varManager = new VariablesManager(typeManager);
            RmlProgramTranslator translator = new RmlProgramTranslator(varManager, this.astNodeCounter);
            Stmt compiledStmt = translator.translate(rmlProgram);
            BruteForceDomainsPool domainsPool = new BruteForceDomainsPool(domainPoolProfiler);
            domainsPool.arrangeDomains(compiledStmt, varManager, threadCallback);
            SemiNaiveHandlerKt.checkForSemiNaive(compiledStmt, varManager);
            varManager.checkUnusedRelations(name);
            return new RMLScriptDSL(name, pass, compiledStmt, domainsPool, varManager);
        }
        catch (RmlParseException e) {
            throw new RmlParseException(e.getMessage() + " in script " + name, (Throwable)e);
        }
    }

    public static /* synthetic */ RMLScriptDSL compile$default(RMLScriptDSLCompiler rMLScriptDSLCompiler, String string, AnalysisPass analysisPass, RmlProgram rmlProgram, DomainTypeManager domainTypeManager, ThreadCallback threadCallback, DomainPoolProfiler domainPoolProfiler, int n, Object object) {
        if ((n & 0x20) != 0) {
            domainPoolProfiler = DomainPoolProfilerDummy.INSTANCE;
        }
        return rMLScriptDSLCompiler.compile(string, analysisPass, rmlProgram, domainTypeManager, threadCallback, domainPoolProfiler);
    }
}

