/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.translator;

import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.Quadruple;
import com.intellij.rml.dfa.analyzes.MayPointsToAnalysisKt;
import com.intellij.rml.dfa.analyzes.ParametersSubstitutorAnalysisKt;
import com.intellij.rml.dfa.analyzes.extensions.ConditionsExtensionKt;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.impl.DfaAnalysisIrResultImpl;
import com.intellij.rml.dfa.impl.translator.CfgConsistencyCheckStage;
import com.intellij.rml.dfa.impl.translator.IrConsistencyCheckerKt;
import com.intellij.rml.dfa.ir.DfaInvalidIrException;
import com.intellij.rml.dfa.ir.IrEnvironment;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.ast.IrDeclaration;
import com.intellij.rml.dfa.ir.ast.IrFieldDecl;
import com.intellij.rml.dfa.ir.ast.IrFieldID;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.ir.ast.IrIdentifier;
import com.intellij.rml.dfa.ir.ast.IrLoadStmt;
import com.intellij.rml.dfa.ir.ast.IrLocationID;
import com.intellij.rml.dfa.ir.ast.IrObjectID;
import com.intellij.rml.dfa.ir.ast.IrRecordDecl;
import com.intellij.rml.dfa.ir.ast.IrRecordID;
import com.intellij.rml.dfa.ir.ast.IrRecursiveVisitor;
import com.intellij.rml.dfa.ir.ast.IrStatement;
import com.intellij.rml.dfa.ir.ast.IrStatementsVisitor;
import com.intellij.rml.dfa.ir.ast.IrStaticCallStmt;
import com.intellij.rml.dfa.ir.ast.IrStoreStmt;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelVisitor;
import com.intellij.rml.dfa.ir.ast.IrVarID;
import com.intellij.rml.dfa.utils.RMLOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"checkEnvironment", "", "environment", "Lcom/intellij/rml/dfa/ir/IrEnvironment;", "topLevelDecls", "", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "checkIdentifiers", "identifiers", "Lcom/intellij/rml/dfa/ir/ast/IrIdentifier;", "checkNotInitialized", "result", "Lcom/intellij/rml/dfa/impl/DfaAnalysisIrResultImpl;", "invalidIrError", "message", "", "location", "Lcom/intellij/rml/dfa/ir/IrLocation;", "check", "Lcom/intellij/rml/dfa/AnalysisOptions$ConsistencyCheck;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nIrConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConsistencyChecker.kt\ncom/intellij/rml/dfa/impl/translator/IrConsistencyCheckerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1485#2:162\n1510#2,3:163\n1513#2,3:173\n1557#2:180\n1628#2,3:181\n1863#2,2:185\n1863#2,2:187\n1863#2,2:189\n381#3,7:166\n126#4:176\n153#4,3:177\n1#5:184\n*S KotlinDebug\n*F\n+ 1 IrConsistencyChecker.kt\ncom/intellij/rml/dfa/impl/translator/IrConsistencyCheckerKt\n*L\n110#1:162\n110#1:163,3\n110#1:173,3\n112#1:180\n112#1:181,3\n131#1:185,2\n136#1:187,2\n141#1:189,2\n110#1:166,7\n110#1:176\n110#1:177,3\n*E\n"})
public final class IrConsistencyCheckerKt {
    public static final void checkEnvironment(@NotNull IrEnvironment environment, @NotNull List<? extends IrTopLevelDecl> topLevelDecls, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(topLevelDecls, (String)"topLevelDecls");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        AnalysisOptions.ConsistencyCheck checkMode = (AnalysisOptions.ConsistencyCheck)options.get(AnalysisOptions.INSTANCE.getCheckEnvironment());
        if (checkMode.getMode() != AnalysisOptions.CheckMode.Skip) {
            List identifiers = new ArrayList();
            for (IrTopLevelDecl irTopLevelDecl : topLevelDecls) {
                irTopLevelDecl.accept((IrTopLevelVisitor)new IrRecursiveVisitor(irTopLevelDecl, identifiers, environment, checkMode){
                    final /* synthetic */ IrTopLevelDecl $decl;
                    final /* synthetic */ List<IrIdentifier> $identifiers;
                    final /* synthetic */ IrEnvironment $environment;
                    final /* synthetic */ AnalysisOptions.ConsistencyCheck $checkMode;
                    {
                        this.$decl = $decl;
                        this.$identifiers = $identifiers;
                        this.$environment = $environment;
                        this.$checkMode = $checkMode;
                    }

                    public void visitStatement(IrStatement stmt) {
                        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                        stmt.accept((IrStatementsVisitor)new IrRecursiveVisitor(this, stmt){
                            final /* synthetic */ checkEnvironment.1 this$0;
                            final /* synthetic */ IrStatement $stmt;
                            {
                                this.this$0 = $receiver;
                                this.$stmt = $stmt;
                            }

                            public void visitIdentifier(IrIdentifier identifier) {
                                Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                                checkEnvironment.1.access$checkDefinedIdentifier(this.this$0, identifier, this.$stmt.getLocation());
                            }
                        });
                    }

                    public void visitIdentifier(IrIdentifier identifier) {
                        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                        this.checkDefinedIdentifier(identifier, this.$decl.getLocation());
                        ((Collection)this.$identifiers).add(identifier);
                    }

                    private final void checkDefinedIdentifier(IrIdentifier identifier, IrLocation location) {
                        if (!(identifier instanceof IrFieldID) && this.$environment.resolve(identifier, this.$decl.getName()) == null) {
                            IrConsistencyCheckerKt.invalidIrError("Undefined identifier " + identifier, location, this.$checkMode);
                        }
                    }

                    private final void checkField(IrRecordID record, IrFieldID field, IrLocation location) {
                        if (record != null) {
                            if (!(this.$environment.resolve((IrIdentifier)record, null) instanceof IrRecordDecl)) {
                                IrConsistencyCheckerKt.invalidIrError("Unresolved record " + record, location, this.$checkMode);
                            }
                            if (!(this.$environment.resolve((IrIdentifier)field, (IrIdentifier)record) instanceof IrFieldDecl)) {
                                IrConsistencyCheckerKt.invalidIrError("Unresolved field " + field + " in record " + record, location, this.$checkMode);
                            }
                        }
                    }

                    public void visitLoadStmt(IrLoadStmt stmt) {
                        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                        this.checkField(stmt.getReceiverDeclaredRecord(), stmt.getField(), stmt.getLocation());
                        super.visitLoadStmt(stmt);
                    }

                    public void visitStoreStmt(IrStoreStmt stmt) {
                        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                        this.checkField(stmt.getReceiverDeclaredRecord(), stmt.getField(), stmt.getLocation());
                        super.visitStoreStmt(stmt);
                    }

                    public void visitDeclaration(IrDeclaration declarator) {
                        Intrinsics.checkNotNullParameter((Object)declarator, (String)"declarator");
                        if (!(declarator instanceof IrFieldDecl) && !Intrinsics.areEqual((Object)this.$environment.resolve(declarator.getName(), this.$decl.getName()), (Object)declarator)) {
                            IrConsistencyCheckerKt.invalidIrError("Duplicate declaration " + declarator.getName(), declarator.getLocation(), this.$checkMode);
                        }
                    }

                    public void visitStaticCallStmt(IrStaticCallStmt stmt) {
                        IrFunctionDecl function2;
                        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                        IrDeclaration irDeclaration = this.$environment.resolve((IrIdentifier)stmt.getCallee(), null);
                        IrFunctionDecl irFunctionDecl = function2 = irDeclaration instanceof IrFunctionDecl ? (IrFunctionDecl)irDeclaration : null;
                        if (function2 != null && function2.getParameters().size() != stmt.getArguments().size()) {
                            IrConsistencyCheckerKt.invalidIrError("Incorrect number of arguments for function " + function2.getName(), stmt.getLocation(), this.$checkMode);
                        }
                        super.visitStaticCallStmt(stmt);
                    }

                    public static final /* synthetic */ void access$checkDefinedIdentifier(checkEnvironment.1 $this, IrIdentifier identifier, IrLocation location) {
                        $this.checkDefinedIdentifier(identifier, location);
                    }
                });
                IrConsistencyCheckerKt.checkIdentifiers(identifiers, options);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkIdentifiers(@NotNull List<? extends IrIdentifier> identifiers, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        AnalysisOptions.ConsistencyCheck checkMode = (AnalysisOptions.ConsistencyCheck)options.get(AnalysisOptions.INSTANCE.getCheckEnvironment());
        if (checkMode.getMode() != AnalysisOptions.CheckMode.Skip) {
            Object object;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object list$iv$iv;
            Map $this$getOrPut$iv$iv$iv;
            boolean bl;
            IrIdentifier it;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv = identifiers;
            boolean $i$f$groupBy = false;
            Object object2 = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object t : $this$groupByTo$iv$iv) {
                Object object3;
                it = (IrIdentifier)t;
                bl = false;
                Class<?> key$iv$iv = it.getClass();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object3;
                list$iv$iv.add(t);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                list$iv$iv = entry;
                object = destination$iv$iv;
                bl = false;
                object.add((List)it.getValue());
            }
            for (List curIdentifiers : (List)destination$iv$iv) {
                void $this$mapTo$iv$iv2;
                Map keyToName = new LinkedHashMap();
                Iterable $this$map$iv2 = curIdentifiers;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv2;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it2;
                    $this$getOrPut$iv$iv$iv = (IrIdentifier)item$iv$iv;
                    object = collection;
                    boolean bl2 = false;
                    object.add(it2.getAttr());
                }
                for (Attribute attribute : (List)collection) {
                    boolean bl3;
                    String key;
                    Intrinsics.checkNotNullExpressionValue((Object)attribute.getKey(), (String)"getKey(...)");
                    String oldName = (String)keyToName.get(key);
                    String string = attribute.getPrettyName();
                    if (oldName != null) {
                        String it3;
                        boolean bl32 = false;
                        bl3 = !Intrinsics.areEqual((Object)it3, (Object)string);
                    } else {
                        bl3 = false;
                    }
                    if (bl3) {
                        IrConsistencyCheckerKt.invalidIrError("Attributes \"" + oldName + "\" and \"" + string + "\" have the same key \"" + key + "\"", null, checkMode);
                    }
                    keyToName.put(key, string);
                }
            }
        }
    }

    public static final void checkNotInitialized(@NotNull DfaAnalysisIrResultImpl result, @NotNull RMLOptions options) {
        IrObjectID loc;
        Quadruple quadruple;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        AnalysisOptions.ConsistencyCheck checkNotInitializedFields = (AnalysisOptions.ConsistencyCheck)options.get(AnalysisOptions.INSTANCE.getCheckNotInitializedFields());
        AnalysisOptions.ConsistencyCheck checkNotInitializedVars = (AnalysisOptions.ConsistencyCheck)options.get(AnalysisOptions.INSTANCE.getCheckNotInitializedVars());
        AnalysisOptions.ConsistencyCheck checkDeadConditions = (AnalysisOptions.ConsistencyCheck)options.get(AnalysisOptions.INSTANCE.getCheckDeadConditions());
        if (checkNotInitializedFields.getMode() != AnalysisOptions.CheckMode.Skip) {
            $this$forEach$iv = result.getRelation(ParametersSubstitutorAnalysisKt.getNotInitializedFieldUsage());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                quadruple = (Quadruple)element$iv;
                boolean bl = false;
                loc = (IrObjectID)quadruple.component2();
                IrFieldID field = (IrFieldID)quadruple.component3();
                IrFunctionID function2 = (IrFunctionID)quadruple.component4();
                String string = "Field \"" + field + "\" is not initialized at \"" + function2 + "\"";
                Intrinsics.checkNotNull((Object)loc, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.ir.ast.IrLocationID");
                IrConsistencyCheckerKt.invalidIrError(string, ((IrLocationID)loc).getLocation(), checkNotInitializedFields);
            }
        }
        if (checkNotInitializedVars.getMode() != AnalysisOptions.CheckMode.Skip) {
            $this$forEach$iv = result.getRelation(MayPointsToAnalysisKt.getNotInitializedVarUsage());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                quadruple = (Triple)element$iv;
                boolean bl = false;
                loc = (IrObjectID)quadruple.component2();
                IrVarID variable = (IrVarID)quadruple.component3();
                String string = "Variable \"" + variable + "\" is not initialized";
                Intrinsics.checkNotNull((Object)loc, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.ir.ast.IrLocationID");
                IrConsistencyCheckerKt.invalidIrError(string, ((IrLocationID)loc).getLocation(), checkNotInitializedVars);
            }
        }
        if (checkDeadConditions.getMode() != AnalysisOptions.CheckMode.Skip) {
            $this$forEach$iv = result.getRelation(ConditionsExtensionKt.getDeadCondition());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                quadruple = (Pair)element$iv;
                boolean bl = false;
                loc = (IrObjectID)quadruple.component2();
                Intrinsics.checkNotNull((Object)loc, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.ir.ast.IrLocationID");
                IrConsistencyCheckerKt.invalidIrError("Condition is dead", ((IrLocationID)loc).getLocation(), checkDeadConditions);
            }
        }
    }

    public static final void invalidIrError(@NotNull String message, @Nullable IrLocation location, @NotNull AnalysisOptions.ConsistencyCheck check) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)check, (String)"check");
        IrLocation irLocation = location;
        String event = irLocation != null ? message + " at " + irLocation.toLongString() : message;
        Function1 function1 = check.getConsumer();
        if (function1 != null) {
            Function1 it = function1;
            boolean bl = false;
            it.invoke((Object)event);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[check.getMode().ordinal()]) {
            case 1: {
                CfgConsistencyCheckStage.Companion.getLOG().error(event);
                throw new DfaInvalidIrException(message, location);
            }
            case 2: {
                CfgConsistencyCheckStage.Companion.getLOG().warn(event);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnalysisOptions.CheckMode.values().length];
            try {
                nArray[AnalysisOptions.CheckMode.Throw.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnalysisOptions.CheckMode.Log.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnalysisOptions.CheckMode.Skip.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

