/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpResponseException;
import com.google.gct.login2.GoogleLoginUtils;
import com.google.gct.login2.common.LoginCallbackHandler;
import com.google.services.firebase.FirebaseProjectClient;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.FirebaseManagementEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/google/services/firebase/FirebaseLoginCallbackHandler;", "Lcom/google/gct/login2/common/LoginCallbackHandler;", "<init>", "()V", "projectId", "", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "_latestCreatedFirebaseProject", "Lkotlinx/coroutines/flow/MutableStateFlow;", "latestCreatedFirebaseProject", "Lkotlinx/coroutines/flow/StateFlow;", "getLatestCreatedFirebaseProject", "()Lkotlinx/coroutines/flow/StateFlow;", "getUrl", "host", "port", "", "authUser", "canHandle", "", "callbackPath", "handle", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "createUniqueProjectId", "trackState", "", "state", "Lcom/google/wireless/android/sdk/stats/FirebaseManagementEvent$CreateFirebaseProjectDetails$CreateFirebaseProjectState;", "firebase"})
@SourceDebugExtension(value={"SMAP\nFirebaseLoginCallbackHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirebaseLoginCallbackHandler.kt\ncom/google/services/firebase/FirebaseLoginCallbackHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n434#2:175\n507#2,5:176\n158#2,6:181\n2632#3,3:187\n1#4:190\n*S KotlinDebug\n*F\n+ 1 FirebaseLoginCallbackHandler.kt\ncom/google/services/firebase/FirebaseLoginCallbackHandler\n*L\n142#1:175\n142#1:176,5\n146#1:181,6\n155#1:187,3\n*E\n"})
public final class FirebaseLoginCallbackHandler
implements LoginCallbackHandler {
    @NotNull
    private String projectId = "";
    @Nullable
    private Credential credential;
    @NotNull
    private final MutableStateFlow<String> _latestCreatedFirebaseProject = StateFlowKt.MutableStateFlow(null);
    @NotNull
    private final StateFlow<String> latestCreatedFirebaseProject = (StateFlow)this._latestCreatedFirebaseProject;

    @NotNull
    public final StateFlow<String> getLatestCreatedFirebaseProject() {
        return this.latestCreatedFirebaseProject;
    }

    @Nullable
    public String getUrl(@NotNull String host, int port, int authUser, @Nullable Credential credential) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            if (!((Collection)FirebaseProjectClient.INSTANCE.listFirebaseProjects(credential)).isEmpty()) {
                return null;
            }
            this._latestCreatedFirebaseProject.setValue(null);
            this.projectId = this.createUniqueProjectId();
            try {
                FirebaseProjectClient.INSTANCE.createCloudProject(this.projectId, credential);
            }
            catch (HttpResponseException e) {
                if (!Intrinsics.areEqual((Object)e.getStatusMessage(), (Object)"ALREADY_EXISTS")) break block6;
                this.projectId = this.createUniqueProjectId();
                FirebaseProjectClient.INSTANCE.createCloudProject(this.projectId, credential);
            }
        }
        Thread.sleep(3000L);
        this.trackState(FirebaseManagementEvent.CreateFirebaseProjectDetails.CreateFirebaseProjectState.STARTED);
        try {
            FirebaseProjectClient.INSTANCE.addFirebaseProject(this.projectId, credential);
        }
        catch (IOException e) {
            if (e instanceof HttpResponseException && ((HttpResponseException)((Object)e)).getStatusCode() == 403) {
                this.credential = credential;
                Object authUserHeader = authUser != -1 ? "u/" + authUser + "/" : "";
                this.trackState(FirebaseManagementEvent.CreateFirebaseProjectDetails.CreateFirebaseProjectState.TOS_NEEDED);
                return "https://console.firebase.google.com/" + (String)authUserHeader + "?forceCheckTos=1&dlAction=AndroidStudioSignIn&localPort=" + port + "/CALLBACK_Firebase";
            }
            this.trackState(FirebaseManagementEvent.CreateFirebaseProjectDetails.CreateFirebaseProjectState.FAILED);
            throw e;
        }
        this.trackState(FirebaseManagementEvent.CreateFirebaseProjectDetails.CreateFirebaseProjectState.CREATED);
        this._latestCreatedFirebaseProject.setValue((Object)this.projectId);
        return null;
    }

    public boolean canHandle(@NotNull String callbackPath) {
        Intrinsics.checkNotNullParameter((Object)callbackPath, (String)"callbackPath");
        return Intrinsics.areEqual((Object)callbackPath, (Object)"/CALLBACK_Firebase");
    }

    public boolean handle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        this.trackState(FirebaseManagementEvent.CreateFirebaseProjectDetails.CreateFirebaseProjectState.TOS_ACCEPTED);
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)EmptyCoroutineContext.INSTANCE)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ FirebaseLoginCallbackHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block13: {
                    block12: {
                        var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        block1 : switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                                if (v0 == var5_2) {
                                    return var5_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                retryLimit = 3;
                                count = 1;
lbl15:
                                // 2 sources

                                while (true) {
                                    try {
                                        FirebaseProjectClient.INSTANCE.addFirebaseProject(FirebaseLoginCallbackHandler.access$getProjectId$p(this.this$0), FirebaseLoginCallbackHandler.access$getCredential$p(this.this$0));
                                        break block12;
                                    }
                                    catch (IOException e) {
                                        if (!(e instanceof HttpResponseException) || ((HttpResponseException)e).getStatusCode() != 403 || count >= retryLimit) break block1;
                                        this.I$0 = retryLimit;
                                        this.I$1 = count;
                                        this.label = 2;
                                        v1 = DelayKt.delay((long)2000L, (Continuation)((Continuation)this));
                                        if (v1 == var5_2) {
                                            return var5_2;
                                        }
                                        break block13;
                                    }
                                    break;
                                }
                            }
                            case 2: {
                                count = this.I$1;
                                retryLimit = this.I$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                                break block13;
                            }
                        }
                        FirebaseLoginCallbackHandler.access$trackState(this.this$0, FirebaseManagementEvent.CreateFirebaseProjectDetails.CreateFirebaseProjectState.FAILED);
                        v2 = e.getLocalizedMessage();
                        if (v2 == null) {
                            v2 = "";
                        }
                        GoogleLoginUtils.showErrorDialog((String)v2, (String)"Project Creation Failed");
                        return Unit.INSTANCE;
                    }
                    FirebaseLoginCallbackHandler.access$trackState(this.this$0, FirebaseManagementEvent.CreateFirebaseProjectDetails.CreateFirebaseProjectState.CREATED);
                    return Unit.INSTANCE;
                }
                if (count != retryLimit) {
                    ++count;
                    ** continue;
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this._latestCreatedFirebaseProject.setValue((Object)this.projectId);
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final String createUniqueProjectId() {
        block10: {
            block9: {
                var2_1 = new String[]{"google", "null", "undefined", "ssl"};
                restrictedWords = CollectionsKt.listOf((Object[])var2_1);
                var3_3 = (Project)CollectionsKt.firstOrNull((List)ProjectManagerEx.Companion.getOpenProjects());
                if (var3_3 == null || (var4_4 = ProjectSystemUtil.getProjectSystem((Project)var3_3)) == null || (var5_6 = var4_4.getKnownApplicationIds()) == null || (var6_8 = (String)CollectionsKt.firstOrNull((Iterable)var5_6)) == null || (var7_9 = StringsKt.substringAfterLast$default((String)var6_8, (String)".", null, (int)2, null)) == null) ** GOTO lbl-1000
                var9_10 = var7_9;
                $i$f$filter = false;
                var11_13 = (CharSequence)$this$filter$iv;
                destination$iv$iv = new StringBuilder();
                $i$f$filterTo = false;
                var15_21 = $this$filterTo$iv$iv.length();
                for (index$iv$iv = 0; index$iv$iv < var15_21; ++index$iv$iv) {
                    it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                    $i$a$-filter-FirebaseLoginCallbackHandler$createUniqueProjectId$projectId$1 = false;
                    if (!(Character.isLetter(it) != false || Character.isDigit(it) != false)) continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                var8_28 = ((StringBuilder)destination$iv$iv).toString();
                if (var8_28 == null) ** GOTO lbl-1000
                v0 = var8_28.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toLowerCase(...)");
                var9_10 = v0;
                if (var9_10 == null) ** GOTO lbl-1000
                id = var9_10;
                $i$a$-let-FirebaseLoginCallbackHandler$createUniqueProjectId$projectId$2 = false;
                index$iv$iv = id;
                $this$indexOfFirst$iv = id;
                $i$f$indexOfFirst = false;
                var18_26 = $this$indexOfFirst$iv.length();
                for (index$iv = 0; index$iv < var18_26; ++index$iv) {
                    it = $this$indexOfFirst$iv.charAt(index$iv);
                    $i$a$-indexOfFirst-FirebaseLoginCallbackHandler$createUniqueProjectId$projectId$2$1 = false;
                    if (!Character.isLowerCase(it)) continue;
                    v1 = index$iv;
                    break block9;
                }
                v1 = -1;
            }
            $this$indexOfFirst$iv = v1;
            v2 = index$iv$iv.substring($this$indexOfFirst$iv);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
            var10_12 = v2;
            if (var10_12 == null) ** GOTO lbl-1000
            id = var10_12;
            $i$a$-let-FirebaseLoginCallbackHandler$createUniqueProjectId$projectId$3 = false;
            v3 = id.substring(0, Math.min(20, id.length()));
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
            var11_13 = v3;
            if (var11_13 == null) ** GOTO lbl-1000
            it = var13_16 = var11_13;
            $i$a$-takeIf-FirebaseLoginCallbackHandler$createUniqueProjectId$projectId$4 = false;
            if (!(it.length() > 0)) ** GOTO lbl-1000
            $this$none$iv = restrictedWords;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v4 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    restrictedWord = (String)element$iv;
                    $i$a$-none-FirebaseLoginCallbackHandler$createUniqueProjectId$projectId$4$1 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)restrictedWord, (boolean)false, (int)2, null)) continue;
                    v4 = false;
                    break block10;
                }
                v4 = true;
            }
        }
        if (v4) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        v6 = var12_14 = v5 != false ? var13_16 : null;
        if (var12_14 != null) {
            v7 /* !! */  = var12_14;
        } else lbl-1000:
        // 6 sources

        {
            v7 /* !! */  = "device-streaming";
        }
        projectId = v7 /* !! */ ;
        v8 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"toString(...)");
        var3_3 = v8;
        var4_5 = 0;
        var5_7 = 8;
        v9 = var3_3.substring(var4_5, var5_7);
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"substring(...)");
        return projectId + "-" + v9;
    }

    private final void trackState(FirebaseManagementEvent.CreateFirebaseProjectDetails.CreateFirebaseProjectState state) {
        FirebaseManagementEvent.CreateFirebaseProjectDetails.Builder builder;
        FirebaseManagementEvent.Builder builder2;
        AndroidStudioEvent.Builder builder3;
        AndroidStudioEvent.Builder $this$trackState_u24lambda_u248 = builder3 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $this$trackState_u24lambda_u248.setKind(AndroidStudioEvent.EventKind.FIREBASE_MANAGEMENT_EVENT);
        $this$trackState_u24lambda_u248.setProductDetails(AndroidStudioUsageTracker.getProductDetails());
        FirebaseManagementEvent.Builder $this$trackState_u24lambda_u248_u24lambda_u247 = builder2 = $this$trackState_u24lambda_u248.getFirebaseManagementEventBuilder();
        boolean bl2 = false;
        $this$trackState_u24lambda_u248_u24lambda_u247.setType(FirebaseManagementEvent.FirebaseManagementEventType.CREATE_FIREBASE_PROJECT);
        $this$trackState_u24lambda_u248_u24lambda_u247.setProjectId(AnonymizerUtil.anonymizeUtf8((String)this.projectId));
        FirebaseManagementEvent.CreateFirebaseProjectDetails.Builder $this$trackState_u24lambda_u248_u24lambda_u247_u24lambda_u246 = builder = $this$trackState_u24lambda_u248_u24lambda_u247.getCreateFirebaseProjectDetailsBuilder();
        boolean bl3 = false;
        $this$trackState_u24lambda_u248_u24lambda_u247_u24lambda_u246.setState(state);
        AndroidStudioEvent.Builder builder4 = builder3;
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"apply(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder4);
    }

    public static final /* synthetic */ String access$getProjectId$p(FirebaseLoginCallbackHandler $this) {
        return $this.projectId;
    }

    public static final /* synthetic */ Credential access$getCredential$p(FirebaseLoginCallbackHandler $this) {
        return $this.credential;
    }

    public static final /* synthetic */ void access$trackState(FirebaseLoginCallbackHandler $this, FirebaseManagementEvent.CreateFirebaseProjectDetails.CreateFirebaseProjectState state) {
        $this.trackState(state);
    }
}

