/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.StepData;
import com.android.tools.idea.assistant.datamodel.StepElementData;
import com.android.tools.idea.assistant.datamodel.StepElementType;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.wizard.template.RecipeExecutor;
import com.android.tools.idea.wizard.template.TemplateData;
import com.android.utils.FileUtils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.services.firebase.FirebaseTutorialBundleCacheManager;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;

@XmlRootElement(name="tutorialBundle")
public class FirebaseTutorialBundle
implements TutorialBundleData {
    @XmlAttribute(name="name")
    private String myName;
    @XmlAttribute(name="icon")
    @Nullable
    private String myIconName;
    @XmlAttribute(name="logo")
    @Nullable
    private String myLogoName;
    @XmlAttribute(name="id")
    private String myId;
    @XmlAttribute(name="delete")
    private int myDeleteme;
    @XmlAttribute(name="contentRoot")
    private String myContentRoot;
    @XmlAttribute(name="resourceRoot")
    private String myResourceRoot;
    @XmlElement(name="welcome")
    private String myWelcome;
    @XmlElement(name="learnMoreLink")
    private String myLearnMoreLink;
    @XmlAttribute(name="stepByStep")
    private boolean myStepByStep;
    @XmlAttribute(name="hideStepIndex")
    private boolean myHideStepIndex;
    private Icon myIcon;
    private Icon myLogo;
    private Class myResourceClass;
    @NotNull
    private String myBundleCreatorId = "Default";
    @XmlElements(value={@XmlElement(name="feature", type=Feature.class)})
    private List<Feature> myFeatures = Lists.newArrayList();

    public static TutorialBundleData parse(@NotNull InputStream stream) throws JAXBException {
        return FirebaseTutorialBundle.parse(stream, FirebaseTutorialBundle.class);
    }

    public static <T> T parse(@NotNull InputStream stream, Class<T> clazz) throws JAXBException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{clazz}).createUnmarshaller();
        unmarshaller.setEventHandler(event -> {
            FirebaseTutorialBundle.getLog().info("Found unhandled xml", event.getLinkedException());
            return true;
        });
        return (T)unmarshaller.unmarshal((Source)new StreamSource(stream), clazz).getValue();
    }

    public static <T extends TutorialBundleData> T parse(@NotNull InputStream stream, Class<T> clazz, @NotNull String bundleCreatorId) throws JAXBException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{clazz}).createUnmarshaller();
        unmarshaller.setEventHandler(event -> {
            FirebaseTutorialBundle.getLog().info("Found unhandled xml", event.getLinkedException());
            return true;
        });
        TutorialBundleData bundleData = (TutorialBundleData)unmarshaller.unmarshal((Source)new StreamSource(stream), clazz).getValue();
        bundleData.setBundleCreatorId(bundleCreatorId);
        return (T)bundleData;
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseTutorialBundle.class);
    }

    public void setResourceClass(@NotNull Class clazz) {
        this.myResourceClass = clazz;
        this.myFeatures.forEach(feature -> feature.getTutorials().forEach(tutorial -> tutorial.setResourceClass(clazz)));
    }

    public void setIconProvider(FirebaseTutorialBundleCacheManager iconProvider) {
        this.myFeatures.forEach(feature -> feature.setIconProvider(iconProvider));
    }

    @Nullable
    private Icon getIconResource(@NotNull String path) {
        return IconLoader.findIcon((String)path, (Class)this.myResourceClass);
    }

    @NotNull
    public static String getIconResourcePath(@NotNull String resourceRoot, @NotNull String iconPath) {
        return FileUtils.toSystemIndependentPath((String)new File(resourceRoot, iconPath).toString());
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public boolean isStepByStep() {
        return this.myStepByStep;
    }

    public boolean hideStepIndex() {
        return this.myHideStepIndex;
    }

    @Nullable
    public Icon getIcon() {
        if (this.myIcon != null) {
            return this.myIcon;
        }
        if (this.myIconName == null || this.myResourceRoot == null) {
            return null;
        }
        this.myIcon = this.getIconResource(FirebaseTutorialBundle.getIconResourcePath(this.myResourceRoot, this.myIconName));
        return this.myIcon;
    }

    @NotNull
    public String getBundleCreatorId() {
        return this.myBundleCreatorId;
    }

    public void setBundleCreatorId(@NotNull String bundleCreatorId) {
        this.myBundleCreatorId = bundleCreatorId;
    }

    @Nullable
    public Icon getLogo() {
        if (this.myLogo != null) {
            return this.myLogo;
        }
        if (this.myLogoName == null || this.myResourceRoot == null) {
            return null;
        }
        this.myLogo = this.getIconResource(FirebaseTutorialBundle.getIconResourcePath(this.myResourceRoot, this.myLogoName));
        return this.myLogo;
    }

    @NotNull
    public List<Feature> getFeatures() {
        return ImmutableList.copyOf(this.myFeatures);
    }

    @NotNull
    public String getWelcome() {
        return this.myWelcome;
    }

    private void afterUnmarshal(Unmarshaller u, Object parent) {
        this.myFeatures.forEach(feature -> feature.getTutorials().forEach(tutorial -> {
            tutorial.myResourceRoot = this.myResourceRoot;
        }));
    }

    public String toString() {
        return "TutorialBundle{myName='" + this.myName + "', myIcon='" + this.myIcon + "', myLogo='" + this.myLogo + "', myId='" + this.myId + "', myContentRoot='" + this.myContentRoot + "', myResourceRoot='" + this.myResourceRoot + "', myWelcome='" + this.myWelcome + "', myLearnMoreLink='" + this.myLearnMoreLink + "', myFeatures=" + this.myFeatures + "}";
    }

    public static final class Feature
    implements FeatureData {
        @XmlAttribute(name="name")
        @NotNull
        private String myName;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIcon;
        @XmlAttribute(name="resourceRoot")
        @NotNull
        private String myResourceRoot;
        @XmlElements(value={@XmlElement(name="resource", type=String.class)})
        private List<String> myResources = Lists.newArrayList();
        @XmlElement(name="description")
        private String myDescription;
        @XmlElements(value={@XmlElement(name="tutorial", type=Tutorial.class)})
        private List<Tutorial> myTutorials = Lists.newArrayList();
        private Class myResourceClass;
        private FirebaseTutorialBundleCacheManager iconProvider;

        public void setIconProvider(FirebaseTutorialBundleCacheManager iconProvider) {
            this.iconProvider = iconProvider;
        }

        public void setResourceClass(@NotNull Class clazz) {
            this.myResourceClass = clazz;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @Nullable
        public Icon getIcon() {
            if (this.myIcon == null) {
                return null;
            }
            return this.iconProvider.getIconResource(this.myResourceRoot, this.myResourceClass, this.myIcon);
        }

        @NotNull
        public String getDescription() {
            return this.myDescription;
        }

        @NotNull
        public List<Tutorial> getTutorials() {
            return ImmutableList.copyOf(this.myTutorials);
        }

        public String toString() {
            return "Feature{myName='" + this.myName + "', myResourceRoot='" + this.myResourceRoot + "', myResources=" + this.myResources + ", myIcon=" + this.myIcon + "}";
        }
    }

    public static class Tutorial
    implements TutorialData {
        @XmlAttribute(name="label")
        private String myLabel;
        @XmlElement(name="description")
        private String myDescription;
        @XmlAttribute(name="remoteLink")
        private String myRemoteLink;
        @XmlAttribute(name="remoteLinkLabel")
        private String myRemoteLinkLabel;
        @XmlAttribute(name="key")
        private String myKey;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIconName;
        @XmlAttribute(name="hasLocalHTMLPaths")
        private boolean myHasLocalHTMLPaths = false;
        @XmlAttribute(name="loadLazily")
        private boolean myLoadLazily = true;
        protected String myResourceRoot;
        @XmlElements(value={@XmlElement(name="step", type=Step.class)})
        private List<Step> mySteps = Lists.newArrayList();
        private Icon myIcon;
        private Class myResourceClass;

        public void setResourceClass(@NotNull Class clazz) {
            this.myResourceClass = clazz;
        }

        @NotNull
        public String getLabel() {
            return this.myLabel;
        }

        @Nullable
        public String getDescription() {
            return this.myDescription;
        }

        @NotNull
        public String getRemoteLink() {
            return this.myRemoteLink;
        }

        @NotNull
        public String getRemoteLinkLabel() {
            return this.myRemoteLinkLabel;
        }

        @NotNull
        public String getKey() {
            return this.myKey;
        }

        public boolean hasLocalHTMLPaths() {
            return this.myHasLocalHTMLPaths;
        }

        public boolean shouldLoadLazily() {
            return this.myLoadLazily;
        }

        @NotNull
        public Class<?> getResourceClass() {
            return this.myResourceClass;
        }

        @Nullable
        public Icon getIcon() {
            if (this.myIcon != null) {
                return this.myIcon;
            }
            if (this.myIconName == null || this.myResourceRoot == null) {
                return null;
            }
            this.myIcon = IconLoader.findIcon((String)FirebaseTutorialBundle.getIconResourcePath(this.myResourceRoot, this.myIconName), (Class)this.myResourceClass);
            return this.myIcon;
        }

        @NotNull
        public List<Step> getSteps() {
            return ImmutableList.copyOf(this.mySteps);
        }

        public String toString() {
            return "Tutorial{myLabel='" + this.myLabel + "', myDescription='" + this.myDescription + "', myRemoteLink='" + this.myRemoteLink + "', myRemoteLinkLabel='" + this.myRemoteLinkLabel + "', myKey='" + this.myKey + "', mySteps=" + this.mySteps + "}";
        }
    }

    @XmlRootElement(name="recipe")
    public static class Recipe
    implements Function2<RecipeExecutor, TemplateData, Unit> {
        @XmlElements(value={@XmlElement(name="recipe", type=Recipe.class), @XmlElement(name="apply", type=ApplyInstruction.class), @XmlElement(name="dependency", type=DependencyInstruction.class), @XmlElement(name="moduleDependency", type=ModuleDependencyInstruction.class), @XmlElement(name="setExtVar", type=SetExtVarInstruction.class), @XmlElement(name="setBuildFeature", type=SetBuildFeatureInstruction.class), @XmlElement(name="requireJavaVersion", type=RequireJavaVersionInstruction.class), @XmlElement(name="addDynamicFeature", type=AddDynamicFeatureInstruction.class)})
        public List<Function2<RecipeExecutor, TemplateData, Unit>> instructions = Lists.newArrayList();
        @XmlAttribute(name="folder")
        @Nullable
        private String myFolder;

        public Unit invoke(RecipeExecutor executor, TemplateData data) {
            for (Function2<RecipeExecutor, TemplateData, Unit> instruction : this.instructions) {
                instruction.invoke((Object)executor, (Object)data);
            }
            return Unit.INSTANCE;
        }

        private static final class AddDynamicFeatureInstruction
        implements Function2<RecipeExecutor, TemplateData, Unit> {
            @XmlAttribute(required=true)
            @NotNull
            private String name;
            @XmlAttribute(required=true)
            @NotNull
            private String to;

            private AddDynamicFeatureInstruction() {
            }

            public Unit invoke(RecipeExecutor executor, TemplateData data) {
                executor.addDynamicFeature(this.name, new File(this.to));
                return Unit.INSTANCE;
            }
        }

        private static final class ModuleDependencyInstruction
        implements Function2<RecipeExecutor, TemplateData, Unit> {
            @XmlAttribute(required=true)
            @NotNull
            private String name;
            @XmlAttribute(required=true)
            @NotNull
            private String to;
            @XmlAttribute
            private String gradleConfiguration;

            private ModuleDependencyInstruction() {
            }

            public Unit invoke(RecipeExecutor executor, TemplateData data) {
                executor.addModuleDependency(this.gradleConfiguration, this.name, new File(this.to));
                return Unit.INSTANCE;
            }
        }

        private static final class DependencyInstruction
        implements Function2<RecipeExecutor, TemplateData, Unit> {
            @XmlAttribute(required=true)
            @NotNull
            private String mavenUrl;
            @XmlAttribute
            private String gradleConfiguration;

            private DependencyInstruction() {
            }

            public Unit invoke(RecipeExecutor executor, TemplateData data) {
                String configuration2 = (String)MoreObjects.firstNonNull((Object)this.gradleConfiguration, (Object)"implementation");
                executor.addDependency(this.mavenUrl, configuration2, null, null, false, null);
                return Unit.INSTANCE;
            }
        }

        private static final class RequireJavaVersionInstruction
        implements Function2<RecipeExecutor, TemplateData, Unit> {
            @XmlAttribute(required=true)
            @NotNull
            private String version;
            @XmlAttribute
            @Nullable
            private String kotlinSupport;

            private RequireJavaVersionInstruction() {
            }

            public Unit invoke(RecipeExecutor executor, TemplateData data) {
                executor.requireJavaVersion(this.version, Boolean.parseBoolean(this.kotlinSupport));
                return Unit.INSTANCE;
            }
        }

        private static final class SetBuildFeatureInstruction
        implements Function2<RecipeExecutor, TemplateData, Unit> {
            @XmlAttribute(required=true)
            @NotNull
            private String name;
            @XmlAttribute(required=true)
            @NotNull
            private String value;

            private SetBuildFeatureInstruction() {
            }

            public Unit invoke(RecipeExecutor executor, TemplateData data) {
                executor.setBuildFeature(this.name, Boolean.parseBoolean(this.value));
                return Unit.INSTANCE;
            }
        }

        private static final class SetExtVarInstruction
        implements Function2<RecipeExecutor, TemplateData, Unit> {
            @XmlAttribute(required=true)
            @NotNull
            private String name;
            @XmlAttribute(required=true)
            @NotNull
            private String value;

            private SetExtVarInstruction() {
            }

            public Unit invoke(RecipeExecutor executor, TemplateData data) {
                executor.setExtVar(this.name, this.value);
                return Unit.INSTANCE;
            }
        }

        private static final class ApplyInstruction
        implements Function2<RecipeExecutor, TemplateData, Unit> {
            @XmlAttribute(required=true)
            @NotNull
            private String plugin;
            @XmlAttribute(required=true)
            @NotNull
            private String classpath;

            private ApplyInstruction() {
            }

            public Unit invoke(RecipeExecutor executor, TemplateData data) {
                executor.addPlugin(this.plugin, this.classpath);
                return Unit.INSTANCE;
            }
        }
    }

    public static final class Action
    implements ActionData {
        @XmlAttribute(name="label")
        private String myLabel;
        @XmlAttribute(name="key")
        private String myKey;
        @XmlAttribute(name="actionArgument")
        private String myActionArgument;
        @XmlAttribute(name="successMessage")
        private String mySuccessMessage;
        @XmlAttribute(name="editAction")
        private String myEditAction;
        @XmlAttribute(name="highlighted")
        private boolean myHighlighted;
        @XmlElement(name="recipe", type=Recipe.class)
        private Recipe myRecipe;

        @NotNull
        public String getLabel() {
            return this.myLabel;
        }

        @NotNull
        public String getKey() {
            return this.myKey;
        }

        public String getActionArgument() {
            return this.myActionArgument;
        }

        public String getSuccessMessage() {
            return this.mySuccessMessage;
        }

        public boolean isHighlighted() {
            return this.myHighlighted;
        }

        public Recipe getRecipe() {
            return this.myRecipe;
        }

        public String toString() {
            return "Action{myLabel='" + this.myLabel + "', myKey='" + this.myKey + "', myActionArgument='" + this.myActionArgument + "', mySuccessMessage='" + this.mySuccessMessage + "', myEditAction='" + this.myEditAction + "', myHighlighted='" + this.myHighlighted + "', myRecipe='" + this.myRecipe + "'}";
        }

        public boolean equals(@Nullable Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Action)) {
                return false;
            }
            Action otherAction = (Action)that;
            return this.toString().equals(otherAction.toString());
        }
    }

    public static final class Code {
        @XmlValue
        private String myCode;
        @XmlAttribute(name="fileType")
        private String myCodeType;

        public String getCode() {
            return this.myCode;
        }

        public FileType getCodeType() {
            if (this.myCodeType == null) {
                return null;
            }
            String type = StringUtil.toUpperCase((String)this.myCodeType.trim());
            if (type.equals("JAVA")) {
                return JavaFileType.INSTANCE;
            }
            if (type.equals("XML")) {
                return XmlFileType.INSTANCE;
            }
            if (type.equals("GROOVY")) {
                return GroovyFileType.GROOVY_FILE_TYPE;
            }
            if (type.equals("PLAIN_TEXT")) {
                return FileTypes.PLAIN_TEXT;
            }
            return null;
        }
    }

    public static final class StepElement
    implements StepElementData {
        private StepElementType myType;
        @XmlElement(name="code", type=Code.class)
        private Code myCode;
        @XmlElement(name="section")
        private String mySection;
        @XmlElement(name="action", type=Action.class)
        private Action myAction;
        @XmlElement(name="image", type=DefaultTutorialBundle.Image.class)
        private DefaultTutorialBundle.Image myImage;
        @XmlElement(name="panel", type=DefaultTutorialBundle.Panel.class)
        private DefaultTutorialBundle.Panel myPanel;

        @NotNull
        public StepElementType getType() {
            if (this.myType != null) {
                return this.myType;
            }
            if (this.myAction != null) {
                this.myType = StepElementType.ACTION;
            } else if (this.mySection != null) {
                this.myType = StepElementType.SECTION;
            } else if (this.myCode != null) {
                this.myType = StepElementType.CODE;
            } else if (this.myImage != null) {
                this.myType = StepElementType.IMAGE;
            } else if (this.myPanel != null) {
                this.myType = StepElementType.PANEL;
            }
            if (this.myType == null) {
                throw new RuntimeException("Unsupported StepElement.");
            }
            return this.myType;
        }

        public String getCode() {
            return this.myCode.getCode();
        }

        public FileType getCodeType() {
            return this.myCode == null ? null : this.myCode.getCodeType();
        }

        public String getSection() {
            return this.mySection;
        }

        public Action getAction() {
            return this.myAction;
        }

        @Nullable
        public DefaultTutorialBundle.Panel getPanel() {
            return this.myPanel;
        }

        @Nullable
        public DefaultTutorialBundle.Image getImage() {
            return this.myImage;
        }

        public String toString() {
            return "StepElement{myType='" + this.getType() + "'}";
        }
    }

    public static final class Step
    implements StepData {
        @XmlElements(value={@XmlElement(name="stepElement", type=StepElement.class)})
        private List<StepElement> myStepElements = Lists.newArrayList();
        @XmlAttribute(name="label")
        private String myLabel;

        @NotNull
        public List<StepElement> getStepElements() {
            return ImmutableList.copyOf(this.myStepElements);
        }

        @NotNull
        public Border getBorder() {
            return BorderFactory.createMatteBorder(0, 0, 0, 0, UIUtils.getSeparatorColor());
        }

        @NotNull
        public String getLabel() {
            return this.myLabel;
        }

        public String toString() {
            return "Step{myLabel='" + this.myLabel + "'}";
        }
    }
}

