/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.adtui.common.StudioColorsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B/\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0014H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001f\u0010\r\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00018\u00008\u00000\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/google/services/firebase/insights/ui/IssueDetailTable;", "T", "Ljavax/swing/JPanel;", "model", "Lcom/intellij/util/ui/ListTableModel;", "fieldSelector", "Lkotlin/Function2;", "", "", "<init>", "(Lcom/intellij/util/ui/ListTableModel;Lkotlin/jvm/functions/Function2;)V", "getModel", "()Lcom/intellij/util/ui/ListTableModel;", "table", "Lcom/intellij/ui/table/TableView;", "kotlin.jvm.PlatformType", "getTable", "()Lcom/intellij/ui/table/TableView;", "updateRowHeights", "", "Ljavax/swing/JTable;", "firebase"})
public final class IssueDetailTable<T>
extends JPanel {
    @NotNull
    private final ListTableModel<T> model;
    @NotNull
    private final TableView<T> table;

    /*
     * WARNING - void declaration
     */
    public IssueDetailTable(@NotNull ListTableModel<T> model, @NotNull Function2<? super T, ? super Integer, String> fieldSelector) {
        void $this$_init__u24lambda_u243;
        void $this$table_u24lambda_u240;
        TableView tableView;
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter(fieldSelector, (String)"fieldSelector");
        super(new BorderLayout());
        this.model = model;
        TableView tableView2 = tableView = new TableView(this.model);
        IssueDetailTable issueDetailTable = this;
        boolean $i$a$-apply-IssueDetailTable$table$22 = false;
        $this$table_u24lambda_u240.setRowSelectionAllowed(true);
        $this$table_u24lambda_u240.setCellSelectionEnabled(true);
        $this$table_u24lambda_u240.getSelectionModel().setSelectionMode(0);
        $this$table_u24lambda_u240.setFocusable(true);
        $this$table_u24lambda_u240.setFocusCycleRoot(true);
        $this$table_u24lambda_u240.getTableHeader().setReorderingAllowed(false);
        UiUtils.setEmptyState((Component)((Component)$this$table_u24lambda_u240), (String)"No data available.");
        $this$table_u24lambda_u240.setAutoResizeMode(1);
        $this$table_u24lambda_u240.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        issueDetailTable.table = tableView;
        this.add((Component)this.table.getTableHeader(), "North");
        this.add((Component)this.table, "Center");
        this.table.getModel().addTableModelListener(arg_0 -> IssueDetailTable._init_$lambda$1(this, arg_0));
        this.table.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.updateRowHeights((JTable)this.getTable());
            }
        });
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.updateRowHeights((JTable)this.getTable());
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        final JBPopupMenu popupMenu = new JBPopupMenu();
        TableView $i$a$-apply-IssueDetailTable$table$22 = tableView2 = new JBMenuItem("Copy");
        issueDetailTable = popupMenu;
        boolean bl = false;
        $this$_init__u24lambda_u243.addActionListener(arg_0 -> IssueDetailTable.lambda$3$lambda$2(this, fieldSelector, arg_0));
        issueDetailTable.add((JMenuItem)tableView2);
        popupMenu.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ActionsKt.invokeLater$default(null, () -> 5.popupMenuWillBecomeVisible$lambda$0(popupMenu, this), (int)1, null);
            }

            private static final Unit popupMenuWillBecomeVisible$lambda$0(JBPopupMenu $popupMenu, IssueDetailTable this$0) {
                Point point = SwingUtilities.convertPoint((Component)$popupMenu, new Point(0, 0), (Component)this$0.getTable());
                int row = this$0.getTable().rowAtPoint(point);
                int column = this$0.getTable().columnAtPoint(point);
                if (row > -1) {
                    this$0.getTable().setRowSelectionInterval(row, row);
                }
                if (column > -1) {
                    this$0.getTable().setColumnSelectionInterval(column, column);
                }
                return Unit.INSTANCE;
            }
        });
        this.table.setComponentPopupMenu((JPopupMenu)popupMenu);
        this.setOpaque(false);
    }

    @NotNull
    public final ListTableModel<T> getModel() {
        return this.model;
    }

    @NotNull
    public final TableView<T> getTable() {
        return this.table;
    }

    private final void updateRowHeights(JTable table) {
        ActionsKt.invokeLater$default(null, () -> IssueDetailTable.updateRowHeights$lambda$4(table), (int)1, null);
    }

    private static final void _init_$lambda$1(IssueDetailTable this$0, TableModelEvent it) {
        this$0.updateRowHeights((JTable)this$0.table);
    }

    private static final void lambda$3$lambda$2(IssueDetailTable this$0, Function2 $fieldSelector, ActionEvent it) {
        if (this$0.table.getSelectedColumn() < 0) {
            return;
        }
        Object object = this$0.table.getSelectedObject();
        if (object == null) {
            return;
        }
        Object value = object;
        String text2 = (String)$fieldSelector.invoke(value, (Object)this$0.table.getSelectedColumn());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text2), null);
    }

    private static final Unit updateRowHeights$lambda$4(JTable $table) {
        int n = $table.getRowCount();
        for (int row = 0; row < n; ++row) {
            int maxHeight = 0;
            int n2 = $table.getColumnCount();
            for (int column = 0; column < n2; ++column) {
                int cellHeight = $table.prepareRenderer((TableCellRenderer)$table.getCellRenderer((int)row, (int)column), (int)row, (int)column).getPreferredSize().height;
                if (maxHeight >= cellHeight) continue;
                maxHeight = cellHeight;
            }
            int actualRowHeight = $table.getRowHeight(row);
            if (maxHeight == actualRowHeight || maxHeight == 0) continue;
            $table.setRowHeight(row, maxHeight);
        }
        return Unit.INSTANCE;
    }
}

