/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IBrailleDisplayController;
import android.accessibilityservice.MagnificationConfig;
import android.annotation.EnforcePermission;
import android.annotation.RequiresNoPermission;
import android.app.ActivityThread;
import android.content.pm.ParceledListSlice;
import android.graphics.Region;
import android.hardware.usb.UsbDevice;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.window.ScreenCapture;
import java.util.ArrayList;
import java.util.List;

public interface IAccessibilityServiceConnection
extends IInterface {
    @RequiresNoPermission
    public void setServiceInfo(AccessibilityServiceInfo var1) throws RemoteException;

    @RequiresNoPermission
    public void setAttributionTag(String var1) throws RemoteException;

    @RequiresNoPermission
    public String[] findAccessibilityNodeInfoByAccessibilityId(int var1, long var2, int var4, IAccessibilityInteractionConnectionCallback var5, int var6, long var7, Bundle var9) throws RemoteException;

    @RequiresNoPermission
    public String[] findAccessibilityNodeInfosByText(int var1, long var2, String var4, int var5, IAccessibilityInteractionConnectionCallback var6, long var7) throws RemoteException;

    @RequiresNoPermission
    public String[] findAccessibilityNodeInfosByViewId(int var1, long var2, String var4, int var5, IAccessibilityInteractionConnectionCallback var6, long var7) throws RemoteException;

    @RequiresNoPermission
    public String[] findFocus(int var1, long var2, int var4, int var5, IAccessibilityInteractionConnectionCallback var6, long var7) throws RemoteException;

    @RequiresNoPermission
    public String[] focusSearch(int var1, long var2, int var4, int var5, IAccessibilityInteractionConnectionCallback var6, long var7) throws RemoteException;

    @RequiresNoPermission
    public boolean performAccessibilityAction(int var1, long var2, int var4, Bundle var5, int var6, IAccessibilityInteractionConnectionCallback var7, long var8) throws RemoteException;

    @RequiresNoPermission
    public AccessibilityWindowInfo getWindow(int var1) throws RemoteException;

    @RequiresNoPermission
    public AccessibilityWindowInfo.WindowListSparseArray getWindows() throws RemoteException;

    @RequiresNoPermission
    public AccessibilityServiceInfo getServiceInfo() throws RemoteException;

    @RequiresNoPermission
    public boolean performGlobalAction(int var1) throws RemoteException;

    @RequiresNoPermission
    public List<AccessibilityNodeInfo.AccessibilityAction> getSystemActions() throws RemoteException;

    @RequiresNoPermission
    public void disableSelf() throws RemoteException;

    @RequiresNoPermission
    public void setOnKeyEventResult(boolean var1, int var2) throws RemoteException;

    @RequiresNoPermission
    public MagnificationConfig getMagnificationConfig(int var1) throws RemoteException;

    @RequiresNoPermission
    public float getMagnificationScale(int var1) throws RemoteException;

    @RequiresNoPermission
    public float getMagnificationCenterX(int var1) throws RemoteException;

    @RequiresNoPermission
    public float getMagnificationCenterY(int var1) throws RemoteException;

    @RequiresNoPermission
    public Region getMagnificationRegion(int var1) throws RemoteException;

    @RequiresNoPermission
    public Region getCurrentMagnificationRegion(int var1) throws RemoteException;

    @RequiresNoPermission
    public boolean resetMagnification(int var1, boolean var2) throws RemoteException;

    @RequiresNoPermission
    public boolean resetCurrentMagnification(int var1, boolean var2) throws RemoteException;

    @RequiresNoPermission
    public boolean setMagnificationConfig(int var1, MagnificationConfig var2, boolean var3) throws RemoteException;

    @RequiresNoPermission
    public void setMagnificationCallbackEnabled(int var1, boolean var2) throws RemoteException;

    @RequiresNoPermission
    public boolean setSoftKeyboardShowMode(int var1) throws RemoteException;

    @RequiresNoPermission
    public int getSoftKeyboardShowMode() throws RemoteException;

    @RequiresNoPermission
    public void setSoftKeyboardCallbackEnabled(boolean var1) throws RemoteException;

    @RequiresNoPermission
    public boolean switchToInputMethod(String var1) throws RemoteException;

    @RequiresNoPermission
    public int setInputMethodEnabled(String var1, boolean var2) throws RemoteException;

    @RequiresNoPermission
    public boolean isAccessibilityButtonAvailable() throws RemoteException;

    @RequiresNoPermission
    public void sendGesture(int var1, ParceledListSlice var2) throws RemoteException;

    @RequiresNoPermission
    public void dispatchGesture(int var1, ParceledListSlice var2, int var3) throws RemoteException;

    @RequiresNoPermission
    public boolean isFingerprintGestureDetectionAvailable() throws RemoteException;

    @RequiresNoPermission
    public IBinder getOverlayWindowToken(int var1) throws RemoteException;

    @RequiresNoPermission
    public int getWindowIdForLeashToken(IBinder var1) throws RemoteException;

    @RequiresNoPermission
    public void takeScreenshot(int var1, RemoteCallback var2) throws RemoteException;

    @RequiresNoPermission
    public void takeScreenshotOfWindow(int var1, int var2, ScreenCapture.ScreenCaptureListener var3, IAccessibilityInteractionConnectionCallback var4) throws RemoteException;

    @RequiresNoPermission
    public void setGestureDetectionPassthroughRegion(int var1, Region var2) throws RemoteException;

    @RequiresNoPermission
    public void setTouchExplorationPassthroughRegion(int var1, Region var2) throws RemoteException;

    @RequiresNoPermission
    public void setFocusAppearance(int var1, int var2) throws RemoteException;

    @RequiresNoPermission
    public void setCacheEnabled(boolean var1) throws RemoteException;

    @RequiresNoPermission
    public void logTrace(long var1, String var3, long var4, String var6, int var7, long var8, int var10, Bundle var11) throws RemoteException;

    @RequiresNoPermission
    public void setServiceDetectsGesturesEnabled(int var1, boolean var2) throws RemoteException;

    @RequiresNoPermission
    public void requestTouchExploration(int var1) throws RemoteException;

    @RequiresNoPermission
    public void requestDragging(int var1, int var2) throws RemoteException;

    @RequiresNoPermission
    public void requestDelegating(int var1) throws RemoteException;

    @RequiresNoPermission
    public void onDoubleTap(int var1) throws RemoteException;

    @RequiresNoPermission
    public void onDoubleTapAndHold(int var1) throws RemoteException;

    @RequiresNoPermission
    public void setAnimationScale(float var1) throws RemoteException;

    @RequiresNoPermission
    public void setInstalledAndEnabledServices(List<AccessibilityServiceInfo> var1) throws RemoteException;

    @RequiresNoPermission
    public List<AccessibilityServiceInfo> getInstalledAndEnabledServices() throws RemoteException;

    @RequiresNoPermission
    public void attachAccessibilityOverlayToDisplay(int var1, int var2, SurfaceControl var3, IAccessibilityInteractionConnectionCallback var4) throws RemoteException;

    @RequiresNoPermission
    public void attachAccessibilityOverlayToWindow(int var1, int var2, SurfaceControl var3, IAccessibilityInteractionConnectionCallback var4) throws RemoteException;

    @EnforcePermission(value="android.permission.BLUETOOTH_CONNECT")
    public void connectBluetoothBrailleDisplay(String var1, IBrailleDisplayController var2) throws RemoteException;

    @RequiresNoPermission
    public void connectUsbBrailleDisplay(UsbDevice var1, IBrailleDisplayController var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public void setTestBrailleDisplayData(List<Bundle> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAccessibilityServiceConnection {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.accessibilityservice.IAccessibilityServiceConnection";
        static final int TRANSACTION_setServiceInfo = 1;
        static final int TRANSACTION_setAttributionTag = 2;
        static final int TRANSACTION_findAccessibilityNodeInfoByAccessibilityId = 3;
        static final int TRANSACTION_findAccessibilityNodeInfosByText = 4;
        static final int TRANSACTION_findAccessibilityNodeInfosByViewId = 5;
        static final int TRANSACTION_findFocus = 6;
        static final int TRANSACTION_focusSearch = 7;
        static final int TRANSACTION_performAccessibilityAction = 8;
        static final int TRANSACTION_getWindow = 9;
        static final int TRANSACTION_getWindows = 10;
        static final int TRANSACTION_getServiceInfo = 11;
        static final int TRANSACTION_performGlobalAction = 12;
        static final int TRANSACTION_getSystemActions = 13;
        static final int TRANSACTION_disableSelf = 14;
        static final int TRANSACTION_setOnKeyEventResult = 15;
        static final int TRANSACTION_getMagnificationConfig = 16;
        static final int TRANSACTION_getMagnificationScale = 17;
        static final int TRANSACTION_getMagnificationCenterX = 18;
        static final int TRANSACTION_getMagnificationCenterY = 19;
        static final int TRANSACTION_getMagnificationRegion = 20;
        static final int TRANSACTION_getCurrentMagnificationRegion = 21;
        static final int TRANSACTION_resetMagnification = 22;
        static final int TRANSACTION_resetCurrentMagnification = 23;
        static final int TRANSACTION_setMagnificationConfig = 24;
        static final int TRANSACTION_setMagnificationCallbackEnabled = 25;
        static final int TRANSACTION_setSoftKeyboardShowMode = 26;
        static final int TRANSACTION_getSoftKeyboardShowMode = 27;
        static final int TRANSACTION_setSoftKeyboardCallbackEnabled = 28;
        static final int TRANSACTION_switchToInputMethod = 29;
        static final int TRANSACTION_setInputMethodEnabled = 30;
        static final int TRANSACTION_isAccessibilityButtonAvailable = 31;
        static final int TRANSACTION_sendGesture = 32;
        static final int TRANSACTION_dispatchGesture = 33;
        static final int TRANSACTION_isFingerprintGestureDetectionAvailable = 34;
        static final int TRANSACTION_getOverlayWindowToken = 35;
        static final int TRANSACTION_getWindowIdForLeashToken = 36;
        static final int TRANSACTION_takeScreenshot = 37;
        static final int TRANSACTION_takeScreenshotOfWindow = 38;
        static final int TRANSACTION_setGestureDetectionPassthroughRegion = 39;
        static final int TRANSACTION_setTouchExplorationPassthroughRegion = 40;
        static final int TRANSACTION_setFocusAppearance = 41;
        static final int TRANSACTION_setCacheEnabled = 42;
        static final int TRANSACTION_logTrace = 43;
        static final int TRANSACTION_setServiceDetectsGesturesEnabled = 44;
        static final int TRANSACTION_requestTouchExploration = 45;
        static final int TRANSACTION_requestDragging = 46;
        static final int TRANSACTION_requestDelegating = 47;
        static final int TRANSACTION_onDoubleTap = 48;
        static final int TRANSACTION_onDoubleTapAndHold = 49;
        static final int TRANSACTION_setAnimationScale = 50;
        static final int TRANSACTION_setInstalledAndEnabledServices = 51;
        static final int TRANSACTION_getInstalledAndEnabledServices = 52;
        static final int TRANSACTION_attachAccessibilityOverlayToDisplay = 53;
        static final int TRANSACTION_attachAccessibilityOverlayToWindow = 54;
        static final int TRANSACTION_connectBluetoothBrailleDisplay = 55;
        static final int TRANSACTION_connectUsbBrailleDisplay = 56;
        static final int TRANSACTION_setTestBrailleDisplayData = 57;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IAccessibilityServiceConnection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAccessibilityServiceConnection) {
                return (IAccessibilityServiceConnection)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setServiceInfo";
                }
                case 2: {
                    return "setAttributionTag";
                }
                case 3: {
                    return "findAccessibilityNodeInfoByAccessibilityId";
                }
                case 4: {
                    return "findAccessibilityNodeInfosByText";
                }
                case 5: {
                    return "findAccessibilityNodeInfosByViewId";
                }
                case 6: {
                    return "findFocus";
                }
                case 7: {
                    return "focusSearch";
                }
                case 8: {
                    return "performAccessibilityAction";
                }
                case 9: {
                    return "getWindow";
                }
                case 10: {
                    return "getWindows";
                }
                case 11: {
                    return "getServiceInfo";
                }
                case 12: {
                    return "performGlobalAction";
                }
                case 13: {
                    return "getSystemActions";
                }
                case 14: {
                    return "disableSelf";
                }
                case 15: {
                    return "setOnKeyEventResult";
                }
                case 16: {
                    return "getMagnificationConfig";
                }
                case 17: {
                    return "getMagnificationScale";
                }
                case 18: {
                    return "getMagnificationCenterX";
                }
                case 19: {
                    return "getMagnificationCenterY";
                }
                case 20: {
                    return "getMagnificationRegion";
                }
                case 21: {
                    return "getCurrentMagnificationRegion";
                }
                case 22: {
                    return "resetMagnification";
                }
                case 23: {
                    return "resetCurrentMagnification";
                }
                case 24: {
                    return "setMagnificationConfig";
                }
                case 25: {
                    return "setMagnificationCallbackEnabled";
                }
                case 26: {
                    return "setSoftKeyboardShowMode";
                }
                case 27: {
                    return "getSoftKeyboardShowMode";
                }
                case 28: {
                    return "setSoftKeyboardCallbackEnabled";
                }
                case 29: {
                    return "switchToInputMethod";
                }
                case 30: {
                    return "setInputMethodEnabled";
                }
                case 31: {
                    return "isAccessibilityButtonAvailable";
                }
                case 32: {
                    return "sendGesture";
                }
                case 33: {
                    return "dispatchGesture";
                }
                case 34: {
                    return "isFingerprintGestureDetectionAvailable";
                }
                case 35: {
                    return "getOverlayWindowToken";
                }
                case 36: {
                    return "getWindowIdForLeashToken";
                }
                case 37: {
                    return "takeScreenshot";
                }
                case 38: {
                    return "takeScreenshotOfWindow";
                }
                case 39: {
                    return "setGestureDetectionPassthroughRegion";
                }
                case 40: {
                    return "setTouchExplorationPassthroughRegion";
                }
                case 41: {
                    return "setFocusAppearance";
                }
                case 42: {
                    return "setCacheEnabled";
                }
                case 43: {
                    return "logTrace";
                }
                case 44: {
                    return "setServiceDetectsGesturesEnabled";
                }
                case 45: {
                    return "requestTouchExploration";
                }
                case 46: {
                    return "requestDragging";
                }
                case 47: {
                    return "requestDelegating";
                }
                case 48: {
                    return "onDoubleTap";
                }
                case 49: {
                    return "onDoubleTapAndHold";
                }
                case 50: {
                    return "setAnimationScale";
                }
                case 51: {
                    return "setInstalledAndEnabledServices";
                }
                case 52: {
                    return "getInstalledAndEnabledServices";
                }
                case 53: {
                    return "attachAccessibilityOverlayToDisplay";
                }
                case 54: {
                    return "attachAccessibilityOverlayToWindow";
                }
                case 55: {
                    return "connectBluetoothBrailleDisplay";
                }
                case 56: {
                    return "connectUsbBrailleDisplay";
                }
                case 57: {
                    return "setTestBrailleDisplayData";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    AccessibilityServiceInfo _arg0 = data.readTypedObject(AccessibilityServiceInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.setServiceInfo(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setAttributionTag(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    IAccessibilityInteractionConnectionCallback _arg3 = IAccessibilityInteractionConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg4 = data.readInt();
                    long _arg5 = data.readLong();
                    Bundle _arg6 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    String[] _result = this.findAccessibilityNodeInfoByAccessibilityId(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    IAccessibilityInteractionConnectionCallback _arg4 = IAccessibilityInteractionConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    long _arg5 = data.readLong();
                    data.enforceNoDataAvail();
                    String[] _result = this.findAccessibilityNodeInfosByText(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    IAccessibilityInteractionConnectionCallback _arg4 = IAccessibilityInteractionConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    long _arg5 = data.readLong();
                    data.enforceNoDataAvail();
                    String[] _result = this.findAccessibilityNodeInfosByViewId(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    IAccessibilityInteractionConnectionCallback _arg4 = IAccessibilityInteractionConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    long _arg5 = data.readLong();
                    data.enforceNoDataAvail();
                    String[] _result = this.findFocus(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    IAccessibilityInteractionConnectionCallback _arg4 = IAccessibilityInteractionConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    long _arg5 = data.readLong();
                    data.enforceNoDataAvail();
                    String[] _result = this.focusSearch(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    int _arg4 = data.readInt();
                    IAccessibilityInteractionConnectionCallback _arg5 = IAccessibilityInteractionConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    long _arg6 = data.readLong();
                    data.enforceNoDataAvail();
                    boolean _result = this.performAccessibilityAction(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    AccessibilityWindowInfo _result = this.getWindow(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    AccessibilityWindowInfo.WindowListSparseArray _result = this.getWindows();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    AccessibilityServiceInfo _result = this.getServiceInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.performGlobalAction(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    List<AccessibilityNodeInfo.AccessibilityAction> _result = this.getSystemActions();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 14: {
                    this.disableSelf();
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setOnKeyEventResult(_arg0, _arg1);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    MagnificationConfig _result = this.getMagnificationConfig(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getMagnificationScale(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getMagnificationCenterX(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getMagnificationCenterY(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Region _result = this.getMagnificationRegion(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Region _result = this.getCurrentMagnificationRegion(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.resetMagnification(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.resetCurrentMagnification(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    MagnificationConfig _arg1 = data.readTypedObject(MagnificationConfig.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setMagnificationConfig(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setMagnificationCallbackEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setSoftKeyboardShowMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 27: {
                    int _result = this.getSoftKeyboardShowMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 28: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSoftKeyboardCallbackEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.switchToInputMethod(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.setInputMethodEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 31: {
                    boolean _result = this.isAccessibilityButtonAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    ParceledListSlice _arg1 = data.readTypedObject(ParceledListSlice.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendGesture(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    ParceledListSlice _arg1 = data.readTypedObject(ParceledListSlice.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.dispatchGesture(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    boolean _result = this.isFingerprintGestureDetectionAvailable();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    IBinder _result = this.getOverlayWindowToken(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 36: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    int _result = this.getWindowIdForLeashToken(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 37: {
                    int _arg0 = data.readInt();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.takeScreenshot(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ScreenCapture.ScreenCaptureListener _arg2 = data.readTypedObject(ScreenCapture.ScreenCaptureListener.CREATOR);
                    IAccessibilityInteractionConnectionCallback _arg3 = IAccessibilityInteractionConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.takeScreenshotOfWindow(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    Region _arg1 = data.readTypedObject(Region.CREATOR);
                    data.enforceNoDataAvail();
                    this.setGestureDetectionPassthroughRegion(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    Region _arg1 = data.readTypedObject(Region.CREATOR);
                    data.enforceNoDataAvail();
                    this.setTouchExplorationPassthroughRegion(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setFocusAppearance(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setCacheEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    long _arg5 = data.readLong();
                    int _arg6 = data.readInt();
                    Bundle _arg7 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.logTrace(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 44: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setServiceDetectsGesturesEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestTouchExploration(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestDragging(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestDelegating(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDoubleTap(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDoubleTapAndHold(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setAnimationScale(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    ArrayList<AccessibilityServiceInfo> _arg0 = data.createTypedArrayList(AccessibilityServiceInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.setInstalledAndEnabledServices(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    List<AccessibilityServiceInfo> _result = this.getInstalledAndEnabledServices();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 53: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    SurfaceControl _arg2 = data.readTypedObject(SurfaceControl.CREATOR);
                    IAccessibilityInteractionConnectionCallback _arg3 = IAccessibilityInteractionConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.attachAccessibilityOverlayToDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    SurfaceControl _arg2 = data.readTypedObject(SurfaceControl.CREATOR);
                    IAccessibilityInteractionConnectionCallback _arg3 = IAccessibilityInteractionConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.attachAccessibilityOverlayToWindow(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    String _arg0 = data.readString();
                    IBrailleDisplayController _arg1 = IBrailleDisplayController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.connectBluetoothBrailleDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    UsbDevice _arg0 = data.readTypedObject(UsbDevice.CREATOR);
                    IBrailleDisplayController _arg1 = IBrailleDisplayController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.connectUsbBrailleDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    ArrayList<Bundle> _arg0 = data.createTypedArrayList(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.setTestBrailleDisplayData(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void connectBluetoothBrailleDisplay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BLUETOOTH_CONNECT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setTestBrailleDisplayData_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 56;
        }

        private static class Proxy
        implements IAccessibilityServiceConnection {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setServiceInfo(AccessibilityServiceInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAttributionTag(String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] findAccessibilityNodeInfoByAccessibilityId(int accessibilityWindowId, long accessibilityNodeId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, long threadId, Bundle arguments) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(accessibilityWindowId);
                    _data.writeLong(accessibilityNodeId);
                    _data.writeInt(interactionId);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(flags);
                    _data.writeLong(threadId);
                    _data.writeTypedObject(arguments, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] findAccessibilityNodeInfosByText(int accessibilityWindowId, long accessibilityNodeId, String text, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(accessibilityWindowId);
                    _data.writeLong(accessibilityNodeId);
                    _data.writeString(text);
                    _data.writeInt(interactionId);
                    _data.writeStrongInterface(callback);
                    _data.writeLong(threadId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] findAccessibilityNodeInfosByViewId(int accessibilityWindowId, long accessibilityNodeId, String viewId, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(accessibilityWindowId);
                    _data.writeLong(accessibilityNodeId);
                    _data.writeString(viewId);
                    _data.writeInt(interactionId);
                    _data.writeStrongInterface(callback);
                    _data.writeLong(threadId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] findFocus(int accessibilityWindowId, long accessibilityNodeId, int focusType, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(accessibilityWindowId);
                    _data.writeLong(accessibilityNodeId);
                    _data.writeInt(focusType);
                    _data.writeInt(interactionId);
                    _data.writeStrongInterface(callback);
                    _data.writeLong(threadId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] focusSearch(int accessibilityWindowId, long accessibilityNodeId, int direction, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(accessibilityWindowId);
                    _data.writeLong(accessibilityNodeId);
                    _data.writeInt(direction);
                    _data.writeInt(interactionId);
                    _data.writeStrongInterface(callback);
                    _data.writeLong(threadId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean performAccessibilityAction(int accessibilityWindowId, long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(accessibilityWindowId);
                    _data.writeLong(accessibilityNodeId);
                    _data.writeInt(action);
                    _data.writeTypedObject(arguments, 0);
                    _data.writeInt(interactionId);
                    _data.writeStrongInterface(callback);
                    _data.writeLong(threadId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AccessibilityWindowInfo getWindow(int windowId) throws RemoteException {
                AccessibilityWindowInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(windowId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AccessibilityWindowInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AccessibilityWindowInfo.WindowListSparseArray getWindows() throws RemoteException {
                AccessibilityWindowInfo.WindowListSparseArray _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AccessibilityWindowInfo.WindowListSparseArray.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AccessibilityServiceInfo getServiceInfo() throws RemoteException {
                AccessibilityServiceInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AccessibilityServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean performGlobalAction(int action) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(action);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AccessibilityNodeInfo.AccessibilityAction> getSystemActions() throws RemoteException {
                ArrayList<AccessibilityNodeInfo.AccessibilityAction> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AccessibilityNodeInfo.AccessibilityAction.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableSelf() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnKeyEventResult(boolean handled, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(handled);
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MagnificationConfig getMagnificationConfig(int displayId) throws RemoteException {
                MagnificationConfig _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MagnificationConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getMagnificationScale(int displayId) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getMagnificationCenterX(int displayId) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getMagnificationCenterY(int displayId) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Region getMagnificationRegion(int displayId) throws RemoteException {
                Region _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Region.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Region getCurrentMagnificationRegion(int displayId) throws RemoteException {
                Region _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Region.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean resetMagnification(int displayId, boolean animate) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(animate);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean resetCurrentMagnification(int displayId, boolean animate) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(animate);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setMagnificationConfig(int displayId, MagnificationConfig config, boolean animate) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(config, 0);
                    _data.writeBoolean(animate);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMagnificationCallbackEnabled(int displayId, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSoftKeyboardShowMode(int showMode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(showMode);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSoftKeyboardShowMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSoftKeyboardCallbackEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean switchToInputMethod(String imeId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(imeId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setInputMethodEnabled(String imeId, boolean enabled) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(imeId);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAccessibilityButtonAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendGesture(int sequence, ParceledListSlice gestureSteps) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sequence);
                    _data.writeTypedObject(gestureSteps, 0);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchGesture(int sequence, ParceledListSlice gestureSteps, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sequence);
                    _data.writeTypedObject(gestureSteps, 0);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isFingerprintGestureDetectionAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getOverlayWindowToken(int displayid) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayid);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWindowIdForLeashToken(IBinder token) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void takeScreenshot(int displayId, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void takeScreenshotOfWindow(int accessibilityWindowId, int interactionId, ScreenCapture.ScreenCaptureListener listener, IAccessibilityInteractionConnectionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(accessibilityWindowId);
                    _data.writeInt(interactionId);
                    _data.writeTypedObject(listener, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setGestureDetectionPassthroughRegion(int displayId, Region region) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(region, 0);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTouchExplorationPassthroughRegion(int displayId, Region region) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(region, 0);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFocusAppearance(int strokeWidth, int color2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(strokeWidth);
                    _data.writeInt(color2);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCacheEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void logTrace(long timestamp, String where, long loggingTypes, String callingParams, int processId, long threadId, int callingUid, Bundle serializedCallingStackInBundle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timestamp);
                    _data.writeString(where);
                    _data.writeLong(loggingTypes);
                    _data.writeString(callingParams);
                    _data.writeInt(processId);
                    _data.writeLong(threadId);
                    _data.writeInt(callingUid);
                    _data.writeTypedObject(serializedCallingStackInBundle, 0);
                    boolean bl = this.mRemote.transact(43, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setServiceDetectsGesturesEnabled(int displayId, boolean mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(mode);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestTouchExploration(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestDragging(int displayId, int pointerId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(pointerId);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestDelegating(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDoubleTap(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDoubleTapAndHold(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnimationScale(float scale) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(scale);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInstalledAndEnabledServices(List<AccessibilityServiceInfo> infos) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(infos, 0);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AccessibilityServiceInfo> getInstalledAndEnabledServices() throws RemoteException {
                ArrayList<AccessibilityServiceInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AccessibilityServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attachAccessibilityOverlayToDisplay(int interactionId, int displayId, SurfaceControl sc, IAccessibilityInteractionConnectionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(interactionId);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(sc, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attachAccessibilityOverlayToWindow(int interactionId, int accessibilityWindowId, SurfaceControl sc, IAccessibilityInteractionConnectionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(interactionId);
                    _data.writeInt(accessibilityWindowId);
                    _data.writeTypedObject(sc, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectBluetoothBrailleDisplay(String bluetoothAddress, IBrailleDisplayController controller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(bluetoothAddress);
                    _data.writeStrongInterface(controller);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectUsbBrailleDisplay(UsbDevice usbDevice, IBrailleDisplayController controller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(usbDevice, 0);
                    _data.writeStrongInterface(controller);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTestBrailleDisplayData(List<Bundle> brailleDisplays) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(brailleDisplays, 0);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAccessibilityServiceConnection {
        @Override
        public void setServiceInfo(AccessibilityServiceInfo info) throws RemoteException {
        }

        @Override
        public void setAttributionTag(String attributionTag) throws RemoteException {
        }

        @Override
        public String[] findAccessibilityNodeInfoByAccessibilityId(int accessibilityWindowId, long accessibilityNodeId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, long threadId, Bundle arguments) throws RemoteException {
            return null;
        }

        @Override
        public String[] findAccessibilityNodeInfosByText(int accessibilityWindowId, long accessibilityNodeId, String text, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
            return null;
        }

        @Override
        public String[] findAccessibilityNodeInfosByViewId(int accessibilityWindowId, long accessibilityNodeId, String viewId, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
            return null;
        }

        @Override
        public String[] findFocus(int accessibilityWindowId, long accessibilityNodeId, int focusType, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
            return null;
        }

        @Override
        public String[] focusSearch(int accessibilityWindowId, long accessibilityNodeId, int direction, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
            return null;
        }

        @Override
        public boolean performAccessibilityAction(int accessibilityWindowId, long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
            return false;
        }

        @Override
        public AccessibilityWindowInfo getWindow(int windowId) throws RemoteException {
            return null;
        }

        @Override
        public AccessibilityWindowInfo.WindowListSparseArray getWindows() throws RemoteException {
            return null;
        }

        @Override
        public AccessibilityServiceInfo getServiceInfo() throws RemoteException {
            return null;
        }

        @Override
        public boolean performGlobalAction(int action) throws RemoteException {
            return false;
        }

        @Override
        public List<AccessibilityNodeInfo.AccessibilityAction> getSystemActions() throws RemoteException {
            return null;
        }

        @Override
        public void disableSelf() throws RemoteException {
        }

        @Override
        public void setOnKeyEventResult(boolean handled, int sequence) throws RemoteException {
        }

        @Override
        public MagnificationConfig getMagnificationConfig(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public float getMagnificationScale(int displayId) throws RemoteException {
            return 0.0f;
        }

        @Override
        public float getMagnificationCenterX(int displayId) throws RemoteException {
            return 0.0f;
        }

        @Override
        public float getMagnificationCenterY(int displayId) throws RemoteException {
            return 0.0f;
        }

        @Override
        public Region getMagnificationRegion(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public Region getCurrentMagnificationRegion(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public boolean resetMagnification(int displayId, boolean animate) throws RemoteException {
            return false;
        }

        @Override
        public boolean resetCurrentMagnification(int displayId, boolean animate) throws RemoteException {
            return false;
        }

        @Override
        public boolean setMagnificationConfig(int displayId, MagnificationConfig config, boolean animate) throws RemoteException {
            return false;
        }

        @Override
        public void setMagnificationCallbackEnabled(int displayId, boolean enabled) throws RemoteException {
        }

        @Override
        public boolean setSoftKeyboardShowMode(int showMode) throws RemoteException {
            return false;
        }

        @Override
        public int getSoftKeyboardShowMode() throws RemoteException {
            return 0;
        }

        @Override
        public void setSoftKeyboardCallbackEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean switchToInputMethod(String imeId) throws RemoteException {
            return false;
        }

        @Override
        public int setInputMethodEnabled(String imeId, boolean enabled) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isAccessibilityButtonAvailable() throws RemoteException {
            return false;
        }

        @Override
        public void sendGesture(int sequence, ParceledListSlice gestureSteps) throws RemoteException {
        }

        @Override
        public void dispatchGesture(int sequence, ParceledListSlice gestureSteps, int displayId) throws RemoteException {
        }

        @Override
        public boolean isFingerprintGestureDetectionAvailable() throws RemoteException {
            return false;
        }

        @Override
        public IBinder getOverlayWindowToken(int displayid) throws RemoteException {
            return null;
        }

        @Override
        public int getWindowIdForLeashToken(IBinder token) throws RemoteException {
            return 0;
        }

        @Override
        public void takeScreenshot(int displayId, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void takeScreenshotOfWindow(int accessibilityWindowId, int interactionId, ScreenCapture.ScreenCaptureListener listener, IAccessibilityInteractionConnectionCallback callback) throws RemoteException {
        }

        @Override
        public void setGestureDetectionPassthroughRegion(int displayId, Region region) throws RemoteException {
        }

        @Override
        public void setTouchExplorationPassthroughRegion(int displayId, Region region) throws RemoteException {
        }

        @Override
        public void setFocusAppearance(int strokeWidth, int color2) throws RemoteException {
        }

        @Override
        public void setCacheEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void logTrace(long timestamp, String where, long loggingTypes, String callingParams, int processId, long threadId, int callingUid, Bundle serializedCallingStackInBundle) throws RemoteException {
        }

        @Override
        public void setServiceDetectsGesturesEnabled(int displayId, boolean mode) throws RemoteException {
        }

        @Override
        public void requestTouchExploration(int displayId) throws RemoteException {
        }

        @Override
        public void requestDragging(int displayId, int pointerId) throws RemoteException {
        }

        @Override
        public void requestDelegating(int displayId) throws RemoteException {
        }

        @Override
        public void onDoubleTap(int displayId) throws RemoteException {
        }

        @Override
        public void onDoubleTapAndHold(int displayId) throws RemoteException {
        }

        @Override
        public void setAnimationScale(float scale) throws RemoteException {
        }

        @Override
        public void setInstalledAndEnabledServices(List<AccessibilityServiceInfo> infos) throws RemoteException {
        }

        @Override
        public List<AccessibilityServiceInfo> getInstalledAndEnabledServices() throws RemoteException {
            return null;
        }

        @Override
        public void attachAccessibilityOverlayToDisplay(int interactionId, int displayId, SurfaceControl sc, IAccessibilityInteractionConnectionCallback callback) throws RemoteException {
        }

        @Override
        public void attachAccessibilityOverlayToWindow(int interactionId, int accessibilityWindowId, SurfaceControl sc, IAccessibilityInteractionConnectionCallback callback) throws RemoteException {
        }

        @Override
        public void connectBluetoothBrailleDisplay(String bluetoothAddress, IBrailleDisplayController controller) throws RemoteException {
        }

        @Override
        public void connectUsbBrailleDisplay(UsbDevice usbDevice, IBrailleDisplayController controller) throws RemoteException {
        }

        @Override
        public void setTestBrailleDisplayData(List<Bundle> brailleDisplays) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

