/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class MagnificationConfig
implements Parcelable {
    public static final int MAGNIFICATION_MODE_DEFAULT = 0;
    public static final int MAGNIFICATION_MODE_FULLSCREEN = 1;
    public static final int MAGNIFICATION_MODE_WINDOW = 2;
    private int mMode = 0;
    private boolean mActivated = false;
    private float mScale = Float.NaN;
    private float mCenterX = Float.NaN;
    private float mCenterY = Float.NaN;
    @NonNull
    public static final Parcelable.Creator<MagnificationConfig> CREATOR = new Parcelable.Creator<MagnificationConfig>(){

        @Override
        public MagnificationConfig createFromParcel(Parcel parcel) {
            return new MagnificationConfig(parcel);
        }

        public MagnificationConfig[] newArray(int size) {
            return new MagnificationConfig[size];
        }
    };

    private MagnificationConfig() {
    }

    private MagnificationConfig(@NonNull Parcel parcel) {
        this.mMode = parcel.readInt();
        this.mActivated = parcel.readBoolean();
        this.mScale = parcel.readFloat();
        this.mCenterX = parcel.readFloat();
        this.mCenterY = parcel.readFloat();
    }

    public int getMode() {
        return this.mMode;
    }

    public boolean isActivated() {
        return this.mActivated;
    }

    public float getScale() {
        return this.mScale;
    }

    public float getCenterX() {
        return this.mCenterX;
    }

    public float getCenterY() {
        return this.mCenterY;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("MagnificationConfig[");
        stringBuilder.append("mode: ").append(this.getMode());
        stringBuilder.append(", ");
        stringBuilder.append("activated: ").append(this.isActivated());
        stringBuilder.append(", ");
        stringBuilder.append("scale: ").append(this.getScale());
        stringBuilder.append(", ");
        stringBuilder.append("centerX: ").append(this.getCenterX());
        stringBuilder.append(", ");
        stringBuilder.append("centerY: ").append(this.getCenterY());
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeInt(this.mMode);
        parcel.writeBoolean(this.mActivated);
        parcel.writeFloat(this.mScale);
        parcel.writeFloat(this.mCenterX);
        parcel.writeFloat(this.mCenterY);
    }

    public static class Builder {
        private int mMode = 0;
        private boolean mActivated = true;
        private float mScale = Float.NaN;
        private float mCenterX = Float.NaN;
        private float mCenterY = Float.NaN;

        @NonNull
        public Builder setMode(int mode) {
            this.mMode = mode;
            return this;
        }

        @NonNull
        public Builder setActivated(boolean activated) {
            this.mActivated = activated;
            return this;
        }

        @NonNull
        public Builder setScale(float scale) {
            this.mScale = scale;
            return this;
        }

        @NonNull
        public Builder setCenterX(float centerX) {
            this.mCenterX = centerX;
            return this;
        }

        @NonNull
        public Builder setCenterY(float centerY) {
            this.mCenterY = centerY;
            return this;
        }

        @NonNull
        public MagnificationConfig build() {
            MagnificationConfig magnificationConfig = new MagnificationConfig();
            magnificationConfig.mMode = this.mMode;
            magnificationConfig.mActivated = this.mActivated;
            magnificationConfig.mScale = this.mScale;
            magnificationConfig.mCenterX = this.mCenterX;
            magnificationConfig.mCenterY = this.mCenterY;
            return magnificationConfig;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface MagnificationMode {
    }
}

