/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class AdSelectionResponse
implements Parcelable {
    private final long mAdSelectionId;
    private final Uri mRenderUri;
    private final AdTechIdentifier mWinningSeller;
    @NonNull
    public static final Parcelable.Creator<AdSelectionResponse> CREATOR = new Parcelable.Creator<AdSelectionResponse>(){

        @Override
        public AdSelectionResponse createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new AdSelectionResponse(in);
        }

        public AdSelectionResponse[] newArray(int size) {
            return new AdSelectionResponse[size];
        }
    };

    private AdSelectionResponse(long adSelectionId, Uri renderUri, AdTechIdentifier winningSeller) {
        Objects.requireNonNull(renderUri);
        this.mAdSelectionId = adSelectionId;
        this.mRenderUri = renderUri;
        this.mWinningSeller = Objects.requireNonNull(winningSeller, "Winning seller cannot be null");
    }

    private AdSelectionResponse(Parcel in) {
        Objects.requireNonNull(in);
        this.mAdSelectionId = in.readLong();
        this.mRenderUri = Uri.CREATOR.createFromParcel(in);
        this.mWinningSeller = AdTechIdentifier.CREATOR.createFromParcel(in);
    }

    public Uri getRenderUri() {
        return this.mRenderUri;
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    public AdTechIdentifier getWinningSeller() {
        return this.mWinningSeller;
    }

    public boolean equals(Object o) {
        if (o instanceof AdSelectionResponse) {
            AdSelectionResponse adSelectionResponse = (AdSelectionResponse)o;
            return this.mAdSelectionId == adSelectionResponse.mAdSelectionId && Objects.equals(this.mRenderUri, adSelectionResponse.mRenderUri) && Objects.equals(this.mWinningSeller, adSelectionResponse.mWinningSeller);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mAdSelectionId, this.mRenderUri, this.mWinningSeller);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        Objects.requireNonNull(this.mRenderUri, "Render uri cannot be null");
        Objects.requireNonNull(this.mWinningSeller, "Winning seller cannot be null");
        dest.writeLong(this.mAdSelectionId);
        this.mRenderUri.writeToParcel(dest, flags);
        this.mWinningSeller.writeToParcel(dest, flags);
    }

    public String toString() {
        return "AdSelectionResponse{mAdSelectionId=" + this.mAdSelectionId + ", mRenderUri=" + this.mRenderUri + ", mWinningSeller=" + this.mWinningSeller + '}';
    }

    public static class Builder {
        private long mAdSelectionId = 0L;
        private Uri mRenderUri;
        private AdTechIdentifier mWinningSeller = AdTechIdentifier.UNSET_AD_TECH_IDENTIFIER;

        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        public Builder setRenderUri(Uri renderUri) {
            Objects.requireNonNull(renderUri);
            this.mRenderUri = renderUri;
            return this;
        }

        public Builder setWinningSeller(AdTechIdentifier winningSeller) {
            Objects.requireNonNull(winningSeller, "Winning seller cannot be null");
            Preconditions.checkArgument(!winningSeller.equals(AdTechIdentifier.UNSET_AD_TECH_IDENTIFIER), "Winning seller cannot be empty");
            this.mWinningSeller = winningSeller;
            return this;
        }

        public AdSelectionResponse build() {
            Objects.requireNonNull(this.mRenderUri);
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Non-zero ad selection ID must be set");
            return new AdSelectionResponse(this.mAdSelectionId, this.mRenderUri, this.mWinningSeller);
        }
    }
}

