/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.InputEvent;
import com.android.adservices.AdServicesParcelableUtil;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class ReportInteractionInput
implements Parcelable {
    private static final int UNSET_REPORTING_DESTINATIONS = 0;
    private static final String UNSET_REPORTING_DESTINATIONS_MESSAGE = "Reporting Destinations bitfield not set.";
    private final long mAdSelectionId;
    @NonNull
    private final String mInteractionKey;
    @NonNull
    private final String mInteractionData;
    @NonNull
    private final String mCallerPackageName;
    private final int mReportingDestinations;
    @Nullable
    private final InputEvent mInputEvent;
    @Nullable
    private final String mAdId;
    @Nullable
    private final String mCallerSdkName;
    @NonNull
    public static final Parcelable.Creator<ReportInteractionInput> CREATOR = new Parcelable.Creator<ReportInteractionInput>(){

        @Override
        public ReportInteractionInput createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new ReportInteractionInput(in);
        }

        public ReportInteractionInput[] newArray(int size) {
            return new ReportInteractionInput[size];
        }
    };

    private ReportInteractionInput(long adSelectionId, @NonNull String interactionKey, @NonNull String interactionData, @NonNull String callerPackageName, int reportingDestinations, @Nullable InputEvent inputEvent, @Nullable String adId, @Nullable String callerSdkName) {
        Objects.requireNonNull(interactionKey);
        Objects.requireNonNull(interactionData);
        Objects.requireNonNull(callerPackageName);
        this.mAdSelectionId = adSelectionId;
        this.mInteractionKey = interactionKey;
        this.mInteractionData = interactionData;
        this.mCallerPackageName = callerPackageName;
        this.mReportingDestinations = reportingDestinations;
        this.mInputEvent = inputEvent;
        this.mAdId = adId;
        this.mCallerSdkName = callerSdkName;
    }

    private ReportInteractionInput(@NonNull Parcel in) {
        this.mAdSelectionId = in.readLong();
        this.mInteractionKey = in.readString();
        this.mInteractionData = in.readString();
        this.mCallerPackageName = in.readString();
        this.mReportingDestinations = in.readInt();
        this.mInputEvent = AdServicesParcelableUtil.readNullableFromParcel(in, InputEvent.CREATOR::createFromParcel);
        this.mAdId = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> in.readString());
        this.mCallerSdkName = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> in.readString());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeLong(this.mAdSelectionId);
        dest.writeString(this.mInteractionKey);
        dest.writeString(this.mInteractionData);
        dest.writeString(this.mCallerPackageName);
        dest.writeInt(this.mReportingDestinations);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mInputEvent, (targetParcel, sourceInputEvent) -> sourceInputEvent.writeToParcel(targetParcel, flags));
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mAdId, Parcel::writeString);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mCallerSdkName, Parcel::writeString);
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    @NonNull
    public String getInteractionKey() {
        return this.mInteractionKey;
    }

    @NonNull
    public String getInteractionData() {
        return this.mInteractionData;
    }

    @NonNull
    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    public int getReportingDestinations() {
        return this.mReportingDestinations;
    }

    @Nullable
    public InputEvent getInputEvent() {
        return this.mInputEvent;
    }

    @Nullable
    public String getAdId() {
        return this.mAdId;
    }

    @Nullable
    public String getCallerSdkName() {
        return this.mCallerSdkName;
    }

    public static class Builder {
        private long mAdSelectionId = 0L;
        @Nullable
        private String mInteractionKey;
        @Nullable
        private String mInteractionData;
        @Nullable
        private String mCallerPackageName;
        @Nullable
        private String mCallerSdkName;
        private int mReportingDestinations = 0;
        @Nullable
        private InputEvent mInputEvent;
        @Nullable
        private String mAdId;

        @NonNull
        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        @NonNull
        public Builder setInteractionKey(@NonNull String interactionKey) {
            Objects.requireNonNull(interactionKey);
            this.mInteractionKey = interactionKey;
            return this;
        }

        @NonNull
        public Builder setInteractionData(@NonNull String interactionData) {
            Objects.requireNonNull(interactionData);
            this.mInteractionData = interactionData;
            return this;
        }

        @NonNull
        public Builder setCallerPackageName(@NonNull String callerPackageName) {
            Objects.requireNonNull(callerPackageName);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        @NonNull
        public Builder setReportingDestinations(int reportingDestinations) {
            Preconditions.checkArgument(reportingDestinations != 0, ReportInteractionInput.UNSET_REPORTING_DESTINATIONS_MESSAGE);
            this.mReportingDestinations = reportingDestinations;
            return this;
        }

        @NonNull
        public Builder setInputEvent(@Nullable InputEvent inputEvent) {
            this.mInputEvent = inputEvent;
            return this;
        }

        @NonNull
        public Builder setAdId(@Nullable String adId) {
            this.mAdId = adId;
            return this;
        }

        @NonNull
        public Builder setCallerSdkName(@Nullable String callerSdkName) {
            this.mCallerSdkName = callerSdkName;
            return this;
        }

        @NonNull
        public ReportInteractionInput build() {
            Objects.requireNonNull(this.mInteractionKey);
            Objects.requireNonNull(this.mInteractionData);
            Objects.requireNonNull(this.mCallerPackageName);
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Non-zero ad selection ID must be set");
            Preconditions.checkArgument(this.mReportingDestinations != 0, ReportInteractionInput.UNSET_REPORTING_DESTINATIONS_MESSAGE);
            return new ReportInteractionInput(this.mAdSelectionId, this.mInteractionKey, this.mInteractionData, this.mCallerPackageName, this.mReportingDestinations, this.mInputEvent, this.mAdId, this.mCallerSdkName);
        }
    }
}

