/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.adselection.AdWithBid;
import android.adservices.common.AdTechIdentifier;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@FlaggedApi(value="com.android.adservices.flags.fledge_ad_selection_filtering_enabled")
public class SignedContextualAds
implements Parcelable {
    private static final String BUYER_CANNOT_BE_NULL = "Buyer cannot be null.";
    private static final String DECISION_LOGIC_URI_CANNOT_BE_NULL = "DecisionLogicUri cannot be null.";
    private static final String ADS_WITH_BID_CANNOT_BE_NULL = "AdsWithBid cannot be null.";
    private static final String SIGNATURE_CANNOT_BE_NULL = "Signature cannot be null.";
    @NonNull
    private final AdTechIdentifier mBuyer;
    @NonNull
    private final Uri mDecisionLogicUri;
    @NonNull
    private final List<AdWithBid> mAdsWithBid;
    @NonNull
    private final byte[] mSignature;
    @NonNull
    public static final Parcelable.Creator<SignedContextualAds> CREATOR = new Parcelable.Creator<SignedContextualAds>(){

        @Override
        public SignedContextualAds createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new SignedContextualAds(in);
        }

        public SignedContextualAds[] newArray(int size) {
            return new SignedContextualAds[0];
        }
    };

    private SignedContextualAds(@NonNull AdTechIdentifier buyer, @NonNull Uri decisionLogicUri, @NonNull List<AdWithBid> adsWithBid, @NonNull byte[] signature) {
        this.mBuyer = buyer;
        this.mDecisionLogicUri = decisionLogicUri;
        this.mAdsWithBid = adsWithBid;
        this.mSignature = signature;
    }

    private SignedContextualAds(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mBuyer = AdTechIdentifier.CREATOR.createFromParcel(in);
        this.mDecisionLogicUri = Uri.CREATOR.createFromParcel(in);
        this.mAdsWithBid = in.createTypedArrayList(AdWithBid.CREATOR);
        this.mSignature = in.createByteArray();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mBuyer.writeToParcel(dest, flags);
        this.mDecisionLogicUri.writeToParcel(dest, flags);
        dest.writeTypedList(this.mAdsWithBid);
        dest.writeByteArray(this.mSignature);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignedContextualAds)) {
            return false;
        }
        SignedContextualAds that = (SignedContextualAds)o;
        return Objects.equals(this.mBuyer, that.mBuyer) && Objects.equals(this.mDecisionLogicUri, that.mDecisionLogicUri) && Objects.equals(this.mAdsWithBid, that.mAdsWithBid) && Arrays.equals(this.mSignature, that.mSignature);
    }

    public int hashCode() {
        return Objects.hash(this.mBuyer, this.mDecisionLogicUri, this.mAdsWithBid, Arrays.hashCode(this.mSignature));
    }

    @NonNull
    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    @NonNull
    public Uri getDecisionLogicUri() {
        return this.mDecisionLogicUri;
    }

    @NonNull
    public List<AdWithBid> getAdsWithBid() {
        return this.mAdsWithBid;
    }

    @NonNull
    public byte[] getSignature() {
        return Arrays.copyOf(this.mSignature, this.mSignature.length);
    }

    public String toString() {
        return "SignedContextualAds{mBuyer=" + this.mBuyer + ", mDecisionLogicUri=" + this.mDecisionLogicUri + ", mAdsWithBid=" + this.mAdsWithBid + ", mSignature=" + Arrays.toString(this.mSignature) + '}';
    }

    public static class Builder {
        @Nullable
        private AdTechIdentifier mBuyer;
        @Nullable
        private Uri mDecisionLogicUri;
        @Nullable
        private List<AdWithBid> mAdsWithBid;
        @Nullable
        private byte[] mSignature;

        public Builder() {
        }

        public Builder(@NonNull SignedContextualAds signedContextualAds) {
            Objects.requireNonNull(signedContextualAds);
            this.mBuyer = signedContextualAds.getBuyer();
            this.mDecisionLogicUri = signedContextualAds.getDecisionLogicUri();
            this.mAdsWithBid = signedContextualAds.getAdsWithBid();
            this.mSignature = signedContextualAds.getSignature();
        }

        @NonNull
        public Builder setBuyer(@NonNull AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer, SignedContextualAds.BUYER_CANNOT_BE_NULL);
            this.mBuyer = buyer;
            return this;
        }

        @NonNull
        public Builder setDecisionLogicUri(@NonNull Uri decisionLogicUri) {
            Objects.requireNonNull(decisionLogicUri, SignedContextualAds.DECISION_LOGIC_URI_CANNOT_BE_NULL);
            this.mDecisionLogicUri = decisionLogicUri;
            return this;
        }

        @NonNull
        public Builder setAdsWithBid(@NonNull List<AdWithBid> adsWithBid) {
            Objects.requireNonNull(adsWithBid, SignedContextualAds.ADS_WITH_BID_CANNOT_BE_NULL);
            this.mAdsWithBid = adsWithBid;
            return this;
        }

        @NonNull
        public Builder setSignature(@NonNull byte[] signature) {
            Objects.requireNonNull(signature, SignedContextualAds.SIGNATURE_CANNOT_BE_NULL);
            this.mSignature = Arrays.copyOf(signature, signature.length);
            return this;
        }

        @NonNull
        public SignedContextualAds build() {
            Objects.requireNonNull(this.mBuyer, SignedContextualAds.BUYER_CANNOT_BE_NULL);
            Objects.requireNonNull(this.mDecisionLogicUri, SignedContextualAds.DECISION_LOGIC_URI_CANNOT_BE_NULL);
            Objects.requireNonNull(this.mAdsWithBid, SignedContextualAds.ADS_WITH_BID_CANNOT_BE_NULL);
            Objects.requireNonNull(this.mSignature, SignedContextualAds.SIGNATURE_CANNOT_BE_NULL);
            return new SignedContextualAds(this.mBuyer, this.mDecisionLogicUri, this.mAdsWithBid, this.mSignature);
        }
    }
}

