/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.adservices.common.AdServicesCommonStatesResponse;
import android.adservices.common.AdServicesOutcomeReceiver;
import android.adservices.common.AdServicesStates;
import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.AndroidRCommonUtil;
import android.adservices.common.CallerMetadata;
import android.adservices.common.EnableAdServicesResponse;
import android.adservices.common.GetAdServicesCommonStatesParams;
import android.adservices.common.IAdServicesCommonCallback;
import android.adservices.common.IAdServicesCommonService;
import android.adservices.common.IAdServicesCommonStatesCallback;
import android.adservices.common.IEnableAdServicesCallback;
import android.adservices.common.IRequestAdServicesModuleOverridesCallback;
import android.adservices.common.IRequestAdServicesModuleUserChoicesCallback;
import android.adservices.common.IUpdateAdIdCallback;
import android.adservices.common.IsAdServicesEnabledResult;
import android.adservices.common.OutcomeReceiverConverter;
import android.adservices.common.SandboxedSdkContextUtils;
import android.adservices.common.UpdateAdIdRequest;
import android.adservices.common.UpdateAdServicesModuleStatesParams;
import android.adservices.common.UpdateAdServicesUserChoicesParams;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os._Original_Build;
import com.android.adservices.LogUtil;
import com.android.adservices.ServiceBinder;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class AdServicesCommonManager {
    public static final String AD_SERVICES_COMMON_SERVICE = "ad_services_common_service";
    private final Context mContext;
    private final ServiceBinder<IAdServicesCommonService> mAdServicesCommonServiceBinder;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int NOTIFICATION_NONE = 0;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int NOTIFICATION_ONGOING = 1;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int NOTIFICATION_REGULAR = 2;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int USER_CHOICE_UNKNOWN = 0;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int USER_CHOICE_OPTED_IN = 1;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int USER_CHOICE_OPTED_OUT = 2;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int MODULE_STATE_UNKNOWN = 0;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int MODULE_STATE_ENABLED = 1;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int MODULE_STATE_DISABLED = 2;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int MODULE_MEASUREMENT = 0;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int MODULE_PROTECTED_AUDIENCE = 1;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int MODULE_PROTECTED_APP_SIGNALS = 2;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int MODULE_TOPICS = 3;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int MODULE_ON_DEVICE_PERSONALIZATION = 4;
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    public static final int MODULE_ADID = 5;
    @SystemApi
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    @RequiresPermission(anyOf={"android.permission.MODIFY_ADSERVICES_STATE", "android.permission.MODIFY_ADSERVICES_STATE_COMPAT"})
    public static final String ACTION_ADSERVICES_NOTIFICATION_DISPLAYED = "android.adservices.common.action.ADSERVICES_NOTIFICATION_DISPLAYED";
    @SystemApi
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    @RequiresPermission(anyOf={"android.permission.MODIFY_ADSERVICES_STATE", "android.permission.MODIFY_ADSERVICES_STATE_COMPAT"})
    public static final String ACTION_VIEW_ADSERVICES_CONSENT_PAGE = "android.adservices.common.action.VIEW_ADSERVICES_CONSENT_PAGE";

    public static int validateModule(int module) {
        switch (module) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Module:" + module);
            }
        }
        return module;
    }

    public static int validateModuleState(int moduleState) {
        switch (moduleState) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Module State:" + moduleState);
            }
        }
        return moduleState;
    }

    public AdServicesCommonManager(@NonNull Context context) {
        this.mContext = context;
        this.mAdServicesCommonServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.AD_SERVICES_COMMON_SERVICE", IAdServicesCommonService.Stub::asInterface);
    }

    @NonNull
    public static AdServicesCommonManager get(@NonNull Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(AdServicesCommonManager.class) : new AdServicesCommonManager(context);
    }

    @NonNull
    private IAdServicesCommonService getService() {
        IAdServicesCommonService service = this.mAdServicesCommonServiceBinder.getService();
        if (service == null) {
            throw new IllegalStateException("Unable to find the service");
        }
        return service;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.ACCESS_ADSERVICES_STATE", "android.permission.ACCESS_ADSERVICES_STATE_COMPAT"})
    @RequiresApi(value=31)
    public void isAdServicesEnabled(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, Exception> callback) {
        IAdServicesCommonService service = this.getService();
        try {
            service.isAdServicesEnabled(new IAdServicesCommonCallback.Stub(this){

                @Override
                public void onResult(IsAdServicesEnabledResult result) {
                    executor.execute(() -> callback.onResult(result.getAdServicesEnabled()));
                }

                @Override
                public void onFailure(int statusCode) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(statusCode)));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            executor.execute(() -> callback.onError(new IllegalStateException("Internal Error!", e)));
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(anyOf={"android.permission.ACCESS_ADSERVICES_STATE", "android.permission.ACCESS_ADSERVICES_STATE_COMPAT"})
    @FlaggedApi(value="com.android.adservices.flags.adservices_outcomereceiver_r_api_deprecated")
    public void isAdServicesEnabled(@NonNull Executor executor, @NonNull AdServicesOutcomeReceiver<Boolean, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        this.isAdServicesEnabled(executor, OutcomeReceiverConverter.toOutcomeReceiver(callback));
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MODIFY_ADSERVICES_STATE", "android.permission.MODIFY_ADSERVICES_STATE_COMPAT"})
    public void setAdServicesEnabled(boolean adServicesEntryPointEnabled, boolean adIdEnabled) {
        IAdServicesCommonService service = this.getService();
        try {
            service.setAdServicesEnabled(adServicesEntryPointEnabled, adIdEnabled);
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MODIFY_ADSERVICES_STATE", "android.permission.MODIFY_ADSERVICES_STATE_COMPAT"})
    @RequiresApi(value=31)
    public void enableAdServices(@NonNull AdServicesStates adServicesStates, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, Exception> callback) {
        Objects.requireNonNull(adServicesStates);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        IAdServicesCommonService service = this.getService();
        try {
            service.enableAdServices(adServicesStates, new IEnableAdServicesCallback.Stub(this){

                @Override
                public void onResult(EnableAdServicesResponse response) {
                    executor.execute(() -> {
                        if (!response.isApiEnabled()) {
                            callback.onResult(false);
                            return;
                        }
                        if (response.isSuccess()) {
                            callback.onResult(true);
                        } else {
                            callback.onError(AdServicesStatusUtils.asException(response.getStatusCode()));
                        }
                    });
                }

                @Override
                public void onFailure(int statusCode) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(statusCode)));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            executor.execute(() -> callback.onError(new IllegalStateException("Internal Error!", e)));
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    @RequiresPermission(anyOf={"android.permission.MODIFY_ADSERVICES_STATE", "android.permission.MODIFY_ADSERVICES_STATE_COMPAT"})
    public void requestAdServicesModuleOverrides(@NonNull UpdateAdServicesModuleStatesParams updateParams, @NonNull Executor executor, final @NonNull AdServicesOutcomeReceiver<Void, Exception> callback) {
        Objects.requireNonNull(updateParams, "updateParams cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        IAdServicesCommonService service = this.getService();
        try {
            service.requestAdServicesModuleOverrides(updateParams, new IRequestAdServicesModuleOverridesCallback.Stub(this){

                @Override
                public void onSuccess() throws RemoteException {
                    callback.onResult(null);
                }

                @Override
                public void onFailure(int statusCode) throws RemoteException {
                    callback.onError(new IllegalStateException("Internal Error! status code: " + statusCode));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            executor.execute(() -> callback.onError(new IllegalStateException("Internal Error!", e)));
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
    @RequiresPermission(anyOf={"android.permission.MODIFY_ADSERVICES_STATE", "android.permission.MODIFY_ADSERVICES_STATE_COMPAT"})
    public void requestAdServicesModuleUserChoices(@NonNull UpdateAdServicesUserChoicesParams updateParams, @NonNull Executor executor, final @NonNull AdServicesOutcomeReceiver<Void, Exception> callback) {
        Objects.requireNonNull(updateParams, "updateParams cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        IAdServicesCommonService service = this.getService();
        try {
            service.requestAdServicesModuleUserChoices(updateParams, new IRequestAdServicesModuleUserChoicesCallback.Stub(this){

                @Override
                public void onSuccess() throws RemoteException {
                    callback.onResult(null);
                }

                @Override
                public void onFailure(int statusCode) throws RemoteException {
                    callback.onError(new IllegalStateException("Internal Error! status code: " + statusCode));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            executor.execute(() -> callback.onError(new IllegalStateException("Internal Error!", e)));
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(anyOf={"android.permission.MODIFY_ADSERVICES_STATE", "android.permission.MODIFY_ADSERVICES_STATE_COMPAT"})
    @FlaggedApi(value="com.android.adservices.flags.adservices_outcomereceiver_r_api_deprecated")
    public void enableAdServices(@NonNull AdServicesStates adServicesStates, @NonNull Executor executor, @NonNull AdServicesOutcomeReceiver<Boolean, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        this.enableAdServices(adServicesStates, executor, OutcomeReceiverConverter.toOutcomeReceiver(callback));
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(anyOf={"android.permission.UPDATE_PRIVILEGED_AD_ID", "android.permission.UPDATE_PRIVILEGED_AD_ID_COMPAT"})
    @FlaggedApi(value="com.android.adservices.flags.adservices_outcomereceiver_r_api_deprecated")
    public void updateAdId(@NonNull UpdateAdIdRequest updateAdIdRequest, @NonNull Executor executor, @NonNull AdServicesOutcomeReceiver<Boolean, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        this.updateAdId(updateAdIdRequest, executor, OutcomeReceiverConverter.toOutcomeReceiver(callback));
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.UPDATE_PRIVILEGED_AD_ID", "android.permission.UPDATE_PRIVILEGED_AD_ID_COMPAT"})
    @RequiresApi(value=31)
    public void updateAdId(@NonNull UpdateAdIdRequest updateAdIdRequest, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, Exception> callback) {
        Objects.requireNonNull(updateAdIdRequest);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        IAdServicesCommonService service = this.getService();
        try {
            service.updateAdIdCache(updateAdIdRequest, new IUpdateAdIdCallback.Stub(this){

                @Override
                public void onResult(String message) {
                    executor.execute(() -> callback.onResult(true));
                }

                @Override
                public void onFailure(int statusCode) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(statusCode)));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException calling updateAdIdCache with %s", updateAdIdRequest);
            executor.execute(() -> callback.onError(new IllegalStateException("Internal Error!", e)));
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.adservices.flags.get_adservices_common_states_api_enabled")
    @RequiresPermission(anyOf={"android.permission.ACCESS_ADSERVICES_STATE", "android.permission.ACCESS_ADSERVICES_STATE_COMPAT"})
    public void getAdservicesCommonStates(final @NonNull Executor executor, final @NonNull AdServicesOutcomeReceiver<AdServicesCommonStatesResponse, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        IAdServicesCommonService service = this.getService();
        CallerMetadata callerMetadata = new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build();
        String appPackageName = "";
        String sdkPackageName = "";
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        if (sandboxedSdkContext != null) {
            sdkPackageName = sandboxedSdkContext.getSdkPackageName();
            appPackageName = sandboxedSdkContext.getClientPackageName();
        } else {
            appPackageName = this.mContext.getPackageName();
        }
        try {
            service.getAdServicesCommonStates(new GetAdServicesCommonStatesParams.Builder(appPackageName, sdkPackageName).build(), callerMetadata, new IAdServicesCommonStatesCallback.Stub(this){

                @Override
                public void onResult(AdServicesCommonStatesResponse result) {
                    executor.execute(() -> callback.onResult(result));
                }

                @Override
                public void onFailure(int statusCode) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(statusCode)));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            executor.execute(() -> callback.onError(new IllegalStateException("Internal Error!", e)));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Module {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ModuleState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ModuleUserChoice {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NotificationType {
    }
}

