/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@FlaggedApi(value="com.android.adservices.flags.fledge_enable_custom_audience_component_ads")
public class ComponentAdData
implements Parcelable {
    private final Uri mRenderUri;
    private final String mAdRenderId;
    @NonNull
    public static final Parcelable.Creator<ComponentAdData> CREATOR = new Parcelable.Creator<ComponentAdData>(){

        @Override
        public ComponentAdData createFromParcel(@NonNull Parcel in) {
            return new ComponentAdData(in);
        }

        public ComponentAdData[] newArray(int size) {
            return new ComponentAdData[size];
        }
    };

    private ComponentAdData(@NonNull Parcel in) {
        this.mRenderUri = Uri.CREATOR.createFromParcel(in);
        this.mAdRenderId = in.readString();
    }

    public ComponentAdData(@NonNull Uri renderUri, @NonNull String adRenderId) {
        if (adRenderId.isEmpty()) {
            throw new IllegalArgumentException("Ad render id cannot be empty");
        }
        this.mRenderUri = Objects.requireNonNull(renderUri, "Provided render uri is null");
        this.mAdRenderId = Objects.requireNonNull(adRenderId, "Provided ad render id is null");
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mRenderUri.writeToParcel(dest, flags);
        dest.writeString(this.mAdRenderId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public Uri getRenderUri() {
        return this.mRenderUri;
    }

    @NonNull
    public String getAdRenderId() {
        return this.mAdRenderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentAdData)) {
            return false;
        }
        ComponentAdData adData = (ComponentAdData)o;
        return ((Object)this.mRenderUri).equals(adData.mRenderUri) && Objects.equals(this.mAdRenderId, adData.mAdRenderId);
    }

    public int hashCode() {
        return Objects.hash(this.mRenderUri, this.mAdRenderId);
    }

    public String toString() {
        return "ComponentAdData{mRenderUri=" + this.mRenderUri + ", mAdRenderId='" + this.mAdRenderId + '\'' + '}';
    }
}

