/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.topics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import java.util.Arrays;
import java.util.Objects;

@FlaggedApi(value="com.android.adservices.flags.topics_encryption_enabled")
public class EncryptedTopic {
    @NonNull
    private final byte[] mEncryptedTopic;
    @NonNull
    private final String mKeyIdentifier;
    @NonNull
    private final byte[] mEncapsulatedKey;

    public EncryptedTopic(@NonNull byte[] encryptedTopic, @NonNull String keyIdentifier, @NonNull byte[] encapsulatedKey) {
        this.mEncryptedTopic = Objects.requireNonNull(encryptedTopic);
        this.mKeyIdentifier = Objects.requireNonNull(keyIdentifier);
        this.mEncapsulatedKey = Objects.requireNonNull(encapsulatedKey);
    }

    @NonNull
    public byte[] getEncryptedTopic() {
        return this.mEncryptedTopic;
    }

    @NonNull
    public String getKeyIdentifier() {
        return this.mKeyIdentifier;
    }

    @NonNull
    public byte[] getEncapsulatedKey() {
        return this.mEncapsulatedKey;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EncryptedTopic)) {
            return false;
        }
        EncryptedTopic encryptedTopic = (EncryptedTopic)object;
        return Arrays.equals(this.getEncryptedTopic(), encryptedTopic.getEncryptedTopic()) && this.getKeyIdentifier().equals(encryptedTopic.getKeyIdentifier()) && Arrays.equals(this.getEncapsulatedKey(), encryptedTopic.getEncapsulatedKey());
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.getEncryptedTopic()), this.getKeyIdentifier(), Arrays.hashCode(this.getEncapsulatedKey()));
    }

    public String toString() {
        return "EncryptedTopic{mEncryptedTopic=" + Arrays.toString(this.mEncryptedTopic) + ", mKeyIdentifier=" + this.mKeyIdentifier + ", mEncapsulatedKey=" + Arrays.toString(this.mEncapsulatedKey) + '}';
    }
}

