/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.topics;

import android.adservices.common.AdServicesResponse;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GetTopicsResult
extends AdServicesResponse {
    private final List<Long> mTaxonomyVersions;
    private final List<Long> mModelVersions;
    private final List<Integer> mTopics;
    private final List<byte[]> mEncryptedTopics;
    private final List<String> mEncryptionKeys;
    private final List<byte[]> mEncapsulatedKeys;
    @NonNull
    public static final Parcelable.Creator<GetTopicsResult> CREATOR = new Parcelable.Creator<GetTopicsResult>(){

        @Override
        public GetTopicsResult createFromParcel(Parcel in) {
            return new GetTopicsResult(in);
        }

        public GetTopicsResult[] newArray(int size) {
            return new GetTopicsResult[size];
        }
    };

    private GetTopicsResult(int resultCode, String errorMessage, List<Long> taxonomyVersions, List<Long> modelVersions, List<Integer> topics, List<byte[]> encryptedTopics, List<String> encryptionKeys, List<byte[]> encapsulatedKeys) {
        super(resultCode, errorMessage);
        this.mTaxonomyVersions = taxonomyVersions;
        this.mModelVersions = modelVersions;
        this.mTopics = topics;
        this.mEncryptedTopics = encryptedTopics;
        this.mEncryptionKeys = encryptionKeys;
        this.mEncapsulatedKeys = encapsulatedKeys;
    }

    private GetTopicsResult(@NonNull Parcel in) {
        super(in.readInt(), in.readString());
        this.mTaxonomyVersions = Collections.unmodifiableList(GetTopicsResult.readLongList(in));
        this.mModelVersions = Collections.unmodifiableList(GetTopicsResult.readLongList(in));
        this.mTopics = Collections.unmodifiableList(GetTopicsResult.readIntegerList(in));
        this.mEncryptedTopics = Collections.unmodifiableList(GetTopicsResult.readByteArrayList(in));
        this.mEncryptionKeys = Collections.unmodifiableList(GetTopicsResult.readStringList(in));
        this.mEncapsulatedKeys = Collections.unmodifiableList(GetTopicsResult.readByteArrayList(in));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mStatusCode);
        out.writeString(this.mErrorMessage);
        GetTopicsResult.writeLongList(out, this.mTaxonomyVersions);
        GetTopicsResult.writeLongList(out, this.mModelVersions);
        GetTopicsResult.writeIntegerList(out, this.mTopics);
        GetTopicsResult.writeByteArrayList(out, this.mEncryptedTopics);
        GetTopicsResult.writeStringList(out, this.mEncryptionKeys);
        GetTopicsResult.writeByteArrayList(out, this.mEncapsulatedKeys);
    }

    @Override
    public boolean isSuccess() {
        return this.getResultCode() == 0;
    }

    public int getResultCode() {
        return this.mStatusCode;
    }

    @Override
    @Nullable
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public List<Long> getTaxonomyVersions() {
        return this.mTaxonomyVersions;
    }

    public List<Long> getModelVersions() {
        return this.mModelVersions;
    }

    @NonNull
    public List<Integer> getTopics() {
        return this.mTopics;
    }

    @NonNull
    public List<byte[]> getEncryptedTopics() {
        return this.mEncryptedTopics;
    }

    @NonNull
    public List<String> getEncryptionKeys() {
        return this.mEncryptionKeys;
    }

    @NonNull
    public List<byte[]> getEncapsulatedKeys() {
        return this.mEncapsulatedKeys;
    }

    public String toString() {
        return "GetTopicsResult{mResultCode=" + this.mStatusCode + ", mErrorMessage='" + this.mErrorMessage + '\'' + ", mTaxonomyVersions=" + this.mTaxonomyVersions + ", mModelVersions=" + this.mModelVersions + ", mTopics=" + this.mTopics + ", mEncryptedTopics=" + this.prettyPrint(this.mEncryptedTopics) + ", mEncryptionKeys=" + this.mEncryptionKeys + ", mEncapsulatedKeys=" + this.prettyPrint(this.mEncapsulatedKeys) + '}';
    }

    private String prettyPrint(List<byte[]> listOfByteArrays) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int index = 0; index < listOfByteArrays.size(); ++index) {
            stringBuilder.append(Arrays.toString(listOfByteArrays.get(index)));
            if (index == listOfByteArrays.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTopicsResult)) {
            return false;
        }
        GetTopicsResult that = (GetTopicsResult)o;
        return this.mStatusCode == that.mStatusCode && Objects.equals(this.mErrorMessage, that.mErrorMessage) && this.mTaxonomyVersions.equals(that.mTaxonomyVersions) && this.mModelVersions.equals(that.mModelVersions) && this.mTopics.equals(that.mTopics) && GetTopicsResult.equals(this.mEncryptedTopics, that.mEncryptedTopics) && this.mEncryptionKeys.equals(that.mEncryptionKeys);
    }

    private static boolean equals(List<byte[]> list1, List<byte[]> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (Arrays.equals(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.mStatusCode, this.mErrorMessage, this.mTaxonomyVersions, this.mModelVersions, this.mTopics, GetTopicsResult.hashCode(this.mEncryptedTopics), this.mEncryptionKeys, GetTopicsResult.hashCode(this.mEncryptedTopics));
    }

    private static int hashCode(List<byte[]> list) {
        int hash = 0;
        for (byte[] bytes : list) {
            hash += Arrays.hashCode(bytes);
        }
        return hash;
    }

    private static List<Long> readLongList(@NonNull Parcel in) {
        ArrayList<Long> list = new ArrayList<Long>();
        int toReadCount = in.readInt();
        for (int i = 0; i < toReadCount; ++i) {
            list.add(in.readLong());
        }
        return list;
    }

    private static List<Integer> readIntegerList(@NonNull Parcel in) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int toReadCount = in.readInt();
        for (int i = 0; i < toReadCount; ++i) {
            list.add(in.readInt());
        }
        return list;
    }

    private static List<String> readStringList(@NonNull Parcel in) {
        ArrayList<String> list = new ArrayList<String>();
        int toReadCount = in.readInt();
        for (int i = 0; i < toReadCount; ++i) {
            list.add(in.readString());
        }
        return list;
    }

    private static List<byte[]> readByteArrayList(@NonNull Parcel in) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int toReadCount = in.readInt();
        for (int i = 0; i < toReadCount; ++i) {
            list.add(in.createByteArray());
        }
        return list;
    }

    private static void writeLongList(@NonNull Parcel out, @Nullable List<Long> val) {
        if (val == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(val.size());
        for (Long l : val) {
            out.writeLong(l);
        }
    }

    private static void writeIntegerList(@NonNull Parcel out, @Nullable List<Integer> val) {
        if (val == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(val.size());
        for (Integer integer2 : val) {
            out.writeInt(integer2);
        }
    }

    private static void writeStringList(@NonNull Parcel out, @Nullable List<String> val) {
        if (val == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(val.size());
        for (String string2 : val) {
            out.writeString(string2);
        }
    }

    private static void writeByteArrayList(@NonNull Parcel out, @Nullable List<byte[]> val) {
        if (val == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(val.size());
        for (byte[] bytes : val) {
            out.writeByteArray(bytes);
        }
    }

    public static class Builder {
        private int mResultCode;
        private String mErrorMessage;
        private List<Long> mTaxonomyVersions = new ArrayList<Long>();
        private List<Long> mModelVersions = new ArrayList<Long>();
        private List<Integer> mTopics = new ArrayList<Integer>();
        private List<byte[]> mEncryptedTopics = new ArrayList<byte[]>();
        private List<String> mEncryptionKeys = new ArrayList<String>();
        private List<byte[]> mEncapsulatedKeys = new ArrayList<byte[]>();

        @NonNull
        public Builder setResultCode(int resultCode) {
            this.mResultCode = resultCode;
            return this;
        }

        @NonNull
        public Builder setErrorMessage(@Nullable String errorMessage) {
            this.mErrorMessage = errorMessage;
            return this;
        }

        @NonNull
        public Builder setTaxonomyVersions(@NonNull List<Long> taxonomyVersions) {
            this.mTaxonomyVersions = taxonomyVersions;
            return this;
        }

        @NonNull
        public Builder setModelVersions(@NonNull List<Long> modelVersions) {
            this.mModelVersions = modelVersions;
            return this;
        }

        @NonNull
        public Builder setTopics(@NonNull List<Integer> topics) {
            this.mTopics = topics;
            return this;
        }

        @NonNull
        public Builder setEncryptedTopics(@NonNull List<byte[]> encryptedTopics) {
            this.mEncryptedTopics = encryptedTopics;
            return this;
        }

        @NonNull
        public Builder setEncryptionKeys(@NonNull List<String> encryptionKeys) {
            this.mEncryptionKeys = encryptionKeys;
            return this;
        }

        @NonNull
        public Builder setEncapsulatedKeys(@NonNull List<byte[]> encapsulatedKeys) {
            this.mEncapsulatedKeys = encapsulatedKeys;
            return this;
        }

        @NonNull
        public GetTopicsResult build() {
            if (this.mTopics == null || this.mTaxonomyVersions == null || this.mModelVersions == null || this.mEncryptedTopics == null || this.mEncryptionKeys == null) {
                throw new IllegalArgumentException("One of the mandatory params of GetTopicsResult is null");
            }
            if (this.mTopics.size() != this.mTaxonomyVersions.size() || this.mTopics.size() != this.mModelVersions.size()) {
                throw new IllegalArgumentException("Size mismatch in Topics");
            }
            if (this.mEncryptedTopics.size() != this.mEncryptionKeys.size() || this.mEncryptedTopics.size() != this.mEncapsulatedKeys.size()) {
                throw new IllegalArgumentException("Size mismatch in EncryptedTopic lists");
            }
            return new GetTopicsResult(this.mResultCode, this.mErrorMessage, this.mTaxonomyVersions, this.mModelVersions, this.mTopics, this.mEncryptedTopics, this.mEncryptionKeys, this.mEncapsulatedKeys);
        }
    }
}

