/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.AnimationHandler;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.ConstantState;
import android.os.Trace;
import android.util.LongArray;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Animator
implements Cloneable {
    public static final long DURATION_INFINITE = -1L;
    ArrayList<AnimatorListener> mListeners = null;
    ArrayList<AnimatorPauseListener> mPauseListeners = null;
    boolean mPaused = false;
    int mChangingConfigurations = 0;
    private AnimatorConstantState mConstantState;
    private static long sBackgroundPauseDelay = 1000L;
    static boolean sPostNotifyEndListenerEnabled;
    private Runnable mPendingEndCallback;
    private AtomicReference<Object[]> mCachedList = new AtomicReference();
    boolean mStartListenersCalled = false;

    public static void setBackgroundPauseDelay(long value) {
        sBackgroundPauseDelay = value;
    }

    public static long getBackgroundPauseDelay() {
        return sBackgroundPauseDelay;
    }

    public static void setAnimatorPausingEnabled(boolean enable) {
        AnimationHandler.setAnimatorPausingEnabled(enable);
        AnimationHandler.setOverrideAnimatorPausingSystemProperty(!enable);
    }

    public static void setPostNotifyEndListenerEnabled(boolean enable) {
        sPostNotifyEndListenerEnabled = enable;
    }

    public static boolean isPostNotifyEndListenerEnabled() {
        return sPostNotifyEndListenerEnabled;
    }

    public void start() {
    }

    public void cancel() {
    }

    public void end() {
    }

    public void pause() {
        if ((this.isStarted() || this.mStartListenersCalled) && !this.mPaused) {
            this.mPaused = true;
            this.notifyPauseListeners(AnimatorCaller.ON_PAUSE);
        }
    }

    public void resume() {
        if (this.mPaused) {
            this.mPaused = false;
            this.notifyPauseListeners(AnimatorCaller.ON_RESUME);
        }
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    public abstract long getStartDelay();

    public abstract void setStartDelay(long var1);

    public abstract Animator setDuration(long var1);

    public abstract long getDuration();

    public long getTotalDuration() {
        long duration = this.getDuration();
        if (duration == -1L) {
            return -1L;
        }
        return this.getStartDelay() + duration;
    }

    public abstract void setInterpolator(TimeInterpolator var1);

    public TimeInterpolator getInterpolator() {
        return null;
    }

    public abstract boolean isRunning();

    public boolean isStarted() {
        return this.isRunning();
    }

    public void addListener(AnimatorListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
    }

    public void removeListener(AnimatorListener listener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
    }

    public ArrayList<AnimatorListener> getListeners() {
        return this.mListeners;
    }

    public void addPauseListener(AnimatorPauseListener listener) {
        if (this.mPauseListeners == null) {
            this.mPauseListeners = new ArrayList();
        }
        this.mPauseListeners.add(listener);
    }

    public void removePauseListener(AnimatorPauseListener listener) {
        if (this.mPauseListeners == null) {
            return;
        }
        this.mPauseListeners.remove(listener);
        if (this.mPauseListeners.size() == 0) {
            this.mPauseListeners = null;
        }
    }

    public void removeAllListeners() {
        if (this.mListeners != null) {
            this.mListeners.clear();
            this.mListeners = null;
        }
        if (this.mPauseListeners != null) {
            this.mPauseListeners.clear();
            this.mPauseListeners = null;
        }
    }

    public int getChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    public void setChangingConfigurations(int configs) {
        this.mChangingConfigurations = configs;
    }

    public void appendChangingConfigurations(int configs) {
        this.mChangingConfigurations |= configs;
    }

    public ConstantState<Animator> createConstantState() {
        return new AnimatorConstantState(this);
    }

    public Animator clone() {
        try {
            Animator anim2 = (Animator)super.clone();
            if (this.mListeners != null) {
                anim2.mListeners = new ArrayList<AnimatorListener>(this.mListeners);
            }
            if (this.mPauseListeners != null) {
                anim2.mPauseListeners = new ArrayList<AnimatorPauseListener>(this.mPauseListeners);
            }
            anim2.mCachedList.set(null);
            anim2.mStartListenersCalled = false;
            return anim2;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public void setupStartValues() {
    }

    public void setupEndValues() {
    }

    public void setTarget(@Nullable Object target) {
    }

    public boolean canReverse() {
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void reverse() {
        throw new IllegalStateException("Reverse is not supported");
    }

    boolean pulseAnimationFrame(long frameTime) {
        return false;
    }

    void startWithoutPulsing(boolean inReverse) {
        if (inReverse) {
            this.reverse();
        } else {
            this.start();
        }
    }

    void skipToEndValue(boolean inReverse) {
    }

    boolean isInitialized() {
        return true;
    }

    void animateValuesInRange(long currentPlayTime, long lastPlayTime) {
    }

    void animateSkipToEnds(long currentPlayTime, long lastPlayTime) {
    }

    void getStartAndEndTimes(LongArray times, long offset) {
        long endTime;
        long duration;
        long startTime = offset + this.getStartDelay();
        if (times.indexOf(startTime) < 0) {
            times.add(startTime);
        }
        if ((duration = this.getTotalDuration()) != -1L && times.indexOf(endTime = duration + offset) < 0) {
            times.add(endTime);
        }
    }

    void notifyListeners(AnimatorCaller<AnimatorListener, Animator> notification, boolean isReverse) {
        this.callOnList(this.mListeners, notification, this, isReverse);
    }

    void notifyPauseListeners(AnimatorCaller<AnimatorPauseListener, Animator> notification) {
        this.callOnList(this.mPauseListeners, notification, this, false);
    }

    void notifyStartListeners(boolean isReversing) {
        boolean startListenersCalled = this.mStartListenersCalled;
        this.mStartListenersCalled = true;
        if (this.mListeners != null && !startListenersCalled) {
            this.notifyListeners(AnimatorCaller.ON_START, isReversing);
        }
    }

    void notifyEndListeners(boolean isReversing) {
        boolean startListenersCalled = this.mStartListenersCalled;
        this.mStartListenersCalled = false;
        if (this.mListeners != null && startListenersCalled) {
            this.notifyListeners(AnimatorCaller.ON_END, isReversing);
        }
    }

    boolean consumePendingEndListeners(boolean notifyListeners) {
        if (this.mPendingEndCallback == null) {
            return false;
        }
        AnimationHandler.getInstance().removePendingEndAnimationCallback(this.mPendingEndCallback);
        this.mPendingEndCallback = null;
        if (notifyListeners) {
            this.notifyEndListeners(false);
        }
        return true;
    }

    void notifyEndListenersFromEndAnimation(boolean isReversing, boolean postNotifyEndListener) {
        if (postNotifyEndListener) {
            this.mPendingEndCallback = () -> {
                this.completeEndAnimation(isReversing, "postNotifyAnimEnd");
                this.mPendingEndCallback = null;
            };
            AnimationHandler.getInstance().postEndAnimationCallback(this.mPendingEndCallback);
        } else {
            this.completeEndAnimation(isReversing, "notifyAnimEnd");
        }
    }

    void completeEndAnimation(boolean isReversing, String notifyListenerTraceName) {
        boolean useTrace;
        boolean bl = useTrace = this.mListeners != null && Trace.isTagEnabled(8L);
        if (useTrace) {
            Trace.traceBegin(8L, notifyListenerTraceName + "-" + this.getClass().getSimpleName());
        }
        this.notifyEndListeners(isReversing);
        if (useTrace) {
            Trace.traceEnd(8L);
        }
    }

    <T, A> void callOnList(ArrayList<T> list, AnimatorCaller<T, A> call, A animator2, boolean isReverse) {
        int size;
        int n = size = list == null ? 0 : list.size();
        if (size > 0) {
            Object[] array2 = this.mCachedList.getAndSet(null);
            if (array2 == null || array2.length < size) {
                array2 = new Object[size];
            }
            list.toArray(array2);
            for (int i = 0; i < size; ++i) {
                Object item = array2[i];
                call.call(item, animator2, isReverse);
                array2[i] = null;
            }
            this.mCachedList.compareAndSet(null, array2);
        }
    }

    public void setAllowRunningAsynchronously(boolean mayRunAsync) {
    }

    static interface AnimatorCaller<T, A> {
        public static final AnimatorCaller<AnimatorListener, Animator> ON_START = AnimatorListener::onAnimationStart;
        public static final AnimatorCaller<AnimatorListener, Animator> ON_END = AnimatorListener::onAnimationEnd;
        public static final AnimatorCaller<AnimatorListener, Animator> ON_CANCEL = (listener, animator2, isReverse) -> listener.onAnimationCancel((Animator)animator2);
        public static final AnimatorCaller<AnimatorListener, Animator> ON_REPEAT = (listener, animator2, isReverse) -> listener.onAnimationRepeat((Animator)animator2);
        public static final AnimatorCaller<AnimatorPauseListener, Animator> ON_PAUSE = (listener, animator2, isReverse) -> listener.onAnimationPause((Animator)animator2);
        public static final AnimatorCaller<AnimatorPauseListener, Animator> ON_RESUME = (listener, animator2, isReverse) -> listener.onAnimationResume((Animator)animator2);
        public static final AnimatorCaller<ValueAnimator.AnimatorUpdateListener, ValueAnimator> ON_UPDATE = (listener, animator2, isReverse) -> listener.onAnimationUpdate((ValueAnimator)animator2);

        public void call(T var1, A var2, boolean var3);
    }

    private static class AnimatorConstantState
    extends ConstantState<Animator> {
        final Animator mAnimator;
        int mChangingConf;

        public AnimatorConstantState(Animator animator2) {
            this.mAnimator = animator2;
            this.mAnimator.mConstantState = this;
            this.mChangingConf = this.mAnimator.getChangingConfigurations();
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConf;
        }

        @Override
        public Animator newInstance() {
            Animator clone = this.mAnimator.clone();
            clone.mConstantState = this;
            return clone;
        }
    }

    public static interface AnimatorPauseListener {
        public void onAnimationPause(@NonNull Animator var1);

        public void onAnimationResume(@NonNull Animator var1);
    }

    public static interface AnimatorListener {
        default public void onAnimationStart(@NonNull Animator animation, boolean isReverse) {
            this.onAnimationStart(animation);
        }

        default public void onAnimationEnd(@NonNull Animator animation, boolean isReverse) {
            this.onAnimationEnd(animation);
        }

        public void onAnimationStart(@NonNull Animator var1);

        public void onAnimationEnd(@NonNull Animator var1);

        public void onAnimationCancel(@NonNull Animator var1);

        public void onAnimationRepeat(@NonNull Animator var1);
    }
}

