/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActionBar;
import android.app.ActivityClient;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.ActivityTaskManager;
import android.app.ActivityThread;
import android.app.ActivityTransitionState;
import android.app.AlertDialog;
import android.app.Application;
import android.app.ComponentCaller;
import android.app.Dialog;
import android.app.DirectAction;
import android.app.EventLogTags;
import android.app.Fragment;
import android.app.FragmentController;
import android.app.FragmentHostCallback;
import android.app.FragmentManager;
import android.app.FragmentManagerNonConfig;
import android.app.FullscreenRequestHandler;
import android.app.IRequestFinishCallback;
import android.app.Instrumentation;
import android.app.LoaderManager;
import android.app.PendingIntent;
import android.app.PictureInPictureParams;
import android.app.PictureInPictureUiState;
import android.app.ResourcesManager;
import android.app.ScreenCaptureCallbackHandler;
import android.app.SearchManager;
import android.app.SharedElementCallback;
import android.app.TaskStackBuilder;
import android.app.VoiceInteractor;
import android.app.WindowConfiguration;
import android.app.assist.AssistContent;
import android.app.compat.CompatChanges;
import android.app.jank.Flags;
import android.app.jank.JankTracker;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.ComponentCallbacksController;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.LocusId;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.media.session.MediaController;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.GraphicsEnvironment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.OutcomeReceiver;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.text.Selection;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.TextKeyListener;
import android.transition.Scene;
import android.transition.TransitionManager;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Dumpable;
import android.util.EventLog;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.util.SparseArray;
import android.util.SuperNotCalledException;
import android.view.ActionMode;
import android.view.Choreographer;
import android.view.ContextMenu;
import android.view.ContextThemeWrapper;
import android.view.DragAndDropPermissions;
import android.view.DragEvent;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.KeyboardShortcutInfo;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.RemoteAnimationDefinition;
import android.view.SearchEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.accessibility.AccessibilityEvent;
import android.view.autofill.AutofillClientController;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.ContentCaptureManager;
import android.view.translation.TranslationSpec;
import android.view.translation.UiTranslationController;
import android.view.translation.UiTranslationSpec;
import android.widget.Toast;
import android.widget.Toolbar;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedDispatcher;
import android.window.SplashScreen;
import android.window.WindowOnBackInvokedDispatcher;
import com.android.internal.R;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IVoiceInteractionManagerService;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.app.ToolbarActionBar;
import com.android.internal.app.WindowDecorActionBar;
import com.android.internal.policy.DecorView;
import com.android.internal.policy.PhoneWindow;
import com.android.internal.util.dump.DumpableContainerImpl;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class Activity
extends ContextThemeWrapper
implements LayoutInflater.Factory2,
Window.Callback,
KeyEvent.Callback,
View.OnCreateContextMenuListener,
ComponentCallbacks2,
Window.OnWindowDismissedCallback,
ContentCaptureManager.ContentCaptureClient {
    private static final String TAG = "Activity";
    private static final boolean DEBUG_LIFECYCLE = false;
    public static final int RESULT_CANCELED = 0;
    public static final int RESULT_OK = -1;
    public static final int RESULT_FIRST_USER = 1;
    public static final int DONT_FINISH_TASK_WITH_ACTIVITY = 0;
    public static final int FINISH_TASK_WITH_ROOT_ACTIVITY = 1;
    public static final int FINISH_TASK_WITH_ACTIVITY = 2;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    static final String FRAGMENTS_TAG = "android:fragments";
    private static final String WINDOW_HIERARCHY_TAG = "android:viewHierarchyState";
    private static final String SAVED_DIALOG_IDS_KEY = "android:savedDialogIds";
    private static final String SAVED_DIALOGS_TAG = "android:savedDialogs";
    private static final String SAVED_DIALOG_KEY_PREFIX = "android:dialog_";
    private static final String SAVED_DIALOG_ARGS_KEY_PREFIX = "android:dialog_args_";
    private static final String HAS_CURRENT_PERMISSIONS_REQUEST_KEY = "android:hasCurrentPermissionsRequest";
    private static final String REQUEST_PERMISSIONS_WHO_PREFIX = "@android:requestPermissions:";
    private static final String KEYBOARD_SHORTCUTS_RECEIVER_PKG_NAME = "com.android.systemui";
    private static final int LOG_AM_ON_CREATE_CALLED = 30057;
    private static final int LOG_AM_ON_START_CALLED = 30059;
    private static final int LOG_AM_ON_RESUME_CALLED = 30022;
    private static final int LOG_AM_ON_PAUSE_CALLED = 30021;
    private static final int LOG_AM_ON_STOP_CALLED = 30049;
    private static final int LOG_AM_ON_RESTART_CALLED = 30058;
    private static final int LOG_AM_ON_DESTROY_CALLED = 30060;
    private static final int LOG_AM_ON_ACTIVITY_RESULT_CALLED = 30062;
    private static final int LOG_AM_ON_TOP_RESUMED_GAINED_CALLED = 30064;
    private static final int LOG_AM_ON_TOP_RESUMED_LOST_CALLED = 30065;
    private OnBackInvokedCallback mDefaultBackCallback;
    @VisibleForTesting
    private static final long DUMP_IGNORES_SPECIAL_ARGS = 149254050L;
    public static final String DUMP_ARG_AUTOFILL = "--autofill";
    public static final String DUMP_ARG_CONTENT_CAPTURE = "--contentcapture";
    public static final String DUMP_ARG_TRANSLATION = "--translation";
    public static final String DUMP_ARG_LIST_DUMPABLES = "--list-dumpables";
    public static final String DUMP_ARG_DUMP_DUMPABLE = "--dump-dumpable";
    private SparseArray<ManagedDialog> mManagedDialogs;
    @UnsupportedAppUsage
    private Instrumentation mInstrumentation;
    @UnsupportedAppUsage
    private IBinder mToken;
    private IBinder mAssistToken;
    private IBinder mShareableActivityToken;
    private ComponentCaller mInitialCaller;
    private ComponentCaller mCaller;
    private ComponentCaller mCurrentCaller;
    @UnsupportedAppUsage
    private int mIdent;
    @UnsupportedAppUsage
    String mEmbeddedID;
    @UnsupportedAppUsage
    private Application mApplication;
    @UnsupportedAppUsage
    Intent mIntent;
    @UnsupportedAppUsage
    String mReferrer;
    @UnsupportedAppUsage
    private ComponentName mComponent;
    @UnsupportedAppUsage
    ActivityInfo mActivityInfo;
    @UnsupportedAppUsage
    ActivityThread mMainThread;
    @UnsupportedAppUsage(trackingBug=137825207L, maxTargetSdk=29, publicAlternatives="Use {@code androidx.fragment.app.Fragment} and {@code androidx.fragment.app.FragmentManager} instead")
    Activity mParent;
    @UnsupportedAppUsage
    boolean mCalled;
    @UnsupportedAppUsage
    boolean mResumed;
    @UnsupportedAppUsage
    boolean mStopped;
    @UnsupportedAppUsage
    boolean mFinished;
    boolean mStartedActivity;
    @UnsupportedAppUsage
    private boolean mDestroyed;
    private boolean mDoReportFullyDrawn = true;
    private boolean mRestoredFromBundle;
    private boolean mCanEnterPictureInPicture = false;
    boolean mChangingConfigurations = false;
    @UnsupportedAppUsage
    int mConfigChangeFlags;
    @UnsupportedAppUsage
    Configuration mCurrentConfig = Configuration.EMPTY;
    private SearchManager mSearchManager;
    private MenuInflater mMenuInflater;
    @Nullable
    private ContentCaptureManager mContentCaptureManager;
    private final ArrayList<Application.ActivityLifecycleCallbacks> mActivityLifecycleCallbacks = new ArrayList();
    @UnsupportedAppUsage
    NonConfigurationInstances mLastNonConfigurationInstances;
    @UnsupportedAppUsage
    private Window mWindow;
    @UnsupportedAppUsage
    private WindowManager mWindowManager;
    View mDecor = null;
    @UnsupportedAppUsage
    boolean mWindowAdded = false;
    boolean mVisibleFromServer = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    boolean mVisibleFromClient = true;
    ActionBar mActionBar = null;
    private boolean mEnableDefaultActionBarUp;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    VoiceInteractor mVoiceInteractor;
    @UnsupportedAppUsage
    private CharSequence mTitle;
    private int mTitleColor = 0;
    @UnsupportedAppUsage
    final Handler mHandler = new Handler();
    @UnsupportedAppUsage
    final FragmentController mFragments = FragmentController.createController(new HostCallbacks());
    ActivityOptions.SceneTransitionInfo mSceneTransitionInfo;
    boolean mLaunchedFromBubble;
    @GuardedBy(value={"mManagedCursors"})
    private final ArrayList<ManagedCursor> mManagedCursors = new ArrayList();
    @GuardedBy(value={"this"})
    @UnsupportedAppUsage
    int mResultCode = 0;
    @GuardedBy(value={"this"})
    @UnsupportedAppUsage
    Intent mResultData = null;
    private TranslucentConversionListener mTranslucentCallback;
    private boolean mChangeCanvasToTranslucent;
    private SearchEvent mSearchEvent;
    private boolean mTitleReady = false;
    private int mActionModeTypeStarting = 0;
    private int mDefaultKeyMode = 0;
    private SpannableStringBuilder mDefaultKeySsb = null;
    private final ActivityManager.TaskDescription mTaskDescription = new ActivityManager.TaskDescription();
    private int mLastTaskDescriptionHashCode;
    private int mLastRequestedOrientation = -2;
    protected static final int[] FOCUSED_STATE_SET = new int[]{16842908};
    private final Object mInstanceTracker = StrictMode.trackActivity(this);
    private Thread mUiThread;
    @UnsupportedAppUsage
    final ActivityTransitionState mActivityTransitionState = new ActivityTransitionState();
    SharedElementCallback mEnterTransitionListener = SharedElementCallback.NULL_CALLBACK;
    SharedElementCallback mExitTransitionListener = SharedElementCallback.NULL_CALLBACK;
    private boolean mHasCurrentPermissionsRequest;
    private AutofillClientController mAutofillClientController;
    private boolean mIsInMultiWindowMode;
    boolean mIsInPictureInPictureMode;
    public static final int FULLSCREEN_MODE_REQUEST_EXIT = 0;
    public static final int FULLSCREEN_MODE_REQUEST_ENTER = 1;
    public static final int OVERRIDE_TRANSITION_OPEN = 0;
    public static final int OVERRIDE_TRANSITION_CLOSE = 1;
    private boolean mShouldDockBigOverlays;
    private UiTranslationController mUiTranslationController;
    private SplashScreen mSplashScreen;
    @Nullable
    private DumpableContainerImpl mDumpableContainer;
    private ComponentCallbacksController mCallbacksController;
    @Nullable
    private IVoiceInteractionManagerService mVoiceInteractionManagerService;
    private ScreenCaptureCallbackHandler mScreenCaptureCallbackHandler;
    private final Window.WindowControllerCallback mWindowControllerCallback = new Window.WindowControllerCallback(){

        @Override
        public void toggleFreeformWindowingMode() {
            ActivityClient.getInstance().toggleFreeformWindowingMode(Activity.this.mToken);
        }

        @Override
        public void enterPictureInPictureModeIfPossible() {
            if (Activity.this.mActivityInfo.supportsPictureInPicture()) {
                Activity.this.enterPictureInPictureMode();
            }
        }

        @Override
        public boolean isTaskRoot() {
            return ActivityClient.getInstance().getTaskForActivity(Activity.this.mToken, true) >= 0;
        }

        @Override
        public void updateStatusBarColor(int color2) {
            Activity.this.mTaskDescription.setStatusBarColor(color2);
            Activity.this.setTaskDescription(Activity.this.mTaskDescription);
        }

        @Override
        public void updateSystemBarsAppearance(int appearance) {
            Activity.this.mTaskDescription.setSystemBarsAppearance(appearance);
            Activity.this.setTaskDescription(Activity.this.mTaskDescription);
        }

        @Override
        public void updateNavigationBarColor(int color2) {
            Activity.this.mTaskDescription.setNavigationBarColor(color2);
            Activity.this.setTaskDescription(Activity.this.mTaskDescription);
        }
    };
    @Nullable
    private JankTracker mJankTracker;
    private static final int CONTENT_CAPTURE_START = 1;
    private static final int CONTENT_CAPTURE_RESUME = 2;
    private static final int CONTENT_CAPTURE_PAUSE = 3;
    private static final int CONTENT_CAPTURE_STOP = 4;
    public static final int DEFAULT_KEYS_DISABLE = 0;
    public static final int DEFAULT_KEYS_DIALER = 1;
    public static final int DEFAULT_KEYS_SHORTCUT = 2;
    public static final int DEFAULT_KEYS_SEARCH_LOCAL = 3;
    public static final int DEFAULT_KEYS_SEARCH_GLOBAL = 4;

    private static String getDlWarning() {
        return (String)OverrideMethod.invokeA("android.app.Activity#getDlWarning()Ljava/lang/String;", true, null);
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public void setIntent(Intent newIntent) {
        this.internalSetIntent(newIntent, null);
    }

    @FlaggedApi(value="android.security.content_uri_permission_apis")
    @SuppressLint(value={"OnNameExpected"})
    @Nullable
    public ComponentCaller getCaller() {
        return this.mCaller;
    }

    @FlaggedApi(value="android.security.content_uri_permission_apis")
    @SuppressLint(value={"OnNameExpected"})
    public void setIntent(@Nullable Intent newIntent, @Nullable ComponentCaller newCaller) {
        this.internalSetIntent(newIntent, newCaller);
    }

    private void internalSetIntent(Intent newIntent, ComponentCaller newCaller) {
        this.mIntent = newIntent;
        this.mCaller = newCaller;
    }

    public void setLocusContext(@Nullable LocusId locusId, @Nullable Bundle bundle) {
        try {
            ActivityManager.getService().setActivityLocusContext(this.mComponent, locusId, this.mToken);
        }
        catch (RemoteException re) {
            re.rethrowFromSystemServer();
        }
        if (locusId != null) {
            this.setLocusContextToContentCapture(locusId, bundle);
        }
    }

    @FlaggedApi(value="com.android.window.flags.enable_desktop_windowing_app_to_web_education")
    public void requestOpenInBrowserEducation() {
        try {
            ActivityTaskManager.getService().requestOpenInBrowserEducation(this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Application getApplication() {
        return this.mApplication;
    }

    @Deprecated
    public boolean isChild() {
        return this.mParent != null;
    }

    @Deprecated
    public Activity getParent() {
        return this.mParent;
    }

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    public Window getWindow() {
        return this.mWindow;
    }

    @Deprecated
    public LoaderManager getLoaderManager() {
        return this.mFragments.getLoaderManager();
    }

    @Nullable
    public View getCurrentFocus() {
        return this.mWindow != null ? this.mWindow.getCurrentFocus() : null;
    }

    @Nullable
    private ContentCaptureManager getContentCaptureManager() {
        if (!UserHandle.isApp(Process.myUid())) {
            return null;
        }
        if (this.mContentCaptureManager == null) {
            this.mContentCaptureManager = this.getSystemService(ContentCaptureManager.class);
        }
        return this.mContentCaptureManager;
    }

    private String getContentCaptureTypeAsString(int type) {
        switch (type) {
            case 1: {
                return "START";
            }
            case 2: {
                return "RESUME";
            }
            case 3: {
                return "PAUSE";
            }
            case 4: {
                return "STOP";
            }
        }
        return "UNKNOW-" + type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void notifyContentCaptureManagerIfNeeded(int type) {
        if (Trace.isTagEnabled(64L)) {
            Trace.traceBegin(64L, "notifyContentCapture(" + this.getContentCaptureTypeAsString(type) + ") for " + this.mComponent.toShortString());
        }
        try {
            ContentCaptureManager cm = this.getContentCaptureManager();
            if (cm == null) {
                return;
            }
            switch (type) {
                case 1: {
                    Window window = this.getWindow();
                    if (window != null) {
                        cm.updateWindowAttributes(window.getAttributes());
                    }
                    cm.onActivityCreated(this.mToken, this.mShareableActivityToken, this.getComponentName());
                    return;
                }
                case 2: {
                    cm.onActivityResumed();
                    return;
                }
                case 3: {
                    cm.onActivityPaused();
                    return;
                }
                case 4: {
                    cm.onActivityDestroyed();
                    return;
                }
                default: {
                    Log.wtf(TAG, "Invalid @ContentCaptureNotificationType: " + type);
                    return;
                }
            }
        }
        finally {
            Trace.traceEnd(64L);
        }
    }

    private void setLocusContextToContentCapture(LocusId locusId, @Nullable Bundle bundle) {
        ContentCaptureManager cm = this.getContentCaptureManager();
        if (cm == null) {
            return;
        }
        ContentCaptureContext.Builder contentCaptureContextBuilder = new ContentCaptureContext.Builder(locusId);
        if (bundle != null) {
            contentCaptureContextBuilder.setExtras(bundle);
        }
        cm.getMainContentCaptureSession().setContentCaptureContext(contentCaptureContextBuilder.build());
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(newBase);
        if (newBase != null) {
            newBase.setAutofillClient(this.getAutofillClient());
            newBase.setContentCaptureOptions(this.getContentCaptureOptions());
        }
    }

    @Override
    public AutofillManager.AutofillClient getAutofillClient() {
        return this.getAutofillClientController();
    }

    private AutofillClientController getAutofillClientController() {
        if (this.mAutofillClientController == null) {
            this.mAutofillClientController = new AutofillClientController(this);
        }
        return this.mAutofillClientController;
    }

    @Override
    public ContentCaptureManager.ContentCaptureClient getContentCaptureClient() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActivityLifecycleCallbacks(@NonNull Application.ActivityLifecycleCallbacks callback) {
        ArrayList<Application.ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            this.mActivityLifecycleCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterActivityLifecycleCallbacks(@NonNull Application.ActivityLifecycleCallbacks callback) {
        ArrayList<Application.ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            this.mActivityLifecycleCallbacks.remove(callback);
        }
    }

    @Override
    public void registerComponentCallbacks(ComponentCallbacks callback) {
        if (CompatChanges.isChangeEnabled(193247900L) && this.mCallbacksController == null) {
            this.mCallbacksController = new ComponentCallbacksController();
        }
        if (this.mCallbacksController != null) {
            this.mCallbacksController.registerCallbacks(callback);
        } else {
            super.registerComponentCallbacks(callback);
        }
    }

    @Override
    public void unregisterComponentCallbacks(ComponentCallbacks callback) {
        if (this.mCallbacksController != null) {
            this.mCallbacksController.unregisterCallbacks(callback);
        } else {
            super.unregisterComponentCallbacks(callback);
        }
    }

    private void dispatchActivityPreCreated(@Nullable Bundle savedInstanceState) {
        this.getApplication().dispatchActivityPreCreated(this, savedInstanceState);
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPreCreated(this, savedInstanceState);
            }
        }
    }

    private void dispatchActivityCreated(@Nullable Bundle savedInstanceState) {
        this.getApplication().dispatchActivityCreated(this, savedInstanceState);
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityCreated(this, savedInstanceState);
            }
        }
    }

    private void dispatchActivityPostCreated(@Nullable Bundle savedInstanceState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPostCreated(this, savedInstanceState);
            }
        }
        this.getApplication().dispatchActivityPostCreated(this, savedInstanceState);
    }

    private void dispatchActivityPreStarted() {
        this.getApplication().dispatchActivityPreStarted(this);
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPreStarted(this);
            }
        }
    }

    private void dispatchActivityStarted() {
        this.getApplication().dispatchActivityStarted(this);
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityStarted(this);
            }
        }
    }

    private void dispatchActivityPostStarted() {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPostStarted(this);
            }
        }
        this.getApplication().dispatchActivityPostStarted(this);
    }

    private void dispatchActivityPreResumed() {
        this.getApplication().dispatchActivityPreResumed(this);
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPreResumed(this);
            }
        }
    }

    private void dispatchActivityResumed() {
        this.getApplication().dispatchActivityResumed(this);
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityResumed(this);
            }
        }
    }

    private void dispatchActivityPostResumed() {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPostResumed(this);
            }
        }
        this.getApplication().dispatchActivityPostResumed(this);
    }

    private void dispatchActivityPrePaused() {
        this.getApplication().dispatchActivityPrePaused(this);
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPrePaused(this);
            }
        }
    }

    private void dispatchActivityPaused() {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPaused(this);
            }
        }
        this.getApplication().dispatchActivityPaused(this);
    }

    private void dispatchActivityPostPaused() {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPostPaused(this);
            }
        }
        this.getApplication().dispatchActivityPostPaused(this);
    }

    private void dispatchActivityPreStopped() {
        this.getApplication().dispatchActivityPreStopped(this);
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPreStopped(this);
            }
        }
    }

    private void dispatchActivityStopped() {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityStopped(this);
            }
        }
        this.getApplication().dispatchActivityStopped(this);
    }

    private void dispatchActivityPostStopped() {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPostStopped(this);
            }
        }
        this.getApplication().dispatchActivityPostStopped(this);
    }

    private void dispatchActivityPreSaveInstanceState(@NonNull Bundle outState) {
        this.getApplication().dispatchActivityPreSaveInstanceState(this, outState);
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPreSaveInstanceState(this, outState);
            }
        }
    }

    private void dispatchActivitySaveInstanceState(@NonNull Bundle outState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivitySaveInstanceState(this, outState);
            }
        }
        this.getApplication().dispatchActivitySaveInstanceState(this, outState);
    }

    private void dispatchActivityPostSaveInstanceState(@NonNull Bundle outState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPostSaveInstanceState(this, outState);
            }
        }
        this.getApplication().dispatchActivityPostSaveInstanceState(this, outState);
    }

    private void dispatchActivityPreDestroyed() {
        this.getApplication().dispatchActivityPreDestroyed(this);
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPreDestroyed(this);
            }
        }
    }

    private void dispatchActivityDestroyed() {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityDestroyed(this);
            }
        }
        this.getApplication().dispatchActivityDestroyed(this);
    }

    private void dispatchActivityPostDestroyed() {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = callbacks.length - 1; i >= 0; --i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityPostDestroyed(this);
            }
        }
        this.getApplication().dispatchActivityPostDestroyed(this);
    }

    private void dispatchActivityConfigurationChanged() {
        Object[] callbacks;
        if (this.getApplication() != null) {
            this.getApplication().dispatchActivityConfigurationChanged(this);
        }
        if ((callbacks = this.collectActivityLifecycleCallbacks()) != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((Application.ActivityLifecycleCallbacks)callbacks[i]).onActivityConfigurationChanged(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] collectActivityLifecycleCallbacks() {
        Object[] callbacks = null;
        ArrayList<Application.ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            if (this.mActivityLifecycleCallbacks.size() > 0) {
                callbacks = this.mActivityLifecycleCallbacks.toArray();
            }
        }
        return callbacks;
    }

    private void notifyVoiceInteractionManagerServiceActivityEvent(int type) {
        if (this.mVoiceInteractionManagerService == null) {
            this.mVoiceInteractionManagerService = IVoiceInteractionManagerService.Stub.asInterface(ServiceManager.getService("voiceinteraction"));
            if (this.mVoiceInteractionManagerService == null) {
                Log.w(TAG, "notifyVoiceInteractionManagerServiceActivityEvent: Can not get VoiceInteractionManagerService");
                return;
            }
        }
        try {
            this.mVoiceInteractionManagerService.notifyActivityEventChanged(this.mToken, type);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        if (this.mLastNonConfigurationInstances != null) {
            this.mFragments.restoreLoaderNonConfig(this.mLastNonConfigurationInstances.loaders);
        }
        if (this.mActivityInfo.parentActivityName != null) {
            if (this.mActionBar == null) {
                this.mEnableDefaultActionBarUp = true;
            } else {
                this.mActionBar.setDefaultDisplayHomeAsUpEnabled(true);
            }
        }
        if (savedInstanceState != null) {
            this.getAutofillClientController().onActivityCreated(savedInstanceState);
            Object p = savedInstanceState.getParcelable(FRAGMENTS_TAG);
            this.mFragments.restoreAllState((Parcelable)p, this.mLastNonConfigurationInstances != null ? this.mLastNonConfigurationInstances.fragments : null);
        }
        this.mFragments.dispatchCreate();
        this.dispatchActivityCreated(savedInstanceState);
        if (this.mVoiceInteractor != null) {
            this.mVoiceInteractor.attachActivity(this);
        }
        this.mRestoredFromBundle = savedInstanceState != null;
        this.mCalled = true;
        boolean aheadOfTimeBack = WindowOnBackInvokedDispatcher.isOnBackInvokedCallbackEnabled(this);
        if (aheadOfTimeBack) {
            this.mDefaultBackCallback = this::onBackInvoked;
            this.getOnBackInvokedDispatcher().registerSystemOnBackInvokedCallback(this.mDefaultBackCallback);
        }
    }

    @NonNull
    public SplashScreen getSplashScreen() {
        return this.getOrCreateSplashScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SplashScreen getOrCreateSplashScreen() {
        Activity activity = this;
        synchronized (activity) {
            if (this.mSplashScreen == null) {
                this.mSplashScreen = new SplashScreen.SplashScreenImpl(this);
            }
            return this.mSplashScreen;
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState, @Nullable PersistableBundle persistentState) {
        this.onCreate(savedInstanceState);
    }

    void performRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        this.onRestoreInstanceState(savedInstanceState);
        this.restoreManagedDialogs(savedInstanceState);
    }

    void performRestoreInstanceState(@Nullable Bundle savedInstanceState, @Nullable PersistableBundle persistentState) {
        this.onRestoreInstanceState(savedInstanceState, persistentState);
        if (savedInstanceState != null) {
            this.restoreManagedDialogs(savedInstanceState);
        }
    }

    protected void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        Bundle windowState;
        if (this.mWindow != null && (windowState = savedInstanceState.getBundle(WINDOW_HIERARCHY_TAG)) != null) {
            this.mWindow.restoreHierarchyState(windowState);
        }
    }

    public void onRestoreInstanceState(@Nullable Bundle savedInstanceState, @Nullable PersistableBundle persistentState) {
        if (savedInstanceState != null) {
            this.onRestoreInstanceState(savedInstanceState);
        }
    }

    private void restoreManagedDialogs(Bundle savedInstanceState) {
        Bundle b = savedInstanceState.getBundle(SAVED_DIALOGS_TAG);
        if (b == null) {
            return;
        }
        int[] ids = b.getIntArray(SAVED_DIALOG_IDS_KEY);
        int numDialogs = ids.length;
        this.mManagedDialogs = new SparseArray(numDialogs);
        for (int i = 0; i < numDialogs; ++i) {
            int dialogId = ids[i];
            Bundle dialogState = b.getBundle(Activity.savedDialogKeyFor(dialogId));
            if (dialogState == null) continue;
            ManagedDialog md = new ManagedDialog();
            md.mArgs = b.getBundle(Activity.savedDialogArgsKeyFor(dialogId));
            md.mDialog = this.createDialog(dialogId, dialogState, md.mArgs);
            if (md.mDialog == null) continue;
            this.mManagedDialogs.put(dialogId, md);
            this.onPrepareDialog(dialogId, md.mDialog, md.mArgs);
            md.mDialog.onRestoreInstanceState(dialogState);
        }
    }

    private Dialog createDialog(Integer dialogId, Bundle state, Bundle args) {
        Dialog dialog = this.onCreateDialog(dialogId, args);
        if (dialog == null) {
            return null;
        }
        dialog.dispatchOnCreate(state);
        return dialog;
    }

    private static String savedDialogKeyFor(int key) {
        return SAVED_DIALOG_KEY_PREFIX + key;
    }

    private static String savedDialogArgsKeyFor(int key) {
        return SAVED_DIALOG_ARGS_KEY_PREFIX + key;
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        if (!this.isChild()) {
            this.mTitleReady = true;
            this.onTitleChanged(this.getTitle(), this.getTitleColor());
        }
        this.mCalled = true;
        this.notifyContentCaptureManagerIfNeeded(1);
        this.notifyVoiceInteractionManagerServiceActivityEvent(1);
    }

    public void onPostCreate(@Nullable Bundle savedInstanceState, @Nullable PersistableBundle persistentState) {
        this.onPostCreate(savedInstanceState);
    }

    protected void onStart() {
        this.mCalled = true;
        this.mFragments.doLoaderStart();
        this.dispatchActivityStarted();
        this.getAutofillClientController().onActivityStarted();
    }

    protected void onRestart() {
        this.mCalled = true;
    }

    @Deprecated
    public void onStateNotSaved() {
    }

    protected void onResume() {
        this.dispatchActivityResumed();
        this.mActivityTransitionState.onResume(this);
        this.getAutofillClientController().onActivityResumed();
        this.notifyContentCaptureManagerIfNeeded(2);
        this.mCalled = true;
    }

    protected void onPostResume() {
        Window win = this.getWindow();
        if (win != null) {
            win.makeActive();
        }
        if (this.mActionBar != null) {
            this.mActionBar.setShowHideAnimationEnabled(true);
        }
        this.notifyVoiceInteractionManagerServiceActivityEvent(2);
        this.getAutofillClientController().onActivityPostResumed();
        if (Flags.detailedAppJankMetricsApi()) {
            this.startAppJankTracking();
        }
        this.mCalled = true;
    }

    public void onTopResumedActivityChanged(boolean isTopResumedActivity) {
    }

    void performTopResumedActivityChanged(boolean isTopResumedActivity, String reason) {
        this.onTopResumedActivityChanged(isTopResumedActivity);
        if (isTopResumedActivity) {
            EventLogTags.writeWmOnTopResumedGainedCalled(this.mIdent, this.getComponentName().getClassName(), reason);
        } else {
            EventLogTags.writeWmOnTopResumedLostCalled(this.mIdent, this.getComponentName().getClassName(), reason);
        }
    }

    void setVoiceInteractor(IVoiceInteractor voiceInteractor) {
        VoiceInteractor.Request[] requests;
        if (this.mVoiceInteractor != null && (requests = this.mVoiceInteractor.getActiveRequests()) != null) {
            for (VoiceInteractor.Request activeRequest : this.mVoiceInteractor.getActiveRequests()) {
                activeRequest.cancel();
                activeRequest.clear();
            }
        }
        this.mVoiceInteractor = voiceInteractor == null ? null : new VoiceInteractor(voiceInteractor, this, this, Looper.myLooper());
    }

    @Override
    public int getNextAutofillId() {
        return this.getAutofillClientController().getNextAutofillId();
    }

    public boolean isVoiceInteraction() {
        return this.mVoiceInteractor != null;
    }

    public boolean isVoiceInteractionRoot() {
        return this.mVoiceInteractor != null && ActivityClient.getInstance().isRootVoiceInteraction(this.mToken);
    }

    public VoiceInteractor getVoiceInteractor() {
        return this.mVoiceInteractor;
    }

    public boolean isLocalVoiceInteractionSupported() {
        try {
            return ActivityTaskManager.getService().supportsLocalVoiceInteraction();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void startLocalVoiceInteraction(Bundle privateOptions) {
        ActivityClient.getInstance().startLocalVoiceInteraction(this.mToken, privateOptions);
    }

    public void onLocalVoiceInteractionStarted() {
    }

    public void onLocalVoiceInteractionStopped() {
    }

    public void stopLocalVoiceInteraction() {
        ActivityClient.getInstance().stopLocalVoiceInteraction(this.mToken);
    }

    protected void onNewIntent(Intent intent) {
    }

    @FlaggedApi(value="android.security.content_uri_permission_apis")
    public void onNewIntent(@NonNull Intent intent, @NonNull ComponentCaller caller) {
        this.onNewIntent(intent);
    }

    void performSaveInstanceState(@NonNull Bundle outState) {
        this.dispatchActivityPreSaveInstanceState(outState);
        this.onSaveInstanceState(outState);
        this.saveManagedDialogs(outState);
        this.mActivityTransitionState.saveState(outState);
        this.storeHasCurrentPermissionRequest(outState);
        this.dispatchActivityPostSaveInstanceState(outState);
    }

    void performSaveInstanceState(@NonNull Bundle outState, @NonNull PersistableBundle outPersistentState) {
        this.dispatchActivityPreSaveInstanceState(outState);
        this.onSaveInstanceState(outState, outPersistentState);
        this.saveManagedDialogs(outState);
        this.storeHasCurrentPermissionRequest(outState);
        this.dispatchActivityPostSaveInstanceState(outState);
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putBundle(WINDOW_HIERARCHY_TAG, this.mWindow.saveHierarchyState());
        Parcelable p = this.mFragments.saveAllState();
        if (p != null) {
            outState.putParcelable(FRAGMENTS_TAG, p);
        }
        this.getAutofillClientController().onSaveInstanceState(outState);
        this.dispatchActivitySaveInstanceState(outState);
    }

    public void onSaveInstanceState(@NonNull Bundle outState, @NonNull PersistableBundle outPersistentState) {
        this.onSaveInstanceState(outState);
    }

    @UnsupportedAppUsage
    private void saveManagedDialogs(Bundle outState) {
        if (this.mManagedDialogs == null) {
            return;
        }
        int numDialogs = this.mManagedDialogs.size();
        if (numDialogs == 0) {
            return;
        }
        Bundle dialogState = new Bundle();
        int[] ids = new int[this.mManagedDialogs.size()];
        for (int i = 0; i < numDialogs; ++i) {
            int key;
            ids[i] = key = this.mManagedDialogs.keyAt(i);
            ManagedDialog md = this.mManagedDialogs.valueAt(i);
            dialogState.putBundle(Activity.savedDialogKeyFor(key), md.mDialog.onSaveInstanceState());
            if (md.mArgs == null) continue;
            dialogState.putBundle(Activity.savedDialogArgsKeyFor(key), md.mArgs);
        }
        dialogState.putIntArray(SAVED_DIALOG_IDS_KEY, ids);
        outState.putBundle(SAVED_DIALOGS_TAG, dialogState);
    }

    protected void onPause() {
        this.dispatchActivityPaused();
        this.getAutofillClientController().onActivityPaused();
        this.notifyContentCaptureManagerIfNeeded(3);
        this.notifyVoiceInteractionManagerServiceActivityEvent(3);
        this.mCalled = true;
    }

    protected void onUserLeaveHint() {
    }

    @Deprecated
    public boolean onCreateThumbnail(Bitmap outBitmap, Canvas canvas) {
        return false;
    }

    @Nullable
    public CharSequence onCreateDescription() {
        return null;
    }

    public void onProvideAssistData(Bundle data) {
    }

    public void onProvideAssistContent(AssistContent outContent) {
    }

    public void onGetDirectActions(@NonNull CancellationSignal cancellationSignal, @NonNull Consumer<List<DirectAction>> callback) {
        callback.accept(Collections.emptyList());
    }

    public void onPerformDirectAction(@NonNull String actionId, @NonNull Bundle arguments, @NonNull CancellationSignal cancellationSignal, @NonNull Consumer<Bundle> resultListener) {
    }

    public void requestShowKeyboardShortcuts() {
        ComponentName sysuiComponent = ComponentName.unflattenFromString(this.getResources().getString(17040097));
        Intent intent = new Intent("com.android.intent.action.SHOW_KEYBOARD_SHORTCUTS");
        intent.setPackage(sysuiComponent.getPackageName());
        this.sendBroadcastAsUser(intent, Process.myUserHandle());
    }

    public void dismissKeyboardShortcutsHelper() {
        ComponentName sysuiComponent = ComponentName.unflattenFromString(this.getResources().getString(17040097));
        Intent intent = new Intent("com.android.intent.action.DISMISS_KEYBOARD_SHORTCUTS");
        intent.setPackage(sysuiComponent.getPackageName());
        this.sendBroadcastAsUser(intent, Process.myUserHandle());
    }

    @Override
    public void onProvideKeyboardShortcuts(List<KeyboardShortcutGroup> data, Menu menu2, int deviceId) {
        if (menu2 == null) {
            return;
        }
        KeyboardShortcutGroup group = null;
        int menuSize = menu2.size();
        for (int i = 0; i < menuSize; ++i) {
            MenuItem item = menu2.getItem(i);
            CharSequence title = item.getTitle();
            char alphaShortcut = item.getAlphabeticShortcut();
            int alphaModifiers = item.getAlphabeticModifiers();
            if (title == null || alphaShortcut == '\u0000') continue;
            if (group == null) {
                int resource = this.mApplication.getApplicationInfo().labelRes;
                group = new KeyboardShortcutGroup(resource != 0 ? this.getString(resource) : null);
            }
            group.addItem(new KeyboardShortcutInfo(title, alphaShortcut, alphaModifiers));
        }
        if (group != null) {
            data.add(group);
        }
    }

    public boolean showAssist(Bundle args) {
        return ActivityClient.getInstance().showAssistFromActivity(this.mToken, args);
    }

    protected void onStop() {
        if (this.mActionBar != null) {
            this.mActionBar.setShowHideAnimationEnabled(false);
        }
        this.mActivityTransitionState.onStop(this);
        this.dispatchActivityStopped();
        this.mTranslucentCallback = null;
        this.mCalled = true;
        this.getAutofillClientController().onActivityStopped(this.mIntent, this.mChangingConfigurations);
        this.notifyVoiceInteractionManagerServiceActivityEvent(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDestroy() {
        this.mCalled = true;
        this.getAutofillClientController().onActivityDestroyed();
        if (this.mManagedDialogs != null) {
            int numDialogs = this.mManagedDialogs.size();
            for (int i = 0; i < numDialogs; ++i) {
                ManagedDialog md = this.mManagedDialogs.valueAt(i);
                if (!md.mDialog.isShowing()) continue;
                md.mDialog.dismiss();
            }
            this.mManagedDialogs = null;
        }
        ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
        synchronized (arrayList) {
            int numCursors = this.mManagedCursors.size();
            for (int i = 0; i < numCursors; ++i) {
                ManagedCursor c = this.mManagedCursors.get(i);
                if (c == null) continue;
                c.mCursor.close();
            }
            this.mManagedCursors.clear();
        }
        if (this.mSearchManager != null) {
            this.mSearchManager.stopSearch();
        }
        if (this.mActionBar != null) {
            this.mActionBar.onDestroy();
        }
        this.dispatchActivityDestroyed();
        this.notifyContentCaptureManagerIfNeeded(4);
        if (this.mUiTranslationController != null) {
            this.mUiTranslationController.onActivityDestroyed();
        }
        if (this.mDefaultBackCallback != null) {
            this.getOnBackInvokedDispatcher().unregisterOnBackInvokedCallback(this.mDefaultBackCallback);
            this.mDefaultBackCallback = null;
        }
        if (this.mCallbacksController != null) {
            this.mCallbacksController.clearCallbacks();
        }
    }

    public void reportFullyDrawn() {
        if (this.mDoReportFullyDrawn) {
            if (Trace.isTagEnabled(64L)) {
                Trace.traceBegin(64L, "reportFullyDrawn() for " + this.mComponent.toShortString());
            }
            this.mDoReportFullyDrawn = false;
            try {
                ActivityClient.getInstance().reportActivityFullyDrawn(this.mToken, this.mRestoredFromBundle);
                VMRuntime.getRuntime().notifyStartupCompleted();
            }
            finally {
                Trace.traceEnd(64L);
            }
        }
    }

    public void onMultiWindowModeChanged(boolean isInMultiWindowMode, Configuration newConfig) {
        this.onMultiWindowModeChanged(isInMultiWindowMode);
    }

    @Deprecated
    public void onMultiWindowModeChanged(boolean isInMultiWindowMode) {
    }

    public boolean isInMultiWindowMode() {
        return this.mIsInMultiWindowMode;
    }

    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode, Configuration newConfig) {
        this.onPictureInPictureModeChanged(isInPictureInPictureMode);
    }

    public void onPictureInPictureUiStateChanged(@NonNull PictureInPictureUiState pipState) {
    }

    @Deprecated
    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
    }

    public boolean isInPictureInPictureMode() {
        return this.mIsInPictureInPictureMode;
    }

    @Deprecated
    public void enterPictureInPictureMode() {
        this.enterPictureInPictureMode(new PictureInPictureParams.Builder().build());
    }

    public boolean enterPictureInPictureMode(@NonNull PictureInPictureParams params) {
        if (!this.deviceSupportsPictureInPictureMode()) {
            return false;
        }
        if (params == null) {
            throw new IllegalArgumentException("Expected non-null picture-in-picture params");
        }
        if (!this.mCanEnterPictureInPicture) {
            if (this.isTvImplicitEnterPipProhibited()) {
                Log.e(TAG, "Activity must be resumed to enter picture-in-picture and not about to be paused. Implicit app entry is only permitted on TV if android.permission.TV_IMPLICIT_ENTER_PIP is held by the app.");
                return false;
            }
            throw new IllegalStateException("Activity must be resumed to enter picture-in-picture");
        }
        this.mIsInPictureInPictureMode = ActivityClient.getInstance().enterPictureInPictureMode(this.mToken, params);
        return this.mIsInPictureInPictureMode;
    }

    public void setPictureInPictureParams(@NonNull PictureInPictureParams params) {
        if (!this.deviceSupportsPictureInPictureMode()) {
            return;
        }
        if (params == null) {
            throw new IllegalArgumentException("Expected non-null picture-in-picture params");
        }
        ActivityClient.getInstance().setPictureInPictureParams(this.mToken, params);
    }

    public int getMaxNumPictureInPictureActions() {
        return ActivityTaskManager.getMaxNumPictureInPictureActions(this);
    }

    private boolean isTvImplicitEnterPipProhibited() {
        PackageManager pm = this.getPackageManager();
        if (android.app.Flags.enableTvImplicitEnterPipRestriction()) {
            return pm.hasSystemFeature("android.software.leanback") && pm.checkPermission("android.permission.TV_IMPLICIT_ENTER_PIP", this.getPackageName()) == -1;
        }
        return false;
    }

    private boolean deviceSupportsPictureInPictureMode() {
        return this.getPackageManager().hasSystemFeature("android.software.picture_in_picture");
    }

    public boolean onPictureInPictureRequested() {
        return false;
    }

    public void requestFullscreenMode(int request, @Nullable OutcomeReceiver<Void, Throwable> approvalCallback) {
        FullscreenRequestHandler.requestFullscreenMode(request, approvalCallback, this.mCurrentConfig, this.getActivityToken());
    }

    public void setShouldDockBigOverlays(boolean shouldDockBigOverlays) {
        ActivityClient.getInstance().setShouldDockBigOverlays(this.mToken, shouldDockBigOverlays);
        this.mShouldDockBigOverlays = shouldDockBigOverlays;
    }

    public boolean shouldDockBigOverlays() {
        return this.mShouldDockBigOverlays;
    }

    void dispatchMovedToDisplay(int displayId, Configuration config) {
        this.updateDisplay(displayId);
        this.onMovedToDisplay(displayId, config);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void onMovedToDisplay(int displayId, Configuration config) {
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        this.mCalled = true;
        this.mFragments.dispatchConfigurationChanged(newConfig);
        if (this.mWindow != null) {
            this.mWindow.onConfigurationChanged(newConfig);
        }
        if (this.mActionBar != null) {
            this.mActionBar.onConfigurationChanged(newConfig);
        }
        this.dispatchActivityConfigurationChanged();
        if (this.mCallbacksController != null) {
            this.mCallbacksController.dispatchConfigurationChanged(newConfig);
        }
    }

    public int getChangingConfigurations() {
        return this.mConfigChangeFlags;
    }

    @Nullable
    public Object getLastNonConfigurationInstance() {
        return this.mLastNonConfigurationInstances != null ? this.mLastNonConfigurationInstances.activity : null;
    }

    public Object onRetainNonConfigurationInstance() {
        return null;
    }

    @Nullable
    HashMap<String, Object> getLastNonConfigurationChildInstances() {
        return this.mLastNonConfigurationInstances != null ? this.mLastNonConfigurationInstances.children : null;
    }

    @Nullable
    HashMap<String, Object> onRetainNonConfigurationChildInstances() {
        return null;
    }

    NonConfigurationInstances retainNonConfigurationInstances() {
        Object activity = this.onRetainNonConfigurationInstance();
        HashMap<String, Object> children = this.onRetainNonConfigurationChildInstances();
        FragmentManagerNonConfig fragments = this.mFragments.retainNestedNonConfig();
        this.mFragments.doLoaderStart();
        this.mFragments.doLoaderStop(true);
        ArrayMap<String, LoaderManager> loaders = this.mFragments.retainLoaderNonConfig();
        if (activity == null && children == null && fragments == null && loaders == null && this.mVoiceInteractor == null) {
            return null;
        }
        NonConfigurationInstances nci = new NonConfigurationInstances();
        nci.activity = activity;
        nci.children = children;
        nci.fragments = fragments;
        nci.loaders = loaders;
        if (this.mVoiceInteractor != null) {
            this.mVoiceInteractor.retainInstance();
            nci.voiceInteractor = this.mVoiceInteractor;
        }
        return nci;
    }

    @Override
    public void onLowMemory() {
        this.mCalled = true;
        this.mFragments.dispatchLowMemory();
        if (this.mCallbacksController != null) {
            this.mCallbacksController.dispatchLowMemory();
        }
    }

    @Override
    public void onTrimMemory(int level) {
        this.mCalled = true;
        this.mFragments.dispatchTrimMemory(level);
        if (this.mCallbacksController != null) {
            this.mCallbacksController.dispatchTrimMemory(level);
        }
    }

    @Deprecated
    public FragmentManager getFragmentManager() {
        return this.mFragments.getFragmentManager();
    }

    @Deprecated
    public void onAttachFragment(Fragment fragment) {
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public Cursor managedQuery(Uri uri, String[] projection, String selection, String sortOrder) {
        Cursor c = this.getContentResolver().query(uri, projection, selection, null, sortOrder);
        if (c != null) {
            this.startManagingCursor(c);
        }
        return c;
    }

    @Deprecated
    public Cursor managedQuery(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor c = this.getContentResolver().query(uri, projection, selection, selectionArgs, sortOrder);
        if (c != null) {
            this.startManagingCursor(c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void startManagingCursor(Cursor c) {
        ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
        synchronized (arrayList) {
            this.mManagedCursors.add(new ManagedCursor(c));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void stopManagingCursor(Cursor c) {
        ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
        synchronized (arrayList) {
            int N2 = this.mManagedCursors.size();
            for (int i = 0; i < N2; ++i) {
                ManagedCursor mc = this.mManagedCursors.get(i);
                if (mc.mCursor != c) continue;
                this.mManagedCursors.remove(i);
                break;
            }
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public void setPersistent(boolean isPersistent) {
    }

    public <T extends View> T findViewById(int id2) {
        return this.getWindow().findViewById(id2);
    }

    @NonNull
    public <T extends View> T requireViewById(int id2) {
        T view = this.findViewById(id2);
        if (view == null) {
            throw new IllegalArgumentException("ID does not reference a View inside this Activity");
        }
        return view;
    }

    @Nullable
    public ActionBar getActionBar() {
        this.initWindowDecorActionBar();
        return this.mActionBar;
    }

    public void setActionBar(@Nullable Toolbar toolbar) {
        ActionBar ab = this.getActionBar();
        if (ab instanceof WindowDecorActionBar) {
            throw new IllegalStateException("This Activity already has an action bar supplied by the window decor. Do not request Window.FEATURE_ACTION_BAR and set android:windowActionBar to false in your theme to use a Toolbar instead.");
        }
        this.mMenuInflater = null;
        if (ab != null) {
            ab.onDestroy();
        }
        if (toolbar != null) {
            ToolbarActionBar tbab = new ToolbarActionBar(toolbar, this.getTitle(), this);
            this.mActionBar = tbab;
            this.mWindow.setCallback(tbab.getWrappedWindowCallback());
        } else {
            this.mActionBar = null;
            this.mWindow.setCallback(this);
        }
        this.invalidateOptionsMenu();
    }

    private void initWindowDecorActionBar() {
        Window window = this.getWindow();
        window.getDecorView();
        if (this.isChild() || !window.hasFeature(8) || this.mActionBar != null) {
            return;
        }
        this.mActionBar = new WindowDecorActionBar(this);
        this.mActionBar.setDefaultDisplayHomeAsUpEnabled(this.mEnableDefaultActionBarUp);
        this.mWindow.setDefaultIcon(this.mActivityInfo.getIconResource());
        this.mWindow.setDefaultLogo(this.mActivityInfo.getLogoResource());
    }

    public void setContentView(int layoutResID) {
        this.getWindow().setContentView(layoutResID);
        this.initWindowDecorActionBar();
    }

    public void setContentView(View view) {
        this.getWindow().setContentView(view);
        this.initWindowDecorActionBar();
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        this.getWindow().setContentView(view, params);
        this.initWindowDecorActionBar();
    }

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        this.getWindow().addContentView(view, params);
        this.initWindowDecorActionBar();
    }

    public TransitionManager getContentTransitionManager() {
        return this.getWindow().getTransitionManager();
    }

    public void setContentTransitionManager(TransitionManager tm) {
        this.getWindow().setTransitionManager(tm);
    }

    public Scene getContentScene() {
        return this.getWindow().getContentScene();
    }

    public void setFinishOnTouchOutside(boolean finish) {
        this.mWindow.setCloseOnTouchOutside(finish);
    }

    public void setDefaultKeyMode(int mode) {
        this.mDefaultKeyMode = mode;
        switch (mode) {
            case 0: 
            case 2: {
                this.mDefaultKeySsb = null;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.mDefaultKeySsb = new SpannableStringBuilder();
                Selection.setSelection(this.mDefaultKeySsb, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean handled;
        if (keyCode == 4) {
            if (this.getApplicationInfo().targetSdkVersion >= 5) {
                event.startTracking();
            } else {
                this.onBackPressed();
            }
            return true;
        }
        if (keyCode == 111 && this.mWindow.shouldCloseOnTouchOutside()) {
            event.startTracking();
            this.finish();
            return true;
        }
        if (this.mDefaultKeyMode == 0) {
            return false;
        }
        if (this.mDefaultKeyMode == 2) {
            Window w = this.getWindow();
            return w.hasFeature(0) && w.performPanelShortcut(0, keyCode, event, 2);
        }
        if (keyCode == 61) {
            return false;
        }
        boolean clearSpannable = false;
        if (event.getRepeatCount() != 0 || event.isSystem()) {
            clearSpannable = true;
            handled = false;
        } else {
            handled = TextKeyListener.getInstance().onKeyDown(null, this.mDefaultKeySsb, keyCode, event);
            if (handled && this.mDefaultKeySsb.length() > 0) {
                String str = this.mDefaultKeySsb.toString();
                clearSpannable = true;
                switch (this.mDefaultKeyMode) {
                    case 1: {
                        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse("tel:" + str));
                        intent.addFlags(0x10000000);
                        this.startActivity(intent);
                        break;
                    }
                    case 3: {
                        this.startSearch(str, false, null, false);
                        break;
                    }
                    case 4: {
                        this.startSearch(str, false, null, true);
                    }
                }
            }
        }
        if (clearSpannable) {
            this.mDefaultKeySsb.clear();
            this.mDefaultKeySsb.clearSpans();
            Selection.setSelection(this.mDefaultKeySsb, 0);
        }
        return handled;
    }

    @Override
    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        int sdkVersion = this.getApplicationInfo().targetSdkVersion;
        if (sdkVersion >= 5 && keyCode == 4 && event.isTracking() && !event.isCanceled() && this.mDefaultBackCallback == null) {
            this.onBackPressed();
            return true;
        }
        return keyCode == 111 && event.isTracking();
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return false;
    }

    @Deprecated
    public void onBackPressed() {
        if (this.mActionBar != null && this.mActionBar.collapseActionView()) {
            return;
        }
        FragmentManager fragmentManager = this.mFragments.getFragmentManager();
        if (!fragmentManager.isStateSaved() && fragmentManager.popBackStackImmediate()) {
            return;
        }
        this.onBackInvoked();
    }

    private void onBackInvoked() {
        ActivityClient.getInstance().onBackPressed(this.mToken, new RequestFinishCallback(new WeakReference<Activity>(this)));
        if (this.isTaskRoot()) {
            this.getAutofillClientController().onActivityBackPressed(this.mIntent);
        }
    }

    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        ActionBar actionBar = this.getActionBar();
        return actionBar != null && actionBar.onKeyShortcut(keyCode, event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mWindow.shouldCloseOnTouch(this, event)) {
            this.finish();
            return true;
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return false;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        return false;
    }

    public void onUserInteraction() {
    }

    @Override
    public void onWindowAttributesChanged(WindowManager.LayoutParams params) {
        View decor;
        if (this.mParent == null && (decor = this.mDecor) != null && decor.getParent() != null) {
            this.getWindowManager().updateViewLayout(decor, params);
            if (this.mContentCaptureManager != null) {
                this.mContentCaptureManager.updateWindowAttributes(params);
            }
        }
    }

    @Override
    public void onContentChanged() {
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
    }

    @Override
    public void onAttachedToWindow() {
    }

    @Override
    public void onDetachedFromWindow() {
    }

    public boolean hasWindowFocus() {
        View d;
        Window w = this.getWindow();
        if (w != null && (d = w.getDecorView()) != null) {
            return d.hasWindowFocus();
        }
        return false;
    }

    @Override
    public void onWindowDismissed(boolean finishTask, boolean suppressWindowTransition) {
        this.finish(finishTask ? 2 : 0);
        if (suppressWindowTransition) {
            this.overridePendingTransition(0, 0);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        this.onUserInteraction();
        int keyCode = event.getKeyCode();
        if (keyCode == 82 && this.mActionBar != null && this.mActionBar.onMenuKeyEvent(event)) {
            return true;
        }
        Window win = this.getWindow();
        if (win.superDispatchKeyEvent(event)) {
            return true;
        }
        View decor = this.mDecor;
        if (decor == null) {
            decor = win.getDecorView();
        }
        return event.dispatch(this, decor != null ? decor.getKeyDispatcherState() : null, this);
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        this.onUserInteraction();
        if (this.getWindow().superDispatchKeyShortcutEvent(event)) {
            return true;
        }
        return this.onKeyShortcut(event.getKeyCode(), event);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.onUserInteraction();
        }
        if (this.getWindow().superDispatchTouchEvent(ev)) {
            return true;
        }
        return this.onTouchEvent(ev);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent ev) {
        this.onUserInteraction();
        if (this.getWindow().superDispatchTrackballEvent(ev)) {
            return true;
        }
        return this.onTrackballEvent(ev);
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent ev) {
        this.onUserInteraction();
        if (this.getWindow().superDispatchGenericMotionEvent(ev)) {
            return true;
        }
        return this.onGenericMotionEvent(ev);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName(this.getClass().getName());
        event.setPackageName(this.getPackageName());
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        boolean isFullScreen = params.width == -1 && params.height == -1;
        event.setFullScreen(isFullScreen);
        CharSequence title = this.getTitle();
        if (!TextUtils.isEmpty(title)) {
            event.getText().add(title);
        }
        return true;
    }

    @Override
    @Nullable
    public View onCreatePanelView(int featureId) {
        return null;
    }

    @Override
    public boolean onCreatePanelMenu(int featureId, @NonNull Menu menu2) {
        if (featureId == 0) {
            boolean show = this.onCreateOptionsMenu(menu2);
            return show |= this.mFragments.dispatchCreateOptionsMenu(menu2, this.getMenuInflater());
        }
        return false;
    }

    @Override
    public boolean onPreparePanel(int featureId, @Nullable View view, @NonNull Menu menu2) {
        if (featureId == 0) {
            boolean goforit = this.onPrepareOptionsMenu(menu2);
            return goforit |= this.mFragments.dispatchPrepareOptionsMenu(menu2);
        }
        return true;
    }

    @Override
    public boolean onMenuOpened(int featureId, @NonNull Menu menu2) {
        if (featureId == 8) {
            this.initWindowDecorActionBar();
            if (this.mActionBar != null) {
                this.mActionBar.dispatchMenuVisibilityChanged(true);
            } else {
                Log.e(TAG, "Tried to open action bar menu with no action bar");
            }
        }
        return true;
    }

    @Override
    public boolean onMenuItemSelected(int featureId, @NonNull MenuItem item) {
        CharSequence titleCondensed = item.getTitleCondensed();
        switch (featureId) {
            case 0: {
                if (titleCondensed != null) {
                    EventLog.writeEvent(50000, 0, titleCondensed.toString());
                }
                if (this.onOptionsItemSelected(item)) {
                    return true;
                }
                if (this.mFragments.dispatchOptionsItemSelected(item)) {
                    return true;
                }
                if (item.getItemId() == 16908332 && this.mActionBar != null && (this.mActionBar.getDisplayOptions() & 4) != 0) {
                    if (this.mParent == null) {
                        return this.onNavigateUp();
                    }
                    return this.mParent.onNavigateUpFromChild(this);
                }
                return false;
            }
            case 6: {
                if (titleCondensed != null) {
                    EventLog.writeEvent(50000, 1, titleCondensed.toString());
                }
                if (this.onContextItemSelected(item)) {
                    return true;
                }
                return this.mFragments.dispatchContextItemSelected(item);
            }
        }
        return false;
    }

    @Override
    public void onPanelClosed(int featureId, @NonNull Menu menu2) {
        switch (featureId) {
            case 0: {
                this.mFragments.dispatchOptionsMenuClosed(menu2);
                this.onOptionsMenuClosed(menu2);
                break;
            }
            case 6: {
                this.onContextMenuClosed(menu2);
                break;
            }
            case 8: {
                this.initWindowDecorActionBar();
                this.mActionBar.dispatchMenuVisibilityChanged(false);
            }
        }
    }

    public void invalidateOptionsMenu() {
        if (this.mWindow.hasFeature(0) && (this.mActionBar == null || !this.mActionBar.invalidateOptionsMenu())) {
            this.mWindow.invalidatePanelMenu(0);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.mParent != null) {
            return this.mParent.onCreateOptionsMenu(menu2);
        }
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        if (this.mParent != null) {
            return this.mParent.onPrepareOptionsMenu(menu2);
        }
        return true;
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        if (this.mParent != null) {
            return this.mParent.onOptionsItemSelected(item);
        }
        return false;
    }

    public boolean onNavigateUp() {
        Intent upIntent = this.getParentActivityIntent();
        if (upIntent != null) {
            if (this.mActivityInfo.taskAffinity == null) {
                this.finish();
            } else if (this.shouldUpRecreateTask(upIntent)) {
                TaskStackBuilder b = TaskStackBuilder.create(this);
                this.onCreateNavigateUpTaskStack(b);
                this.onPrepareNavigateUpTaskStack(b);
                b.startActivities();
                if (this.mResultCode != 0 || this.mResultData != null) {
                    Log.i(TAG, "onNavigateUp only finishing topmost activity to return a result");
                    this.finish();
                } else {
                    this.finishAffinity();
                }
            } else {
                this.navigateUpTo(upIntent);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean onNavigateUpFromChild(Activity child) {
        return this.onNavigateUp();
    }

    public void onCreateNavigateUpTaskStack(TaskStackBuilder builder) {
        builder.addParentStack(this);
    }

    public void onPrepareNavigateUpTaskStack(TaskStackBuilder builder) {
    }

    public void onOptionsMenuClosed(Menu menu2) {
        if (this.mParent != null) {
            this.mParent.onOptionsMenuClosed(menu2);
        }
    }

    public void openOptionsMenu() {
        if (this.mWindow.hasFeature(0) && (this.mActionBar == null || !this.mActionBar.openOptionsMenu())) {
            this.mWindow.openPanel(0, null);
        }
    }

    public void closeOptionsMenu() {
        if (this.mWindow.hasFeature(0) && (this.mActionBar == null || !this.mActionBar.closeOptionsMenu())) {
            this.mWindow.closePanel(0);
        }
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
    }

    public void registerForContextMenu(View view) {
        view.setOnCreateContextMenuListener(this);
    }

    public void unregisterForContextMenu(View view) {
        view.setOnCreateContextMenuListener(null);
    }

    public void openContextMenu(View view) {
        view.showContextMenu();
    }

    public void closeContextMenu() {
        if (this.mWindow.hasFeature(6)) {
            this.mWindow.closePanel(6);
        }
    }

    public boolean onContextItemSelected(@NonNull MenuItem item) {
        if (this.mParent != null) {
            return this.mParent.onContextItemSelected(item);
        }
        return false;
    }

    public void onContextMenuClosed(@NonNull Menu menu2) {
        if (this.mParent != null) {
            this.mParent.onContextMenuClosed(menu2);
        }
    }

    @Deprecated
    protected Dialog onCreateDialog(int id2) {
        return null;
    }

    @Deprecated
    @Nullable
    protected Dialog onCreateDialog(int id2, Bundle args) {
        return this.onCreateDialog(id2);
    }

    @Deprecated
    protected void onPrepareDialog(int id2, Dialog dialog) {
        dialog.setOwnerActivity(this);
    }

    @Deprecated
    protected void onPrepareDialog(int id2, Dialog dialog, Bundle args) {
        this.onPrepareDialog(id2, dialog);
    }

    @Deprecated
    public void showDialog(int id2) {
        this.showDialog(id2, null);
    }

    @Deprecated
    public boolean showDialog(int id2, Bundle args) {
        ManagedDialog md;
        if (this.mManagedDialogs == null) {
            this.mManagedDialogs = new SparseArray();
        }
        if ((md = this.mManagedDialogs.get(id2)) == null) {
            md = new ManagedDialog();
            md.mDialog = this.createDialog(id2, null, args);
            if (md.mDialog == null) {
                return false;
            }
            this.mManagedDialogs.put(id2, md);
        }
        md.mArgs = args;
        this.onPrepareDialog(id2, md.mDialog, args);
        md.mDialog.show();
        return true;
    }

    @Deprecated
    public void dismissDialog(int id2) {
        if (this.mManagedDialogs == null) {
            throw this.missingDialog(id2);
        }
        ManagedDialog md = this.mManagedDialogs.get(id2);
        if (md == null) {
            throw this.missingDialog(id2);
        }
        md.mDialog.dismiss();
    }

    private IllegalArgumentException missingDialog(int id2) {
        return new IllegalArgumentException("no dialog with id " + id2 + " was ever shown via Activity#showDialog");
    }

    @Deprecated
    public void removeDialog(int id2) {
        ManagedDialog md;
        if (this.mManagedDialogs != null && (md = this.mManagedDialogs.get(id2)) != null) {
            md.mDialog.dismiss();
            this.mManagedDialogs.remove(id2);
        }
    }

    @Override
    public boolean onSearchRequested(@Nullable SearchEvent searchEvent) {
        this.mSearchEvent = searchEvent;
        boolean result = this.onSearchRequested();
        this.mSearchEvent = null;
        return result;
    }

    @Override
    public boolean onSearchRequested() {
        int uiMode = this.getResources().getConfiguration().uiMode & 0xF;
        if (uiMode != 4 && uiMode != 6) {
            this.startSearch(null, false, null, false);
            return true;
        }
        return false;
    }

    public SearchEvent getSearchEvent() {
        return this.mSearchEvent;
    }

    public void startSearch(@Nullable String initialQuery, boolean selectInitialQuery, @Nullable Bundle appSearchData, boolean globalSearch) {
        this.ensureSearchManager();
        this.mSearchManager.startSearch(initialQuery, selectInitialQuery, this.getComponentName(), appSearchData, globalSearch);
    }

    public void triggerSearch(String query, @Nullable Bundle appSearchData) {
        this.ensureSearchManager();
        this.mSearchManager.triggerSearch(query, this.getComponentName(), appSearchData);
    }

    public void takeKeyEvents(boolean get) {
        this.getWindow().takeKeyEvents(get);
    }

    public boolean requestWindowFeature(int featureId) {
        return this.getWindow().requestFeature(featureId);
    }

    public void setFeatureDrawableResource(int featureId, int resId) {
        this.getWindow().setFeatureDrawableResource(featureId, resId);
    }

    public void setFeatureDrawableUri(int featureId, Uri uri) {
        this.getWindow().setFeatureDrawableUri(featureId, uri);
    }

    public void setFeatureDrawable(int featureId, Drawable drawable2) {
        this.getWindow().setFeatureDrawable(featureId, drawable2);
    }

    public void setFeatureDrawableAlpha(int featureId, int alpha) {
        this.getWindow().setFeatureDrawableAlpha(featureId, alpha);
    }

    @NonNull
    public LayoutInflater getLayoutInflater() {
        return this.getWindow().getLayoutInflater();
    }

    @NonNull
    public MenuInflater getMenuInflater() {
        if (this.mMenuInflater == null) {
            this.initWindowDecorActionBar();
            this.mMenuInflater = this.mActionBar != null ? new MenuInflater(this.mActionBar.getThemedContext(), this) : new MenuInflater(this);
        }
        return this.mMenuInflater;
    }

    @Override
    public void setTheme(int resid) {
        super.setTheme(resid);
        this.mWindow.setTheme(resid);
    }

    @Override
    protected void onApplyThemeResource(Resources.Theme theme, int resid, boolean first) {
        int targetSdk;
        boolean targetPreQ;
        int navigationBarColor;
        int statusBarColor;
        int colorBackgroundFloating;
        int colorBackground;
        int colorPrimary;
        if (this.mParent == null) {
            super.onApplyThemeResource(theme, resid, first);
        } else {
            try {
                theme.setTo(this.mParent.getTheme());
            }
            catch (Exception exception) {
                // empty catch block
            }
            theme.applyStyle(resid, false);
        }
        TypedArray a = theme.obtainStyledAttributes(R.styleable.ActivityTaskDescription);
        if (this.mTaskDescription.getPrimaryColor() == 0 && (colorPrimary = a.getColor(1, 0)) != 0 && Color.alpha(colorPrimary) == 255) {
            this.mTaskDescription.setPrimaryColor(colorPrimary);
        }
        if ((colorBackground = a.getColor(0, 0)) != 0 && Color.alpha(colorBackground) == 255) {
            this.mTaskDescription.setBackgroundColor(colorBackground);
        }
        if ((colorBackgroundFloating = a.getColor(4, 0)) != 0 && Color.alpha(colorBackgroundFloating) == 255) {
            this.mTaskDescription.setBackgroundColorFloating(colorBackgroundFloating);
        }
        if ((statusBarColor = a.getColor(2, 0)) != 0) {
            this.mTaskDescription.setStatusBarColor(statusBarColor);
        }
        if ((navigationBarColor = a.getColor(3, 0)) != 0) {
            this.mTaskDescription.setNavigationBarColor(navigationBarColor);
        }
        boolean bl = targetPreQ = (targetSdk = this.getApplicationInfo().targetSdkVersion) < 29;
        if (!targetPreQ) {
            this.mTaskDescription.setEnsureStatusBarContrastWhenTransparent(a.getBoolean(5, false));
            this.mTaskDescription.setEnsureNavigationBarContrastWhenTransparent(a.getBoolean(6, true));
        }
        a.recycle();
        if (first && this.mTaskDescription.getSystemBarsAppearance() == 0 && this.mWindow != null && this.mWindow.getSystemBarAppearance() != 0) {
            this.mTaskDescription.setSystemBarsAppearance(this.mWindow.getSystemBarAppearance());
        }
        this.setTaskDescription(this.mTaskDescription);
    }

    public void requestPermissions(@NonNull String[] permissions, int requestCode) {
        this.requestPermissions(permissions, requestCode, this.getDeviceId());
    }

    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    public void requestPermissions(@NonNull String[] permissions, int requestCode, int deviceId) {
        Activity context;
        if (this.getApplicationInfo().targetSdkVersion < 23) {
            this.onRequestPermissionsResult(requestCode, new String[0], new int[0], deviceId);
        }
        if (requestCode < 0) {
            throw new IllegalArgumentException("requestCode should be >= 0");
        }
        if (this.mHasCurrentPermissionsRequest) {
            Log.w(TAG, "Can request only one set of permissions at a time");
            this.onRequestPermissionsResult(requestCode, new String[0], new int[0], deviceId);
            return;
        }
        if (!this.getAttributionSource().getRenouncedPermissions().isEmpty()) {
            for (int i = 0; i < permissions.length; ++i) {
                if (!this.getAttributionSource().getRenouncedPermissions().contains(permissions[i])) continue;
                throw new IllegalArgumentException("Cannot request renounced permission: " + permissions[i]);
            }
        }
        Context context2 = context = this.getDeviceId() == deviceId ? this : this.createDeviceContext(deviceId);
        if (com.android.internal.hidden_from_bootclasspath.android.permission.flags.Flags.permissionRequestShortCircuitEnabled()) {
            int[] permissionsState = this.getPermissionRequestStates(context, permissions);
            boolean hasRequestablePermission = false;
            for (int i = 0; i < permissionsState.length; ++i) {
                if (permissionsState[i] != 1) continue;
                hasRequestablePermission = true;
                break;
            }
            if (!hasRequestablePermission) {
                this.mHasCurrentPermissionsRequest = true;
                Log.v(TAG, "No requestable permission in the request.");
                int[] results = new int[permissionsState.length];
                for (int i = 0; i < permissionsState.length; ++i) {
                    results[i] = permissionsState[i] == 0 ? 0 : -1;
                }
                this.mHandler.post(() -> {
                    this.mHasCurrentPermissionsRequest = false;
                    this.onRequestPermissionsResult(requestCode, permissions, results, deviceId);
                });
                return;
            }
        }
        PackageManager packageManager = ((Context)context).getPackageManager();
        Intent intent = packageManager.buildRequestPermissionsIntent(permissions);
        this.startActivityForResult(REQUEST_PERMISSIONS_WHO_PREFIX, intent, requestCode, null);
        this.mHasCurrentPermissionsRequest = true;
    }

    @NonNull
    private int[] getPermissionRequestStates(@NonNull Context deviceContext, @NonNull String[] permissions) {
        int size = permissions.length;
        int[] results = new int[size];
        for (int i = 0; i < size; ++i) {
            results[i] = permissions[i] == null ? 2 : deviceContext.getPermissionRequestState(permissions[i]);
        }
        return results;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
    }

    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults, int deviceId) {
        this.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public boolean shouldShowRequestPermissionRationale(@NonNull String permission2) {
        return this.getPackageManager().shouldShowRequestPermissionRationale(permission2);
    }

    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    @SuppressLint(value={"OnNameExpected"})
    public boolean shouldShowRequestPermissionRationale(@NonNull String permission2, int deviceId) {
        PackageManager packageManager = this.getDeviceId() == deviceId ? this.getPackageManager() : this.createDeviceContext(deviceId).getPackageManager();
        return packageManager.shouldShowRequestPermissionRationale(permission2);
    }

    public void startActivityForResult(@RequiresPermission Intent intent, int requestCode) {
        this.startActivityForResult(intent, requestCode, null);
    }

    public void startActivityForResult(@RequiresPermission Intent intent, int requestCode, @Nullable Bundle options) {
        if (this.mParent == null) {
            options = this.transferSpringboardActivityOptions(options);
            Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivity((Context)this, (IBinder)this.mMainThread.getApplicationThread(), this.mToken, this, intent, requestCode, options);
            if (ar != null) {
                this.mMainThread.sendActivityResult(this.mToken, this.mEmbeddedID, requestCode, ar.getResultCode(), ar.getResultData());
            }
            if (requestCode >= 0) {
                this.mStartedActivity = true;
            }
            this.cancelInputsAndStartExitTransition(options);
        } else if (options != null) {
            this.mParent.startActivityFromChild(this, intent, requestCode, options);
        } else {
            this.mParent.startActivityFromChild(this, intent, requestCode);
        }
    }

    private void cancelInputsAndStartExitTransition(Bundle options) {
        View decor;
        View view = decor = this.mWindow != null ? this.mWindow.peekDecorView() : null;
        if (decor != null) {
            decor.cancelPendingInputEvents();
        }
        if (options != null) {
            this.mActivityTransitionState.startExitOutTransition(this, options);
        }
    }

    public boolean isActivityTransitionRunning() {
        return this.mActivityTransitionState.isTransitionRunning();
    }

    private Bundle transferSpringboardActivityOptions(@Nullable Bundle options) {
        ActivityOptions.SceneTransitionInfo info;
        if (options == null && this.mWindow != null && !this.mWindow.isActive() && (info = this.getSceneTransitionInfo()) != null) {
            return ActivityOptions.makeBasic().setSceneTransitionInfo(info).toBundle();
        }
        return options;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void startActivityForResultAsUser(@NonNull Intent intent, int requestCode, @NonNull UserHandle user) {
        this.startActivityForResultAsUser(intent, requestCode, null, user);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void startActivityForResultAsUser(@NonNull Intent intent, int requestCode, @Nullable Bundle options, @NonNull UserHandle user) {
        this.startActivityForResultAsUser(intent, this.mEmbeddedID, requestCode, options, user);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void startActivityForResultAsUser(@NonNull Intent intent, @NonNull String resultWho, int requestCode, @Nullable Bundle options, @NonNull UserHandle user) {
        if (this.mParent != null) {
            throw new RuntimeException("Can't be called from a child");
        }
        options = this.transferSpringboardActivityOptions(options);
        Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivity(this, this.mMainThread.getApplicationThread(), this.mToken, resultWho, intent, requestCode, options, user);
        if (ar != null) {
            this.mMainThread.sendActivityResult(this.mToken, this.mEmbeddedID, requestCode, ar.getResultCode(), ar.getResultData());
        }
        if (requestCode >= 0) {
            this.mStartedActivity = true;
        }
        this.cancelInputsAndStartExitTransition(options);
    }

    @Override
    public void startActivityAsUser(Intent intent, UserHandle user) {
        this.startActivityAsUser(intent, null, user);
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void startActivityAsUser(@NonNull Intent intent, @Nullable Bundle options, @NonNull UserHandle user) {
        if (this.mParent != null) {
            throw new RuntimeException("Can't be called from a child");
        }
        options = this.transferSpringboardActivityOptions(options);
        Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivity(this, this.mMainThread.getApplicationThread(), this.mToken, this.mEmbeddedID, intent, -1, options, user);
        if (ar != null) {
            this.mMainThread.sendActivityResult(this.mToken, this.mEmbeddedID, -1, ar.getResultCode(), ar.getResultData());
        }
        this.cancelInputsAndStartExitTransition(options);
    }

    public void startActivityAsCaller(Intent intent, @Nullable Bundle options, boolean ignoreTargetSecurity, int userId) {
        this.startActivityAsCaller(intent, options, ignoreTargetSecurity, userId, -1);
    }

    public void startActivityAsCaller(Intent intent, @Nullable Bundle options, boolean ignoreTargetSecurity, int userId, int requestCode) {
        if (this.mParent != null) {
            throw new RuntimeException("Can't be called from a child");
        }
        options = this.transferSpringboardActivityOptions(options);
        Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivityAsCaller(this, this.mMainThread.getApplicationThread(), this.mToken, this, intent, requestCode, options, ignoreTargetSecurity, userId);
        if (ar != null) {
            this.mMainThread.sendActivityResult(this.mToken, this.mEmbeddedID, requestCode, ar.getResultCode(), ar.getResultData());
        }
        this.cancelInputsAndStartExitTransition(options);
    }

    public void startIntentSenderForResult(IntentSender intent, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
        this.startIntentSenderForResult(intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, null);
    }

    public void startIntentSenderForResult(IntentSender intent, String who, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, Bundle options) throws IntentSender.SendIntentException {
        this.startIntentSenderForResultInner(intent, who, requestCode, fillInIntent, flagsMask, flagsValues, options);
    }

    public void startIntentSenderForResult(IntentSender intent, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
        if (this.mParent == null) {
            this.startIntentSenderForResultInner(intent, this.mEmbeddedID, requestCode, fillInIntent, flagsMask, flagsValues, options);
        } else if (options != null) {
            this.mParent.startIntentSenderFromChild(this, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
        } else {
            this.mParent.startIntentSenderFromChild(this, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags);
        }
    }

    public void startIntentSenderForResultInner(IntentSender intent, String who, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, @Nullable Bundle options) throws IntentSender.SendIntentException {
        try {
            int result;
            options = this.transferSpringboardActivityOptions(options);
            String resolvedType = null;
            if (fillInIntent != null) {
                fillInIntent.migrateExtraStreamToClipData(this);
                fillInIntent.prepareToLeaveProcess(this);
                resolvedType = fillInIntent.resolveTypeIfNeeded(this.getContentResolver());
            }
            if ((result = ActivityTaskManager.getService().startActivityIntentSender(this.mMainThread.getApplicationThread(), intent != null ? intent.getTarget() : null, intent != null ? intent.getWhitelistToken() : null, fillInIntent, resolvedType, this.mToken, who, requestCode, flagsMask, flagsValues, options)) == -96) {
                throw new IntentSender.SendIntentException();
            }
            Instrumentation.checkStartActivityResult(result, null);
            if (options != null) {
                this.cancelInputsAndStartExitTransition(options);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (requestCode >= 0) {
            this.mStartedActivity = true;
        }
    }

    @Override
    public void startActivity(Intent intent) {
        this.startActivity(intent, null);
    }

    @Override
    public void startActivity(Intent intent, @Nullable Bundle options) {
        this.getAutofillClientController().onStartActivity(intent, this.mIntent);
        if (options != null) {
            this.startActivityForResult(intent, -1, options);
        } else {
            this.startActivityForResult(intent, -1);
        }
    }

    @Override
    public void startActivities(Intent[] intents) {
        this.startActivities(intents, null);
    }

    @Override
    public void startActivities(Intent[] intents, @Nullable Bundle options) {
        this.mInstrumentation.execStartActivities(this, this.mMainThread.getApplicationThread(), this.mToken, this, intents, options);
    }

    @Override
    public void startIntentSender(IntentSender intent, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
        this.startIntentSender(intent, fillInIntent, flagsMask, flagsValues, extraFlags, null);
    }

    @Override
    public void startIntentSender(IntentSender intent, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
        if (options != null) {
            this.startIntentSenderForResult(intent, -1, fillInIntent, flagsMask, flagsValues, extraFlags, options);
        } else {
            this.startIntentSenderForResult(intent, -1, fillInIntent, flagsMask, flagsValues, extraFlags);
        }
    }

    public boolean startActivityIfNeeded(@RequiresPermission @NonNull Intent intent, int requestCode) {
        return this.startActivityIfNeeded(intent, requestCode, null);
    }

    public boolean startActivityIfNeeded(@RequiresPermission @NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        if (Instrumentation.DEBUG_START_ACTIVITY) {
            Log.d("Instrumentation", "startActivity: intent=" + intent + " requestCode=" + requestCode + " options=" + options, new Throwable());
        }
        if (this.mParent == null) {
            int result = 1;
            try {
                Uri referrer = this.onProvideReferrer();
                if (referrer != null) {
                    intent.putExtra("android.intent.extra.REFERRER", referrer);
                }
                intent.migrateExtraStreamToClipData(this);
                intent.prepareToLeaveProcess(this);
                result = ActivityTaskManager.getService().startActivity(this.mMainThread.getApplicationThread(), this.getOpPackageName(), this.getAttributionTag(), intent, intent.resolveTypeIfNeeded(this.getContentResolver()), this.mToken, this.mEmbeddedID, requestCode, 1, null, options);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            Instrumentation.checkStartActivityResult(result, intent);
            if (requestCode >= 0) {
                this.mStartedActivity = true;
            }
            return result != 1;
        }
        throw new UnsupportedOperationException("startActivityIfNeeded can only be called from a top-level activity");
    }

    public boolean startNextMatchingActivity(@RequiresPermission @NonNull Intent intent) {
        return this.startNextMatchingActivity(intent, null);
    }

    public boolean startNextMatchingActivity(@RequiresPermission @NonNull Intent intent, @Nullable Bundle options) {
        if (this.mParent == null) {
            try {
                intent.migrateExtraStreamToClipData(this);
                intent.prepareToLeaveProcess(this);
                return ActivityTaskManager.getService().startNextMatchingActivity(this.mToken, intent, options);
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        throw new UnsupportedOperationException("startNextMatchingActivity can only be called from a top-level activity");
    }

    @Deprecated
    public void startActivityFromChild(@NonNull Activity child, @RequiresPermission Intent intent, int requestCode) {
        this.startActivityFromChild(child, intent, requestCode, null);
    }

    @Deprecated
    public void startActivityFromChild(@NonNull Activity child, @RequiresPermission Intent intent, int requestCode, @Nullable Bundle options) {
        options = this.transferSpringboardActivityOptions(options);
        Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivity((Context)this, (IBinder)this.mMainThread.getApplicationThread(), this.mToken, child, intent, requestCode, options);
        if (ar != null) {
            this.mMainThread.sendActivityResult(this.mToken, child.mEmbeddedID, requestCode, ar.getResultCode(), ar.getResultData());
        }
        this.cancelInputsAndStartExitTransition(options);
    }

    @Deprecated
    public void startActivityFromFragment(@NonNull Fragment fragment, @RequiresPermission Intent intent, int requestCode) {
        this.startActivityFromFragment(fragment, intent, requestCode, null);
    }

    @Deprecated
    public void startActivityFromFragment(@NonNull Fragment fragment, @RequiresPermission Intent intent, int requestCode, @Nullable Bundle options) {
        this.startActivityForResult(fragment.mWho, intent, requestCode, options);
    }

    private void startActivityAsUserFromFragment(@NonNull Fragment fragment, @RequiresPermission Intent intent, int requestCode, @Nullable Bundle options, UserHandle user) {
        this.startActivityForResultAsUser(intent, fragment.mWho, requestCode, options, user);
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void startActivityForResult(String who, Intent intent, int requestCode, @Nullable Bundle options) {
        Uri referrer = this.onProvideReferrer();
        if (referrer != null) {
            intent.putExtra("android.intent.extra.REFERRER", referrer);
        }
        options = this.transferSpringboardActivityOptions(options);
        Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivity((Context)this, (IBinder)this.mMainThread.getApplicationThread(), this.mToken, who, intent, requestCode, options);
        if (ar != null) {
            this.mMainThread.sendActivityResult(this.mToken, who, requestCode, ar.getResultCode(), ar.getResultData());
        }
        this.cancelInputsAndStartExitTransition(options);
    }

    @Override
    public boolean canStartActivityForResult() {
        return true;
    }

    @Deprecated
    public void startIntentSenderFromChild(Activity child, IntentSender intent, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
        this.startIntentSenderFromChild(child, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, null);
    }

    @Deprecated
    public void startIntentSenderFromChild(Activity child, IntentSender intent, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
        this.startIntentSenderForResultInner(intent, child.mEmbeddedID, requestCode, fillInIntent, flagsMask, flagsValues, options);
    }

    private void startIntentSenderFromFragment(Fragment fragment, IntentSender intent, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, @Nullable Bundle options) throws IntentSender.SendIntentException {
        this.startIntentSenderForResultInner(intent, fragment.mWho, requestCode, fillInIntent, flagsMask, flagsValues, options);
    }

    public void overrideActivityTransition(int overrideType, int enterAnim, int exitAnim) {
        this.overrideActivityTransition(overrideType, enterAnim, exitAnim, 0);
    }

    public void overrideActivityTransition(int overrideType, int enterAnim, int exitAnim, int backgroundColor) {
        if (overrideType != 0 && overrideType != 1) {
            throw new IllegalArgumentException("Override type must be either open or close");
        }
        ActivityClient.getInstance().overrideActivityTransition(this.mToken, overrideType == 0, enterAnim, exitAnim, backgroundColor);
    }

    public void clearOverrideActivityTransition(int overrideType) {
        if (overrideType != 0 && overrideType != 1) {
            throw new IllegalArgumentException("Override type must be either open or close");
        }
        ActivityClient.getInstance().clearOverrideActivityTransition(this.mToken, overrideType == 0);
    }

    @Deprecated
    public void overridePendingTransition(int enterAnim, int exitAnim) {
        this.overridePendingTransition(enterAnim, exitAnim, 0);
    }

    @Deprecated
    public void overridePendingTransition(int enterAnim, int exitAnim, int backgroundColor) {
        ActivityClient.getInstance().overridePendingTransition(this.mToken, this.getPackageName(), enterAnim, exitAnim, backgroundColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(int resultCode) {
        Activity activity = this;
        synchronized (activity) {
            this.mResultCode = resultCode;
            this.mResultData = null;
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void setForceSendResultForMediaProjection() {
        ActivityClient.getInstance().setForceSendResultForMediaProjection(this.mToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(int resultCode, Intent data) {
        Activity activity = this;
        synchronized (activity) {
            this.mResultCode = resultCode;
            this.mResultData = data;
        }
    }

    @Nullable
    public Uri getReferrer() {
        Intent intent = this.getIntent();
        if (intent != null) {
            try {
                Uri referrer = intent.getParcelableExtra("android.intent.extra.REFERRER", Uri.class);
                if (referrer != null) {
                    return referrer;
                }
                String referrerName = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
                if (referrerName != null) {
                    return Uri.parse(referrerName);
                }
            }
            catch (BadParcelableException e) {
                Log.w(TAG, "Cannot read referrer from intent; intent extras contain unknown custom Parcelable objects");
            }
        }
        if (this.mReferrer != null) {
            return new Uri.Builder().scheme("android-app").authority(this.mReferrer).build();
        }
        return null;
    }

    public Uri onProvideReferrer() {
        return null;
    }

    @Nullable
    public String getCallingPackage() {
        return ActivityClient.getInstance().getCallingPackage(this.mToken);
    }

    @Nullable
    public ComponentName getCallingActivity() {
        return ActivityClient.getInstance().getCallingActivity(this.mToken);
    }

    public int getLaunchedFromUid() {
        return ActivityClient.getInstance().getLaunchedFromUid(this.getActivityToken());
    }

    @Nullable
    public String getLaunchedFromPackage() {
        return ActivityClient.getInstance().getLaunchedFromPackage(this.getActivityToken());
    }

    @FlaggedApi(value="android.security.content_uri_permission_apis")
    @SuppressLint(value={"OnNameExpected"})
    @NonNull
    public ComponentCaller getInitialCaller() {
        return this.mInitialCaller;
    }

    @FlaggedApi(value="android.security.content_uri_permission_apis")
    @SuppressLint(value={"OnNameExpected"})
    @NonNull
    public ComponentCaller getCurrentCaller() {
        if (this.mCurrentCaller == null) {
            throw new IllegalStateException("The caller is null because #getCurrentCaller should be called within #onNewIntent or #onActivityResult methods");
        }
        return this.mCurrentCaller;
    }

    public void setVisible(boolean visible) {
        if (this.mVisibleFromClient != visible) {
            this.mVisibleFromClient = visible;
            if (this.mVisibleFromServer) {
                if (visible) {
                    this.makeVisible();
                } else {
                    this.mDecor.setVisibility(4);
                }
            }
        }
    }

    void makeVisible() {
        if (!this.mWindowAdded) {
            WindowManager wm = this.getWindowManager();
            wm.addView(this.mDecor, this.getWindow().getAttributes());
            this.mWindowAdded = true;
        }
        this.mDecor.setVisibility(0);
    }

    public boolean isFinishing() {
        return this.mFinished;
    }

    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    public boolean isChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    public void recreate() {
        if (this.mParent != null) {
            throw new IllegalStateException("Can only be called on top-level activity");
        }
        if (Looper.myLooper() != this.mMainThread.getLooper()) {
            throw new IllegalStateException("Must be called from main thread");
        }
        this.mMainThread.scheduleRelaunchActivity(this.mToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void finish(int finishTask) {
        if (Instrumentation.DEBUG_FINISH_ACTIVITY) {
            Log.d("Instrumentation", "finishActivity: finishTask=" + finishTask, new Throwable());
        }
        if (this.mParent == null) {
            Intent resultData;
            int resultCode;
            Activity activity = this;
            synchronized (activity) {
                resultCode = this.mResultCode;
                resultData = this.mResultData;
            }
            if (resultData != null) {
                resultData.prepareToLeaveProcess(this);
            }
            if (ActivityClient.getInstance().finishActivity(this.mToken, resultCode, resultData, finishTask)) {
                this.mFinished = true;
            }
        } else {
            this.mParent.finishFromChild(this);
        }
        this.getAutofillClientController().onActivityFinish(this.mIntent);
    }

    public void finish() {
        this.finish(0);
    }

    public void finishAffinity() {
        if (this.mParent != null) {
            throw new IllegalStateException("Can not be called from an embedded activity");
        }
        if (this.mResultCode != 0 || this.mResultData != null) {
            throw new IllegalStateException("Can not be called to deliver a result");
        }
        if (ActivityClient.getInstance().finishActivityAffinity(this.mToken)) {
            this.mFinished = true;
        }
    }

    @Deprecated
    public void finishFromChild(Activity child) {
        this.finish();
    }

    public void finishAfterTransition() {
        if (!this.mActivityTransitionState.startExitBackTransition(this)) {
            this.finish();
        }
    }

    public void finishActivity(int requestCode) {
        if (this.mParent == null) {
            ActivityClient.getInstance().finishSubActivity(this.mToken, this.mEmbeddedID, requestCode);
        } else {
            this.mParent.finishActivityFromChild(this, requestCode);
        }
    }

    @Deprecated
    public void finishActivityFromChild(@NonNull Activity child, int requestCode) {
        ActivityClient.getInstance().finishSubActivity(this.mToken, child.mEmbeddedID, requestCode);
    }

    public void finishAndRemoveTask() {
        this.finish(1);
    }

    public boolean releaseInstance() {
        return ActivityClient.getInstance().releaseActivityInstance(this.mToken);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    @FlaggedApi(value="android.security.content_uri_permission_apis")
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data, @NonNull ComponentCaller caller) {
        this.onActivityResult(requestCode, resultCode, data);
    }

    public void onActivityReenter(int resultCode, Intent data) {
    }

    public PendingIntent createPendingResult(int requestCode, @NonNull Intent data, int flags) {
        String packageName = this.getPackageName();
        try {
            data.prepareToLeaveProcess(this);
            IIntentSender target = ActivityManager.getService().getIntentSenderWithFeature(3, packageName, this.getAttributionTag(), this.mParent == null ? this.mToken : this.mParent.mToken, this.mEmbeddedID, requestCode, new Intent[]{data}, null, flags, null, this.getUserId());
            return target != null ? new PendingIntent(target) : null;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void setRequestedOrientation(int requestedOrientation) {
        if (requestedOrientation == this.mLastRequestedOrientation) {
            return;
        }
        if (this.mParent == null) {
            ActivityClient.getInstance().setRequestedOrientation(this.mToken, requestedOrientation);
        } else {
            this.mParent.setRequestedOrientation(requestedOrientation);
        }
        this.mLastRequestedOrientation = requestedOrientation;
    }

    public int getRequestedOrientation() {
        if (this.mLastRequestedOrientation != -2) {
            return this.mLastRequestedOrientation;
        }
        if (this.mParent == null) {
            return ActivityClient.getInstance().getRequestedOrientation(this.mToken);
        }
        return this.mParent.getRequestedOrientation();
    }

    public int getTaskId() {
        return ActivityClient.getInstance().getTaskForActivity(this.mToken, false);
    }

    public boolean isTaskRoot() {
        return this.mWindowControllerCallback.isTaskRoot();
    }

    public boolean moveTaskToBack(boolean nonRoot) {
        return ActivityClient.getInstance().moveActivityTaskToBack(this.mToken, nonRoot);
    }

    @NonNull
    public String getLocalClassName() {
        String pkg = this.getPackageName();
        String cls = this.mComponent.getClassName();
        int packageLen = pkg.length();
        if (!cls.startsWith(pkg) || cls.length() <= packageLen || cls.charAt(packageLen) != '.') {
            return cls;
        }
        return cls.substring(packageLen + 1);
    }

    public ComponentName getComponentName() {
        return this.mComponent;
    }

    @Override
    public ComponentName contentCaptureClientGetComponentName() {
        return this.getComponentName();
    }

    public SharedPreferences getPreferences(int mode) {
        return this.getSharedPreferences(this.getLocalClassName(), mode);
    }

    public boolean isLaunchedFromBubble() {
        return this.mLaunchedFromBubble;
    }

    private void ensureSearchManager() {
        if (this.mSearchManager != null) {
            return;
        }
        try {
            this.mSearchManager = new SearchManager(this, null);
        }
        catch (ServiceManager.ServiceNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object getSystemService(@NonNull String name) {
        if (this.getBaseContext() == null) {
            throw new IllegalStateException("System services not available to Activities before onCreate()");
        }
        if ("window".equals(name)) {
            return this.mWindowManager;
        }
        if ("search".equals(name)) {
            this.ensureSearchManager();
            return this.mSearchManager;
        }
        return super.getSystemService(name);
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
        this.onTitleChanged(title, this.mTitleColor);
        if (this.mParent != null) {
            this.mParent.onChildTitleChanged(this, title);
        }
    }

    public void setTitle(int titleId) {
        this.setTitle(this.getText(titleId));
    }

    @Deprecated
    public void setTitleColor(int textColor) {
        this.mTitleColor = textColor;
        this.onTitleChanged(this.mTitle, textColor);
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public int getTitleColor() {
        return this.mTitleColor;
    }

    protected void onTitleChanged(CharSequence title, int color2) {
        if (this.mTitleReady) {
            Window win = this.getWindow();
            if (win != null) {
                win.setTitle(title);
                if (color2 != 0) {
                    win.setTitleColor(color2);
                }
            }
            if (this.mActionBar != null) {
                this.mActionBar.setWindowTitle(title);
            }
        }
    }

    protected void onChildTitleChanged(Activity childActivity, CharSequence title) {
    }

    public void setTaskDescription(ActivityManager.TaskDescription taskDescription) {
        if (this.mTaskDescription != taskDescription) {
            this.mTaskDescription.copyFromPreserveHiddenFields(taskDescription);
            if (taskDescription.getIconFilename() == null && taskDescription.getIcon() != null) {
                int size = ActivityManager.getLauncherLargeIconSizeInner(this);
                Bitmap icon = Bitmap.createScaledBitmap(taskDescription.getIcon(), size, size, true);
                this.mTaskDescription.setIcon(Icon.createWithBitmap(icon));
            }
        }
        if (this.mLastTaskDescriptionHashCode == this.mTaskDescription.hashCode()) {
            return;
        }
        this.mLastTaskDescriptionHashCode = this.mTaskDescription.hashCode();
        ActivityClient.getInstance().setTaskDescription(this.mToken, this.mTaskDescription);
    }

    @Deprecated
    public void setProgressBarVisibility(boolean visible) {
        this.getWindow().setFeatureInt(2, visible ? -1 : -2);
    }

    @Deprecated
    public void setProgressBarIndeterminateVisibility(boolean visible) {
        this.getWindow().setFeatureInt(5, visible ? -1 : -2);
    }

    @Deprecated
    public void setProgressBarIndeterminate(boolean indeterminate) {
        this.getWindow().setFeatureInt(2, indeterminate ? -3 : -4);
    }

    @Deprecated
    public void setProgress(int progress) {
        this.getWindow().setFeatureInt(2, progress + 0);
    }

    @Deprecated
    public void setSecondaryProgress(int secondaryProgress) {
        this.getWindow().setFeatureInt(2, secondaryProgress + 20000);
    }

    public void setVolumeControlStream(int streamType) {
        this.getWindow().setVolumeControlStream(streamType);
    }

    public int getVolumeControlStream() {
        return this.getWindow().getVolumeControlStream();
    }

    public void setMediaController(MediaController controller) {
        this.getWindow().setMediaController(controller);
    }

    public MediaController getMediaController() {
        return this.getWindow().getMediaController();
    }

    public void runOnUiThread(Runnable action) {
        if (Thread.currentThread() != this.mUiThread) {
            this.mHandler.post(action);
        } else {
            action.run();
        }
    }

    @Override
    @Nullable
    public View onCreateView(@NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        return null;
    }

    @Override
    @Nullable
    public View onCreateView(@Nullable View parent, @NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        if (!"fragment".equals(name)) {
            return this.onCreateView(name, context, attrs);
        }
        return this.mFragments.onCreateView(parent, name, context, attrs);
    }

    public void dump(@NonNull String prefix, @Nullable FileDescriptor fd, @NonNull PrintWriter writer, @Nullable String[] args) {
        this.dumpInner(prefix, fd, writer, args);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean addDumpable(@NonNull Dumpable dumpable) {
        if (this.mDumpableContainer == null) {
            this.mDumpableContainer = new DumpableContainerImpl();
        }
        return this.mDumpableContainer.addDumpable(dumpable);
    }

    @VisibleForTesting
    @SuppressLint(value={"OnNameExpected"})
    public void dumpInternal(@NonNull String prefix, @SuppressLint(value={"UseParcelFileDescriptor"}) @Nullable FileDescriptor fd, @NonNull PrintWriter writer, @Nullable String[] args) {
        if (this.mAutofillClientController != null) {
            this.addDumpable(this.mAutofillClientController);
        }
        if (this.mUiTranslationController != null) {
            this.addDumpable(this.mUiTranslationController);
        }
        if (this.mContentCaptureManager != null) {
            this.mContentCaptureManager.addDumpable(this);
        }
        boolean dumpInternalState = true;
        String arg = null;
        if (args != null && args.length > 0) {
            arg = args[0];
            boolean isSpecialCase = true;
            switch (arg) {
                case "--autofill": {
                    this.dumpLegacyDumpable(prefix, writer, arg, "AutofillManager");
                    return;
                }
                case "--contentcapture": {
                    this.dumpLegacyDumpable(prefix, writer, arg, "ContentCaptureManager");
                    return;
                }
                case "--translation": {
                    this.dumpLegacyDumpable(prefix, writer, arg, "UiTranslationController");
                    return;
                }
                case "--list-dumpables": {
                    if (this.mDumpableContainer == null) {
                        writer.print(prefix);
                        writer.println("No dumpables");
                    } else {
                        this.mDumpableContainer.listDumpables(prefix, writer);
                    }
                    return;
                }
                case "--dump-dumpable": {
                    if (args.length == 1) {
                        writer.print(DUMP_ARG_DUMP_DUMPABLE);
                        writer.println(" requires the dumpable name");
                        break;
                    }
                    if (this.mDumpableContainer == null) {
                        writer.println("no dumpables");
                        break;
                    }
                    String[] prunedArgs = new String[args.length - 2];
                    System.arraycopy(args, 2, prunedArgs, 0, prunedArgs.length);
                    this.mDumpableContainer.dumpOneDumpable(prefix, writer, args[1], prunedArgs);
                    break;
                }
                default: {
                    isSpecialCase = false;
                }
            }
            if (isSpecialCase) {
                boolean bl = dumpInternalState = !CompatChanges.isChangeEnabled(149254050L);
            }
        }
        if (dumpInternalState) {
            this.dump(prefix, fd, writer, args);
        } else {
            Log.i(TAG, "Not calling dump() on " + this + " because of special argument " + arg);
        }
    }

    void dumpInner(@NonNull String prefix, @Nullable FileDescriptor fd, @NonNull PrintWriter writer, @Nullable String[] args) {
        String innerPrefix = prefix + "  ";
        writer.print(prefix);
        writer.print("Local Activity ");
        writer.print(Integer.toHexString(System.identityHashCode(this)));
        writer.println(" State:");
        writer.print(innerPrefix);
        writer.print("mResumed=");
        writer.print(this.mResumed);
        writer.print(" mStopped=");
        writer.print(this.mStopped);
        writer.print(" mFinished=");
        writer.println(this.mFinished);
        writer.print(innerPrefix);
        writer.print("mIsInMultiWindowMode=");
        writer.print(this.mIsInMultiWindowMode);
        writer.print(" mIsInPictureInPictureMode=");
        writer.println(this.mIsInPictureInPictureMode);
        writer.print(innerPrefix);
        writer.print("mChangingConfigurations=");
        writer.println(this.mChangingConfigurations);
        writer.print(innerPrefix);
        writer.print("mCurrentConfig=");
        writer.println(this.mCurrentConfig);
        this.mFragments.dumpLoaders(innerPrefix, fd, writer, args);
        this.mFragments.getFragmentManager().dump(innerPrefix, fd, writer, args);
        if (this.mVoiceInteractor != null) {
            this.mVoiceInteractor.dump(innerPrefix, fd, writer, args);
        }
        if (this.getWindow() != null && this.getWindow().peekDecorView() != null && this.getWindow().peekDecorView().getViewRootImpl() != null) {
            this.getWindow().peekDecorView().getViewRootImpl().dump(prefix, writer);
        }
        this.mHandler.getLooper().dump(new PrintWriterPrinter(writer), prefix);
        ResourcesManager.getInstance().dump(prefix, writer);
        if (this.mDumpableContainer != null) {
            this.mDumpableContainer.dumpAllDumpables(prefix, writer, args);
        }
    }

    private void dumpLegacyDumpable(String prefix, PrintWriter writer, String legacyOption, String dumpableName) {
        writer.printf("%s%s option deprecated. Use %s %s instead\n", prefix, legacyOption, DUMP_ARG_DUMP_DUMPABLE, dumpableName);
    }

    public boolean isImmersive() {
        return ActivityClient.getInstance().isImmersive(this.mToken);
    }

    boolean isTopOfTask() {
        if (this.mToken == null || this.mWindow == null) {
            return false;
        }
        return ActivityClient.getInstance().isTopOfTask(this.getActivityToken());
    }

    public boolean setTranslucent(boolean translucent) {
        if (translucent) {
            return this.convertToTranslucent(null, null);
        }
        return this.convertFromTranslucentInternal();
    }

    @SystemApi
    public void convertFromTranslucent() {
        this.convertFromTranslucentInternal();
    }

    private boolean convertFromTranslucentInternal() {
        this.mTranslucentCallback = null;
        if (ActivityClient.getInstance().convertFromTranslucent(this.mToken)) {
            WindowManagerGlobal.getInstance().changeCanvasOpacity(this.mToken, true);
            return true;
        }
        return false;
    }

    @SystemApi
    public boolean convertToTranslucent(TranslucentConversionListener callback, ActivityOptions options) {
        this.mTranslucentCallback = callback;
        this.mChangeCanvasToTranslucent = ActivityClient.getInstance().convertToTranslucent(this.mToken, options == null ? null : options.toBundle());
        WindowManagerGlobal.getInstance().changeCanvasOpacity(this.mToken, false);
        if (!this.mChangeCanvasToTranslucent && this.mTranslucentCallback != null) {
            this.mTranslucentCallback.onTranslucentConversionComplete(true);
        }
        return this.mChangeCanvasToTranslucent;
    }

    void onTranslucentConversionComplete(boolean drawComplete) {
        if (this.mTranslucentCallback != null) {
            this.mTranslucentCallback.onTranslucentConversionComplete(drawComplete);
            this.mTranslucentCallback = null;
        }
        if (this.mChangeCanvasToTranslucent) {
            WindowManagerGlobal.getInstance().changeCanvasOpacity(this.mToken, false);
        }
    }

    public void onNewSceneTransitionInfo(ActivityOptions.SceneTransitionInfo info) {
        this.mActivityTransitionState.setEnterSceneTransitionInfo(this, info);
        if (!this.mStopped) {
            this.mActivityTransitionState.enterReady(this);
        }
    }

    ActivityOptions.SceneTransitionInfo getSceneTransitionInfo() {
        ActivityOptions.SceneTransitionInfo sceneTransitionInfo = this.mSceneTransitionInfo;
        this.mSceneTransitionInfo = null;
        return sceneTransitionInfo;
    }

    @Deprecated
    public boolean requestVisibleBehind(boolean visible) {
        return false;
    }

    @Deprecated
    public void onVisibleBehindCanceled() {
        this.mCalled = true;
    }

    @Deprecated
    @SystemApi
    public boolean isBackgroundVisibleBehind() {
        return false;
    }

    @Deprecated
    @SystemApi
    public void onBackgroundVisibleBehindChanged(boolean visible) {
    }

    public void onEnterAnimationComplete() {
    }

    public void dispatchEnterAnimationComplete() {
        this.onEnterAnimationComplete();
        if (this.getWindow() != null && this.getWindow().getDecorView() != null) {
            View decorView = this.getWindow().getDecorView();
            decorView.getViewTreeObserver().dispatchOnEnterAnimationComplete();
        }
    }

    public void setImmersive(boolean i) {
        ActivityClient.getInstance().setImmersive(this.mToken, i);
    }

    public void setVrModeEnabled(boolean enabled, @NonNull ComponentName requestedComponent) throws PackageManager.NameNotFoundException {
        if (ActivityClient.getInstance().setVrMode(this.mToken, enabled, requestedComponent) != 0) {
            throw new PackageManager.NameNotFoundException(requestedComponent.flattenToString());
        }
    }

    @Nullable
    public ActionMode startActionMode(ActionMode.Callback callback) {
        return this.mWindow.getDecorView().startActionMode(callback);
    }

    @Nullable
    public ActionMode startActionMode(ActionMode.Callback callback, int type) {
        return this.mWindow.getDecorView().startActionMode(callback, type);
    }

    @Override
    @Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        if (this.mActionModeTypeStarting == 0) {
            this.initWindowDecorActionBar();
            if (this.mActionBar != null) {
                return this.mActionBar.startActionMode(callback);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback, int type) {
        try {
            this.mActionModeTypeStarting = type;
            ActionMode actionMode = this.onWindowStartingActionMode(callback);
            return actionMode;
        }
        finally {
            this.mActionModeTypeStarting = 0;
        }
    }

    @Override
    public void onActionModeStarted(ActionMode mode) {
    }

    @Override
    public void onActionModeFinished(ActionMode mode) {
    }

    public boolean shouldUpRecreateTask(Intent targetIntent) {
        try {
            PackageManager pm = this.getPackageManager();
            ComponentName cn = targetIntent.getComponent();
            if (cn == null) {
                cn = targetIntent.resolveActivity(pm);
            }
            ActivityInfo info = pm.getActivityInfo(cn, 0);
            if (info.taskAffinity == null) {
                return false;
            }
            return ActivityClient.getInstance().shouldUpRecreateTask(this.mToken, info.taskAffinity);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean navigateUpTo(Intent upIntent) {
        if (this.mParent == null) {
            Intent resultData;
            int resultCode;
            ComponentName destInfo = upIntent.getComponent();
            if (destInfo == null) {
                destInfo = upIntent.resolveActivity(this.getPackageManager());
                if (destInfo == null) {
                    return false;
                }
                upIntent = new Intent(upIntent);
                upIntent.setComponent(destInfo);
            }
            Activity activity = this;
            synchronized (activity) {
                resultCode = this.mResultCode;
                resultData = this.mResultData;
            }
            if (resultData != null) {
                resultData.prepareToLeaveProcess(this);
            }
            upIntent.prepareToLeaveProcess(this);
            String resolvedType = upIntent.resolveTypeIfNeeded(this.getContentResolver());
            return ActivityClient.getInstance().navigateUpTo(this.mToken, upIntent, resolvedType, resultCode, resultData);
        }
        return this.mParent.navigateUpToFromChild(this, upIntent);
    }

    @Deprecated
    public boolean navigateUpToFromChild(Activity child, Intent upIntent) {
        return this.navigateUpTo(upIntent);
    }

    @Nullable
    public Intent getParentActivityIntent() {
        String parentName = this.mActivityInfo.parentActivityName;
        if (TextUtils.isEmpty(parentName)) {
            return null;
        }
        ComponentName target = new ComponentName((Context)this, parentName);
        try {
            ActivityInfo parentInfo = this.getPackageManager().getActivityInfo(target, 0);
            String parentActivity = parentInfo.parentActivityName;
            Intent parentIntent = parentActivity == null ? Intent.makeMainActivity(target) : new Intent().setComponent(target);
            return parentIntent;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "getParentActivityIntent: bad parentActivityName '" + parentName + "' in manifest");
            return null;
        }
    }

    public void setEnterSharedElementCallback(SharedElementCallback callback) {
        if (callback == null) {
            callback = SharedElementCallback.NULL_CALLBACK;
        }
        this.mEnterTransitionListener = callback;
    }

    public void setExitSharedElementCallback(SharedElementCallback callback) {
        if (callback == null) {
            callback = SharedElementCallback.NULL_CALLBACK;
        }
        this.mExitTransitionListener = callback;
    }

    public void postponeEnterTransition() {
        this.mActivityTransitionState.postponeEnterTransition();
    }

    public void startPostponedEnterTransition() {
        this.mActivityTransitionState.startPostponedEnterTransition();
    }

    public DragAndDropPermissions requestDragAndDropPermissions(DragEvent event) {
        DragAndDropPermissions dragAndDropPermissions = DragAndDropPermissions.obtain(event);
        if (dragAndDropPermissions != null && dragAndDropPermissions.take(this.getActivityToken())) {
            return dragAndDropPermissions;
        }
        return null;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    void setParent(Activity parent) {
        this.mParent = parent;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void attach(Context context, ActivityThread aThread, Instrumentation instr, IBinder token, int ident, Application application, Intent intent, ActivityInfo info, CharSequence title, Activity parent, String id2, NonConfigurationInstances lastNonConfigurationInstances, Configuration config, String referrer, IVoiceInteractor voiceInteractor, Window window, ViewRootImpl.ActivityConfigCallback activityConfigCallback, IBinder assistToken, IBinder shareableActivityToken) {
        this.attach(context, aThread, instr, token, ident, application, intent, info, title, parent, id2, lastNonConfigurationInstances, config, referrer, voiceInteractor, window, activityConfigCallback, assistToken, shareableActivityToken, null);
    }

    void attach(Context context, ActivityThread aThread, Instrumentation instr, IBinder token, int ident, Application application, Intent intent, ActivityInfo info, CharSequence title, Activity parent, String id2, NonConfigurationInstances lastNonConfigurationInstances, Configuration config, String referrer, IVoiceInteractor voiceInteractor, Window window, ViewRootImpl.ActivityConfigCallback activityConfigCallback, IBinder assistToken, IBinder shareableActivityToken, IBinder initialCallerInfoAccessToken) {
        this.mIntent = intent;
        this.attachBaseContext(context);
        this.mFragments.attachHost(null);
        this.mActivityInfo = info;
        this.mWindow = new PhoneWindow(this, window, activityConfigCallback);
        this.mWindow.setWindowControllerCallback(this.mWindowControllerCallback);
        this.mWindow.setCallback(this);
        this.mWindow.setOnWindowDismissedCallback(this);
        this.mWindow.getLayoutInflater().setPrivateFactory(this);
        if (info.softInputMode != 0) {
            this.mWindow.setSoftInputMode(info.softInputMode);
        }
        if (info.uiOptions != 0) {
            this.mWindow.setUiOptions(info.uiOptions);
        }
        this.mUiThread = Thread.currentThread();
        this.mMainThread = aThread;
        this.mInstrumentation = instr;
        this.mToken = token;
        this.mAssistToken = assistToken;
        this.mShareableActivityToken = shareableActivityToken;
        this.mIdent = ident;
        this.mApplication = application;
        this.mReferrer = referrer;
        this.mComponent = intent.getComponent();
        this.mTitle = title;
        this.mParent = parent;
        this.mEmbeddedID = id2;
        this.mLastNonConfigurationInstances = lastNonConfigurationInstances;
        if (voiceInteractor != null) {
            this.mVoiceInteractor = lastNonConfigurationInstances != null ? lastNonConfigurationInstances.voiceInteractor : new VoiceInteractor(voiceInteractor, this, this, Looper.myLooper());
        }
        this.mWindow.setWindowManager((WindowManager)context.getSystemService("window"), this.mToken, this.mComponent.flattenToString(), (info.flags & 0x200) != 0);
        if (this.mParent != null) {
            this.mWindow.setContainer(this.mParent.getWindow());
        }
        this.mWindowManager = this.mWindow.getWindowManager();
        this.mCurrentConfig = config;
        this.mWindow.setColorMode(info.colorMode);
        this.mWindow.setPreferMinimalPostProcessing((info.flags & 0x2000000) != 0);
        this.getAutofillClientController().onActivityAttached(application);
        this.setContentCaptureOptions(application.getContentCaptureOptions());
        if (com.android.internal.hidden_from_bootclasspath.android.security.Flags.contentUriPermissionApis()) {
            this.mCaller = this.mInitialCaller = new ComponentCaller(this.getActivityToken(), initialCallerInfoAccessToken);
        }
    }

    @Override
    @UnsupportedAppUsage
    public IBinder getActivityToken() {
        return this.mParent != null ? this.mParent.getActivityToken() : this.mToken;
    }

    public IBinder getAssistToken() {
        return this.mParent != null ? this.mParent.getAssistToken() : this.mAssistToken;
    }

    public IBinder getShareableActivityToken() {
        return this.mParent != null ? this.mParent.getShareableActivityToken() : this.mShareableActivityToken;
    }

    @VisibleForTesting
    public ActivityThread getActivityThread() {
        return this.mMainThread;
    }

    public ActivityInfo getActivityInfo() {
        return this.mActivityInfo;
    }

    void performCreate(Bundle icicle) {
        this.performCreate(icicle, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void performCreate(Bundle icicle, PersistableBundle persistentState) {
        if (Trace.isTagEnabled(32L)) {
            Trace.traceBegin(32L, "performCreate:" + this.mComponent.getClassName());
        }
        this.dispatchActivityPreCreated(icicle);
        this.mCanEnterPictureInPicture = true;
        int windowingMode = this.getResources().getConfiguration().windowConfiguration.getWindowingMode();
        this.mIsInMultiWindowMode = WindowConfiguration.inMultiWindowMode(windowingMode);
        this.mIsInPictureInPictureMode = windowingMode == 2;
        this.mShouldDockBigOverlays = this.getResources().getBoolean(17891660);
        this.restoreHasCurrentPermissionRequest(icicle);
        long startTime = SystemClock.uptimeMillis();
        if (persistentState != null) {
            this.onCreate(icicle, persistentState);
        } else {
            this.onCreate(icicle);
        }
        long duration = SystemClock.uptimeMillis() - startTime;
        EventLogTags.writeWmOnCreateCalled(this.mIdent, this.getComponentName().getClassName(), "performCreate", duration);
        this.mActivityTransitionState.readState(icicle);
        this.mVisibleFromClient = !this.mWindow.getWindowStyle().getBoolean(10, false);
        this.mFragments.dispatchActivityCreated();
        this.mActivityTransitionState.setEnterSceneTransitionInfo(this, this.getSceneTransitionInfo());
        this.dispatchActivityPostCreated(icicle);
        Trace.traceEnd(32L);
    }

    void performNewIntent(@NonNull Intent intent) {
        Trace.traceBegin(32L, "performNewIntent");
        this.mCanEnterPictureInPicture = true;
        this.onNewIntent(intent);
        Trace.traceEnd(32L);
    }

    @FlaggedApi(value="android.security.content_uri_permission_apis")
    void performNewIntent(@NonNull Intent intent, @NonNull ComponentCaller caller) {
        Trace.traceBegin(32L, "performNewIntent");
        this.mCanEnterPictureInPicture = true;
        this.mCurrentCaller = caller;
        this.onNewIntent(intent, caller);
        this.mCurrentCaller = null;
        Trace.traceEnd(32L);
    }

    void performStart(String reason) {
        String dlwarning;
        boolean isAppDebuggable;
        if (Trace.isTagEnabled(32L)) {
            Trace.traceBegin(32L, "performStart:" + this.mComponent.getClassName());
        }
        this.dispatchActivityPreStarted();
        this.mActivityTransitionState.setEnterSceneTransitionInfo(this, this.getSceneTransitionInfo());
        this.mFragments.noteStateNotSaved();
        this.mCalled = false;
        this.mFragments.execPendingActions();
        long startTime = SystemClock.uptimeMillis();
        this.mInstrumentation.callActivityOnStart(this);
        long duration = SystemClock.uptimeMillis() - startTime;
        EventLogTags.writeWmOnStartCalled(this.mIdent, this.getComponentName().getClassName(), reason, duration);
        if (!this.mCalled) {
            throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onStart()");
        }
        this.mFragments.dispatchStart();
        this.mFragments.reportLoaderStart();
        boolean bl = isAppDebuggable = (this.mApplication.getApplicationInfo().flags & 2) != 0;
        if (isAppDebuggable && (dlwarning = Activity.getDlWarning()) != null) {
            String appName = this.getApplicationInfo().loadLabel(this.getPackageManager()).toString();
            String warning = "Detected problems with app native libraries\n(please consult log for detail):\n" + dlwarning;
            if (isAppDebuggable) {
                new AlertDialog.Builder(this).setTitle(appName).setMessage(warning).setPositiveButton(17039370, null).setCancelable(false).show();
            } else {
                Toast.makeText((Context)this, appName + "\n" + warning, 1).show();
            }
        }
        GraphicsEnvironment.getInstance().showAngleInUseDialogBox(this);
        this.mActivityTransitionState.enterReady(this);
        this.dispatchActivityPostStarted();
        Trace.traceEnd(32L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performRestart(boolean start) {
        Trace.traceBegin(32L, "performRestart");
        this.mCanEnterPictureInPicture = true;
        this.mFragments.noteStateNotSaved();
        if (this.mToken != null && this.mParent == null) {
            WindowManagerGlobal.getInstance().setStoppedState(this.mToken, false);
        }
        if (this.mStopped) {
            this.mStopped = false;
            ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
            synchronized (arrayList) {
                int N2 = this.mManagedCursors.size();
                for (int i = 0; i < N2; ++i) {
                    ManagedCursor mc = this.mManagedCursors.get(i);
                    if (!mc.mReleased && !mc.mUpdated) continue;
                    if (!mc.mCursor.requery() && this.getApplicationInfo().targetSdkVersion >= 14) {
                        throw new IllegalStateException("trying to requery an already closed cursor  " + mc.mCursor);
                    }
                    mc.mReleased = false;
                    mc.mUpdated = false;
                }
            }
            this.mCalled = false;
            long startTime = SystemClock.uptimeMillis();
            this.mInstrumentation.callActivityOnRestart(this);
            long duration = SystemClock.uptimeMillis() - startTime;
            EventLogTags.writeWmOnRestartCalled(this.mIdent, this.getComponentName().getClassName(), "performRestart", duration);
            if (!this.mCalled) {
                throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onRestart()");
            }
            if (start) {
                this.performStart("performRestart");
            }
        }
        Trace.traceEnd(32L);
    }

    void performResume(boolean followedByPause, String reason) {
        if (Trace.isTagEnabled(32L)) {
            Trace.traceBegin(32L, "performResume:" + this.mComponent.getClassName());
        }
        this.dispatchActivityPreResumed();
        this.mCanEnterPictureInPicture = true;
        this.mFragments.execPendingActions();
        this.mLastNonConfigurationInstances = null;
        this.getAutofillClientController().onActivityPerformResume(followedByPause);
        this.mCalled = false;
        long startTime = SystemClock.uptimeMillis();
        this.mInstrumentation.callActivityOnResume(this);
        long duration = SystemClock.uptimeMillis() - startTime;
        EventLogTags.writeWmOnResumeCalled(this.mIdent, this.getComponentName().getClassName(), reason, duration);
        if (!this.mCalled) {
            throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onResume()");
        }
        if (!this.mVisibleFromClient && !this.mFinished) {
            Log.w(TAG, "An activity without a UI must call finish() before onResume() completes");
            if (this.getApplicationInfo().targetSdkVersion > 22) {
                throw new IllegalStateException("Activity " + this.mComponent.toShortString() + " did not call finish() prior to onResume() completing");
            }
        }
        this.mCalled = false;
        this.mFragments.dispatchResume();
        this.mFragments.execPendingActions();
        this.onPostResume();
        if (!this.mCalled) {
            throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onPostResume()");
        }
        this.dispatchActivityPostResumed();
        Trace.traceEnd(32L);
    }

    void performPause() {
        if (Trace.isTagEnabled(32L)) {
            Trace.traceBegin(32L, "performPause:" + this.mComponent.getClassName());
        }
        if (this.isTvImplicitEnterPipProhibited()) {
            this.mCanEnterPictureInPicture = false;
        }
        this.dispatchActivityPrePaused();
        this.mDoReportFullyDrawn = false;
        this.mFragments.dispatchPause();
        if (Flags.detailedAppJankMetricsApi()) {
            this.stopAppJankTracking();
        }
        this.mCalled = false;
        long startTime = SystemClock.uptimeMillis();
        this.onPause();
        long duration = SystemClock.uptimeMillis() - startTime;
        EventLogTags.writeWmOnPausedCalled(this.mIdent, this.getComponentName().getClassName(), "performPause", duration);
        this.mResumed = false;
        if (!this.mCalled && this.getApplicationInfo().targetSdkVersion >= 9) {
            throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onPause()");
        }
        this.dispatchActivityPostPaused();
        Trace.traceEnd(32L);
    }

    void performUserLeaving() {
        this.onUserInteraction();
        if (this.isTvImplicitEnterPipProhibited()) {
            this.mCanEnterPictureInPicture = false;
        }
        this.onUserLeaveHint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performStop(boolean preserveWindow, String reason) {
        if (Trace.isTagEnabled(32L)) {
            Trace.traceBegin(32L, "performStop:" + this.mComponent.getClassName());
        }
        this.mDoReportFullyDrawn = false;
        this.mFragments.doLoaderStop(this.mChangingConfigurations);
        this.mCanEnterPictureInPicture = false;
        if (!this.mStopped) {
            this.dispatchActivityPreStopped();
            if (this.mWindow != null) {
                this.mWindow.closeAllPanels();
            }
            if (!preserveWindow && this.mToken != null && this.mParent == null) {
                WindowManagerGlobal.getInstance().setStoppedState(this.mToken, true);
            }
            this.mFragments.dispatchStop();
            this.mCalled = false;
            long startTime = SystemClock.uptimeMillis();
            this.mInstrumentation.callActivityOnStop(this);
            long duration = SystemClock.uptimeMillis() - startTime;
            EventLogTags.writeWmOnStopCalled(this.mIdent, this.getComponentName().getClassName(), reason, duration);
            if (!this.mCalled) {
                throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onStop()");
            }
            ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
            synchronized (arrayList) {
                int N2 = this.mManagedCursors.size();
                for (int i = 0; i < N2; ++i) {
                    ManagedCursor mc = this.mManagedCursors.get(i);
                    if (mc.mReleased) continue;
                    mc.mCursor.deactivate();
                    mc.mReleased = true;
                }
            }
            this.mStopped = true;
            this.dispatchActivityPostStopped();
        }
        this.mResumed = false;
        Trace.traceEnd(32L);
    }

    void performDestroy() {
        if (Trace.isTagEnabled(32L)) {
            Trace.traceBegin(32L, "performDestroy:" + this.mComponent.getClassName());
        }
        this.dispatchActivityPreDestroyed();
        this.mDestroyed = true;
        this.mWindow.destroy();
        this.mFragments.dispatchDestroy();
        long startTime = SystemClock.uptimeMillis();
        this.onDestroy();
        long duration = SystemClock.uptimeMillis() - startTime;
        EventLogTags.writeWmOnDestroyCalled(this.mIdent, this.getComponentName().getClassName(), "performDestroy", duration);
        this.mFragments.doLoaderDestroy();
        if (this.mVoiceInteractor != null) {
            this.mVoiceInteractor.detachActivity();
        }
        this.dispatchActivityPostDestroyed();
        Trace.traceEnd(32L);
    }

    void dispatchMultiWindowModeChanged(boolean isInMultiWindowMode, Configuration newConfig) {
        this.mIsInMultiWindowMode = isInMultiWindowMode;
        this.mFragments.dispatchMultiWindowModeChanged(isInMultiWindowMode, newConfig);
        if (this.mWindow != null) {
            this.mWindow.onMultiWindowModeChanged();
        }
        this.onMultiWindowModeChanged(isInMultiWindowMode, newConfig);
    }

    void dispatchPictureInPictureModeChanged(boolean isInPictureInPictureMode, Configuration newConfig) {
        this.mIsInPictureInPictureMode = isInPictureInPictureMode;
        this.mFragments.dispatchPictureInPictureModeChanged(isInPictureInPictureMode, newConfig);
        if (this.mWindow != null) {
            this.mWindow.onPictureInPictureModeChanged(isInPictureInPictureMode);
        }
        this.onPictureInPictureModeChanged(isInPictureInPictureMode, newConfig);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public boolean isResumed() {
        return this.mResumed;
    }

    private void storeHasCurrentPermissionRequest(Bundle bundle) {
        if (bundle != null && this.mHasCurrentPermissionsRequest) {
            bundle.putBoolean(HAS_CURRENT_PERMISSIONS_REQUEST_KEY, true);
        }
    }

    private void restoreHasCurrentPermissionRequest(Bundle bundle) {
        if (bundle != null) {
            this.mHasCurrentPermissionsRequest = bundle.getBoolean(HAS_CURRENT_PERMISSIONS_REQUEST_KEY, false);
        }
    }

    void dispatchActivityResult(String who, int requestCode, int resultCode, Intent data, ComponentCaller caller, String reason) {
        this.internalDispatchActivityResult(who, requestCode, resultCode, data, caller, reason);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void dispatchActivityResult(String who, int requestCode, int resultCode, Intent data, String reason) {
        if (com.android.internal.hidden_from_bootclasspath.android.security.Flags.contentUriPermissionApis()) {
            this.internalDispatchActivityResult(who, requestCode, resultCode, data, new ComponentCaller(this.getActivityToken(), null), reason);
        } else {
            this.internalDispatchActivityResult(who, requestCode, resultCode, data, null, reason);
        }
    }

    private void internalDispatchActivityResult(String who, int requestCode, int resultCode, Intent data, ComponentCaller caller, String reason) {
        this.mFragments.noteStateNotSaved();
        if (who == null) {
            if (com.android.internal.hidden_from_bootclasspath.android.security.Flags.contentUriPermissionApis()) {
                this.mCurrentCaller = caller;
                this.onActivityResult(requestCode, resultCode, data, caller);
                this.mCurrentCaller = null;
            } else {
                this.onActivityResult(requestCode, resultCode, data);
            }
        } else if (who.startsWith(REQUEST_PERMISSIONS_WHO_PREFIX)) {
            if (TextUtils.isEmpty(who = who.substring(REQUEST_PERMISSIONS_WHO_PREFIX.length()))) {
                this.dispatchRequestPermissionsResult(requestCode, data);
            } else {
                Fragment frag = this.mFragments.findFragmentByWho(who);
                if (frag != null) {
                    this.dispatchRequestPermissionsResultToFragment(requestCode, data, frag);
                }
            }
        } else if (who.startsWith("@android:view:")) {
            ArrayList<ViewRootImpl> views = WindowManagerGlobal.getInstance().getRootViews(this.getActivityToken());
            for (ViewRootImpl viewRoot : views) {
                if (viewRoot.getView() == null || !viewRoot.getView().dispatchActivityResult(who, requestCode, resultCode, data)) continue;
                return;
            }
        } else if (who.startsWith("@android:autoFillAuth:")) {
            this.getAutofillClientController().onDispatchActivityResult(requestCode, resultCode, data);
        } else {
            Fragment frag = this.mFragments.findFragmentByWho(who);
            if (frag != null) {
                frag.onActivityResult(requestCode, resultCode, data);
            }
        }
        EventLogTags.writeWmOnActivityResultCalled(this.mIdent, this.getComponentName().getClassName(), reason);
    }

    public void startLockTask() {
        ActivityClient.getInstance().startLockTaskModeByToken(this.mToken);
    }

    public void stopLockTask() {
        ActivityClient.getInstance().stopLockTaskModeByToken(this.mToken);
    }

    public void showLockTaskEscapeMessage() {
        ActivityClient.getInstance().showLockTaskEscapeMessage(this.mToken);
    }

    public boolean isOverlayWithDecorCaptionEnabled() {
        return this.mWindow.isOverlayWithDecorCaptionEnabled();
    }

    public void setOverlayWithDecorCaptionEnabled(boolean enabled) {
        this.mWindow.setOverlayWithDecorCaptionEnabled(enabled);
    }

    private void dispatchRequestPermissionsResult(int requestCode, Intent data) {
        this.mHasCurrentPermissionsRequest = false;
        String[] permissions = data != null ? data.getStringArrayExtra("android.content.pm.extra.REQUEST_PERMISSIONS_NAMES") : new String[]{};
        int[] grantResults = data != null ? data.getIntArrayExtra("android.content.pm.extra.REQUEST_PERMISSIONS_RESULTS") : new int[]{};
        int deviceId = data != null ? data.getIntExtra("android.content.pm.extra.REQUEST_PERMISSIONS_DEVICE_ID", 0) : 0;
        this.onRequestPermissionsResult(requestCode, permissions, grantResults, deviceId);
    }

    private void dispatchRequestPermissionsResultToFragment(int requestCode, Intent data, Fragment fragment) {
        String[] permissions = data != null ? data.getStringArrayExtra("android.content.pm.extra.REQUEST_PERMISSIONS_NAMES") : new String[]{};
        int[] grantResults = data != null ? data.getIntArrayExtra("android.content.pm.extra.REQUEST_PERMISSIONS_RESULTS") : new int[]{};
        fragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public boolean isVisibleForAutofill() {
        return !this.mStopped;
    }

    @UnsupportedAppUsage(maxTargetSdk=31, publicAlternatives="Use {@link #setRecentsScreenshotEnabled(boolean)} instead.")
    public void setDisablePreviewScreenshots(boolean disable) {
        this.setRecentsScreenshotEnabled(!disable);
    }

    public void setRecentsScreenshotEnabled(boolean enabled) {
        ActivityClient.getInstance().setRecentsScreenshotEnabled(this.mToken, enabled);
    }

    public void setShowWhenLocked(boolean showWhenLocked) {
        ActivityClient.getInstance().setShowWhenLocked(this.mToken, showWhenLocked);
    }

    public void setInheritShowWhenLocked(boolean inheritShowWhenLocked) {
        ActivityClient.getInstance().setInheritShowWhenLocked(this.mToken, inheritShowWhenLocked);
    }

    public void setTurnScreenOn(boolean turnScreenOn) {
        ActivityClient.getInstance().setTurnScreenOn(this.mToken, turnScreenOn);
    }

    @FlaggedApi(value="android.security.asm_restrictions_enabled")
    @SuppressLint(value={"OnNameExpected"})
    public void setAllowCrossUidActivitySwitchFromBelow(boolean allowed) {
        ActivityClient.getInstance().setAllowCrossUidActivitySwitchFromBelow(this.mToken, allowed);
    }

    @RequiresPermission(value="android.permission.CONTROL_REMOTE_APP_TRANSITION_ANIMATIONS")
    public void registerRemoteAnimations(RemoteAnimationDefinition definition) {
        ActivityClient.getInstance().registerRemoteAnimations(this.mToken, definition);
    }

    @RequiresPermission(value="android.permission.CONTROL_REMOTE_APP_TRANSITION_ANIMATIONS")
    public void unregisterRemoteAnimations() {
        ActivityClient.getInstance().unregisterRemoteAnimations(this.mToken);
    }

    public void updateUiTranslationState(int state, TranslationSpec sourceSpec, TranslationSpec targetSpec, List<AutofillId> viewIds, UiTranslationSpec uiTranslationSpec) {
        if (this.mUiTranslationController == null) {
            this.mUiTranslationController = new UiTranslationController(this, this.getApplicationContext());
        }
        this.mUiTranslationController.updateUiTranslationState(state, sourceSpec, targetSpec, viewIds, uiTranslationSpec);
    }

    public void enableTaskLocaleOverride() {
        ActivityClient.getInstance().enableTaskLocaleOverride(this.mToken);
    }

    @RequiresPermission(value="android.permission.INTERNAL_SYSTEM_WINDOW")
    public void setActivityRecordInputSinkEnabled(boolean enabled) {
        ActivityClient.getInstance().setActivityRecordInputSinkEnabled(this.mToken, enabled);
    }

    @NonNull
    public OnBackInvokedDispatcher getOnBackInvokedDispatcher() {
        if (this.mWindow == null) {
            throw new IllegalStateException("OnBackInvokedDispatcher are not available on non-visual activities");
        }
        return this.mWindow.getOnBackInvokedDispatcher();
    }

    @RequiresPermission(value="android.permission.DETECT_SCREEN_CAPTURE")
    public void registerScreenCaptureCallback(@NonNull Executor executor, @NonNull ScreenCaptureCallback callback) {
        if (this.mScreenCaptureCallbackHandler == null) {
            this.mScreenCaptureCallbackHandler = new ScreenCaptureCallbackHandler(this.mToken);
        }
        this.mScreenCaptureCallbackHandler.registerScreenCaptureCallback(executor, callback);
    }

    @RequiresPermission(value="android.permission.DETECT_SCREEN_CAPTURE")
    public void unregisterScreenCaptureCallback(@NonNull ScreenCaptureCallback callback) {
        if (this.mScreenCaptureCallbackHandler != null) {
            this.mScreenCaptureCallbackHandler.unregisterScreenCaptureCallback(callback);
        }
    }

    private void startAppJankTracking() {
        DecorView decorView;
        if (!Flags.detailedAppJankMetricsLoggingEnabled()) {
            return;
        }
        if (this.mApplication.getApplicationInfo().category == -1) {
            return;
        }
        if (this.getWindow() != null && this.getWindow().peekDecorView() != null && (decorView = (DecorView)this.getWindow().peekDecorView()).getVisibility() == 0) {
            decorView.setAppJankStatsCallback(new DecorView.AppJankStatsCallback(){

                @Override
                public JankTracker getAppJankTracker() {
                    return Activity.this.mJankTracker;
                }
            });
            if (this.mJankTracker == null) {
                this.mJankTracker = Flags.viewrootChoreographer() ? new JankTracker(decorView) : new JankTracker(Choreographer.getInstance(), decorView);
            }
            this.mJankTracker.setActivityName(this.getComponentName().getClassName());
            this.mJankTracker.setAppUid(Process.myUid());
            this.mJankTracker.enableAppJankTracking();
        }
    }

    private void stopAppJankTracking() {
        if (!Flags.detailedAppJankMetricsLoggingEnabled()) {
            return;
        }
        if (this.mJankTracker != null) {
            this.mJankTracker.disableAppJankTracking();
        }
    }

    class HostCallbacks
    extends FragmentHostCallback<Activity> {
        public HostCallbacks() {
            super(Activity.this);
        }

        @Override
        public void onDump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            Activity.this.dump(prefix, fd, writer, args);
        }

        @Override
        public boolean onShouldSaveFragmentState(Fragment fragment) {
            return !Activity.this.isFinishing();
        }

        @Override
        public LayoutInflater onGetLayoutInflater() {
            LayoutInflater result = Activity.this.getLayoutInflater();
            if (this.onUseFragmentManagerInflaterFactory()) {
                return result.cloneInContext(Activity.this);
            }
            return result;
        }

        @Override
        public boolean onUseFragmentManagerInflaterFactory() {
            return Activity.this.getApplicationInfo().targetSdkVersion >= 21;
        }

        @Override
        public Activity onGetHost() {
            return Activity.this;
        }

        @Override
        public void onInvalidateOptionsMenu() {
            Activity.this.invalidateOptionsMenu();
        }

        @Override
        public void onStartActivityFromFragment(Fragment fragment, Intent intent, int requestCode, Bundle options) {
            Activity.this.startActivityFromFragment(fragment, intent, requestCode, options);
        }

        @Override
        public void onStartActivityAsUserFromFragment(Fragment fragment, Intent intent, int requestCode, Bundle options, UserHandle user) {
            Activity.this.startActivityAsUserFromFragment(fragment, intent, requestCode, options, user);
        }

        @Override
        public void onStartIntentSenderFromFragment(Fragment fragment, IntentSender intent, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
            if (Activity.this.mParent == null) {
                Activity.this.startIntentSenderForResultInner(intent, fragment.mWho, requestCode, fillInIntent, flagsMask, flagsValues, options);
            } else if (options != null) {
                Activity.this.mParent.startIntentSenderFromFragment(fragment, intent, requestCode, fillInIntent, flagsMask, flagsValues, options);
            }
        }

        @Override
        public void onRequestPermissionsFromFragment(Fragment fragment, String[] permissions, int requestCode) {
            String who = Activity.REQUEST_PERMISSIONS_WHO_PREFIX + fragment.mWho;
            Intent intent = Activity.this.getPackageManager().buildRequestPermissionsIntent(permissions);
            Activity.this.startActivityForResult(who, intent, requestCode, null);
        }

        @Override
        public boolean onHasWindowAnimations() {
            return Activity.this.getWindow() != null;
        }

        @Override
        public int onGetWindowAnimations() {
            Window w = Activity.this.getWindow();
            return w == null ? 0 : w.getAttributes().windowAnimations;
        }

        @Override
        public void onAttachFragment(Fragment fragment) {
            Activity.this.onAttachFragment(fragment);
        }

        @Override
        @Nullable
        public <T extends View> T onFindViewById(int id2) {
            return Activity.this.findViewById(id2);
        }

        @Override
        public boolean onHasView() {
            Window w = Activity.this.getWindow();
            return w != null && w.peekDecorView() != null;
        }
    }

    static class NonConfigurationInstances {
        Object activity;
        HashMap<String, Object> children;
        FragmentManagerNonConfig fragments;
        ArrayMap<String, LoaderManager> loaders;
        VoiceInteractor voiceInteractor;

        NonConfigurationInstances() {
        }
    }

    private static class ManagedDialog {
        Dialog mDialog;
        Bundle mArgs;

        private ManagedDialog() {
        }
    }

    @SystemApi
    public static interface TranslucentConversionListener {
        public void onTranslucentConversionComplete(boolean var1);
    }

    private static class ManagedCursor {
        private final Cursor mCursor;
        private boolean mReleased;
        private boolean mUpdated;

        ManagedCursor(Cursor cursor) {
            this.mCursor = cursor;
            this.mReleased = false;
            this.mUpdated = false;
        }
    }

    private static class RequestFinishCallback
    extends IRequestFinishCallback.Stub {
        private final WeakReference<Activity> mActivityRef;

        RequestFinishCallback(WeakReference<Activity> activityRef) {
            this.mActivityRef = activityRef;
        }

        @Override
        public void requestFinish() {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity != null) {
                activity.mHandler.post(activity::finishAfterTransition);
            }
        }
    }

    public static interface ScreenCaptureCallback {
        public void onScreenCaptured();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface DefaultKeyMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ContentCaptureNotificationType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OverrideTransition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FullscreenModeRequest {
    }
}

