/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.CameraCompatTaskInfo;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class AppCompatTaskInfo
implements Parcelable {
    public int topActivityLetterboxVerticalPosition = -1;
    public int topActivityLetterboxHorizontalPosition = -1;
    public int topActivityLetterboxWidth = -1;
    public int topActivityLetterboxHeight = -1;
    @NonNull
    public final Rect topActivityAppBounds = new Rect();
    @Nullable
    public Rect topActivityLetterboxBounds;
    public CameraCompatTaskInfo cameraCompatTaskInfo = CameraCompatTaskInfo.create();
    private static final int FLAG_UNDEFINED = 0;
    private static final int FLAG_BASE = 1;
    private static final int FLAG_LETTERBOX_EDU_ENABLED = 1;
    private static final int FLAG_ELIGIBLE_FOR_LETTERBOX_EDU = 2;
    private static final int FLAG_LETTERBOXED = 4;
    private static final int FLAG_IN_SIZE_COMPAT = 8;
    private static final int FLAG_LETTERBOX_DOUBLE_TAP_ENABLED = 16;
    private static final int FLAG_IS_FROM_LETTERBOX_DOUBLE_TAP = 32;
    private static final int FLAG_ELIGIBLE_FOR_USER_ASPECT_RATIO_BUTTON = 64;
    private static final int FLAG_FULLSCREEN_OVERRIDE_SYSTEM = 128;
    private static final int FLAG_FULLSCREEN_OVERRIDE_USER = 256;
    public static final int FLAG_HAS_MIN_ASPECT_RATIO_OVERRIDE = 512;
    private static final int FLAG_ENABLE_RESTART_MENU_FOR_DISPLAY_MOVE = 1024;
    public static final int FLAG_OPT_OUT_EDGE_TO_EDGE = 2048;
    private int mTopActivityFlags;
    private static final int FLAGS_ORGANIZER_INTERESTED = 4064;
    private static final int FLAGS_COMPAT_UI_INTERESTED = 4075;
    public static final Parcelable.Creator<AppCompatTaskInfo> CREATOR = new Parcelable.Creator<AppCompatTaskInfo>(){

        @Override
        public AppCompatTaskInfo createFromParcel(Parcel in) {
            return new AppCompatTaskInfo(in);
        }

        public AppCompatTaskInfo[] newArray(int size) {
            return new AppCompatTaskInfo[size];
        }
    };

    private AppCompatTaskInfo() {
    }

    @NonNull
    static AppCompatTaskInfo create() {
        return new AppCompatTaskInfo();
    }

    private AppCompatTaskInfo(Parcel source) {
        this.readFromParcel(source);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean hasCompatUI() {
        return this.isTopActivityInSizeCompat() || this.eligibleForLetterboxEducation() || this.isLetterboxDoubleTapEnabled() || this.eligibleForUserAspectRatioButton() || this.isRestartMenuEnabledForDisplayMove();
    }

    public boolean isTopActivityPillarboxShaped() {
        return this.isTopActivityLetterboxed() && this.topActivityLetterboxWidth <= this.topActivityLetterboxHeight;
    }

    public boolean isLetterboxEducationEnabled() {
        return this.isTopActivityFlagEnabled(1);
    }

    public void setLetterboxEducationEnabled(boolean enable) {
        this.setTopActivityFlag(1, enable);
    }

    public boolean eligibleForLetterboxEducation() {
        return this.isTopActivityFlagEnabled(2);
    }

    public void setEligibleForLetterboxEducation(boolean enable) {
        this.setTopActivityFlag(2, enable);
    }

    public boolean eligibleForUserAspectRatioButton() {
        return this.isTopActivityFlagEnabled(64);
    }

    public void setEligibleForUserAspectRatioButton(boolean enable) {
        this.setTopActivityFlag(64, enable);
    }

    public boolean isLetterboxDoubleTapEnabled() {
        return this.isTopActivityFlagEnabled(16);
    }

    public void setLetterboxDoubleTapEnabled(boolean enable) {
        this.setTopActivityFlag(16, enable);
    }

    public boolean isFromLetterboxDoubleTap() {
        return this.isTopActivityFlagEnabled(32);
    }

    public void setIsFromLetterboxDoubleTap(boolean enable) {
        this.setTopActivityFlag(32, enable);
    }

    public boolean isUserFullscreenOverrideEnabled() {
        return this.isTopActivityFlagEnabled(256);
    }

    public void setUserFullscreenOverrideEnabled(boolean enable) {
        this.setTopActivityFlag(256, enable);
    }

    public boolean isSystemFullscreenOverrideEnabled() {
        return this.isTopActivityFlagEnabled(128);
    }

    public void setSystemFullscreenOverrideEnabled(boolean enable) {
        this.setTopActivityFlag(128, enable);
    }

    public boolean isTopActivityInSizeCompat() {
        return this.isTopActivityFlagEnabled(8);
    }

    public void setTopActivityInSizeCompat(boolean enable) {
        this.setTopActivityFlag(8, enable);
    }

    public boolean isRestartMenuEnabledForDisplayMove() {
        return this.isTopActivityFlagEnabled(1024);
    }

    public void setRestartMenuEnabledForDisplayMove(boolean enable) {
        this.setTopActivityFlag(1024, enable);
    }

    public boolean isTopActivityLetterboxed() {
        return this.isTopActivityFlagEnabled(4);
    }

    public void setTopActivityLetterboxed(boolean enable) {
        this.setTopActivityFlag(4, enable);
    }

    public boolean hasMinAspectRatioOverride() {
        return this.isTopActivityFlagEnabled(512);
    }

    public void setHasMinAspectRatioOverride(boolean enable) {
        this.setTopActivityFlag(512, enable);
    }

    public void setOptOutEdgeToEdge(boolean enable) {
        this.setTopActivityFlag(2048, enable);
    }

    public boolean hasOptOutEdgeToEdge() {
        return this.isTopActivityFlagEnabled(2048);
    }

    public void clearTopActivityFlags() {
        this.mTopActivityFlags = 0;
    }

    public boolean equalsForTaskOrganizer(@Nullable AppCompatTaskInfo that) {
        if (that == null) {
            return false;
        }
        return (this.mTopActivityFlags & 0xFE0) == (that.mTopActivityFlags & 0xFE0) && this.topActivityLetterboxVerticalPosition == that.topActivityLetterboxVerticalPosition && this.topActivityLetterboxWidth == that.topActivityLetterboxWidth && this.topActivityLetterboxHeight == that.topActivityLetterboxHeight && this.topActivityAppBounds.equals(that.topActivityAppBounds) && this.topActivityLetterboxHorizontalPosition == that.topActivityLetterboxHorizontalPosition && this.cameraCompatTaskInfo.equalsForTaskOrganizer(that.cameraCompatTaskInfo);
    }

    public boolean equalsForCompatUi(@Nullable AppCompatTaskInfo that) {
        if (that == null) {
            return false;
        }
        return (this.mTopActivityFlags & 0xFEB) == (that.mTopActivityFlags & 0xFEB) && this.topActivityLetterboxVerticalPosition == that.topActivityLetterboxVerticalPosition && this.topActivityLetterboxHorizontalPosition == that.topActivityLetterboxHorizontalPosition && this.topActivityLetterboxWidth == that.topActivityLetterboxWidth && this.topActivityLetterboxHeight == that.topActivityLetterboxHeight && this.topActivityAppBounds.equals(that.topActivityAppBounds) && this.cameraCompatTaskInfo.equalsForCompatUi(that.cameraCompatTaskInfo);
    }

    void readFromParcel(Parcel source) {
        this.mTopActivityFlags = source.readInt();
        this.topActivityLetterboxVerticalPosition = source.readInt();
        this.topActivityLetterboxHorizontalPosition = source.readInt();
        this.topActivityLetterboxWidth = source.readInt();
        this.topActivityLetterboxHeight = source.readInt();
        this.topActivityAppBounds.set(Objects.requireNonNull(source.readTypedObject(Rect.CREATOR)));
        this.topActivityLetterboxBounds = source.readTypedObject(Rect.CREATOR);
        this.cameraCompatTaskInfo = source.readTypedObject(CameraCompatTaskInfo.CREATOR);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mTopActivityFlags);
        dest.writeInt(this.topActivityLetterboxVerticalPosition);
        dest.writeInt(this.topActivityLetterboxHorizontalPosition);
        dest.writeInt(this.topActivityLetterboxWidth);
        dest.writeInt(this.topActivityLetterboxHeight);
        dest.writeTypedObject(this.topActivityAppBounds, flags);
        dest.writeTypedObject(this.topActivityLetterboxBounds, flags);
        dest.writeTypedObject(this.cameraCompatTaskInfo, flags);
    }

    public String toString() {
        return "AppCompatTaskInfo { topActivityInSizeCompat=" + this.isTopActivityInSizeCompat() + " eligibleForLetterboxEducation= " + this.eligibleForLetterboxEducation() + " isLetterboxEducationEnabled= " + this.isLetterboxEducationEnabled() + " isLetterboxDoubleTapEnabled= " + this.isLetterboxDoubleTapEnabled() + " eligibleForUserAspectRatioButton= " + this.eligibleForUserAspectRatioButton() + " topActivityBoundsLetterboxed= " + this.isTopActivityLetterboxed() + " isFromLetterboxDoubleTap= " + this.isFromLetterboxDoubleTap() + " topActivityLetterboxVerticalPosition= " + this.topActivityLetterboxVerticalPosition + " topActivityLetterboxHorizontalPosition= " + this.topActivityLetterboxHorizontalPosition + " topActivityLetterboxWidth=" + this.topActivityLetterboxWidth + " topActivityLetterboxHeight=" + this.topActivityLetterboxHeight + " topActivityAppBounds=" + this.topActivityAppBounds + " isUserFullscreenOverrideEnabled=" + this.isUserFullscreenOverrideEnabled() + " isSystemFullscreenOverrideEnabled=" + this.isSystemFullscreenOverrideEnabled() + " hasMinAspectRatioOverride=" + this.hasMinAspectRatioOverride() + " topActivityLetterboxBounds=" + this.topActivityLetterboxBounds + " cameraCompatTaskInfo=" + this.cameraCompatTaskInfo.toString() + "}";
    }

    private void setTopActivityFlag(int flag, boolean enable) {
        this.mTopActivityFlags = enable ? this.mTopActivityFlags | flag : this.mTopActivityFlags & ~flag;
    }

    private boolean isTopActivityFlagEnabled(int flag) {
        return (this.mTopActivityFlags & flag) == flag;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TopActivityFlag {
    }
}

