/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.content.ComponentName;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.dreams.IDreamManager;

public class DreamManager {
    private final IDreamManager mService = IDreamManager.Stub.asInterface(ServiceManager.getServiceOrThrow("dreams"));
    private final Context mContext;

    public DreamManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
    }

    public boolean isScreensaverEnabled() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "screensaver_enabled", 0, -2) != 0;
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setScreensaverEnabled(boolean enabled) {
        try {
            this.mService.setScreensaverEnabled(enabled);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public boolean areDreamsSupported() {
        return this.mContext.getResources().getBoolean(17891678);
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void startDream() {
        try {
            this.mService.dream();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void stopDream() {
        try {
            this.mService.awaken();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void setActiveDream(@Nullable ComponentName dreamComponent) {
        ComponentName[] dreams = new ComponentName[]{dreamComponent};
        try {
            this.mService.setDreamComponentsForUser(this.mContext.getUserId(), (ComponentName[])(dreamComponent != null ? dreams : null));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void setSystemDreamComponent(@Nullable ComponentName dreamComponent) {
        try {
            this.mService.setSystemDreamComponent(dreamComponent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void setDreamOverlay(@Nullable ComponentName dreamOverlayComponent) {
        try {
            this.mService.registerDreamOverlayService(dreamOverlayComponent);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.READ_DREAM_STATE")
    public boolean canStartDreaming(boolean isScreenOn) {
        try {
            return this.mService.canStartDreaming(isScreenOn);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    @RequiresPermission(value="android.permission.READ_DREAM_STATE")
    public boolean isDreaming() {
        try {
            return this.mService.isDreaming();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    @FlaggedApi(value="android.service.dreams.dream_handles_being_obscured")
    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void setDreamIsObscured(boolean isObscured) {
        try {
            this.mService.setDreamIsObscured(isObscured);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.service.dreams.allow_dream_when_postured")
    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void setDevicePostured(boolean isPostured) {
        try {
            this.mService.setDevicePostured(isPostured);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

