/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.app.AlarmManager;
import android.app.IAlarmListener;
import android.app.PendingIntent;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.os.WorkSource;

public interface IAlarmManager
extends IInterface {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/apex/jobscheduler/framework/java/android/app/IAlarmManager.aidl:32:1:32:69")
    public void set(String var1, int var2, long var3, long var5, long var7, int var9, PendingIntent var10, IAlarmListener var11, String var12, WorkSource var13, AlarmManager.AlarmClockInfo var14) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/apex/jobscheduler/framework/java/android/app/IAlarmManager.aidl:37:1:37:69")
    @EnforcePermission(value="android.permission.SET_TIME")
    public boolean setTime(long var1) throws RemoteException;

    @EnforcePermission(value="android.permission.SET_TIME_ZONE")
    public void setTimeZone(String var1) throws RemoteException;

    public void remove(PendingIntent var1, IAlarmListener var2) throws RemoteException;

    public void removeAll(String var1) throws RemoteException;

    public long getNextWakeFromIdleTime() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/apex/jobscheduler/framework/java/android/app/IAlarmManager.aidl:44:1:44:69")
    public AlarmManager.AlarmClockInfo getNextAlarmClock(int var1) throws RemoteException;

    public boolean canScheduleExactAlarms(String var1) throws RemoteException;

    public boolean hasScheduleExactAlarm(String var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.DUMP")
    public int getConfigVersion() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAlarmManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.app.IAlarmManager";
        static final int TRANSACTION_set = 1;
        static final int TRANSACTION_setTime = 2;
        static final int TRANSACTION_setTimeZone = 3;
        static final int TRANSACTION_remove = 4;
        static final int TRANSACTION_removeAll = 5;
        static final int TRANSACTION_getNextWakeFromIdleTime = 6;
        static final int TRANSACTION_getNextAlarmClock = 7;
        static final int TRANSACTION_canScheduleExactAlarms = 8;
        static final int TRANSACTION_hasScheduleExactAlarm = 9;
        static final int TRANSACTION_getConfigVersion = 10;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IAlarmManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAlarmManager) {
                return (IAlarmManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "set";
                }
                case 2: {
                    return "setTime";
                }
                case 3: {
                    return "setTimeZone";
                }
                case 4: {
                    return "remove";
                }
                case 5: {
                    return "removeAll";
                }
                case 6: {
                    return "getNextWakeFromIdleTime";
                }
                case 7: {
                    return "getNextAlarmClock";
                }
                case 8: {
                    return "canScheduleExactAlarms";
                }
                case 9: {
                    return "hasScheduleExactAlarm";
                }
                case 10: {
                    return "getConfigVersion";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    long _arg3 = data.readLong();
                    long _arg4 = data.readLong();
                    int _arg5 = data.readInt();
                    PendingIntent _arg6 = data.readTypedObject(PendingIntent.CREATOR);
                    IAlarmListener _arg7 = IAlarmListener.Stub.asInterface(data.readStrongBinder());
                    String _arg8 = data.readString();
                    WorkSource _arg9 = data.readTypedObject(WorkSource.CREATOR);
                    AlarmManager.AlarmClockInfo _arg10 = data.readTypedObject(AlarmManager.AlarmClockInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.set(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    boolean _result = this.setTime(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setTimeZone(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    IAlarmListener _arg1 = IAlarmListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.remove(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeAll(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    long _result = this.getNextWakeFromIdleTime();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    AlarmManager.AlarmClockInfo _result = this.getNextAlarmClock(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.canScheduleExactAlarms(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasScheduleExactAlarm(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    int _result = this.getConfigVersion();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setTime_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.SET_TIME", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setTimeZone_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.SET_TIME_ZONE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getConfigVersion_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.DUMP", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements IAlarmManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(String callingPackage, int type, long triggerAtTime, long windowLength, long interval, int flags, PendingIntent operation, IAlarmListener listener, String listenerTag, WorkSource workSource, AlarmManager.AlarmClockInfo alarmClock) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(type);
                    _data.writeLong(triggerAtTime);
                    _data.writeLong(windowLength);
                    _data.writeLong(interval);
                    _data.writeInt(flags);
                    _data.writeTypedObject(operation, 0);
                    _data.writeStrongInterface(listener);
                    _data.writeString(listenerTag);
                    _data.writeTypedObject(workSource, 0);
                    _data.writeTypedObject(alarmClock, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setTime(long millis) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(millis);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTimeZone(String zone) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(zone);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove(PendingIntent operation, IAlarmListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(operation, 0);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAll(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getNextWakeFromIdleTime() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AlarmManager.AlarmClockInfo getNextAlarmClock(int userId) throws RemoteException {
                AlarmManager.AlarmClockInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AlarmManager.AlarmClockInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canScheduleExactAlarms(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasScheduleExactAlarm(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getConfigVersion() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IAlarmManager {
        @Override
        public void set(String callingPackage, int type, long triggerAtTime, long windowLength, long interval, int flags, PendingIntent operation, IAlarmListener listener, String listenerTag, WorkSource workSource, AlarmManager.AlarmClockInfo alarmClock) throws RemoteException {
        }

        @Override
        public boolean setTime(long millis) throws RemoteException {
            return false;
        }

        @Override
        public void setTimeZone(String zone) throws RemoteException {
        }

        @Override
        public void remove(PendingIntent operation, IAlarmListener listener) throws RemoteException {
        }

        @Override
        public void removeAll(String packageName) throws RemoteException {
        }

        @Override
        public long getNextWakeFromIdleTime() throws RemoteException {
            return 0L;
        }

        @Override
        public AlarmManager.AlarmClockInfo getNextAlarmClock(int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean canScheduleExactAlarms(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasScheduleExactAlarm(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public int getConfigVersion() throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

