/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.ActivityTaskManager;
import android.app.ActivityThread;
import android.app.AppComponentFactory;
import android.app.Application;
import android.app.ComponentCaller;
import android.app.IActivityManager;
import android.app.IAppTask;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IUiAutomationConnection;
import android.app.LoadedApk;
import android.app.UiAutomation;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.hardware.input.InputManagerGlobal;
import android.net.Uri;
import android.os.Bundle;
import android.os.Debug;
import android.os.IBinder;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.PerformanceCollector;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.TestLooperManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.os._Original_Build;
import android.ravenwood.annotation.RavenwoodKeep;
import android.ravenwood.annotation.RavenwoodKeepPartialClass;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.IWindowManager;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManagerGlobal;
import com.android.internal.content.ReferrerIntent;
import com.android.internal.hidden_from_bootclasspath.android.security.Flags;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeoutException;

@RavenwoodKeepPartialClass
public class Instrumentation {
    public static final String REPORT_KEY_IDENTIFIER = "id";
    public static final String REPORT_KEY_STREAMRESULT = "stream";
    public static final String TAG = "Instrumentation";
    private static final long CONNECT_TIMEOUT_MILLIS = 60000L;
    private static final boolean VERBOSE = Log.isLoggable("Instrumentation", 2);
    public static final boolean DEBUG_START_ACTIVITY = _Original_Build.IS_DEBUGGABLE && SystemProperties.getBoolean("persist.wm.debug.start_activity", false);
    static final boolean DEBUG_FINISH_ACTIVITY = _Original_Build.IS_DEBUGGABLE && SystemProperties.getBoolean("persist.wm.debug.finish_activity", false);
    private final Object mSync = new Object();
    private ActivityThread mThread = null;
    private MessageQueue mMessageQueue = null;
    private Context mInstrContext;
    private Context mAppContext;
    private ComponentName mComponent;
    private Thread mRunner;
    private List<ActivityWaiter> mWaitingActivities;
    private List<ActivityMonitor> mActivityMonitors;
    private IInstrumentationWatcher mWatcher;
    private IUiAutomationConnection mUiAutomationConnection;
    private boolean mAutomaticPerformanceSnapshots = false;
    private PerformanceCollector mPerformanceCollector;
    private Bundle mPerfMetrics = new Bundle();
    private UiAutomation mUiAutomation;

    @RavenwoodKeep
    public Instrumentation() {
    }

    @RavenwoodKeep
    private void checkInstrumenting(String method) {
        if (this.mInstrContext == null) {
            throw new RuntimeException(method + " cannot be called outside of instrumented processes");
        }
    }

    @RavenwoodKeep
    public boolean isInstrumenting() {
        return this.mInstrContext != null;
    }

    @RavenwoodKeep
    public void onCreate(Bundle arguments) {
    }

    public void start() {
        if (this.mRunner != null) {
            throw new RuntimeException("Instrumentation already started");
        }
        this.mRunner = new InstrumentationThread("Instr: " + this.getClass().getName());
        this.mRunner.start();
    }

    public void onStart() {
    }

    public boolean onException(Object obj, Throwable e) {
        return false;
    }

    public void sendStatus(int resultCode, Bundle results) {
        if (this.mWatcher != null) {
            try {
                this.mWatcher.instrumentationStatus(this.mComponent, resultCode, results);
            }
            catch (RemoteException e) {
                this.mWatcher = null;
            }
        }
    }

    public void addResults(Bundle results) {
        IActivityManager am = ActivityManager.getService();
        try {
            am.addInstrumentationResults(this.mThread.getApplicationThread(), results);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void finish(int resultCode, Bundle results) {
        if (this.mAutomaticPerformanceSnapshots) {
            this.endPerformanceSnapshot();
        }
        if (this.mPerfMetrics != null) {
            if (results == null) {
                results = new Bundle();
            }
            results.putAll(this.mPerfMetrics);
        }
        if (this.mUiAutomation != null && !this.mUiAutomation.isDestroyed()) {
            this.mUiAutomation.disconnect();
            this.mUiAutomation = null;
        }
        this.mThread.finishInstrumentation(resultCode, results);
    }

    public void setAutomaticPerformanceSnapshots() {
        this.mAutomaticPerformanceSnapshots = true;
        this.mPerformanceCollector = new PerformanceCollector();
    }

    public void startPerformanceSnapshot() {
        if (!this.isProfiling()) {
            this.mPerformanceCollector.beginSnapshot(null);
        }
    }

    public void endPerformanceSnapshot() {
        if (!this.isProfiling()) {
            this.mPerfMetrics = this.mPerformanceCollector.endSnapshot();
        }
    }

    public void onDestroy() {
    }

    @RavenwoodKeep
    public Context getContext() {
        return this.mInstrContext;
    }

    public ComponentName getComponentName() {
        return this.mComponent;
    }

    @RavenwoodKeep
    public Context getTargetContext() {
        return this.mAppContext;
    }

    public String getProcessName() {
        return this.mThread.getProcessName();
    }

    public boolean isProfiling() {
        return this.mThread.isProfiling();
    }

    public void startProfiling() {
        if (this.mThread.isProfiling()) {
            File file = new File(this.mThread.getProfileFilePath());
            file.getParentFile().mkdirs();
            Debug.startMethodTracing(((Object)file).toString(), 0x800000);
        }
    }

    public void stopProfiling() {
        if (this.mThread.isProfiling()) {
            Debug.stopMethodTracing();
        }
    }

    public void setInTouchMode(boolean inTouch) {
        try {
            IWindowManager.Stub.asInterface(ServiceManager.getService("window")).setInTouchModeOnAllDisplays(inTouch);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void resetInTouchMode() {
        boolean defaultInTouchMode = this.getContext().getResources().getBoolean(0x1110131);
        this.setInTouchMode(defaultInTouchMode);
    }

    public void waitForIdle(Runnable recipient) {
        this.mMessageQueue.addIdleHandler(new Idler(recipient));
        this.mThread.getHandler().post(new EmptyRunnable());
    }

    public void waitForIdleSync() {
        this.validateNotAppThread();
        Idler idler = new Idler(null);
        this.mMessageQueue.addIdleHandler(idler);
        this.mThread.getHandler().post(new EmptyRunnable());
        idler.waitForIdle();
    }

    @RavenwoodReplace(blockedBy={ActivityThread.class})
    public void runOnMainSync(Runnable runner) {
        this.validateNotAppThread();
        SyncRunnable sr = new SyncRunnable(runner);
        this.mThread.getHandler().post(sr);
        sr.waitForComplete();
    }

    private void runOnMainSync$ravenwood(Runnable runner) {
        this.validateNotAppThread();
        SyncRunnable sr = new SyncRunnable(runner);
        this.mInstrContext.getMainExecutor().execute(sr);
        sr.waitForComplete();
    }

    boolean isSdkSandboxAllowedToStartActivities() {
        return Process.isSdkSandbox() && this.mThread != null && this.mThread.mBoundApplication != null && this.mThread.mBoundApplication.isSdkInSandbox && this.getContext() != null && this.getContext().checkSelfPermission("android.permission.START_ACTIVITIES_FROM_SDK_SANDBOX") == 0;
    }

    private void adjustIntentForCtsInSdkSandboxInstrumentation(@NonNull Intent intent) {
        if (this.mComponent != null && intent.getComponent() != null && this.getContext().getPackageManager().getSdkSandboxPackageName().equals(intent.getComponent().getPackageName())) {
            intent.setComponent(new ComponentName(this.mComponent.getPackageName(), intent.getComponent().getClassName()));
        }
        intent.setIdentifier(this.mComponent.getPackageName());
    }

    private ActivityInfo resolveActivityInfoForCtsInSandbox(@NonNull Intent intent) {
        this.adjustIntentForCtsInSdkSandboxInstrumentation(intent);
        ActivityInfo ai = intent.resolveActivityInfo(this.getTargetContext().getPackageManager(), 0);
        if (ai != null) {
            ai.processName = this.mThread.getProcessName();
        }
        return ai;
    }

    public Activity startActivitySync(Intent intent) {
        return this.startActivitySync(intent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Activity startActivitySync(@NonNull Intent intent, @Nullable Bundle options) {
        Activity activity;
        if (DEBUG_START_ACTIVITY) {
            Log.d(TAG, "startActivity: intent=" + intent + " options=" + options, new Throwable());
        }
        this.validateNotAppThread();
        Object object = this.mSync;
        synchronized (object) {
            ActivityInfo ai;
            intent = new Intent(intent);
            ActivityInfo activityInfo = ai = this.isSdkSandboxAllowedToStartActivities() ? this.resolveActivityInfoForCtsInSandbox(intent) : intent.resolveActivityInfo(this.getTargetContext().getPackageManager(), 0);
            if (ai == null) {
                throw new RuntimeException("Unable to resolve activity for: " + intent);
            }
            String myProc = this.mThread.getProcessName();
            if (!ai.processName.equals(myProc)) {
                throw new RuntimeException("Intent in process " + myProc + " resolved to different process " + ai.processName + ": " + intent);
            }
            intent.setComponent(new ComponentName(ai.applicationInfo.packageName, ai.name));
            ActivityWaiter aw = new ActivityWaiter(intent);
            if (this.mWaitingActivities == null) {
                this.mWaitingActivities = new ArrayList<ActivityWaiter>();
            }
            this.mWaitingActivities.add(aw);
            this.getTargetContext().startActivity(intent, options);
            do {
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.mWaitingActivities.contains(aw));
            activity = aw.activity;
        }
        try {
            WindowManagerGlobal.getWindowManagerService().syncInputTransactions(true);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(ActivityMonitor monitor) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mActivityMonitors == null) {
                this.mActivityMonitors = new ArrayList<ActivityMonitor>();
            }
            this.mActivityMonitors.add(monitor);
        }
    }

    public ActivityMonitor addMonitor(IntentFilter filter, ActivityResult result, boolean block) {
        ActivityMonitor am = new ActivityMonitor(filter, result, block);
        this.addMonitor(am);
        return am;
    }

    public ActivityMonitor addMonitor(String cls, ActivityResult result, boolean block) {
        ActivityMonitor am = new ActivityMonitor(cls, result, block);
        this.addMonitor(am);
        return am;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkMonitorHit(ActivityMonitor monitor, int minHits) {
        this.waitForIdleSync();
        Object object = this.mSync;
        synchronized (object) {
            if (monitor.getHits() < minHits) {
                return false;
            }
            this.mActivityMonitors.remove(monitor);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity waitForMonitor(ActivityMonitor monitor) {
        Activity activity = monitor.waitForActivity();
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(monitor);
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity waitForMonitorWithTimeout(ActivityMonitor monitor, long timeOut) {
        Activity activity = monitor.waitForActivityWithTimeout(timeOut);
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(monitor);
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitor(ActivityMonitor monitor) {
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(monitor);
        }
    }

    public boolean invokeMenuActionSync(Activity targetActivity, int id2, int flag) {
        class MenuRunnable
        implements Runnable {
            private final Activity activity;
            private final int identifier;
            private final int flags;
            boolean returnValue;

            public MenuRunnable(Instrumentation this$0, Activity _activity, int _identifier, int _flags) {
                this.activity = _activity;
                this.identifier = _identifier;
                this.flags = _flags;
            }

            @Override
            public void run() {
                Window win = this.activity.getWindow();
                this.returnValue = win.performPanelIdentifierAction(0, this.identifier, this.flags);
            }
        }
        MenuRunnable mr = new MenuRunnable(this, targetActivity, id2, flag);
        this.runOnMainSync(mr);
        return mr.returnValue;
    }

    public boolean invokeContextMenuAction(Activity targetActivity, int id2, int flag) {
        this.validateNotAppThread();
        KeyEvent downEvent = new KeyEvent(0, 23);
        this.sendKeySync(downEvent);
        this.waitForIdleSync();
        try {
            Thread.sleep(ViewConfiguration.getLongPressTimeout());
        }
        catch (InterruptedException e) {
            Log.e(TAG, "Could not sleep for long press timeout", e);
            return false;
        }
        KeyEvent upEvent = new KeyEvent(1, 23);
        this.sendKeySync(upEvent);
        this.waitForIdleSync();
        class ContextMenuRunnable
        implements Runnable {
            private final Activity activity;
            private final int identifier;
            private final int flags;
            boolean returnValue;

            public ContextMenuRunnable(Instrumentation this$0, Activity _activity, int _identifier, int _flags) {
                this.activity = _activity;
                this.identifier = _identifier;
                this.flags = _flags;
            }

            @Override
            public void run() {
                Window win = this.activity.getWindow();
                this.returnValue = win.performContextMenuIdentifierAction(this.identifier, this.flags);
            }
        }
        ContextMenuRunnable cmr = new ContextMenuRunnable(this, targetActivity, id2, flag);
        this.runOnMainSync(cmr);
        return cmr.returnValue;
    }

    public void sendStringSync(String text) {
        if (text == null) {
            return;
        }
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(-1);
        KeyEvent[] events = keyCharacterMap.getEvents(text.toCharArray());
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                this.sendKeySync(KeyEvent.changeTimeRepeat(events[i], SystemClock.uptimeMillis(), 0));
            }
        }
    }

    public void sendKeySync(KeyEvent event) {
        this.validateNotAppThread();
        long downTime = event.getDownTime();
        long eventTime = event.getEventTime();
        int source = event.getSource();
        if (source == 0) {
            source = 257;
        }
        if (eventTime == 0L) {
            eventTime = SystemClock.uptimeMillis();
        }
        if (downTime == 0L) {
            downTime = eventTime;
        }
        KeyEvent newEvent = new KeyEvent(event);
        newEvent.setTime(downTime, eventTime);
        newEvent.setSource(source);
        newEvent.setFlags(event.getFlags() | 8);
        this.setDisplayIfNeeded(newEvent);
        InputManagerGlobal.getInstance().injectInputEvent(newEvent, 2);
    }

    private void setDisplayIfNeeded(KeyEvent event) {
        if (!UserManager.isVisibleBackgroundUsersEnabled()) {
            return;
        }
        int eventDisplayId = event.getDisplayId();
        if (eventDisplayId != -1) {
            if (VERBOSE) {
                Log.v(TAG, "setDisplayIfNeeded(" + event + "): not changing display id as it's explicitly set to " + eventDisplayId);
            }
            return;
        }
        UserManager userManager = this.mInstrContext.getSystemService(UserManager.class);
        int userDisplayId = userManager.getMainDisplayIdAssignedToUser();
        if (VERBOSE) {
            Log.v(TAG, "setDisplayIfNeeded(" + event + "): eventDisplayId=" + eventDisplayId + ", user=" + this.mInstrContext.getUser() + ", userDisplayId=" + userDisplayId);
        }
        if (userDisplayId == -1) {
            Log.e(TAG, "setDisplayIfNeeded(" + event + "): UserManager returned INVALID_DISPLAY as display assigned to user " + this.mInstrContext.getUser());
            return;
        }
        event.setDisplayId(userDisplayId);
    }

    public void sendKeyDownUpSync(int keyCode) {
        this.sendKeySync(new KeyEvent(0, keyCode));
        this.sendKeySync(new KeyEvent(1, keyCode));
    }

    public void sendCharacterSync(int keyCode) {
        this.sendKeyDownUpSync(keyCode);
    }

    public void sendPointerSync(MotionEvent event) {
        this.validateNotAppThread();
        if ((event.getSource() & 2) == 0) {
            event.setSource(4098);
        }
        this.syncInputTransactionsAndInjectEventIntoSelf(event);
    }

    private void syncInputTransactionsAndInjectEventIntoSelf(MotionEvent event) {
        boolean syncBefore = event.getAction() == 0 || event.isFromSource(8194);
        boolean syncAfter = event.getAction() == 1;
        try {
            if (syncBefore) {
                WindowManagerGlobal.getWindowManagerService().syncInputTransactions(true);
            }
            InputManagerGlobal.getInstance().injectInputEvent(event, 2, Process.myUid());
            if (syncAfter) {
                WindowManagerGlobal.getWindowManagerService().syncInputTransactions(true);
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void sendTrackballEventSync(MotionEvent event) {
        this.validateNotAppThread();
        if (!event.isFromSource(4)) {
            event.setSource(65540);
        }
        InputManagerGlobal.getInstance().injectInputEvent(event, 2);
    }

    public Application newApplication(ClassLoader cl, String className, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Application app = this.getFactory(context.getPackageName()).instantiateApplication(cl, className);
        app.attach(context);
        return app;
    }

    public static Application newApplication(Class<?> clazz, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Application app = (Application)clazz.newInstance();
        app.attach(context);
        return app;
    }

    public void callApplicationOnCreate(Application app) {
        app.onCreate();
    }

    public Activity newActivity(Class<?> clazz, Context context, IBinder token, Application application, Intent intent, ActivityInfo info, CharSequence title, Activity parent, String id2, Object lastNonConfigurationInstance) throws InstantiationException, IllegalAccessException {
        Activity activity = (Activity)clazz.newInstance();
        ActivityThread aThread = null;
        if (application == null) {
            application = new Application();
        }
        activity.attach(context, aThread, this, token, 0, application, intent, info, title, parent, id2, (Activity.NonConfigurationInstances)lastNonConfigurationInstance, new Configuration(), null, null, null, null, null, null, null);
        return activity;
    }

    public Activity newActivity(ClassLoader cl, String className, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String pkg = intent != null && intent.getComponent() != null ? intent.getComponent().getPackageName() : null;
        return this.getFactory(pkg).instantiateActivity(cl, className, intent);
    }

    private AppComponentFactory getFactory(String pkg) {
        if (pkg == null) {
            Log.e(TAG, "No pkg specified, disabling AppComponentFactory");
            return AppComponentFactory.DEFAULT;
        }
        if (this.mThread == null) {
            Log.e(TAG, "Uninitialized ActivityThread, likely app-created Instrumentation, disabling AppComponentFactory", new Throwable());
            return AppComponentFactory.DEFAULT;
        }
        LoadedApk apk = this.mThread.peekPackageInfo(pkg, true);
        if (apk == null) {
            apk = this.mThread.getSystemContext().mPackageInfo;
        }
        return apk.getAppFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStartActivityResult(int result, @Nullable Bundle options) {
        if (this.mActivityMonitors == null) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            int size = this.mActivityMonitors.size();
            for (int i = 0; i < size; ++i) {
                ActivityMonitor am = this.mActivityMonitors.get(i);
                if (!am.ignoreMatchingSpecificIntents()) continue;
                if (options == null) {
                    options = ActivityOptions.makeBasic().toBundle();
                }
                am.onStartActivityResult(result, options);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prePerformCreate(Activity activity) {
        if (this.mWaitingActivities != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N2 = this.mWaitingActivities.size();
                for (int i = 0; i < N2; ++i) {
                    ActivityWaiter aw = this.mWaitingActivities.get(i);
                    Intent intent = aw.intent;
                    if (!intent.filterEquals(activity.getIntent())) continue;
                    aw.activity = activity;
                    this.mMessageQueue.addIdleHandler(new ActivityGoing(aw));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPerformCreate(Activity activity) {
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N2 = this.mActivityMonitors.size();
                for (int i = 0; i < N2; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    am.match(activity, activity, activity.getIntent());
                }
            }
        }
    }

    public void callActivityOnCreate(Activity activity, Bundle icicle) {
        this.prePerformCreate(activity);
        activity.performCreate(icicle);
        this.postPerformCreate(activity);
    }

    public void callActivityOnCreate(Activity activity, Bundle icicle, PersistableBundle persistentState) {
        this.prePerformCreate(activity);
        activity.performCreate(icicle, persistentState);
        this.postPerformCreate(activity);
    }

    public void callActivityOnDestroy(Activity activity) {
        activity.performDestroy();
    }

    public void callActivityOnRestoreInstanceState(@NonNull Activity activity, @NonNull Bundle savedInstanceState) {
        activity.performRestoreInstanceState(savedInstanceState);
    }

    public void callActivityOnRestoreInstanceState(@NonNull Activity activity, @Nullable Bundle savedInstanceState, @Nullable PersistableBundle persistentState) {
        activity.performRestoreInstanceState(savedInstanceState, persistentState);
    }

    public void callActivityOnPostCreate(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        activity.onPostCreate(savedInstanceState);
    }

    public void callActivityOnPostCreate(@NonNull Activity activity, @Nullable Bundle savedInstanceState, @Nullable PersistableBundle persistentState) {
        activity.onPostCreate(savedInstanceState, persistentState);
    }

    public void callActivityOnNewIntent(Activity activity, Intent intent) {
        if (Flags.contentUriPermissionApis()) {
            activity.performNewIntent(intent, new ComponentCaller(activity.getActivityToken(), null));
        } else {
            activity.performNewIntent(intent);
        }
    }

    @FlaggedApi(value="android.security.content_uri_permission_apis")
    public void callActivityOnNewIntent(@NonNull Activity activity, @NonNull Intent intent, @NonNull ComponentCaller caller) {
        activity.performNewIntent(intent, caller);
    }

    @FlaggedApi(value="android.security.content_uri_permission_apis")
    public void callActivityOnNewIntent(Activity activity, ReferrerIntent intent, @NonNull ComponentCaller caller) {
        this.internalCallActivityOnNewIntent(activity, intent, caller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.security.content_uri_permission_apis")
    private void internalCallActivityOnNewIntent(Activity activity, ReferrerIntent intent, @NonNull ComponentCaller caller) {
        String oldReferrer = activity.mReferrer;
        try {
            if (intent != null) {
                activity.mReferrer = intent.mReferrer;
            }
            Intent newIntent = intent != null ? new Intent(intent) : null;
            this.callActivityOnNewIntent(activity, newIntent, caller);
        }
        finally {
            activity.mReferrer = oldReferrer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void callActivityOnNewIntent(Activity activity, ReferrerIntent intent) {
        if (Flags.contentUriPermissionApis()) {
            this.internalCallActivityOnNewIntent(activity, intent, new ComponentCaller(activity.getActivityToken(), null));
        } else {
            String oldReferrer = activity.mReferrer;
            try {
                if (intent != null) {
                    activity.mReferrer = intent.mReferrer;
                }
                this.callActivityOnNewIntent(activity, intent != null ? new Intent(intent) : null);
            }
            finally {
                activity.mReferrer = oldReferrer;
            }
        }
    }

    public void callActivityOnStart(Activity activity) {
        activity.onStart();
    }

    public void callActivityOnRestart(Activity activity) {
        activity.onRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callActivityOnResume(Activity activity) {
        activity.mResumed = true;
        activity.onResume();
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N2 = this.mActivityMonitors.size();
                for (int i = 0; i < N2; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    am.match(activity, activity, activity.getIntent());
                }
            }
        }
    }

    public void callActivityOnStop(Activity activity) {
        activity.onStop();
    }

    public void callActivityOnSaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        activity.performSaveInstanceState(outState);
    }

    public void callActivityOnSaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState, @NonNull PersistableBundle outPersistentState) {
        activity.performSaveInstanceState(outState, outPersistentState);
    }

    public void callActivityOnPause(Activity activity) {
        activity.performPause();
    }

    public void callActivityOnUserLeaving(Activity activity) {
        activity.performUserLeaving();
    }

    public void callActivityOnPictureInPictureRequested(@NonNull Activity activity) {
        activity.onPictureInPictureRequested();
    }

    @Deprecated
    public void startAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.resetAllCounts();
        Debug.startAllocCounting();
    }

    @Deprecated
    public void stopAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.stopAllocCounting();
    }

    private void addValue(String key, int value, Bundle results) {
        if (results.containsKey(key)) {
            ArrayList<Integer> list = results.getIntegerArrayList(key);
            if (list != null) {
                list.add(value);
            }
        } else {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(value);
            results.putIntegerArrayList(key, list);
        }
    }

    public Bundle getAllocCounts() {
        Bundle results = new Bundle();
        results.putLong("global_alloc_count", Debug.getGlobalAllocCount());
        results.putLong("global_alloc_size", Debug.getGlobalAllocSize());
        results.putLong("global_freed_count", Debug.getGlobalFreedCount());
        results.putLong("global_freed_size", Debug.getGlobalFreedSize());
        results.putLong("gc_invocation_count", Debug.getGlobalGcInvocationCount());
        return results;
    }

    public Bundle getBinderCounts() {
        Bundle results = new Bundle();
        results.putLong("sent_transactions", Debug.getBinderSentTransactions());
        results.putLong("received_transactions", Debug.getBinderReceivedTransactions());
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options) {
        Uri referrer;
        if (DEBUG_START_ACTIVITY) {
            Log.d(TAG, "startActivity: who=" + who + " source=" + target + " intent=" + intent + " requestCode=" + requestCode + " options=" + options, new Throwable());
        }
        Objects.requireNonNull(intent);
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        Uri uri = referrer = target != null ? target.onProvideReferrer() : null;
        if (referrer != null) {
            intent.putExtra("android.intent.extra.REFERRER", referrer);
        }
        if (this.isSdkSandboxAllowedToStartActivities()) {
            this.adjustIntentForCtsInSdkSandboxInstrumentation(intent);
        }
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N2 = this.mActivityMonitors.size();
                for (int i = 0; i < N2; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        if (options == null) {
                            options = ActivityOptions.makeBasic().toBundle();
                        }
                        result = am.onStartActivity(who, intent, options);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return result;
                    }
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return requestCode >= 0 ? am.getResult() : null;
                }
            }
        }
        try {
            intent.migrateExtraStreamToClipData(who);
            intent.prepareToLeaveProcess(who);
            int result = ActivityTaskManager.getService().startActivity(whoThread, who.getOpPackageName(), who.getAttributionTag(), intent, intent.resolveTypeIfNeeded(who.getContentResolver()), token, target != null ? target.mEmbeddedID : null, requestCode, 0, null, options);
            this.notifyStartActivityResult(result, options);
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failure from system", e);
        }
        return null;
    }

    @UnsupportedAppUsage
    public void execStartActivities(Context who, IBinder contextThread, IBinder token, Activity target, Intent[] intents, Bundle options) {
        this.execStartActivitiesAsUser(who, contextThread, token, target, intents, options, who.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int execStartActivitiesAsUser(Context who, IBinder contextThread, IBinder token, Activity target, Intent[] intents, Bundle options, int userId) {
        if (DEBUG_START_ACTIVITY) {
            StringJoiner joiner = new StringJoiner(", ");
            for (Intent i : intents) {
                joiner.add(i.toString());
            }
            Log.d(TAG, "startActivities: who=" + who + " source=" + target + " userId=" + userId + " intents=[" + joiner + "] options=" + options, new Throwable());
        }
        Objects.requireNonNull(intents);
        for (int i = intents.length - 1; i >= 0; --i) {
            Objects.requireNonNull(intents[i]);
        }
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.isSdkSandboxAllowedToStartActivities()) {
            for (Intent intent : intents) {
                this.adjustIntentForCtsInSdkSandboxInstrumentation(intent);
            }
        }
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N2 = this.mActivityMonitors.size();
                for (int i = 0; i < N2; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        if (options == null) {
                            options = ActivityOptions.makeBasic().toBundle();
                        }
                        result = am.onStartActivity(who, intents[0], options);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return -96;
                    }
                    if (!am.match(who, null, intents[0])) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return -96;
                }
            }
        }
        try {
            String[] stringArray = new String[intents.length];
            for (int i = 0; i < intents.length; ++i) {
                intents[i].migrateExtraStreamToClipData(who);
                intents[i].prepareToLeaveProcess(who);
                stringArray[i] = intents[i].resolveTypeIfNeeded(who.getContentResolver());
            }
            int result = ActivityTaskManager.getService().startActivities(whoThread, who.getOpPackageName(), who.getAttributionTag(), intents, stringArray, token, options, userId);
            this.notifyStartActivityResult(result, options);
            Instrumentation.checkStartActivityResult(result, intents[0]);
            return result;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Failure from system", remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, String target, Intent intent, int requestCode, Bundle options) {
        if (DEBUG_START_ACTIVITY) {
            Log.d(TAG, "startActivity: who=" + who + " target=" + target + " intent=" + intent + " requestCode=" + requestCode + " options=" + options, new Throwable());
        }
        Objects.requireNonNull(intent);
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.isSdkSandboxAllowedToStartActivities()) {
            this.adjustIntentForCtsInSdkSandboxInstrumentation(intent);
        }
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N2 = this.mActivityMonitors.size();
                for (int i = 0; i < N2; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        if (options == null) {
                            options = ActivityOptions.makeBasic().toBundle();
                        }
                        result = am.onStartActivity(who, intent, options);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return result;
                    }
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return requestCode >= 0 ? am.getResult() : null;
                }
            }
        }
        try {
            intent.migrateExtraStreamToClipData(who);
            intent.prepareToLeaveProcess(who);
            int result = ActivityTaskManager.getService().startActivity(whoThread, who.getOpPackageName(), who.getAttributionTag(), intent, intent.resolveTypeIfNeeded(who.getContentResolver()), token, target, requestCode, 0, null, options);
            this.notifyStartActivityResult(result, options);
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failure from system", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, String resultWho, Intent intent, int requestCode, Bundle options, UserHandle user) {
        if (DEBUG_START_ACTIVITY) {
            Log.d(TAG, "startActivity: who=" + who + " user=" + user + " intent=" + intent + " requestCode=" + requestCode + " resultWho=" + resultWho + " options=" + options, new Throwable());
        }
        Objects.requireNonNull(intent);
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.isSdkSandboxAllowedToStartActivities()) {
            this.adjustIntentForCtsInSdkSandboxInstrumentation(intent);
        }
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N2 = this.mActivityMonitors.size();
                for (int i = 0; i < N2; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        if (options == null) {
                            options = ActivityOptions.makeBasic().toBundle();
                        }
                        result = am.onStartActivity(who, intent, options);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return result;
                    }
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return requestCode >= 0 ? am.getResult() : null;
                }
            }
        }
        try {
            intent.migrateExtraStreamToClipData(who);
            intent.prepareToLeaveProcess(who);
            int result = ActivityTaskManager.getService().startActivityAsUser(whoThread, who.getOpPackageName(), who.getAttributionTag(), intent, intent.resolveTypeIfNeeded(who.getContentResolver()), token, resultWho, requestCode, 0, null, options, user.getIdentifier());
            this.notifyStartActivityResult(result, options);
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failure from system", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public ActivityResult execStartActivityAsCaller(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options, boolean ignoreTargetSecurity, int userId) {
        if (DEBUG_START_ACTIVITY) {
            Log.d(TAG, "startActivity: who=" + who + " source=" + target + " userId=" + userId + " intent=" + intent + " requestCode=" + requestCode + " ignoreTargetSecurity=" + ignoreTargetSecurity + " options=" + options, new Throwable());
        }
        Objects.requireNonNull(intent);
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.isSdkSandboxAllowedToStartActivities()) {
            this.adjustIntentForCtsInSdkSandboxInstrumentation(intent);
        }
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N2 = this.mActivityMonitors.size();
                for (int i = 0; i < N2; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        if (options == null) {
                            options = ActivityOptions.makeBasic().toBundle();
                        }
                        result = am.onStartActivity(who, intent, options);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return result;
                    }
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return requestCode >= 0 ? am.getResult() : null;
                }
            }
        }
        try {
            intent.migrateExtraStreamToClipData(who);
            intent.prepareToLeaveProcess(who);
            int result = ActivityTaskManager.getService().startActivityAsCaller(whoThread, who.getOpPackageName(), intent, intent.resolveTypeIfNeeded(who.getContentResolver()), token, target != null ? target.mEmbeddedID : null, requestCode, 0, null, options, ignoreTargetSecurity, userId);
            this.notifyStartActivityResult(result, options);
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failure from system", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void execStartActivityFromAppTask(Context who, IBinder contextThread, IAppTask appTask, Intent intent, Bundle options) {
        if (DEBUG_START_ACTIVITY) {
            Log.d(TAG, "startActivity: who=" + who + " intent=" + intent + " options=" + options, new Throwable());
        }
        Objects.requireNonNull(intent);
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.isSdkSandboxAllowedToStartActivities()) {
            this.adjustIntentForCtsInSdkSandboxInstrumentation(intent);
        }
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N2 = this.mActivityMonitors.size();
                for (int i = 0; i < N2; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        if (options == null) {
                            options = ActivityOptions.makeBasic().toBundle();
                        }
                        result = am.onStartActivity(who, intent, options);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return;
                    }
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return;
                }
            }
        }
        try {
            intent.migrateExtraStreamToClipData(who);
            intent.prepareToLeaveProcess(who);
            int result = appTask.startActivity(whoThread.asBinder(), who.getOpPackageName(), who.getAttributionTag(), intent, intent.resolveTypeIfNeeded(who.getContentResolver()), options);
            this.notifyStartActivityResult(result, options);
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failure from system", e);
        }
    }

    void init(ActivityThread thread, Context instrContext, Context appContext, ComponentName component, IInstrumentationWatcher watcher, IUiAutomationConnection uiAutomationConnection) {
        this.mThread = thread;
        this.mThread.getLooper();
        this.mMessageQueue = Looper.myQueue();
        this.mInstrContext = instrContext;
        this.mAppContext = appContext;
        this.mComponent = component;
        this.mWatcher = watcher;
        this.mUiAutomationConnection = uiAutomationConnection;
    }

    void basicInit(ActivityThread thread) {
        this.mThread = thread;
    }

    @RavenwoodKeep
    public void basicInit(Context instrContext, Context appContext, UiAutomation ui) {
        this.mInstrContext = instrContext;
        this.mAppContext = appContext;
        this.mUiAutomation = ui;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static void checkStartActivityResult(int res, Object intent) {
        if (!ActivityManager.isStartResultFatalError(res)) {
            return;
        }
        switch (res) {
            case -92: 
            case -91: {
                if (intent instanceof Intent && ((Intent)intent).getComponent() != null) {
                    throw new ActivityNotFoundException("Unable to find explicit activity class " + ((Intent)intent).getComponent().toShortString() + "; have you declared this activity in your AndroidManifest.xml, or does your intent not match its declared <intent-filter>?");
                }
                throw new ActivityNotFoundException("No Activity found to handle " + intent);
            }
            case -94: {
                throw new SecurityException("Not allowed to start activity " + intent);
            }
            case -93: {
                throw new AndroidRuntimeException("FORWARD_RESULT_FLAG used while also requesting a result");
            }
            case -95: {
                throw new IllegalArgumentException("PendingIntent is not an activity");
            }
            case -97: {
                throw new SecurityException("Starting under voice control not allowed for: " + intent);
            }
            case -99: {
                throw new IllegalStateException("Session calling startVoiceActivity does not match active session");
            }
            case -100: {
                throw new IllegalStateException("Cannot start voice activity on a hidden session");
            }
            case -89: {
                throw new IllegalStateException("Session calling startAssistantActivity does not match active session");
            }
            case -90: {
                throw new IllegalStateException("Cannot start assistant activity on a hidden session");
            }
            case -96: {
                throw new AndroidRuntimeException("Activity could not be started for " + intent);
            }
        }
        throw new AndroidRuntimeException("Unknown error code " + res + " when starting " + intent);
    }

    @RavenwoodKeep
    private void validateNotAppThread() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("This method can not be called from the main application thread");
        }
    }

    @RavenwoodKeep
    public UiAutomation getUiAutomation() {
        return this.getUiAutomation(0);
    }

    @RavenwoodReplace
    public UiAutomation getUiAutomation(int flags) {
        boolean mustCreateNewAutomation;
        boolean bl = mustCreateNewAutomation = this.mUiAutomation == null || this.mUiAutomation.isDestroyed();
        if (this.mUiAutomationConnection != null) {
            if (!mustCreateNewAutomation && this.mUiAutomation.getFlags() == flags) {
                return this.mUiAutomation;
            }
            if (mustCreateNewAutomation) {
                this.mUiAutomation = new UiAutomation(this.getTargetContext(), this.mUiAutomationConnection);
            } else {
                this.mUiAutomation.disconnect();
            }
            if (this.getTargetContext().getApplicationInfo().targetSdkVersion <= 30) {
                this.mUiAutomation.connect(flags);
                return this.mUiAutomation;
            }
            long startUptime = SystemClock.uptimeMillis();
            try {
                this.mUiAutomation.connectWithTimeout(flags, 60000L);
                return this.mUiAutomation;
            }
            catch (TimeoutException e) {
                long waited = SystemClock.uptimeMillis() - startUptime;
                Log.e(TAG, "Unable to connect to UiAutomation. Waited for " + waited + " ms", e);
                this.mUiAutomation.destroy();
                this.mUiAutomation = null;
            }
        }
        return null;
    }

    private UiAutomation getUiAutomation$ravenwood(int flags) {
        return this.mUiAutomation;
    }

    @RavenwoodKeep
    public TestLooperManager acquireLooperManager(Looper looper) {
        this.checkInstrumenting("acquireLooperManager");
        return new TestLooperManager(looper);
    }

    private class InstrumentationThread
    extends Thread {
        public InstrumentationThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                Process.setThreadPriority(-8);
            }
            catch (RuntimeException e) {
                Log.w(Instrumentation.TAG, "Exception setting priority of instrumentation thread " + Process.myTid(), e);
            }
            if (Instrumentation.this.mAutomaticPerformanceSnapshots) {
                Instrumentation.this.startPerformanceSnapshot();
            }
            Instrumentation.this.onStart();
        }
    }

    private static class Idler
    implements MessageQueue.IdleHandler {
        private final Runnable mCallback;
        private boolean mIdle;

        public Idler(Runnable callback) {
            this.mCallback = callback;
            this.mIdle = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean queueIdle() {
            if (this.mCallback != null) {
                this.mCallback.run();
            }
            Idler idler = this;
            synchronized (idler) {
                this.mIdle = true;
                this.notifyAll();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForIdle() {
            Idler idler = this;
            synchronized (idler) {
                while (!this.mIdle) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private static class EmptyRunnable
    implements Runnable {
        private EmptyRunnable() {
        }

        @Override
        public void run() {
        }
    }

    @RavenwoodKeepWholeClass
    private static class SyncRunnable
    implements Runnable {
        private final Runnable mTarget;
        private boolean mComplete;

        public SyncRunnable(Runnable target) {
            this.mTarget = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.mTarget.run();
            SyncRunnable syncRunnable = this;
            synchronized (syncRunnable) {
                this.mComplete = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForComplete() {
            SyncRunnable syncRunnable = this;
            synchronized (syncRunnable) {
                while (!this.mComplete) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private static class ActivityWaiter {
        public final Intent intent;
        public Activity activity;

        public ActivityWaiter(Intent _intent) {
            this.intent = _intent;
        }
    }

    public static class ActivityMonitor {
        private final IntentFilter mWhich;
        private final String mClass;
        private final ActivityResult mResult;
        private final boolean mBlock;
        private final boolean mIgnoreMatchingSpecificIntents;
        int mHits = 0;
        Activity mLastActivity = null;

        public ActivityMonitor(IntentFilter which, ActivityResult result, boolean block) {
            this.mWhich = which;
            this.mClass = null;
            this.mResult = result;
            this.mBlock = block;
            this.mIgnoreMatchingSpecificIntents = false;
        }

        public ActivityMonitor(String cls, ActivityResult result, boolean block) {
            this.mWhich = null;
            this.mClass = cls;
            this.mResult = result;
            this.mBlock = block;
            this.mIgnoreMatchingSpecificIntents = false;
        }

        public ActivityMonitor() {
            this.mWhich = null;
            this.mClass = null;
            this.mResult = null;
            this.mBlock = false;
            this.mIgnoreMatchingSpecificIntents = true;
        }

        boolean ignoreMatchingSpecificIntents() {
            return this.mIgnoreMatchingSpecificIntents;
        }

        public IntentFilter getFilter() {
            return this.mWhich;
        }

        public ActivityResult getResult() {
            return this.mResult;
        }

        public boolean isBlocking() {
            return this.mBlock;
        }

        public int getHits() {
            return this.mHits;
        }

        public Activity getLastActivity() {
            return this.mLastActivity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Activity waitForActivity() {
            ActivityMonitor activityMonitor = this;
            synchronized (activityMonitor) {
                while (this.mLastActivity == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Activity res = this.mLastActivity;
                this.mLastActivity = null;
                return res;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Activity waitForActivityWithTimeout(long timeOut) {
            ActivityMonitor activityMonitor = this;
            synchronized (activityMonitor) {
                if (this.mLastActivity == null) {
                    try {
                        this.wait(timeOut);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.mLastActivity == null) {
                    return null;
                }
                Activity res = this.mLastActivity;
                this.mLastActivity = null;
                return res;
            }
        }

        public ActivityResult onStartActivity(@NonNull Context who, @NonNull Intent intent, @NonNull Bundle options) {
            return this.onStartActivity(intent);
        }

        public ActivityResult onStartActivity(Intent intent) {
            return null;
        }

        public void onStartActivityResult(int result, @NonNull Bundle bOptions) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean match(Context who, Activity activity, Intent intent) {
            if (this.mIgnoreMatchingSpecificIntents) {
                return false;
            }
            ActivityMonitor activityMonitor = this;
            synchronized (activityMonitor) {
                if (this.mWhich != null && this.mWhich.match(who.getContentResolver(), intent, true, Instrumentation.TAG) < 0) {
                    return false;
                }
                if (this.mClass != null) {
                    String cls = null;
                    if (activity != null) {
                        cls = activity.getClass().getName();
                    } else if (intent.getComponent() != null) {
                        cls = intent.getComponent().getClassName();
                    }
                    if (cls == null || !this.mClass.equals(cls)) {
                        return false;
                    }
                }
                if (activity != null) {
                    this.mLastActivity = activity;
                    this.notifyAll();
                }
                return true;
            }
        }
    }

    public static class ActivityResult {
        private final int mResultCode;
        private final Intent mResultData;

        public ActivityResult(int resultCode, Intent resultData) {
            this.mResultCode = resultCode;
            this.mResultData = resultData;
        }

        public int getResultCode() {
            return this.mResultCode;
        }

        public Intent getResultData() {
            return this.mResultData;
        }
    }

    private class ActivityGoing
    implements MessageQueue.IdleHandler {
        private final ActivityWaiter mWaiter;

        public ActivityGoing(ActivityWaiter waiter) {
            this.mWaiter = waiter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean queueIdle() {
            Object object = Instrumentation.this.mSync;
            synchronized (object) {
                Instrumentation.this.mWaitingActivities.remove(this.mWaiter);
                Instrumentation.this.mSync.notifyAll();
            }
            return false;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UiAutomationFlags {
    }
}

