/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.Flags;
import android.app.Notification;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.vibrator.persistence.VibrationXmlParser;
import android.os.vibrator.persistence.VibrationXmlSerializer;
import android.provider.Settings;
import android.service.notification.NotificationListenerService;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlSerializer;

public class NotificationChannel
implements Parcelable {
    private static final String TAG = "NotificationChannel";
    public static final String DEFAULT_CHANNEL_ID = "miscellaneous";
    @FlaggedApi(value="android.service.notification.notification_classification")
    public static final String PROMOTIONS_ID = "android.app.promotions";
    @FlaggedApi(value="android.service.notification.notification_classification")
    public static final String SOCIAL_MEDIA_ID = "android.app.social";
    @FlaggedApi(value="android.service.notification.notification_classification")
    public static final String NEWS_ID = "android.app.news";
    @FlaggedApi(value="android.service.notification.notification_classification")
    public static final String RECS_ID = "android.app.recs";
    @FlaggedApi(value="android.service.notification.notification_classification")
    public static final ArrayList<String> SYSTEM_RESERVED_IDS = new ArrayList<String>(List.of("android.app.news", "android.app.social", "android.app.promotions", "android.app.recs"));
    public static final String CONVERSATION_CHANNEL_ID_FORMAT = "%1$s : %2$s";
    public static final String PLACEHOLDER_CONVERSATION_ID = ":placeholder_id";
    public static final String EDIT_SOUND = "sound";
    public static final String EDIT_VIBRATION = "vibration";
    public static final String EDIT_IMPORTANCE = "importance";
    public static final String EDIT_LOCKED_DEVICE = "locked";
    public static final String EDIT_ZEN = "zen";
    public static final String EDIT_CONVERSATION = "conversation";
    public static final String EDIT_LAUNCHER = "launcher";
    public static final int MAX_TEXT_LENGTH = 1000;
    public static final int MAX_VIBRATION_LENGTH = 500;
    public static final int MAX_SERIALIZED_VIBRATION_LENGTH = 32768;
    private static final String TAG_CHANNEL = "channel";
    private static final String ATT_NAME = "name";
    private static final String ATT_DESC = "desc";
    private static final String ATT_ID = "id";
    private static final String ATT_DELETED = "deleted";
    private static final String ATT_PRIORITY = "priority";
    private static final String ATT_VISIBILITY = "visibility";
    private static final String ATT_IMPORTANCE = "importance";
    private static final String ATT_LIGHTS = "lights";
    private static final String ATT_LIGHT_COLOR = "light_color";
    private static final String ATT_VIBRATION = "vibration";
    private static final String ATT_VIBRATION_EFFECT = "vibration_effect";
    private static final String ATT_VIBRATION_ENABLED = "vibration_enabled";
    private static final String ATT_SOUND = "sound";
    private static final String ATT_USAGE = "usage";
    private static final String ATT_FLAGS = "flags";
    private static final String ATT_CONTENT_TYPE = "content_type";
    private static final String ATT_SHOW_BADGE = "show_badge";
    private static final String ATT_USER_LOCKED = "locked";
    private static final String ATT_FG_SERVICE_SHOWN = "fgservice";
    private static final String ATT_GROUP = "group";
    private static final String ATT_BLOCKABLE_SYSTEM = "blockable_system";
    private static final String ATT_ALLOW_BUBBLE = "allow_bubbles";
    private static final String ATT_ORIG_IMP = "orig_imp";
    private static final String ATT_PARENT_CHANNEL = "parent";
    private static final String ATT_CONVERSATION_ID = "conv_id";
    private static final String ATT_IMP_CONVERSATION = "imp_conv";
    private static final String ATT_DEMOTE = "dem";
    private static final String ATT_DELETED_TIME_MS = "del_time";
    private static final String DELIMITER = ",";
    public static final int USER_LOCKED_PRIORITY = 1;
    public static final int USER_LOCKED_VISIBILITY = 2;
    public static final int USER_LOCKED_IMPORTANCE = 4;
    public static final int USER_LOCKED_LIGHTS = 8;
    public static final int USER_LOCKED_VIBRATION = 16;
    @SystemApi
    public static final int USER_LOCKED_SOUND = 32;
    public static final int USER_LOCKED_SHOW_BADGE = 128;
    public static final int USER_LOCKED_ALLOW_BUBBLE = 256;
    public static final int[] LOCKABLE_FIELDS = new int[]{1, 2, 4, 8, 16, 32, 128, 256};
    public static final int DEFAULT_ALLOW_BUBBLE = -1;
    public static final int ALLOW_BUBBLE_ON = 1;
    public static final int ALLOW_BUBBLE_OFF = 0;
    private static final int DEFAULT_LIGHT_COLOR = 0;
    private static final int DEFAULT_VISIBILITY = -1000;
    private static final int DEFAULT_IMPORTANCE = -1000;
    private static final boolean DEFAULT_DELETED = false;
    private static final boolean DEFAULT_SHOW_BADGE = true;
    private static final long DEFAULT_DELETION_TIME_MS = -1L;
    @UnsupportedAppUsage
    private String mId;
    private String mName;
    private String mDesc;
    private int mImportance = -1000;
    private int mOriginalImportance = -1000;
    private boolean mBypassDnd;
    private int mLockscreenVisibility = -1000;
    private Uri mSound = Settings.System.DEFAULT_NOTIFICATION_URI;
    private boolean mSoundRestored = false;
    private boolean mLights;
    private int mLightColor = 0;
    private long[] mVibrationPattern;
    private VibrationEffect mVibrationEffect;
    private int mUserLockedFields;
    private boolean mUserVisibleTaskShown;
    private boolean mVibrationEnabled;
    private boolean mShowBadge = true;
    private boolean mDeleted = false;
    private String mGroup;
    private AudioAttributes mAudioAttributes = Notification.AUDIO_ATTRIBUTES_DEFAULT;
    private boolean mBlockableSystem = false;
    private int mAllowBubbles = -1;
    private boolean mImportanceLockedDefaultApp;
    private String mParentId = null;
    private String mConversationId = null;
    private boolean mDemoted = false;
    private boolean mImportantConvo = false;
    private long mDeletedTime = -1L;
    private long mLastNotificationUpdateTimeMs = 0L;
    @NonNull
    public static final Parcelable.Creator<NotificationChannel> CREATOR = new Parcelable.Creator<NotificationChannel>(){

        @Override
        public NotificationChannel createFromParcel(Parcel in) {
            return new NotificationChannel(in);
        }

        public NotificationChannel[] newArray(int size) {
            return new NotificationChannel[size];
        }
    };

    public NotificationChannel(String id2, CharSequence name, int importance) {
        this.mId = this.getTrimmedString(id2);
        this.mName = name != null ? this.getTrimmedString(name.toString()) : null;
        this.mImportance = importance;
    }

    protected NotificationChannel(Parcel in) {
        this.mId = in.readByte() != 0 ? this.getTrimmedString(in.readString()) : null;
        this.mName = in.readByte() != 0 ? this.getTrimmedString(in.readString()) : null;
        this.mDesc = in.readByte() != 0 ? this.getTrimmedString(in.readString()) : null;
        this.mImportance = in.readInt();
        this.mBypassDnd = in.readByte() != 0;
        this.mLockscreenVisibility = in.readInt();
        if (in.readByte() != 0) {
            this.mSound = Uri.CREATOR.createFromParcel(in);
            this.mSound = Uri.parse(this.getTrimmedString(this.mSound.toString()));
        } else {
            this.mSound = null;
        }
        this.mLights = in.readByte() != 0;
        this.mUserLockedFields = in.readInt();
        this.mUserVisibleTaskShown = in.readByte() != 0;
        this.mVibrationEnabled = in.readByte() != 0;
        this.mShowBadge = in.readByte() != 0;
        this.mDeleted = in.readByte() != 0;
        this.mGroup = in.readByte() != 0 ? this.getTrimmedString(in.readString()) : null;
        this.mAudioAttributes = in.readInt() > 0 ? AudioAttributes.CREATOR.createFromParcel(in) : null;
        this.mLightColor = in.readInt();
        this.mBlockableSystem = in.readBoolean();
        this.mAllowBubbles = in.readInt();
        this.mOriginalImportance = in.readInt();
        this.mParentId = this.getTrimmedString(in.readString());
        this.mConversationId = this.getTrimmedString(in.readString());
        this.mDemoted = in.readBoolean();
        this.mImportantConvo = in.readBoolean();
        this.mDeletedTime = in.readLong();
        this.mImportanceLockedDefaultApp = in.readBoolean();
        this.mVibrationPattern = in.createLongArray();
        if (this.mVibrationPattern != null && this.mVibrationPattern.length > 500) {
            this.mVibrationPattern = Arrays.copyOf(this.mVibrationPattern, 500);
        }
        boolean largeEffect = false;
        if (Flags.notifChannelEstimateEffectSize()) {
            boolean bl = largeEffect = in.dataAvail() > 32768;
        }
        if (Flags.notificationChannelVibrationEffectApi()) {
            VibrationEffect vibrationEffect = this.mVibrationEffect = in.readInt() != 0 ? VibrationEffect.CREATOR.createFromParcel(in) : null;
            if (Flags.notifChannelCropVibrationEffects() && this.mVibrationEffect != null) {
                if (Flags.notifChannelEstimateEffectSize()) {
                    if (largeEffect) {
                        this.mVibrationEffect = this.mVibrationEffect.cropToLengthOrNull(500);
                    }
                } else {
                    this.mVibrationEffect = this.getTrimmedVibrationEffect(this.mVibrationEffect);
                }
            }
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mId != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mId);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mName != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mName);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mDesc != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mDesc);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeInt(this.mImportance);
        dest.writeByte(this.mBypassDnd ? (byte)1 : 0);
        dest.writeInt(this.mLockscreenVisibility);
        if (this.mSound != null) {
            dest.writeByte((byte)1);
            this.mSound.writeToParcel(dest, 0);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeByte(this.mLights ? (byte)1 : 0);
        dest.writeInt(this.mUserLockedFields);
        dest.writeByte(this.mUserVisibleTaskShown ? (byte)1 : 0);
        dest.writeByte(this.mVibrationEnabled ? (byte)1 : 0);
        dest.writeByte(this.mShowBadge ? (byte)1 : 0);
        dest.writeByte(this.mDeleted ? (byte)1 : 0);
        if (this.mGroup != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mGroup);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mAudioAttributes != null) {
            dest.writeInt(1);
            this.mAudioAttributes.writeToParcel(dest, 0);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mLightColor);
        dest.writeBoolean(this.mBlockableSystem);
        dest.writeInt(this.mAllowBubbles);
        dest.writeInt(this.mOriginalImportance);
        dest.writeString(this.mParentId);
        dest.writeString(this.mConversationId);
        dest.writeBoolean(this.mDemoted);
        dest.writeBoolean(this.mImportantConvo);
        dest.writeLong(this.mDeletedTime);
        dest.writeBoolean(this.mImportanceLockedDefaultApp);
        dest.writeLongArray(this.mVibrationPattern);
        if (Flags.notificationChannelVibrationEffectApi()) {
            if (this.mVibrationEffect != null) {
                dest.writeInt(1);
                this.mVibrationEffect.writeToParcel(dest, 0);
            } else {
                dest.writeInt(0);
            }
        }
    }

    @NonNull
    public NotificationChannel copy() {
        NotificationChannel copy = new NotificationChannel(this.mId, this.mName, this.mImportance);
        copy.setDescription(this.mDesc);
        copy.setBypassDnd(this.mBypassDnd);
        copy.setLockscreenVisibility(this.mLockscreenVisibility);
        copy.setSound(this.mSound, this.mAudioAttributes);
        copy.setLightColor(this.mLightColor);
        copy.enableLights(this.mLights);
        copy.setVibrationPattern(this.mVibrationPattern);
        if (Flags.notificationChannelVibrationEffectApi()) {
            copy.setVibrationEffect(this.mVibrationEffect);
        }
        copy.lockFields(this.mUserLockedFields);
        copy.setUserVisibleTaskShown(this.mUserVisibleTaskShown);
        copy.enableVibration(this.mVibrationEnabled);
        copy.setShowBadge(this.mShowBadge);
        copy.setDeleted(this.mDeleted);
        copy.setGroup(this.mGroup);
        copy.setBlockable(this.mBlockableSystem);
        copy.setAllowBubbles(this.mAllowBubbles);
        copy.setOriginalImportance(this.mOriginalImportance);
        copy.setConversationId(this.mParentId, this.mConversationId);
        copy.setDemoted(this.mDemoted);
        copy.setImportantConversation(this.mImportantConvo);
        copy.setDeletedTimeMs(this.mDeletedTime);
        copy.setImportanceLockedByCriticalDeviceFunction(this.mImportanceLockedDefaultApp);
        copy.setLastNotificationUpdateTimeMs(this.mLastNotificationUpdateTimeMs);
        return copy;
    }

    public void lockFields(int field) {
        this.mUserLockedFields |= field;
    }

    public void unlockFields(int field) {
        this.mUserLockedFields &= ~field;
    }

    public void setUserVisibleTaskShown(boolean shown) {
        this.mUserVisibleTaskShown = shown;
    }

    public void setDeleted(boolean deleted) {
        this.mDeleted = deleted;
    }

    public void setDeletedTimeMs(long time) {
        this.mDeletedTime = time;
    }

    @SystemApi
    @FlaggedApi(value="android.service.notification.notification_conversation_channel_management")
    public void setImportantConversation(boolean importantConvo) {
        this.mImportantConvo = importantConvo;
    }

    public void setBlockable(boolean blockable) {
        this.mBlockableSystem = blockable;
    }

    public void setName(CharSequence name) {
        this.mName = name != null ? this.getTrimmedString(name.toString()) : null;
    }

    public void setDescription(String description) {
        this.mDesc = this.getTrimmedString(description);
    }

    private String getTrimmedString(String input) {
        if (input != null && input.length() > 1000) {
            return input.substring(0, 1000);
        }
        return input;
    }

    private VibrationEffect getTrimmedVibrationEffect(VibrationEffect effect) {
        if (effect == null) {
            return null;
        }
        VibrationEffect result = effect;
        VibrationEffect trimmed = effect.cropToLengthOrNull(500);
        if (trimmed != null) {
            result = trimmed;
        }
        if (NotificationChannel.vibrationToString(result).length() > 32768) {
            return null;
        }
        return result;
    }

    public void setId(String id2) {
        this.mId = id2;
    }

    public void setGroup(String groupId) {
        this.mGroup = groupId;
    }

    public void setShowBadge(boolean showBadge) {
        this.mShowBadge = showBadge;
    }

    public void setSound(Uri sound, AudioAttributes audioAttributes) {
        this.mSound = sound;
        this.mAudioAttributes = audioAttributes;
    }

    public void enableLights(boolean lights) {
        this.mLights = lights;
    }

    public void setLightColor(int argb) {
        this.mLightColor = argb;
    }

    public void enableVibration(boolean vibration) {
        this.mVibrationEnabled = vibration;
    }

    public void setVibrationPattern(long[] vibrationPattern) {
        this.mVibrationEnabled = vibrationPattern != null && vibrationPattern.length > 0;
        this.mVibrationPattern = vibrationPattern;
        if (Flags.notifChannelCropVibrationEffects() && vibrationPattern != null && vibrationPattern.length > 500) {
            this.mVibrationPattern = Arrays.copyOf(vibrationPattern, 500);
        }
        if (Flags.notificationChannelVibrationEffectApi()) {
            try {
                this.mVibrationEffect = VibrationEffect.createWaveform(vibrationPattern, -1);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                this.mVibrationEffect = null;
            }
        }
    }

    @FlaggedApi(value="android.app.notification_channel_vibration_effect_api")
    public void setVibrationEffect(@Nullable VibrationEffect effect) {
        this.mVibrationEnabled = effect != null;
        this.mVibrationEffect = effect;
        if (Flags.notifChannelCropVibrationEffects() && effect != null) {
            long[] pattern = effect.computeCreateWaveformOffOnTimingsOrNull();
            if (pattern != null) {
                if (pattern.length > 500) {
                    this.setVibrationPattern(pattern);
                } else {
                    this.mVibrationPattern = pattern;
                }
            } else {
                this.mVibrationEffect = this.getTrimmedVibrationEffect(this.mVibrationEffect);
                this.mVibrationPattern = null;
            }
        } else {
            this.mVibrationPattern = this.mVibrationEffect == null ? null : this.mVibrationEffect.computeCreateWaveformOffOnTimingsOrNull();
        }
    }

    public void setImportance(int importance) {
        this.mImportance = importance;
    }

    public void setBypassDnd(boolean bypassDnd) {
        this.mBypassDnd = bypassDnd;
    }

    public void setLockscreenVisibility(int lockscreenVisibility) {
        this.mLockscreenVisibility = lockscreenVisibility;
    }

    public void setAllowBubbles(boolean allowBubbles) {
        this.mAllowBubbles = allowBubbles ? 1 : 0;
    }

    public void setAllowBubbles(int allowed) {
        this.mAllowBubbles = allowed;
    }

    public void setConversationId(@NonNull String parentChannelId, @NonNull String conversationId) {
        this.mParentId = parentChannelId;
        this.mConversationId = conversationId;
    }

    public String getId() {
        return this.mId;
    }

    public CharSequence getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDesc;
    }

    public int getImportance() {
        return this.mImportance;
    }

    public boolean canBypassDnd() {
        return this.mBypassDnd;
    }

    public boolean isConversation() {
        return !TextUtils.isEmpty(this.getConversationId());
    }

    public boolean isImportantConversation() {
        return this.mImportantConvo;
    }

    public Uri getSound() {
        return this.mSound;
    }

    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributes;
    }

    public boolean shouldShowLights() {
        return this.mLights;
    }

    public int getLightColor() {
        return this.mLightColor;
    }

    public boolean shouldVibrate() {
        return this.mVibrationEnabled;
    }

    public long[] getVibrationPattern() {
        return this.mVibrationPattern;
    }

    @FlaggedApi(value="android.app.notification_channel_vibration_effect_api")
    @Nullable
    public VibrationEffect getVibrationEffect() {
        return this.mVibrationEffect;
    }

    public int getLockscreenVisibility() {
        return this.mLockscreenVisibility;
    }

    public boolean canShowBadge() {
        return this.mShowBadge;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public boolean canBubble() {
        return this.mAllowBubbles == 1;
    }

    public int getAllowBubbles() {
        return this.mAllowBubbles;
    }

    @Nullable
    public String getParentChannelId() {
        return this.mParentId;
    }

    @Nullable
    public String getConversationId() {
        return this.mConversationId;
    }

    @SystemApi
    public boolean isDeleted() {
        return this.mDeleted;
    }

    public long getDeletedTimeMs() {
        return this.mDeletedTime;
    }

    @SystemApi
    public int getUserLockedFields() {
        return this.mUserLockedFields;
    }

    public boolean isUserVisibleTaskShown() {
        return this.mUserVisibleTaskShown;
    }

    public boolean isBlockable() {
        return this.mBlockableSystem;
    }

    public void setImportanceLockedByCriticalDeviceFunction(boolean locked) {
        this.mImportanceLockedDefaultApp = locked;
    }

    public boolean isImportanceLockedByCriticalDeviceFunction() {
        return this.mImportanceLockedDefaultApp;
    }

    public int getOriginalImportance() {
        return this.mOriginalImportance;
    }

    public void setOriginalImportance(int importance) {
        this.mOriginalImportance = importance;
    }

    public void setDemoted(boolean demoted) {
        this.mDemoted = demoted;
    }

    public boolean isDemoted() {
        return this.mDemoted;
    }

    public boolean hasUserSetImportance() {
        return (this.mUserLockedFields & 4) != 0;
    }

    public boolean hasUserSetSound() {
        return (this.mUserLockedFields & 0x20) != 0;
    }

    public long getLastNotificationUpdateTimeMs() {
        return this.mLastNotificationUpdateTimeMs;
    }

    public void setLastNotificationUpdateTimeMs(long updateTimeMs) {
        this.mLastNotificationUpdateTimeMs = updateTimeMs;
    }

    public void populateFromXmlForRestore(XmlPullParser parser, boolean pkgInstalled, Context context) {
        this.populateFromXml(XmlUtils.makeTyped(parser), true, pkgInstalled, context);
    }

    @SystemApi
    public void populateFromXml(XmlPullParser parser) {
        this.populateFromXml(XmlUtils.makeTyped(parser), false, true, null);
    }

    private void populateFromXml(TypedXmlPullParser parser, boolean forRestore, boolean pkgInstalled, @Nullable Context context) {
        VibrationEffect vibrationEffect;
        Preconditions.checkArgument(!forRestore || context != null, "forRestore is true but got null context");
        this.setDescription(parser.getAttributeValue(null, ATT_DESC));
        this.setBypassDnd(0 != NotificationChannel.safeInt(parser, ATT_PRIORITY, 0));
        this.setLockscreenVisibility(NotificationChannel.safeInt(parser, ATT_VISIBILITY, -1000));
        Uri sound = NotificationChannel.safeUri(parser, "sound");
        AudioAttributes audioAttributes = NotificationChannel.safeAudioAttributes(parser);
        int usage = audioAttributes.getUsage();
        this.setSound(forRestore ? this.restoreSoundUri(context, sound, pkgInstalled, usage) : sound, audioAttributes);
        this.enableLights(NotificationChannel.safeBool(parser, ATT_LIGHTS, false));
        this.setLightColor(NotificationChannel.safeInt(parser, ATT_LIGHT_COLOR, 0));
        this.setVibrationPattern(NotificationChannel.safeLongArray(parser, "vibration", null));
        if (Flags.notificationChannelVibrationEffectApi() && (vibrationEffect = NotificationChannel.safeVibrationEffect(parser, ATT_VIBRATION_EFFECT)) != null) {
            this.setVibrationEffect(vibrationEffect);
        }
        this.enableVibration(NotificationChannel.safeBool(parser, ATT_VIBRATION_ENABLED, false));
        this.setShowBadge(NotificationChannel.safeBool(parser, ATT_SHOW_BADGE, false));
        this.setDeleted(NotificationChannel.safeBool(parser, ATT_DELETED, false));
        this.setDeletedTimeMs(XmlUtils.readLongAttribute(parser, ATT_DELETED_TIME_MS, -1L));
        this.setGroup(parser.getAttributeValue(null, ATT_GROUP));
        this.lockFields(NotificationChannel.safeInt(parser, "locked", 0));
        this.setUserVisibleTaskShown(NotificationChannel.safeBool(parser, ATT_FG_SERVICE_SHOWN, false));
        this.setBlockable(NotificationChannel.safeBool(parser, ATT_BLOCKABLE_SYSTEM, false));
        this.setAllowBubbles(NotificationChannel.safeInt(parser, ATT_ALLOW_BUBBLE, -1));
        this.setOriginalImportance(NotificationChannel.safeInt(parser, ATT_ORIG_IMP, -1000));
        this.setConversationId(parser.getAttributeValue(null, ATT_PARENT_CHANNEL), parser.getAttributeValue(null, ATT_CONVERSATION_ID));
        this.setDemoted(NotificationChannel.safeBool(parser, ATT_DEMOTE, false));
        this.setImportantConversation(NotificationChannel.safeBool(parser, ATT_IMP_CONVERSATION, false));
    }

    public boolean isSoundRestored() {
        return this.mSoundRestored;
    }

    @Nullable
    private Uri getCanonicalizedSoundUri(ContentResolver contentResolver, @NonNull Uri uri) {
        if (Settings.System.DEFAULT_NOTIFICATION_URI.equals(uri)) {
            return uri;
        }
        if ("android.resource".equals(uri.getScheme())) {
            try {
                contentResolver.getResourceId(uri);
                return uri;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        if ("file".equals(uri.getScheme())) {
            return uri;
        }
        return contentResolver.canonicalize(uri);
    }

    @Nullable
    private Uri getUncanonicalizedSoundUri(ContentResolver contentResolver, @NonNull Uri uri, int usage) {
        if (Settings.System.DEFAULT_NOTIFICATION_URI.equals(uri) || "android.resource".equals(uri.getScheme()) || "file".equals(uri.getScheme())) {
            return uri;
        }
        int ringtoneType = 0;
        ringtoneType = 4 == usage ? 4 : (6 == usage ? 1 : 2);
        try {
            return RingtoneManager.getRingtoneUriForRestore(contentResolver, uri.toString(), ringtoneType);
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to uncanonicalized sound uri for " + uri + " " + e);
            return Settings.System.DEFAULT_NOTIFICATION_URI;
        }
    }

    @Nullable
    public Uri restoreSoundUri(Context context, @Nullable Uri uri, boolean pkgInstalled, int usage) {
        if (uri == null || Uri.EMPTY.equals(uri)) {
            return null;
        }
        ContentResolver contentResolver = context.getContentResolver();
        Uri canonicalizedUri = this.getCanonicalizedSoundUri(contentResolver, uri);
        if (canonicalizedUri == null) {
            if (!this.mSoundRestored && pkgInstalled) {
                this.mSoundRestored = true;
                return Settings.System.DEFAULT_NOTIFICATION_URI;
            }
            this.mSoundRestored = false;
            return uri;
        }
        this.mSoundRestored = true;
        return this.getUncanonicalizedSoundUri(contentResolver, canonicalizedUri, usage);
    }

    @SystemApi
    public void writeXml(XmlSerializer out) throws IOException {
        this.writeXml(XmlUtils.makeTyped(out), false, null);
    }

    public void writeXmlForBackup(XmlSerializer out, Context context) throws IOException {
        this.writeXml(XmlUtils.makeTyped(out), true, context);
    }

    private Uri getSoundForBackup(Context context) {
        Uri sound = this.getSound();
        if (sound == null || Uri.EMPTY.equals(sound)) {
            return null;
        }
        try {
            Uri canonicalSound = this.getCanonicalizedSoundUri(context.getContentResolver(), sound);
            if (canonicalSound == null) {
                return Settings.System.DEFAULT_NOTIFICATION_URI;
            }
            return canonicalSound;
        }
        catch (Exception e) {
            Slog.e(TAG, "Cannot find file for sound " + sound + " using default");
            return Settings.System.DEFAULT_NOTIFICATION_URI;
        }
    }

    private void writeXml(TypedXmlSerializer out, boolean forBackup, @Nullable Context context) throws IOException {
        Uri sound;
        Preconditions.checkArgument(!forBackup || context != null, "forBackup is true but got null context");
        out.startTag(null, TAG_CHANNEL);
        out.attribute(null, ATT_ID, this.getId());
        if (this.getName() != null) {
            out.attribute(null, ATT_NAME, this.getName().toString());
        }
        if (this.getDescription() != null) {
            out.attribute(null, ATT_DESC, this.getDescription());
        }
        if (this.getImportance() != -1000) {
            out.attributeInt(null, "importance", this.getImportance());
        }
        if (this.canBypassDnd()) {
            out.attributeInt(null, ATT_PRIORITY, 2);
        }
        if (this.getLockscreenVisibility() != -1000) {
            out.attributeInt(null, ATT_VISIBILITY, this.getLockscreenVisibility());
        }
        Uri uri = sound = forBackup ? this.getSoundForBackup(context) : this.getSound();
        if (sound != null) {
            out.attribute(null, "sound", sound.toString());
        }
        if (this.getAudioAttributes() != null) {
            out.attributeInt(null, ATT_USAGE, this.getAudioAttributes().getUsage());
            out.attributeInt(null, ATT_CONTENT_TYPE, this.getAudioAttributes().getContentType());
            out.attributeInt(null, ATT_FLAGS, this.getAudioAttributes().getFlags());
        }
        if (this.shouldShowLights()) {
            out.attributeBoolean(null, ATT_LIGHTS, this.shouldShowLights());
        }
        if (this.getLightColor() != 0) {
            out.attributeInt(null, ATT_LIGHT_COLOR, this.getLightColor());
        }
        if (this.shouldVibrate()) {
            out.attributeBoolean(null, ATT_VIBRATION_ENABLED, this.shouldVibrate());
        }
        if (this.getVibrationPattern() != null) {
            out.attribute(null, "vibration", NotificationChannel.longArrayToString(this.getVibrationPattern()));
        }
        if (!(this.getVibrationEffect() == null || Flags.notifChannelCropVibrationEffects() && this.getVibrationPattern() != null)) {
            out.attribute(null, ATT_VIBRATION_EFFECT, NotificationChannel.vibrationToString(this.getVibrationEffect()));
        }
        if (this.getUserLockedFields() != 0) {
            out.attributeInt(null, "locked", this.getUserLockedFields());
        }
        if (this.isUserVisibleTaskShown()) {
            out.attributeBoolean(null, ATT_FG_SERVICE_SHOWN, this.isUserVisibleTaskShown());
        }
        if (this.canShowBadge()) {
            out.attributeBoolean(null, ATT_SHOW_BADGE, this.canShowBadge());
        }
        if (this.isDeleted()) {
            out.attributeBoolean(null, ATT_DELETED, this.isDeleted());
        }
        if (this.getDeletedTimeMs() >= 0L) {
            out.attributeLong(null, ATT_DELETED_TIME_MS, this.getDeletedTimeMs());
        }
        if (this.getGroup() != null) {
            out.attribute(null, ATT_GROUP, this.getGroup());
        }
        if (this.isBlockable()) {
            out.attributeBoolean(null, ATT_BLOCKABLE_SYSTEM, this.isBlockable());
        }
        if (this.getAllowBubbles() != -1) {
            out.attributeInt(null, ATT_ALLOW_BUBBLE, this.getAllowBubbles());
        }
        if (this.getOriginalImportance() != -1000) {
            out.attributeInt(null, ATT_ORIG_IMP, this.getOriginalImportance());
        }
        if (this.getParentChannelId() != null) {
            out.attribute(null, ATT_PARENT_CHANNEL, this.getParentChannelId());
        }
        if (this.getConversationId() != null) {
            out.attribute(null, ATT_CONVERSATION_ID, this.getConversationId());
        }
        if (this.isDemoted()) {
            out.attributeBoolean(null, ATT_DEMOTE, this.isDemoted());
        }
        if (this.isImportantConversation()) {
            out.attributeBoolean(null, ATT_IMP_CONVERSATION, this.isImportantConversation());
        }
        out.endTag(null, TAG_CHANNEL);
    }

    @SystemApi
    public JSONObject toJson() throws JSONException {
        JSONObject record = new JSONObject();
        record.put(ATT_ID, this.getId());
        record.put(ATT_NAME, this.getName());
        record.put(ATT_DESC, this.getDescription());
        if (this.getImportance() != -1000) {
            record.put("importance", NotificationListenerService.Ranking.importanceToString(this.getImportance()));
        }
        if (this.canBypassDnd()) {
            record.put(ATT_PRIORITY, 2);
        }
        if (this.getLockscreenVisibility() != -1000) {
            record.put(ATT_VISIBILITY, Notification.visibilityToString(this.getLockscreenVisibility()));
        }
        if (this.getSound() != null) {
            record.put("sound", this.getSound().toString());
        }
        if (this.getAudioAttributes() != null) {
            record.put(ATT_USAGE, Integer.toString(this.getAudioAttributes().getUsage()));
            record.put(ATT_CONTENT_TYPE, Integer.toString(this.getAudioAttributes().getContentType()));
            record.put(ATT_FLAGS, Integer.toString(this.getAudioAttributes().getFlags()));
        }
        record.put(ATT_LIGHTS, Boolean.toString(this.shouldShowLights()));
        record.put(ATT_LIGHT_COLOR, Integer.toString(this.getLightColor()));
        record.put(ATT_VIBRATION_ENABLED, Boolean.toString(this.shouldVibrate()));
        record.put("locked", Integer.toString(this.getUserLockedFields()));
        record.put(ATT_FG_SERVICE_SHOWN, Boolean.toString(this.isUserVisibleTaskShown()));
        record.put("vibration", NotificationChannel.longArrayToString(this.getVibrationPattern()));
        if (this.getVibrationEffect() != null) {
            record.put(ATT_VIBRATION_EFFECT, NotificationChannel.vibrationToString(this.getVibrationEffect()));
        }
        record.put(ATT_SHOW_BADGE, Boolean.toString(this.canShowBadge()));
        record.put(ATT_DELETED, Boolean.toString(this.isDeleted()));
        record.put(ATT_DELETED_TIME_MS, Long.toString(this.getDeletedTimeMs()));
        record.put(ATT_GROUP, this.getGroup());
        record.put(ATT_BLOCKABLE_SYSTEM, this.isBlockable());
        record.put(ATT_ALLOW_BUBBLE, this.getAllowBubbles());
        return record;
    }

    private static AudioAttributes safeAudioAttributes(TypedXmlPullParser parser) {
        int usage = NotificationChannel.safeInt(parser, ATT_USAGE, 5);
        int contentType = NotificationChannel.safeInt(parser, ATT_CONTENT_TYPE, 4);
        int flags = NotificationChannel.safeInt(parser, ATT_FLAGS, 0);
        return new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).setFlags(flags).build();
    }

    private static Uri safeUri(TypedXmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        return val == null ? null : Uri.parse(val);
    }

    private static String vibrationToString(VibrationEffect effect) {
        StringWriter writer = new StringWriter();
        try {
            VibrationXmlSerializer.serialize(effect, writer, 1);
        }
        catch (IOException e) {
            Log.e(TAG, "Unable to serialize vibration: " + effect, e);
        }
        return ((Object)writer).toString();
    }

    private static VibrationEffect safeVibrationEffect(TypedXmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        if (val != null) {
            try {
                return VibrationXmlParser.parseVibrationEffect(new StringReader(val), 1);
            }
            catch (IOException e) {
                Log.e(TAG, "Unable to read serialized vibration effect", e);
            }
        }
        return null;
    }

    private static int safeInt(TypedXmlPullParser parser, String att, int defValue) {
        return parser.getAttributeInt(null, att, defValue);
    }

    private static boolean safeBool(TypedXmlPullParser parser, String att, boolean defValue) {
        return parser.getAttributeBoolean(null, att, defValue);
    }

    private static long[] safeLongArray(TypedXmlPullParser parser, String att, long[] defValue) {
        String attributeValue = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(attributeValue)) {
            return defValue;
        }
        String[] values = attributeValue.split(DELIMITER);
        long[] longValues = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                longValues[i] = Long.parseLong(values[i]);
                continue;
            }
            catch (NumberFormatException e) {
                longValues[i] = 0L;
            }
        }
        return longValues;
    }

    private static String longArrayToString(long[] values) {
        StringBuilder sb = new StringBuilder();
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length - 1; ++i) {
                sb.append(values[i]).append(DELIMITER);
            }
            sb.append(values[values.length - 1]);
        }
        return sb.toString();
    }

    @Nullable
    public static String getChannelIdForBundleType(int type) {
        switch (type) {
            case 4: {
                return RECS_ID;
            }
            case 3: {
                return NEWS_ID;
            }
            case 1: {
                return PROMOTIONS_ID;
            }
            case 2: {
                return SOCIAL_MEDIA_ID;
            }
        }
        return null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationChannel that = (NotificationChannel)o;
        return this.getImportance() == that.getImportance() && this.mBypassDnd == that.mBypassDnd && this.getLockscreenVisibility() == that.getLockscreenVisibility() && this.mLights == that.mLights && this.getLightColor() == that.getLightColor() && this.getUserLockedFields() == that.getUserLockedFields() && this.isUserVisibleTaskShown() == that.isUserVisibleTaskShown() && this.mVibrationEnabled == that.mVibrationEnabled && this.mShowBadge == that.mShowBadge && this.isDeleted() == that.isDeleted() && this.getDeletedTimeMs() == that.getDeletedTimeMs() && this.isBlockable() == that.isBlockable() && this.mAllowBubbles == that.mAllowBubbles && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.mDesc, that.mDesc) && Objects.equals(this.getSound(), that.getSound()) && Arrays.equals(this.mVibrationPattern, that.mVibrationPattern) && Objects.equals(this.getVibrationEffect(), that.getVibrationEffect()) && Objects.equals(this.getGroup(), that.getGroup()) && Objects.equals(this.getAudioAttributes(), that.getAudioAttributes()) && this.mImportanceLockedDefaultApp == that.mImportanceLockedDefaultApp && this.mOriginalImportance == that.mOriginalImportance && Objects.equals(this.getParentChannelId(), that.getParentChannelId()) && Objects.equals(this.getConversationId(), that.getConversationId()) && this.isDemoted() == that.isDemoted() && this.isImportantConversation() == that.isImportantConversation();
    }

    public int hashCode() {
        int result = Objects.hash(this.getId(), this.getName(), this.mDesc, this.getImportance(), this.mBypassDnd, this.getLockscreenVisibility(), this.getSound(), this.mLights, this.getLightColor(), this.getUserLockedFields(), this.isUserVisibleTaskShown(), this.mVibrationEnabled, this.mShowBadge, this.isDeleted(), this.getDeletedTimeMs(), this.getGroup(), this.getAudioAttributes(), this.isBlockable(), this.mAllowBubbles, this.mImportanceLockedDefaultApp, this.mOriginalImportance, this.getVibrationEffect(), this.mParentId, this.mConversationId, this.mDemoted, this.mImportantConvo);
        result = 31 * result + Arrays.hashCode(this.mVibrationPattern);
        return result;
    }

    public void dump(PrintWriter pw, String prefix, boolean redacted) {
        String redactedName = redacted ? TextUtils.trimToLengthWithEllipsis(this.mName, 3) : this.mName;
        String output = "NotificationChannel{mId='" + this.mId + '\'' + ", mName=" + redactedName + this.getFieldsString() + '}';
        pw.println(prefix + output);
    }

    public String toString() {
        return "NotificationChannel{mId='" + this.mId + '\'' + ", mName=" + this.mName + this.getFieldsString() + '}';
    }

    private String getFieldsString() {
        return ", mDescription=" + (!TextUtils.isEmpty(this.mDesc) ? "hasDescription " : "") + ", mImportance=" + this.mImportance + ", mBypassDnd=" + this.mBypassDnd + ", mLockscreenVisibility=" + this.mLockscreenVisibility + ", mSound=" + this.mSound + ", mLights=" + this.mLights + ", mLightColor=" + this.mLightColor + ", mVibrationPattern=" + Arrays.toString(this.mVibrationPattern) + ", mVibrationEffect=" + (this.mVibrationEffect == null ? "null" : this.mVibrationEffect.toString()) + ", mUserLockedFields=" + Integer.toHexString(this.mUserLockedFields) + ", mUserVisibleTaskShown=" + this.mUserVisibleTaskShown + ", mVibrationEnabled=" + this.mVibrationEnabled + ", mShowBadge=" + this.mShowBadge + ", mDeleted=" + this.mDeleted + ", mDeletedTimeMs=" + this.mDeletedTime + ", mGroup='" + this.mGroup + '\'' + ", mAudioAttributes=" + this.mAudioAttributes + ", mBlockableSystem=" + this.mBlockableSystem + ", mAllowBubbles=" + this.mAllowBubbles + ", mImportanceLockedDefaultApp=" + this.mImportanceLockedDefaultApp + ", mOriginalImp=" + this.mOriginalImportance + ", mParent=" + this.mParentId + ", mConversationId=" + this.mConversationId + ", mDemoted=" + this.mDemoted + ", mImportantConvo=" + this.mImportantConvo + ", mLastNotificationUpdateTimeMs=" + this.mLastNotificationUpdateTimeMs;
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.mId);
        proto.write(1138166333442L, this.mName);
        proto.write(1138166333443L, this.mDesc);
        proto.write(1120986464260L, this.mImportance);
        proto.write(1133871366149L, this.mBypassDnd);
        proto.write(1120986464262L, this.mLockscreenVisibility);
        if (this.mSound != null) {
            proto.write(1138166333447L, this.mSound.toString());
        }
        proto.write(0x10800000008L, this.mLights);
        proto.write(1120986464265L, this.mLightColor);
        if (this.mVibrationPattern != null) {
            for (long v : this.mVibrationPattern) {
                proto.write(2211908157450L, v);
            }
        }
        proto.write(1120986464267L, this.mUserLockedFields);
        proto.write(1133871366162L, this.mUserVisibleTaskShown);
        proto.write(1133871366156L, this.mVibrationEnabled);
        proto.write(1133871366157L, this.mShowBadge);
        proto.write(1133871366158L, this.mDeleted);
        proto.write(1138166333455L, this.mGroup);
        if (this.mAudioAttributes != null) {
            this.mAudioAttributes.dumpDebug(proto, 0x10B00000010L);
        }
        proto.write(0x10800000011L, this.mBlockableSystem);
        proto.write(1133871366163L, this.mAllowBubbles);
        proto.end(token);
    }
}

