/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class PictureInPictureUiState
implements Parcelable {
    private final boolean mIsStashed;
    private final boolean mIsTransitioningToPip;
    @NonNull
    public static final Parcelable.Creator<PictureInPictureUiState> CREATOR = new Parcelable.Creator<PictureInPictureUiState>(){

        @Override
        public PictureInPictureUiState createFromParcel(Parcel in) {
            return new PictureInPictureUiState(in);
        }

        public PictureInPictureUiState[] newArray(int size) {
            return new PictureInPictureUiState[size];
        }
    };

    PictureInPictureUiState(Parcel in) {
        this.mIsStashed = in.readBoolean();
        this.mIsTransitioningToPip = in.readBoolean();
    }

    public PictureInPictureUiState(boolean isStashed) {
        this(isStashed, false);
    }

    private PictureInPictureUiState(boolean isStashed, boolean isTransitioningToPip) {
        this.mIsStashed = isStashed;
        this.mIsTransitioningToPip = isTransitioningToPip;
    }

    public boolean isStashed() {
        return this.mIsStashed;
    }

    @FlaggedApi(value="android.app.enable_pip_ui_state_callback_on_entering")
    public boolean isTransitioningToPip() {
        return this.mIsTransitioningToPip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PictureInPictureUiState)) {
            return false;
        }
        PictureInPictureUiState that = (PictureInPictureUiState)o;
        return this.mIsStashed == that.mIsStashed && this.mIsTransitioningToPip == that.mIsTransitioningToPip;
    }

    public int hashCode() {
        return Objects.hash(this.mIsStashed, this.mIsTransitioningToPip);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeBoolean(this.mIsStashed);
        out.writeBoolean(this.mIsTransitioningToPip);
    }

    @FlaggedApi(value="android.app.enable_pip_ui_state_callback_on_entering")
    public static class Builder {
        private boolean mIsStashed;
        private boolean mIsTransitioningToPip;

        public Builder setStashed(boolean isStashed) {
            this.mIsStashed = isStashed;
            return this;
        }

        public Builder setTransitioningToPip(boolean isEnteringPip) {
            this.mIsTransitioningToPip = isEnteringPip;
            return this;
        }

        public PictureInPictureUiState build() {
            return new PictureInPictureUiState(this.mIsStashed, this.mIsTransitioningToPip);
        }
    }
}

