/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.Flags;
import android.app.Instrumentation;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SystemPropertySetter;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.ApplicationSharedMemory;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import dalvik.annotation.optimization.NeverCompile;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@RavenwoodKeepWholeClass
public class PropertyInvalidatedCache<Query, Result> {
    private static final String CACHE_KEY_PREFIX = "cache_key";
    public static final String MODULE_TEST = "test";
    public static final String MODULE_SYSTEM = "system_server";
    public static final String MODULE_BLUETOOTH = "bluetooth";
    public static final String MODULE_TELEPHONY = "telephony";
    private static final String[] sValidModule = new String[]{"system_server", "bluetooth", "telephony", "test"};
    private static final String[] sValidKeyPrefix = new String[]{"cache_key.system_server.", "cache_key.bluetooth.", "cache_key.telephony.", "cache_key.test."};
    @VisibleForTesting
    static final int NONCE_UNSET = 0;
    private static final int NONCE_DISABLED = 1;
    private static final int NONCE_CORKED = 2;
    private static final int NONCE_BYPASS = 3;
    private static final int MAX_RESERVED_NONCE = 3;
    private static final String[] sNonceName = new String[]{"unset", "disabled", "corked", "bypass"};
    private static final String TAG = "PropertyInvalidatedCache";
    private static final boolean DEBUG = false;
    private static final boolean VERIFY = false;
    @GuardedBy(value={"sGlobalLock"})
    private static boolean sTestMode = false;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private long mHits = 0L;
    @GuardedBy(value={"mLock"})
    private long mMisses = 0L;
    @GuardedBy(value={"mLock"})
    private long mNulls = 0L;
    @GuardedBy(value={"mLock"})
    private long[] mSkips = new long[4];
    @GuardedBy(value={"mLock"})
    private long mMissOverflow = 0L;
    @GuardedBy(value={"mLock"})
    private long mHighWaterMark = 0L;
    @GuardedBy(value={"mLock"})
    private long mClears = 0L;
    private static final Object sCorkLock = new Object();
    private static final Object sGlobalLock = new Object();
    @GuardedBy(value={"sGlobalLock"})
    private static final HashSet<String> sDisabledKeys = new HashSet();
    @GuardedBy(value={"sGlobalLock"})
    private static final WeakHashMap<PropertyInvalidatedCache, Void> sCaches = new WeakHashMap();
    private static boolean sEnabled = true;
    private final String mPropertyName;
    private final String mCacheName;
    private final boolean mCacheNullResults;
    private QueryHandler<Query, Result> mComputer;
    @GuardedBy(value={"mLock"})
    private final CacheMap<Query, Result> mCache;
    @GuardedBy(value={"mLock"})
    private final NonceHandler mNonce;
    @GuardedBy(value={"mLock"})
    private long mLastSeenNonce = 0L;
    private boolean mDisabled = false;
    private final int mMaxEntries;
    private static final String PREFIX_TEST = "cache_key.test.";
    private static final String PREFIX_SYSTEM = "cache_key.system_server.";
    private static final ConcurrentHashMap<String, NonceHandler> sHandlers = new ConcurrentHashMap();
    private static final boolean sSharedMemoryAvailable = PropertyInvalidatedCache.isSharedMemoryAvailable();
    static final String NAME_CONTAINS = "-name-has=";
    static final String NAME_LIKE = "-name-like=";
    static final String PROPERTY_CONTAINS = "-property-has=";
    static final String PROPERTY_LIKE = "-property-like=";
    static final String BRIEF = "-brief";

    public static boolean separatePermissionNotificationsEnabled() {
        return PropertyInvalidatedCache.isSharedMemoryAvailable() && Flags.picSeparatePermissionNotifications();
    }

    @NonNull
    public static String createPropertyName(@NonNull String module, @NonNull String apiName) {
        char[] api = apiName.toCharArray();
        int upper = 0;
        for (int i = 1; i < api.length; ++i) {
            if (!Character.isUpperCase(api[i])) continue;
            ++upper;
        }
        char[] suffix = new char[api.length + upper];
        int j = 0;
        for (int i = 0; i < api.length; ++i) {
            if (Character.isJavaIdentifierPart(api[i])) {
                if (Character.isUpperCase(api[i])) {
                    if (i > 0) {
                        suffix[j++] = 95;
                    }
                    suffix[j++] = Character.toLowerCase(api[i]);
                    continue;
                }
                suffix[j++] = api[i];
                continue;
            }
            throw new IllegalArgumentException("invalid api name");
        }
        return "cache_key." + module + "." + new String(suffix);
    }

    private static void throwIfInvalidModule(@NonNull String name) {
        for (int i = 0; i < sValidModule.length; ++i) {
            if (!sValidModule[i].equals(name)) continue;
            return;
        }
        throw new IllegalArgumentException("invalid module: " + name);
    }

    private static void throwIfInvalidCacheKey(String name) {
        for (int i = 0; i < sValidKeyPrefix.length; ++i) {
            if (!name.startsWith(sValidKeyPrefix[i])) continue;
            return;
        }
        throw new IllegalArgumentException("invalid cache name: " + name);
    }

    @NonNull
    public static String createSystemCacheKey(@NonNull String api) {
        return PropertyInvalidatedCache.createPropertyName(MODULE_SYSTEM, api);
    }

    private static boolean isReservedNonce(long n) {
        return n >= 0L && n <= 3L;
    }

    public NonceWatcher getNonceWatcher() {
        return new NonceWatcher(this.mNonce);
    }

    public static NonceWatcher getNonceWatcher(@NonNull String propertyName) {
        return new NonceWatcher(PropertyInvalidatedCache.getNonceHandler(propertyName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public long getNonce() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNonce.getNonce();
        }
    }

    @RavenwoodReplace
    private static boolean isSharedMemoryAvailable() {
        return com.android.internal.os.Flags.applicationSharedMemoryEnabled() && Flags.picUsesSharedMemory();
    }

    private static boolean isSharedMemoryAvailable$ravenwood() {
        return false;
    }

    private static boolean inSharedMemoryDenyList(@NonNull String name) {
        String pkginfo = "cache_key.system_server.package_info";
        return name.equals("cache_key.system_server.package_info");
    }

    private static boolean sharedMemoryOkay(@NonNull String name) {
        return sSharedMemoryAvailable && name.startsWith(PREFIX_SYSTEM) && !PropertyInvalidatedCache.inSharedMemoryDenyList(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NonceHandler getNonceHandler(@NonNull String name) {
        NonceHandler h = sHandlers.get(name);
        if (h == null) {
            Object object = sGlobalLock;
            synchronized (object) {
                PropertyInvalidatedCache.throwIfInvalidCacheKey(name);
                h = sHandlers.get(name);
                if (h == null) {
                    h = PropertyInvalidatedCache.sharedMemoryOkay(name) ? new NonceSharedMem(name, PREFIX_SYSTEM) : (name.startsWith(PREFIX_TEST) ? new NonceLocal(name) : new NonceSysprop(name));
                    sHandlers.put(name, h);
                }
            }
        }
        return h;
    }

    public PropertyInvalidatedCache(@NonNull Args args, @NonNull String cacheName, @Nullable QueryHandler<Query, Result> computer) {
        this.mPropertyName = PropertyInvalidatedCache.createPropertyName(args.mModule, args.mApi);
        this.mCacheName = cacheName;
        this.mCacheNullResults = args.mCacheNulls;
        this.mNonce = PropertyInvalidatedCache.getNonceHandler(this.mPropertyName);
        this.mMaxEntries = args.mMaxEntries;
        this.mCache = new CacheMap(args.mIsolateUids, args.mTestMode);
        this.mComputer = computer != null ? computer : new DefaultComputer(this);
        this.registerCache();
    }

    private static Args argsFromProperty(@NonNull String name) {
        PropertyInvalidatedCache.throwIfInvalidCacheKey(name);
        String base = name.substring(CACHE_KEY_PREFIX.length() + 1);
        int dot = base.indexOf(".");
        String module = base.substring(0, dot);
        String api = base.substring(dot + 1);
        return new Args(module).api(api);
    }

    public static String apiFromProperty(@NonNull String name) {
        return PropertyInvalidatedCache.argsFromProperty((String)name).mApi;
    }

    @Deprecated
    public PropertyInvalidatedCache(int maxEntries, @NonNull String propertyName) {
        this(PropertyInvalidatedCache.argsFromProperty(propertyName).maxEntries(maxEntries), propertyName, null);
    }

    @Deprecated
    public PropertyInvalidatedCache(int maxEntries, @NonNull String propertyName, @NonNull String cacheName) {
        this(PropertyInvalidatedCache.argsFromProperty(propertyName).maxEntries(maxEntries), cacheName, null);
    }

    public PropertyInvalidatedCache(int maxEntries, @NonNull String module, @NonNull String api, @NonNull String cacheName, @NonNull QueryHandler<Query, Result> computer) {
        this(new Args(module).maxEntries(maxEntries).api(api), cacheName, computer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCache() {
        Object object = sGlobalLock;
        synchronized (object) {
            if (sDisabledKeys.contains(this.mCacheName)) {
                this.disableInstance();
            }
            sCaches.put(this, null);
        }
    }

    @RavenwoodReplace
    private static void throwIfNotTest() {
        ActivityThread activityThread = ActivityThread.currentActivityThread();
        if (activityThread == null) {
            return;
        }
        Instrumentation instrumentation = activityThread.getInstrumentation();
        if (instrumentation == null) {
            return;
        }
        if (instrumentation.isInstrumenting()) {
            return;
        }
        if (Flags.enforcePicTestmodeProtocol()) {
            throw new IllegalStateException("Test-only API called not from a test.");
        }
    }

    private static void throwIfNotTest$ravenwood() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void setTestMode(boolean mode) {
        PropertyInvalidatedCache.throwIfNotTest();
        Object object = sGlobalLock;
        synchronized (object) {
            if (sTestMode == mode) {
                String msg = "cannot set test mode redundantly: mode=" + mode;
                if (Flags.enforcePicTestmodeProtocol()) {
                    throw new IllegalStateException(msg);
                }
                Log.e(TAG, msg);
            }
            sTestMode = mode;
            if (Flags.picTestMode() || !mode) {
                PropertyInvalidatedCache.setTestModeLocked(mode);
            }
        }
    }

    @GuardedBy(value={"sGlobalLock"})
    private static void setTestModeLocked(boolean mode) {
        Iterator<String> e = sHandlers.keys().asIterator();
        while (e.hasNext()) {
            String s = e.next();
            NonceHandler h = sHandlers.get(s);
            h.setTestMode(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropertyName() {
        PropertyInvalidatedCache.throwIfNotTest();
        Object object = sGlobalLock;
        synchronized (object) {
            if (!sTestMode) {
                throw new IllegalStateException("cannot test property name with test mode off");
            }
            this.mNonce.setTestMode(true);
        }
    }

    @GuardedBy(value={"mLock"})
    private long getCurrentNonce() {
        return this.mNonce.getNonce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCache.clear();
            ++this.mClears;
        }
    }

    public Result recompute(@NonNull Query query) {
        return this.mComputer.apply(query);
    }

    public boolean bypass(@NonNull Query query) {
        return this.mComputer.shouldBypassCache(query);
    }

    public boolean resultEquals(Result cachedResult, Result fetchedResult) {
        if (fetchedResult != null) {
            return Objects.equals(cachedResult, fetchedResult);
        }
        return true;
    }

    protected Result refresh(Result oldResult, Query query) {
        return oldResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void disableInstance() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDisabled = true;
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disableLocal(@NonNull String name) {
        Object object = sGlobalLock;
        synchronized (object) {
            if (sDisabledKeys.contains(name)) {
                return;
            }
            for (PropertyInvalidatedCache cache : sCaches.keySet()) {
                if (!name.equals(cache.mCacheName)) continue;
                cache.disableInstance();
            }
            sDisabledKeys.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void forgetDisableLocal() {
        Object object = sGlobalLock;
        synchronized (object) {
            sDisabledKeys.remove(this.mCacheName);
        }
    }

    public void disableLocal() {
        this.disableForCurrentProcess();
    }

    public void disableForCurrentProcess() {
        PropertyInvalidatedCache.disableLocal(this.mCacheName);
    }

    public static void disableForCurrentProcess(@NonNull String cacheName) {
        PropertyInvalidatedCache.disableLocal(cacheName);
    }

    @VisibleForTesting
    public boolean isDisabled() {
        return this.mDisabled || !sEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Result query(@NonNull Query query) {
        long currentNonce;
        block26: {
            Result cachedResult;
            block27: {
                Result refreshedResult;
                long l = currentNonce = !this.isDisabled() ? this.getCurrentNonce() : 1L;
                if (!PropertyInvalidatedCache.isReservedNonce(currentNonce) && this.bypass(query)) {
                    currentNonce = 3L;
                }
                while (true) {
                    boolean cacheHit;
                    if (PropertyInvalidatedCache.isReservedNonce(currentNonce)) {
                        if (!this.mDisabled) {
                            Object object = this.mLock;
                            synchronized (object) {
                                int n = (int)currentNonce;
                                this.mSkips[n] = this.mSkips[n] + 1L;
                            }
                        }
                        return this.recompute(query);
                    }
                    Object object = this.mLock;
                    synchronized (object) {
                        if (currentNonce == this.mLastSeenNonce) {
                            cachedResult = this.mCache.get(query);
                            cacheHit = cachedResult == null ? (this.mCacheNullResults ? this.mCache.containsKey(query) : false) : true;
                            if (cacheHit) {
                                ++this.mHits;
                            }
                        } else {
                            this.clear();
                            this.mLastSeenNonce = currentNonce;
                            cacheHit = false;
                            cachedResult = null;
                        }
                    }
                    if (!cacheHit) break block26;
                    refreshedResult = this.refresh(cachedResult, query);
                    if (refreshedResult == cachedResult) break block27;
                    long afterRefreshNonce = this.getCurrentNonce();
                    if (currentNonce == afterRefreshNonce) break;
                    currentNonce = afterRefreshNonce;
                }
                Object object = this.mLock;
                synchronized (object) {
                    if (currentNonce == this.mLastSeenNonce) {
                        if (refreshedResult == null) {
                            this.mCache.remove(query);
                        } else {
                            this.mCache.put(query, refreshedResult);
                        }
                    }
                }
                return this.maybeCheckConsistency(query, refreshedResult);
            }
            return this.maybeCheckConsistency(query, cachedResult);
        }
        Result result = this.recompute(query);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastSeenNonce == currentNonce) {
                if (result != null || this.mCacheNullResults) {
                    this.mCache.put(query, result);
                } else if (result == null) {
                    ++this.mNulls;
                }
            }
            ++this.mMisses;
        }
        return this.maybeCheckConsistency(query, result);
    }

    @VisibleForTesting
    public void disableSystemWide() {
        PropertyInvalidatedCache.throwIfNotTest();
        PropertyInvalidatedCache.disableSystemWide(this.mPropertyName);
    }

    private static void disableSystemWide(@NonNull String name) {
        PropertyInvalidatedCache.getNonceHandler(name).disable();
    }

    public void invalidateCache() {
        this.mNonce.invalidate();
    }

    public void corkInvalidations() {
        this.mNonce.cork();
    }

    public void uncorkInvalidations() {
        this.mNonce.uncork();
    }

    public static void invalidateCache(@NonNull String module, @NonNull String api) {
        PropertyInvalidatedCache.invalidateCache(PropertyInvalidatedCache.createPropertyName(module, api));
    }

    public static void invalidateCache(@NonNull Args args) {
        PropertyInvalidatedCache.invalidateCache(PropertyInvalidatedCache.createPropertyName(args.mModule, args.mApi));
    }

    public static void invalidateCache(@NonNull String name) {
        PropertyInvalidatedCache.getNonceHandler(name).invalidate();
    }

    public static void corkInvalidations(@NonNull String name) {
        PropertyInvalidatedCache.getNonceHandler(name).cork();
    }

    public static void uncorkInvalidations(@NonNull String name) {
        PropertyInvalidatedCache.getNonceHandler(name).uncork();
    }

    private Result maybeCheckConsistency(Query query, Result proposedResult) {
        return proposedResult;
    }

    @NonNull
    public String cacheName() {
        return this.mCacheName;
    }

    @NonNull
    public String propertyName() {
        return this.mPropertyName;
    }

    @NonNull
    protected String queryToString(@NonNull Query query) {
        return Objects.toString(query);
    }

    public static void disableForTestMode() {
        Log.d(TAG, "disabling all caches in the process");
        sEnabled = false;
    }

    private boolean getDisabledState() {
        return this.isDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ArrayList<PropertyInvalidatedCache> getActiveCaches() {
        Object object = sGlobalLock;
        synchronized (object) {
            return new ArrayList<PropertyInvalidatedCache>(sCaches.keySet());
        }
    }

    private static boolean anyDetailed(String[] args) {
        for (String a : args) {
            if (!a.startsWith(NAME_CONTAINS) && !a.startsWith(NAME_LIKE) && !a.startsWith(PROPERTY_CONTAINS) && !a.startsWith(PROPERTY_LIKE)) continue;
            return true;
        }
        return false;
    }

    private static boolean chooses(String arg, String key, String reference, boolean contains) {
        if (arg.startsWith(key)) {
            String value = arg.substring(key.length());
            if (contains) {
                return reference.contains(value);
            }
            return reference.matches(value);
        }
        return false;
    }

    private boolean showDetailed(String[] args) {
        for (String a : args) {
            if (!PropertyInvalidatedCache.chooses(a, NAME_CONTAINS, this.cacheName(), true) && !PropertyInvalidatedCache.chooses(a, NAME_LIKE, this.cacheName(), false) && !PropertyInvalidatedCache.chooses(a, PROPERTY_CONTAINS, this.mPropertyName, true) && !PropertyInvalidatedCache.chooses(a, PROPERTY_LIKE, this.mPropertyName, false)) continue;
            return true;
        }
        return false;
    }

    @GuardedBy(value={"mLock"})
    private long getSkipsLocked() {
        int sum = 0;
        for (int i = 0; i < this.mSkips.length; ++i) {
            sum = (int)((long)sum + this.mSkips[i]);
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActive(NonceHandler.Stats stats) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mHits + this.mMisses + this.getSkipsLocked() + (long)stats.invalidated + (long)stats.corkedInvalidates > 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NeverCompile
    private void dumpContents(PrintWriter pw, boolean detailed, String[] args) {
        if (detailed && !this.showDetailed(args)) {
            return;
        }
        boolean brief = false;
        for (String a : args) {
            brief |= a.equals(BRIEF);
        }
        NonceHandler.Stats stats = this.mNonce.getStats();
        Object object = this.mLock;
        synchronized (object) {
            if (brief && !this.isActive(stats)) {
                return;
            }
            pw.println(TextUtils.formatSimple("  Cache Name: %s", this.cacheName()));
            pw.println(TextUtils.formatSimple("    Property: %s", this.mPropertyName));
            pw.println(TextUtils.formatSimple("    Hits: %d, Misses: %d, Skips: %d, Clears: %d, Nulls: %d", this.mHits, this.mMisses, this.getSkipsLocked(), this.mClears, this.mNulls));
            pw.format("    Skip-%s: %d", sNonceName[0], this.mSkips[0]);
            for (int i = 1; i < this.mSkips.length; ++i) {
                pw.format(", Skip-%s: %d", sNonceName[i], this.mSkips[i]);
            }
            pw.println();
            pw.println(TextUtils.formatSimple("    Nonce: 0x%016x, Invalidates: %d, Corked: %d", this.mLastSeenNonce, stats.invalidated, stats.corkedInvalidates));
            pw.println(TextUtils.formatSimple("    Current Size: %d, Max Size: %d, HW Mark: %d, Overflows: %d", this.mCache.size(), this.mMaxEntries, this.mHighWaterMark, this.mMissOverflow));
            this.mCache.dump(pw);
            pw.println(TextUtils.formatSimple("    Enabled: %s", this.mDisabled ? "false" : "true"));
            if (detailed) {
                this.mCache.dumpDetailed(pw);
            }
            pw.println("");
        }
    }

    @NeverCompile
    private static void dumpCacheInfo(@NonNull PrintWriter pw, @NonNull String[] args) {
        if (!sEnabled) {
            pw.println("  Caching is disabled in this process.");
            return;
        }
        boolean detail = PropertyInvalidatedCache.anyDetailed(args);
        if (sSharedMemoryAvailable) {
            pw.println("  SharedMemory: enabled");
            NonceStore.getInstance().dump(pw, "    ", detail);
        } else {
            pw.println("  SharedMemory: disabled");
        }
        pw.println();
        ArrayList<PropertyInvalidatedCache> activeCaches = PropertyInvalidatedCache.getActiveCaches();
        for (int i = 0; i < activeCaches.size(); ++i) {
            PropertyInvalidatedCache currentCache = activeCaches.get(i);
            currentCache.dumpContents(pw, detail, args);
        }
    }

    @NeverCompile
    public static void dumpCacheInfo(@NonNull ParcelFileDescriptor pfd, @NonNull String[] args) {
        ByteArrayOutputStream barray = new ByteArrayOutputStream();
        PrintWriter bout = new PrintWriter(barray);
        PropertyInvalidatedCache.dumpCacheInfo(bout, args);
        bout.close();
        try {
            FileOutputStream out = new FileOutputStream(pfd.getFileDescriptor());
            barray.writeTo(out);
            out.close();
            barray.close();
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to dump PropertyInvalidatedCache instances");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCacheEntries(@NonNull PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCache.dumpDetailed(pw);
        }
    }

    @FastNative
    private static int nativeGetMaxNonce(long l) {
        return OverrideMethod.invokeI("android.app.PropertyInvalidatedCache#nativeGetMaxNonce(J)I", true, null);
    }

    @FastNative
    private static int nativeGetMaxByte(long l) {
        return OverrideMethod.invokeI("android.app.PropertyInvalidatedCache#nativeGetMaxByte(J)I", true, null);
    }

    @FastNative
    private static void nativeSetByteBlock(long l, int n, @NonNull byte[] byArray) {
        OverrideMethod.invokeV("android.app.PropertyInvalidatedCache#nativeSetByteBlock(JI[B)V", true, null);
    }

    @FastNative
    private static int nativeGetByteBlock(long l, int n, @NonNull byte[] byArray) {
        return OverrideMethod.invokeI("android.app.PropertyInvalidatedCache#nativeGetByteBlock(JI[B)I", true, null);
    }

    @CriticalNative
    private static int nativeGetByteBlockHash(long l) {
        return OverrideMethod.invokeI("android.app.PropertyInvalidatedCache#nativeGetByteBlockHash(J)I", true, null);
    }

    @CriticalNative
    private static boolean nativeSetNonce(long l, int n, long l2) {
        return OverrideMethod.invokeI("android.app.PropertyInvalidatedCache#nativeSetNonce(JIJ)Z", true, null) != 0;
    }

    @CriticalNative
    private static long nativeGetNonce(long l, int n) {
        return OverrideMethod.invokeL("android.app.PropertyInvalidatedCache#nativeGetNonce(JI)J", true, null);
    }

    public static class NonceWatcher
    implements AutoCloseable {
        private final NonceHandler mHandler;
        private long mLastSeen = 0L;
        private final Semaphore mSem = new Semaphore(0);

        private NonceWatcher(@NonNull NonceHandler handler) {
            this.mHandler = handler;
            this.mHandler.registerWatcher(this.mSem);
        }

        @Override
        public void close() {
            this.mHandler.unregisterWatcher(this.mSem);
        }

        public long lastSeen() {
            return this.mLastSeen;
        }

        public boolean isChanged() {
            long current = this.mHandler.getNonce();
            if (current != this.mLastSeen) {
                this.mLastSeen = current;
                return true;
            }
            return false;
        }

        public int waitForChange() throws InterruptedException {
            this.mSem.acquire(1);
            return 1 + this.mSem.drainPermits();
        }

        public int waitForChange(long timeout, TimeUnit timeUnit) throws InterruptedException {
            if (this.mSem.tryAcquire(1, timeout, timeUnit)) {
                return 1 + this.mSem.drainPermits();
            }
            return 0;
        }

        public void wakeUp() {
            this.mSem.release();
        }
    }

    private static abstract class NonceHandler {
        final String mName;
        protected final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private int mInvalidated = 0;
        @GuardedBy(value={"mLock"})
        private int mCorkedInvalidates = 0;
        @GuardedBy(value={"mLock"})
        private int mCorks = 0;
        @GuardedBy(value={"mLock"})
        private boolean mTestMode;
        @GuardedBy(value={"mLock"})
        protected long mShadowNonce = 0L;
        @GuardedBy(value={"mLock"})
        private ArrayList<Semaphore> mWatchers;

        abstract long getNonceInternal();

        abstract void setNonceInternal(long var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        NonceHandler(@NonNull String name) {
            this.mName = name;
            Object object = sGlobalLock;
            synchronized (object) {
                this.mTestMode = sTestMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getNonce() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mTestMode) {
                    return this.mShadowNonce;
                }
            }
            return this.getNonceInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setNonce(long val) {
            Object object = this.mLock;
            synchronized (object) {
                this.mShadowNonce = val;
                if (!this.mTestMode) {
                    this.setNonceInternal(val);
                }
                this.wakeAllWatchersLocked();
            }
        }

        @GuardedBy(value={"mLock"})
        private void wakeAllWatchersLocked() {
            if (this.mWatchers != null) {
                for (int i = 0; i < this.mWatchers.size(); ++i) {
                    this.mWatchers.get(i).release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerWatcher(Semaphore s) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mWatchers == null) {
                    this.mWatchers = new ArrayList();
                }
                this.mWatchers.add(s);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregisterWatcher(Semaphore s) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mWatchers != null) {
                    this.mWatchers.remove(s);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidate() {
            if (!sEnabled) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                long newValue;
                if (this.mCorks > 0) {
                    ++this.mCorkedInvalidates;
                    return;
                }
                long nonce = this.getNonce();
                if (nonce == 1L) {
                    return;
                }
                while (PropertyInvalidatedCache.isReservedNonce(newValue = NoPreloadHolder.next())) {
                }
                this.setNonce(newValue);
                ++this.mInvalidated;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cork() {
            if (!sEnabled) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                int numberCorks = this.mCorks;
                if (numberCorks == 0) {
                    long nonce = this.getNonce();
                    if (nonce != 0L && nonce != 1L) {
                        this.setNonce(2L);
                    }
                } else {
                    ++this.mCorkedInvalidates;
                }
                ++this.mCorks;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void uncork() {
            if (!sEnabled) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                int numberCorks = --this.mCorks;
                if (numberCorks < 0) {
                    throw new AssertionError((Object)("cork underflow: " + this.mName));
                }
                if (numberCorks == 0) {
                    this.invalidate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disable() {
            if (!sEnabled) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                this.setNonce(1L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setTestMode(boolean mode) {
            Object object = this.mLock;
            synchronized (object) {
                this.mTestMode = mode;
                this.mShadowNonce = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Stats getStats() {
            Object object = this.mLock;
            synchronized (object) {
                return new Stats(this.mInvalidated, this.mCorkedInvalidates);
            }
        }

        static class Stats
        extends Record {
            private final int invalidated;
            private final int corkedInvalidates;

            Stats(int invalidated, int corkedInvalidates) {
                this.invalidated = invalidated;
                this.corkedInvalidates = corkedInvalidates;
            }

            @Override
            public String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Stats.class, "invalidated;corkedInvalidates", "invalidated", "corkedInvalidates"}, this);
            }

            @Override
            public int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Stats.class, "invalidated;corkedInvalidates", "invalidated", "corkedInvalidates"}, this);
            }

            @Override
            public boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Stats.class, "invalidated;corkedInvalidates", "invalidated", "corkedInvalidates"}, this, o);
            }

            public int invalidated() {
                return this.invalidated;
            }

            public int corkedInvalidates() {
                return this.corkedInvalidates;
            }
        }
    }

    private static class NonceSharedMem
    extends NonceHandler {
        private volatile NonceStore mStore;
        private volatile int mHandle = -1;
        private final String mShortName;

        NonceSharedMem(@NonNull String name, @Nullable String prefix) {
            super(name);
            this.mShortName = prefix != null && name.startsWith(prefix) ? name.substring(prefix.length()) : name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int initialize(boolean update) {
            Object object = this.mLock;
            synchronized (object) {
                int handle = this.mHandle;
                if (handle == -1) {
                    if (this.mStore == null) {
                        this.mStore = NonceStore.getInstance();
                        if (this.mStore == null) {
                            return -1;
                        }
                    }
                    if (update) {
                        this.mStore.storeName(this.mShortName);
                    }
                    if ((handle = this.mStore.getHandleForName(this.mShortName)) == -1) {
                        return -1;
                    }
                    this.mHandle = handle;
                }
                return handle;
            }
        }

        @Override
        long getNonceInternal() {
            int handle = this.mHandle;
            if (handle == -1 && (handle = this.initialize(false)) == -1) {
                return 0L;
            }
            return this.mStore.getNonce(handle);
        }

        @Override
        void setNonceInternal(long value) {
            int handle = this.mHandle;
            if (handle == -1 && (handle = this.initialize(true)) == -1) {
                throw new IllegalStateException("unable to assign nonce handle: " + this.mName);
            }
            this.mStore.setNonce(handle, value);
        }
    }

    private static class NonceLocal
    extends NonceHandler {
        private long mValue;

        NonceLocal(@NonNull String name) {
            super(name);
        }

        @Override
        long getNonceInternal() {
            return this.mShadowNonce;
        }

        @Override
        void setNonceInternal(long value) {
            this.mShadowNonce = value;
        }
    }

    private static class NonceSysprop
    extends NonceHandler {
        private volatile SystemProperties.Handle mHandle;

        NonceSysprop(@NonNull String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        long getNonceInternal() {
            if (this.mHandle == null) {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mHandle == null) {
                        this.mHandle = SystemProperties.find(this.mName);
                        if (this.mHandle == null) {
                            return 0L;
                        }
                    }
                }
            }
            return this.mHandle.getLong(0L);
        }

        @Override
        void setNonceInternal(long value) {
            String str = Long.toString(value);
            SystemPropertySetter.setWithRetry(this.mName, str);
        }
    }

    public static class Args
    extends Record {
        @NonNull
        private final String mModule;
        @Nullable
        private final String mApi;
        private final int mMaxEntries;
        private final boolean mIsolateUids;
        private final boolean mTestMode;
        private final boolean mCacheNulls;
        public static final int DEFAULT_MAX_ENTRIES = 32;
        public static final boolean DEFAULT_ISOLATE_UIDS = true;
        public static final boolean DEFAULT_CACHE_NULLS = false;

        public Args(@NonNull String mModule, @Nullable String mApi, int mMaxEntries, boolean mIsolateUids, boolean mTestMode, boolean mCacheNulls) {
            PropertyInvalidatedCache.throwIfInvalidModule(mModule);
            Preconditions.checkArgumentPositive(mMaxEntries, "max cache size must be positive");
            this.mModule = mModule;
            this.mApi = mApi;
            this.mMaxEntries = mMaxEntries;
            this.mIsolateUids = mIsolateUids;
            this.mTestMode = mTestMode;
            this.mCacheNulls = mCacheNulls;
        }

        public Args(@NonNull String module) {
            this(module, null, 32, true, false, false);
        }

        public Args api(@NonNull String api) {
            return new Args(this.mModule, api, this.mMaxEntries, this.mIsolateUids, this.mTestMode, this.mCacheNulls);
        }

        public Args maxEntries(int val) {
            return new Args(this.mModule, this.mApi, val, this.mIsolateUids, this.mTestMode, this.mCacheNulls);
        }

        public Args isolateUids(boolean val) {
            return new Args(this.mModule, this.mApi, this.mMaxEntries, val, this.mTestMode, this.mCacheNulls);
        }

        public Args testMode(boolean val) {
            return new Args(this.mModule, this.mApi, this.mMaxEntries, this.mIsolateUids, val, this.mCacheNulls);
        }

        public Args cacheNulls(boolean val) {
            return new Args(this.mModule, this.mApi, this.mMaxEntries, this.mIsolateUids, this.mTestMode, val);
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Args.class, "mModule;mApi;mMaxEntries;mIsolateUids;mTestMode;mCacheNulls", "mModule", "mApi", "mMaxEntries", "mIsolateUids", "mTestMode", "mCacheNulls"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Args.class, "mModule;mApi;mMaxEntries;mIsolateUids;mTestMode;mCacheNulls", "mModule", "mApi", "mMaxEntries", "mIsolateUids", "mTestMode", "mCacheNulls"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Args.class, "mModule;mApi;mMaxEntries;mIsolateUids;mTestMode;mCacheNulls", "mModule", "mApi", "mMaxEntries", "mIsolateUids", "mTestMode", "mCacheNulls"}, this, o);
        }

        @NonNull
        public String mModule() {
            return this.mModule;
        }

        @Nullable
        public String mApi() {
            return this.mApi;
        }

        public int mMaxEntries() {
            return this.mMaxEntries;
        }

        public boolean mIsolateUids() {
            return this.mIsolateUids;
        }

        public boolean mTestMode() {
            return this.mTestMode;
        }

        public boolean mCacheNulls() {
            return this.mCacheNulls;
        }
    }

    private class CacheMap<Query, Result> {
        private final SparseArray<LinkedHashMap<Query, Result>> mCache = new SparseArray();
        private final boolean mIsolated;
        private final boolean mStatistics;
        private final SparseBooleanArray mUidSeen;
        private final ArraySet<Query> mShadowCache;
        private int mShadowHits;
        private int mShadowMisses;
        private int mShadowSelfHits;
        private final int mSelfUid;
        private final boolean mTestMode;

        private LinkedHashMap<Query, Result> createMap() {
            return new LinkedHashMap<Query, Result>(2, 0.75f, true){

                @Override
                @GuardedBy(value={"mLock"})
                protected boolean removeEldestEntry(Map.Entry eldest) {
                    int size = this.size();
                    if ((long)size > PropertyInvalidatedCache.this.mHighWaterMark) {
                        PropertyInvalidatedCache.this.mHighWaterMark = size;
                    }
                    if (size > PropertyInvalidatedCache.this.mMaxEntries) {
                        ++PropertyInvalidatedCache.this.mMissOverflow;
                        return true;
                    }
                    return false;
                }
            };
        }

        CacheMap(boolean isolate, boolean testMode) {
            this.mIsolated = Flags.picIsolateCacheByUid() && isolate;
            boolean bl = this.mStatistics = Flags.picIsolatedCacheStatistics() && this.mIsolated;
            if (this.mStatistics) {
                this.mUidSeen = new SparseBooleanArray();
                this.mShadowCache = new ArraySet();
            } else {
                this.mUidSeen = null;
                this.mShadowCache = null;
            }
            this.mSelfUid = Process.myUid();
            this.mTestMode = testMode;
        }

        private int callerUid() {
            if (!this.mIsolated) {
                return 0;
            }
            if (this.mTestMode) {
                return Binder.getCallingWorkSourceUid();
            }
            return Binder.getCallingUid();
        }

        Result get(Query query) {
            LinkedHashMap<Query, Result> map;
            int uid = this.callerUid();
            if (this.mStatistics) {
                if (this.mShadowCache.contains(query)) {
                    ++this.mShadowHits;
                    if (uid == this.mSelfUid) {
                        ++this.mShadowSelfHits;
                    }
                } else {
                    ++this.mShadowMisses;
                }
            }
            if ((map = this.mCache.get(uid)) != null) {
                return map.get(query);
            }
            return null;
        }

        boolean containsKey(Query query) {
            int uid = this.callerUid();
            LinkedHashMap<Query, Result> map = this.mCache.get(uid);
            if (map != null) {
                return map.containsKey(query);
            }
            return false;
        }

        void remove(Query query) {
            LinkedHashMap<Query, Result> map;
            int uid = this.callerUid();
            if (this.mStatistics) {
                this.mShadowCache.remove(query);
            }
            if ((map = this.mCache.get(uid)) != null) {
                map.remove(query);
            }
        }

        void put(Query query, Result result) {
            LinkedHashMap<Query, Result> map;
            int uid = this.callerUid();
            if (this.mStatistics) {
                this.mShadowCache.add(query);
                this.mUidSeen.put(uid, true);
            }
            if ((map = this.mCache.get(uid)) == null) {
                map = this.createMap();
                this.mCache.put(uid, map);
            }
            map.put(query, result);
        }

        int size() {
            int total = 0;
            for (int i = 0; i < this.mCache.size(); ++i) {
                LinkedHashMap<Query, Result> map = this.mCache.valueAt(i);
                total += map.size();
            }
            return total;
        }

        void clear() {
            if (this.mStatistics) {
                this.mShadowCache.clear();
            }
            this.mCache.clear();
        }

        void dump(PrintWriter pw) {
            if (this.mStatistics) {
                pw.println(TextUtils.formatSimple("    ShadowHits: %d, ShadowMisses: %d, ShadowSize: %d", this.mShadowHits, this.mShadowMisses, this.mShadowCache.size()));
                pw.println(TextUtils.formatSimple("    ShadowUids: %d, SelfUid: %d", this.mUidSeen.size(), this.mShadowSelfHits));
            }
        }

        void dumpDetailed(PrintWriter pw) {
            for (int i = 0; i < this.mCache.size(); ++i) {
                int uid = this.mCache.keyAt(i);
                LinkedHashMap<Query, Result> map = this.mCache.valueAt(i);
                Set<Map.Entry<Query, Result>> cacheEntries = map.entrySet();
                if (cacheEntries.size() == 0) break;
                pw.println("    Contents:");
                pw.println(TextUtils.formatSimple("      Uid: %d\n", uid));
                for (Map.Entry<Query, Result> entry : cacheEntries) {
                    String key = Objects.toString(entry.getKey());
                    String value = Objects.toString(entry.getValue());
                    pw.println(TextUtils.formatSimple("      Key: %s\n      Value: %s\n", key, value));
                }
            }
        }
    }

    private static class DefaultComputer<Query, Result>
    extends QueryHandler<Query, Result> {
        final PropertyInvalidatedCache<Query, Result> mCache;

        DefaultComputer(PropertyInvalidatedCache<Query, Result> cache) {
            this.mCache = cache;
        }

        @Override
        public Result apply(Query query) {
            return this.mCache.recompute(query);
        }
    }

    public static abstract class QueryHandler<Q, R> {
        @Nullable
        public abstract R apply(@NonNull Q var1);

        public boolean shouldBypassCache(@NonNull Q query) {
            return false;
        }
    }

    @VisibleForTesting
    public static class NonceStore {
        private final Object mLock = new Object();
        private final long mPtr;
        private final boolean mMutable;
        private static final int MAX_STRING_LENGTH = 63;
        @GuardedBy(value={"mLock"})
        private int mBlockHash = 0;
        @VisibleForTesting
        public final int mMaxNonce;
        @VisibleForTesting
        public final int mMaxByte;
        private static Object sLock = new Object();
        private static NonceStore sInstance;
        public static final int INVALID_NONCE_INDEX = -1;
        @GuardedBy(value={"mLock"})
        private int mHighestIndex = -1;
        @GuardedBy(value={"mLock"})
        private int mStringBytes = 0;
        @GuardedBy(value={"mLock"})
        private int mPartialReads = 0;
        @GuardedBy(value={"mLock"})
        private int mStringUpdated = 0;
        @GuardedBy(value={"mLock"})
        private final ArrayMap<String, Integer> mStringHandle = new ArrayMap();

        @VisibleForTesting
        public NonceStore(long ptr, boolean mutable) {
            this.mPtr = ptr;
            this.mMutable = mutable;
            this.mMaxByte = PropertyInvalidatedCache.nativeGetMaxByte(ptr);
            this.mMaxNonce = PropertyInvalidatedCache.nativeGetMaxNonce(ptr);
            this.refreshStringBlockLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static NonceStore getInstance() {
            Object object = sLock;
            synchronized (object) {
                if (sInstance == null) {
                    try {
                        ApplicationSharedMemory shmem = ApplicationSharedMemory.getInstance();
                        sInstance = shmem == null ? null : new NonceStore(shmem.getSystemNonceBlock(), shmem.isMutable());
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                return sInstance;
            }
        }

        @GuardedBy(value={"mLock"})
        private void updateStringMapLocked(byte[] block) {
            int index = 0;
            int offset = 0;
            while (offset < block.length && block[offset] != 0) {
                if (index > this.mHighestIndex) {
                    String s = new String(block, offset + 1, (int)block[offset]);
                    this.mStringHandle.put(s, index);
                    this.mHighestIndex = index;
                }
                offset += block[offset] + 1;
                ++index;
            }
            this.mStringBytes = offset;
        }

        @GuardedBy(value={"mLock"})
        private void appendStringToMapLocked(@NonNull String str, @NonNull byte[] block) {
            int offset;
            for (offset = 0; offset < block.length && block[offset] != 0; offset += block[offset] + 1) {
            }
            byte[] strBytes = str.getBytes();
            if (offset + strBytes.length >= block.length) {
                return;
            }
            block[offset] = (byte)strBytes.length;
            System.arraycopy(strBytes, 0, block, offset + 1, strBytes.length);
            this.mBlockHash = Arrays.hashCode(block);
        }

        @GuardedBy(value={"mLock"})
        private void refreshStringBlockLocked() {
            if (this.mBlockHash == PropertyInvalidatedCache.nativeGetByteBlockHash(this.mPtr)) {
                return;
            }
            byte[] block = new byte[this.mMaxByte];
            int hash = PropertyInvalidatedCache.nativeGetByteBlock(this.mPtr, this.mBlockHash, block);
            if (hash != Arrays.hashCode(block)) {
                this.mBlockHash = 0;
                ++this.mPartialReads;
                return;
            }
            ++this.mStringUpdated;
            this.mBlockHash = hash;
            this.updateStringMapLocked(block);
        }

        private static void throwIfBadString(@NonNull String s) {
            if (s.length() == 0) {
                throw new IllegalArgumentException("cannot store an empty string");
            }
            if (s.length() > 63) {
                throw new IllegalArgumentException("cannot store a string longer than 63");
            }
        }

        @GuardedBy(value={"mLock"})
        private void throwIfBadHandle(int handle) {
            if (handle < 0 || handle > this.mHighestIndex) {
                throw new IllegalArgumentException("invalid nonce handle: " + handle);
            }
        }

        private void throwIfImmutable() {
            if (!this.mMutable) {
                throw new RuntimeException("write permission denied");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int storeName(@NonNull String str) {
            Object object = this.mLock;
            synchronized (object) {
                Integer handle = this.mStringHandle.get(str);
                if (handle == null) {
                    this.throwIfImmutable();
                    NonceStore.throwIfBadString(str);
                    if (this.mHighestIndex + 1 >= this.mMaxNonce) {
                        throw new RuntimeException("nonce limit exceeded");
                    }
                    byte[] block = new byte[this.mMaxByte];
                    PropertyInvalidatedCache.nativeGetByteBlock(this.mPtr, 0, block);
                    this.appendStringToMapLocked(str, block);
                    PropertyInvalidatedCache.nativeSetByteBlock(this.mPtr, this.mBlockHash, block);
                    this.updateStringMapLocked(block);
                    handle = this.mStringHandle.get(str);
                }
                return handle;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getHandleForName(@NonNull String str) {
            Object object = this.mLock;
            synchronized (object) {
                Integer handle = this.mStringHandle.get(str);
                if (handle == null) {
                    this.refreshStringBlockLocked();
                    handle = this.mStringHandle.get(str);
                }
                return handle != null ? handle : -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setNonce(int handle, long value) {
            Object object = this.mLock;
            synchronized (object) {
                this.throwIfBadHandle(handle);
                this.throwIfImmutable();
                return PropertyInvalidatedCache.nativeSetNonce(this.mPtr, handle, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNonce(int handle) {
            Object object = this.mLock;
            synchronized (object) {
                this.throwIfBadHandle(handle);
                return PropertyInvalidatedCache.nativeGetNonce(this.mPtr, handle);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(@NonNull PrintWriter pw, @NonNull String prefix, boolean detailed) {
            Object object = this.mLock;
            synchronized (object) {
                pw.println(TextUtils.formatSimple("%sStringsMapped: %d, BytesUsed: %d", prefix, this.mHighestIndex, this.mStringBytes));
                pw.println(TextUtils.formatSimple("%sPartialReads: %d, StringUpdates: %d", prefix, this.mPartialReads, this.mStringUpdated));
                if (detailed) {
                    for (String s : this.mStringHandle.keySet()) {
                        int h = this.mStringHandle.get(s);
                        pw.println(TextUtils.formatSimple("%sHandle:%d Name:%s", prefix, h, s));
                    }
                }
            }
        }
    }

    public static class AutoCorker {
        public static final int DEFAULT_AUTO_CORK_DELAY_MS = 50;
        private final String mPropertyName;
        private final int mAutoCorkDelayMs;
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private long mUncorkDeadlineMs = -1L;
        @GuardedBy(value={"mLock"})
        private Handler mHandler;
        private NonceHandler mNonce;

        public AutoCorker(@NonNull String propertyName) {
            this(propertyName, 50);
        }

        public AutoCorker(@NonNull String propertyName, int autoCorkDelayMs) {
            if (PropertyInvalidatedCache.separatePermissionNotificationsEnabled()) {
                throw new IllegalStateException("AutoCorking is unavailable");
            }
            this.mPropertyName = propertyName;
            this.mAutoCorkDelayMs = autoCorkDelayMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void autoCork() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mNonce == null) {
                    this.mNonce = PropertyInvalidatedCache.getNonceHandler(this.mPropertyName);
                }
            }
            if (AutoCorker.getLooper() == null) {
                this.mNonce.invalidate();
                return;
            }
            object = this.mLock;
            synchronized (object) {
                boolean alreadyQueued = this.mUncorkDeadlineMs >= 0L;
                this.mUncorkDeadlineMs = SystemClock.uptimeMillis() + (long)this.mAutoCorkDelayMs;
                if (!alreadyQueued) {
                    this.getHandlerLocked().sendEmptyMessageAtTime(0, this.mUncorkDeadlineMs);
                    this.mNonce.cork();
                } else {
                    this.mNonce.invalidate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(Message msg) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mUncorkDeadlineMs < 0L) {
                    return;
                }
                long nowMs = SystemClock.uptimeMillis();
                if (this.mUncorkDeadlineMs > nowMs) {
                    this.mUncorkDeadlineMs = nowMs + (long)this.mAutoCorkDelayMs;
                    this.getHandlerLocked().sendEmptyMessageAtTime(0, this.mUncorkDeadlineMs);
                    return;
                }
                this.mUncorkDeadlineMs = -1L;
                this.mNonce.uncork();
            }
        }

        @GuardedBy(value={"mLock"})
        private Handler getHandlerLocked() {
            if (this.mHandler == null) {
                this.mHandler = new Handler(AutoCorker.getLooper()){

                    @Override
                    public void handleMessage(Message msg) {
                        this.handleMessage(msg);
                    }
                };
            }
            return this.mHandler;
        }

        private static Looper getLooper() {
            return BackgroundThread.getHandler().getLooper();
        }
    }

    private static class NoPreloadHolder {
        private static final AtomicLong sNextNonce = new AtomicLong(new Random().nextLong());

        private NoPreloadHolder() {
        }

        public static long next() {
            return sNextNonce.getAndIncrement();
        }
    }
}

