/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityManager;
import android.app.AppCompatTaskInfo;
import android.app.PictureInPictureParams;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Intent;
import android.content.LocusId;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.IBinder;
import android.os.Parcel;
import android.window.WindowContainerToken;
import java.util.ArrayList;
import java.util.Objects;

public class TaskInfo {
    private static final String TAG = "TaskInfo";
    public static final int PROPERTY_VALUE_UNSET = -1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int userId;
    public int taskId;
    public int effectiveUid;
    public boolean isRunning;
    @NonNull
    public Intent baseIntent;
    @Nullable
    public ComponentName baseActivity;
    @Nullable
    public ComponentName topActivity;
    @Nullable
    public ComponentName origActivity;
    @Nullable
    public ComponentName realActivity;
    public int numActivities;
    @UnsupportedAppUsage
    public long lastActiveTime;
    public int displayId;
    public int displayAreaFeatureId = -1;
    @Nullable
    public ActivityManager.TaskDescription taskDescription;
    @Nullable
    public LocusId mTopActivityLocusId;
    public boolean supportsMultiWindow;
    @UnsupportedAppUsage
    public int resizeMode;
    @NonNull
    @UnsupportedAppUsage
    public final Configuration configuration = new Configuration();
    @NonNull
    public WindowContainerToken token;
    @Nullable
    public PictureInPictureParams pictureInPictureParams;
    public boolean shouldDockBigOverlays;
    public int launchIntoPipHostTaskId;
    public int lastParentTaskIdBeforePip;
    @Nullable
    public Rect displayCutoutInsets;
    public int topActivityType;
    @Nullable
    public ActivityInfo topActivityInfo;
    public boolean isResizeable;
    public int minWidth;
    public int minHeight;
    public int defaultMinSize;
    public Point positionInParent;
    public ArrayList<IBinder> launchCookies = new ArrayList();
    public int parentTaskId;
    public boolean isFocused;
    public boolean isVisible;
    public boolean isVisibleRequested;
    public boolean isTopActivityNoDisplay;
    public boolean isSleeping;
    public boolean isTopActivityTransparent;
    public boolean isActivityStackTransparent;
    public Rect lastNonFullscreenBounds;
    @Nullable
    public Uri capturedLink;
    public long capturedLinkTimestamp;
    public int requestedVisibleTypes;
    public long topActivityRequestOpenInBrowserEducationTimestamp;
    public AppCompatTaskInfo appCompatTaskInfo = AppCompatTaskInfo.create();
    @Nullable
    public Rect topActivityMainWindowFrame;

    TaskInfo() {
    }

    public TaskInfo(Parcel source) {
        this.readTaskFromParcel(source);
    }

    public int getTaskId() {
        return this.taskId;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @NonNull
    public WindowContainerToken getToken() {
        return this.token;
    }

    @NonNull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public PictureInPictureParams getPictureInPictureParams() {
        return this.pictureInPictureParams;
    }

    public boolean shouldDockBigOverlays() {
        return this.shouldDockBigOverlays;
    }

    public int getWindowingMode() {
        return this.configuration.windowConfiguration.getWindowingMode();
    }

    public boolean isFreeform() {
        return this.configuration.windowConfiguration.getWindowingMode() == 5;
    }

    public int getActivityType() {
        return this.configuration.windowConfiguration.getActivityType();
    }

    public void addLaunchCookie(IBinder cookie) {
        if (cookie == null || this.launchCookies.contains(cookie)) {
            return;
        }
        this.launchCookies.add(cookie);
    }

    public boolean containsLaunchCookie(@NonNull IBinder cookie) {
        return this.launchCookies.contains(cookie);
    }

    public int getParentTaskId() {
        return this.parentTaskId;
    }

    public boolean hasParentTask() {
        return this.parentTaskId != -1;
    }

    public int getDisplayId() {
        return this.displayId;
    }

    public boolean equalsForTaskOrganizer(@Nullable TaskInfo that) {
        if (that == null) {
            return false;
        }
        return this.topActivityType == that.topActivityType && this.isResizeable == that.isResizeable && this.supportsMultiWindow == that.supportsMultiWindow && this.displayAreaFeatureId == that.displayAreaFeatureId && Objects.equals(this.positionInParent, that.positionInParent) && Objects.equals(this.pictureInPictureParams, that.pictureInPictureParams) && Objects.equals(this.shouldDockBigOverlays, that.shouldDockBigOverlays) && Objects.equals(this.displayCutoutInsets, that.displayCutoutInsets) && this.getWindowingMode() == that.getWindowingMode() && this.configuration.uiMode == that.configuration.uiMode && Objects.equals(this.taskDescription, that.taskDescription) && this.isFocused == that.isFocused && this.isVisible == that.isVisible && this.isVisibleRequested == that.isVisibleRequested && this.isTopActivityNoDisplay == that.isTopActivityNoDisplay && this.isSleeping == that.isSleeping && Objects.equals(this.mTopActivityLocusId, that.mTopActivityLocusId) && this.parentTaskId == that.parentTaskId && Objects.equals(this.topActivity, that.topActivity) && this.isTopActivityTransparent == that.isTopActivityTransparent && this.isActivityStackTransparent == that.isActivityStackTransparent && Objects.equals(this.lastNonFullscreenBounds, that.lastNonFullscreenBounds) && Objects.equals(this.capturedLink, that.capturedLink) && this.capturedLinkTimestamp == that.capturedLinkTimestamp && this.requestedVisibleTypes == that.requestedVisibleTypes && this.topActivityRequestOpenInBrowserEducationTimestamp == that.topActivityRequestOpenInBrowserEducationTimestamp && this.appCompatTaskInfo.equalsForTaskOrganizer(that.appCompatTaskInfo) && Objects.equals(this.topActivityMainWindowFrame, that.topActivityMainWindowFrame);
    }

    public boolean equalsForCompatUi(@Nullable TaskInfo that) {
        if (that == null) {
            return false;
        }
        boolean hasCompatUI = this.appCompatTaskInfo.hasCompatUI();
        return !(this.displayId != that.displayId || this.taskId != that.taskId || this.isFocused != that.isFocused || this.isTopActivityTransparent != that.isTopActivityTransparent || !this.appCompatTaskInfo.equalsForCompatUi(that.appCompatTaskInfo) || hasCompatUI && !this.configuration.windowConfiguration.getBounds().equals(that.configuration.windowConfiguration.getBounds()) || hasCompatUI && this.configuration.getLayoutDirection() != that.configuration.getLayoutDirection() || hasCompatUI && this.configuration.uiMode != that.configuration.uiMode || hasCompatUI && this.isVisible != that.isVisible);
    }

    void readTaskFromParcel(Parcel source) {
        this.userId = source.readInt();
        this.taskId = source.readInt();
        this.effectiveUid = source.readInt();
        this.displayId = source.readInt();
        this.isRunning = source.readBoolean();
        this.baseIntent = source.readTypedObject(Intent.CREATOR);
        this.baseActivity = ComponentName.readFromParcel(source);
        this.topActivity = ComponentName.readFromParcel(source);
        this.origActivity = ComponentName.readFromParcel(source);
        this.realActivity = ComponentName.readFromParcel(source);
        this.numActivities = source.readInt();
        this.lastActiveTime = source.readLong();
        this.taskDescription = source.readTypedObject(ActivityManager.TaskDescription.CREATOR);
        this.supportsMultiWindow = source.readBoolean();
        this.resizeMode = source.readInt();
        this.configuration.readFromParcel(source);
        this.token = WindowContainerToken.CREATOR.createFromParcel(source);
        this.topActivityType = source.readInt();
        this.pictureInPictureParams = source.readTypedObject(PictureInPictureParams.CREATOR);
        this.shouldDockBigOverlays = source.readBoolean();
        this.launchIntoPipHostTaskId = source.readInt();
        this.lastParentTaskIdBeforePip = source.readInt();
        this.displayCutoutInsets = source.readTypedObject(Rect.CREATOR);
        this.topActivityInfo = source.readTypedObject(ActivityInfo.CREATOR);
        this.isResizeable = source.readBoolean();
        this.minWidth = source.readInt();
        this.minHeight = source.readInt();
        this.defaultMinSize = source.readInt();
        source.readBinderList(this.launchCookies);
        this.positionInParent = source.readTypedObject(Point.CREATOR);
        this.parentTaskId = source.readInt();
        this.isFocused = source.readBoolean();
        this.isVisible = source.readBoolean();
        this.isVisibleRequested = source.readBoolean();
        this.isTopActivityNoDisplay = source.readBoolean();
        this.isSleeping = source.readBoolean();
        this.mTopActivityLocusId = source.readTypedObject(LocusId.CREATOR);
        this.displayAreaFeatureId = source.readInt();
        this.isTopActivityTransparent = source.readBoolean();
        this.isActivityStackTransparent = source.readBoolean();
        this.lastNonFullscreenBounds = source.readTypedObject(Rect.CREATOR);
        this.capturedLink = source.readTypedObject(Uri.CREATOR);
        this.capturedLinkTimestamp = source.readLong();
        this.requestedVisibleTypes = source.readInt();
        this.topActivityRequestOpenInBrowserEducationTimestamp = source.readLong();
        this.appCompatTaskInfo = source.readTypedObject(AppCompatTaskInfo.CREATOR);
        this.topActivityMainWindowFrame = source.readTypedObject(Rect.CREATOR);
    }

    public void writeTaskToParcel(Parcel dest, int flags) {
        dest.writeInt(this.userId);
        dest.writeInt(this.taskId);
        dest.writeInt(this.effectiveUid);
        dest.writeInt(this.displayId);
        dest.writeBoolean(this.isRunning);
        dest.writeTypedObject(this.baseIntent, 0);
        ComponentName.writeToParcel(this.baseActivity, dest);
        ComponentName.writeToParcel(this.topActivity, dest);
        ComponentName.writeToParcel(this.origActivity, dest);
        ComponentName.writeToParcel(this.realActivity, dest);
        dest.writeInt(this.numActivities);
        dest.writeLong(this.lastActiveTime);
        dest.writeTypedObject(this.taskDescription, flags);
        dest.writeBoolean(this.supportsMultiWindow);
        dest.writeInt(this.resizeMode);
        this.configuration.writeToParcel(dest, flags);
        this.token.writeToParcel(dest, flags);
        dest.writeInt(this.topActivityType);
        dest.writeTypedObject(this.pictureInPictureParams, flags);
        dest.writeBoolean(this.shouldDockBigOverlays);
        dest.writeInt(this.launchIntoPipHostTaskId);
        dest.writeInt(this.lastParentTaskIdBeforePip);
        dest.writeTypedObject(this.displayCutoutInsets, flags);
        dest.writeTypedObject(this.topActivityInfo, flags);
        dest.writeBoolean(this.isResizeable);
        dest.writeInt(this.minWidth);
        dest.writeInt(this.minHeight);
        dest.writeInt(this.defaultMinSize);
        dest.writeBinderList(this.launchCookies);
        dest.writeTypedObject(this.positionInParent, flags);
        dest.writeInt(this.parentTaskId);
        dest.writeBoolean(this.isFocused);
        dest.writeBoolean(this.isVisible);
        dest.writeBoolean(this.isVisibleRequested);
        dest.writeBoolean(this.isTopActivityNoDisplay);
        dest.writeBoolean(this.isSleeping);
        dest.writeTypedObject(this.mTopActivityLocusId, flags);
        dest.writeInt(this.displayAreaFeatureId);
        dest.writeBoolean(this.isTopActivityTransparent);
        dest.writeBoolean(this.isActivityStackTransparent);
        dest.writeTypedObject(this.lastNonFullscreenBounds, flags);
        dest.writeTypedObject(this.capturedLink, flags);
        dest.writeLong(this.capturedLinkTimestamp);
        dest.writeInt(this.requestedVisibleTypes);
        dest.writeLong(this.topActivityRequestOpenInBrowserEducationTimestamp);
        dest.writeTypedObject(this.appCompatTaskInfo, flags);
        dest.writeTypedObject(this.topActivityMainWindowFrame, flags);
    }

    public String toString() {
        return "TaskInfo{userId=" + this.userId + " taskId=" + this.taskId + " effectiveUid=" + this.effectiveUid + " displayId=" + this.displayId + " isRunning=" + this.isRunning + " baseIntent=" + this.baseIntent + " baseActivity=" + this.baseActivity + " topActivity=" + this.topActivity + " origActivity=" + this.origActivity + " realActivity=" + this.realActivity + " numActivities=" + this.numActivities + " lastActiveTime=" + this.lastActiveTime + " supportsMultiWindow=" + this.supportsMultiWindow + " resizeMode=" + this.resizeMode + " isResizeable=" + this.isResizeable + " minWidth=" + this.minWidth + " minHeight=" + this.minHeight + " defaultMinSize=" + this.defaultMinSize + " token=" + this.token + " topActivityType=" + this.topActivityType + " pictureInPictureParams=" + this.pictureInPictureParams + " shouldDockBigOverlays=" + this.shouldDockBigOverlays + " launchIntoPipHostTaskId=" + this.launchIntoPipHostTaskId + " lastParentTaskIdBeforePip=" + this.lastParentTaskIdBeforePip + " displayCutoutSafeInsets=" + this.displayCutoutInsets + " topActivityInfo=" + this.topActivityInfo + " launchCookies=" + this.launchCookies + " positionInParent=" + this.positionInParent + " parentTaskId=" + this.parentTaskId + " isFocused=" + this.isFocused + " isVisible=" + this.isVisible + " isVisibleRequested=" + this.isVisibleRequested + " isTopActivityNoDisplay=" + this.isTopActivityNoDisplay + " isSleeping=" + this.isSleeping + " locusId=" + this.mTopActivityLocusId + " displayAreaFeatureId=" + this.displayAreaFeatureId + " isTopActivityTransparent=" + this.isTopActivityTransparent + " isActivityStackTransparent=" + this.isActivityStackTransparent + " lastNonFullscreenBounds=" + this.lastNonFullscreenBounds + " capturedLink=" + this.capturedLink + " capturedLinkTimestamp=" + this.capturedLinkTimestamp + " requestedVisibleTypes=" + this.requestedVisibleTypes + " topActivityRequestOpenInBrowserEducationTimestamp=" + this.topActivityRequestOpenInBrowserEducationTimestamp + " appCompatTaskInfo=" + this.appCompatTaskInfo + " topActivityMainWindowFrame=" + this.topActivityMainWindowFrame + "}";
    }
}

