/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class WaitResult
implements Parcelable {
    public static final int LAUNCH_STATE_UNKNOWN = 0;
    public static final int LAUNCH_STATE_COLD = 1;
    public static final int LAUNCH_STATE_WARM = 2;
    public static final int LAUNCH_STATE_HOT = 3;
    public static final int LAUNCH_STATE_RELAUNCH = 4;
    public static final int INVALID_DELAY = -1;
    public int result;
    public boolean timeout;
    public ComponentName who;
    public long totalTime;
    public int launchState;
    @NonNull
    public static final Parcelable.Creator<WaitResult> CREATOR = new Parcelable.Creator<WaitResult>(){

        @Override
        public WaitResult createFromParcel(Parcel source) {
            return new WaitResult(source);
        }

        public WaitResult[] newArray(int size) {
            return new WaitResult[size];
        }
    };

    public WaitResult() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.result);
        dest.writeInt(this.timeout ? 1 : 0);
        ComponentName.writeToParcel(this.who, dest);
        dest.writeLong(this.totalTime);
        dest.writeInt(this.launchState);
    }

    private WaitResult(Parcel source) {
        this.result = source.readInt();
        this.timeout = source.readInt() != 0;
        this.who = ComponentName.readFromParcel(source);
        this.totalTime = source.readLong();
        this.launchState = source.readInt();
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "WaitResult:");
        pw.println(prefix + "  result=" + this.result);
        pw.println(prefix + "  timeout=" + this.timeout);
        pw.println(prefix + "  who=" + this.who);
        pw.println(prefix + "  totalTime=" + this.totalTime);
        pw.println(prefix + "  launchState=" + this.launchState);
    }

    public static String launchStateToString(int type) {
        switch (type) {
            case 1: {
                return "COLD";
            }
            case 2: {
                return "WARM";
            }
            case 3: {
                return "HOT";
            }
            case 4: {
                return "RELAUNCH";
            }
        }
        return "UNKNOWN (" + type + ")";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LaunchState {
    }
}

