/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.admin.DevicePolicyDrawableResource;
import android.app.admin.DevicePolicyStringResource;
import android.app.admin.IDevicePolicyManager;
import android.app.admin.ParcelableResource;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.RemoteException;
import android.provider.DeviceConfig;
import android.util.Log;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class DevicePolicyResourcesManager {
    private static String TAG = "DevicePolicyResourcesManager";
    private static String DISABLE_RESOURCES_UPDATABILITY_FLAG = "disable_resources_updatability";
    private static boolean DEFAULT_DISABLE_RESOURCES_UPDATABILITY = false;
    private final Context mContext;
    private final IDevicePolicyManager mService;

    protected DevicePolicyResourcesManager(Context context, IDevicePolicyManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DEVICE_MANAGEMENT_RESOURCES")
    public void setDrawables(@NonNull Set<DevicePolicyDrawableResource> drawables) {
        if (this.mService != null) {
            try {
                this.mService.setDrawables(new ArrayList<DevicePolicyDrawableResource>(drawables));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DEVICE_MANAGEMENT_RESOURCES")
    public void resetDrawables(@NonNull Set<String> drawableIds) {
        if (this.mService != null) {
            try {
                this.mService.resetDrawables(new ArrayList<String>(drawableIds));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Nullable
    public Drawable getDrawable(@NonNull String drawableId, @NonNull String drawableStyle, @NonNull Supplier<Drawable> defaultDrawableLoader) {
        return this.getDrawable(drawableId, drawableStyle, "UNDEFINED", defaultDrawableLoader);
    }

    @Nullable
    public Drawable getDrawable(@NonNull String drawableId, @NonNull String drawableStyle, @NonNull String drawableSource, @NonNull Supplier<Drawable> defaultDrawableLoader) {
        Objects.requireNonNull(drawableId, "drawableId can't be null");
        Objects.requireNonNull(drawableStyle, "drawableStyle can't be null");
        Objects.requireNonNull(drawableSource, "drawableSource can't be null");
        Objects.requireNonNull(defaultDrawableLoader, "defaultDrawableLoader can't be null");
        if (drawableId.equals("UNDEFINED") || DeviceConfig.getBoolean("device_policy_manager", DISABLE_RESOURCES_UPDATABILITY_FLAG, DEFAULT_DISABLE_RESOURCES_UPDATABILITY)) {
            return ParcelableResource.loadDefaultDrawable(defaultDrawableLoader);
        }
        if (this.mService != null) {
            try {
                ParcelableResource resource = this.mService.getDrawable(drawableId, drawableStyle, drawableSource);
                if (resource == null) {
                    return ParcelableResource.loadDefaultDrawable(defaultDrawableLoader);
                }
                return resource.getDrawable(this.mContext, 0, defaultDrawableLoader);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error getting the updated drawable from DevicePolicyManagerService.", e);
                return ParcelableResource.loadDefaultDrawable(defaultDrawableLoader);
            }
        }
        return ParcelableResource.loadDefaultDrawable(defaultDrawableLoader);
    }

    @Nullable
    public Drawable getDrawableForDensity(@NonNull String drawableId, @NonNull String drawableStyle, int density, @NonNull Supplier<Drawable> defaultDrawableLoader) {
        return this.getDrawableForDensity(drawableId, drawableStyle, "UNDEFINED", density, defaultDrawableLoader);
    }

    @Nullable
    public Drawable getDrawableForDensity(@NonNull String drawableId, @NonNull String drawableStyle, @NonNull String drawableSource, int density, @NonNull Supplier<Drawable> defaultDrawableLoader) {
        Objects.requireNonNull(drawableId, "drawableId can't be null");
        Objects.requireNonNull(drawableStyle, "drawableStyle can't be null");
        Objects.requireNonNull(drawableSource, "drawableSource can't be null");
        Objects.requireNonNull(defaultDrawableLoader, "defaultDrawableLoader can't be null");
        if (drawableId.equals("UNDEFINED") || DeviceConfig.getBoolean("device_policy_manager", DISABLE_RESOURCES_UPDATABILITY_FLAG, DEFAULT_DISABLE_RESOURCES_UPDATABILITY)) {
            return ParcelableResource.loadDefaultDrawable(defaultDrawableLoader);
        }
        if (this.mService != null) {
            try {
                ParcelableResource resource = this.mService.getDrawable(drawableId, drawableStyle, drawableSource);
                if (resource == null) {
                    return ParcelableResource.loadDefaultDrawable(defaultDrawableLoader);
                }
                return resource.getDrawable(this.mContext, density, defaultDrawableLoader);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error getting the updated drawable from DevicePolicyManagerService.", e);
                return ParcelableResource.loadDefaultDrawable(defaultDrawableLoader);
            }
        }
        return ParcelableResource.loadDefaultDrawable(defaultDrawableLoader);
    }

    @Nullable
    public Icon getDrawableAsIcon(@NonNull String drawableId, @NonNull String drawableStyle, @NonNull String drawableSource, @Nullable Icon defaultIcon) {
        Objects.requireNonNull(drawableId, "drawableId can't be null");
        Objects.requireNonNull(drawableStyle, "drawableStyle can't be null");
        Objects.requireNonNull(drawableSource, "drawableSource can't be null");
        Objects.requireNonNull(defaultIcon, "defaultIcon can't be null");
        if (drawableId.equals("UNDEFINED") || DeviceConfig.getBoolean("device_policy_manager", DISABLE_RESOURCES_UPDATABILITY_FLAG, DEFAULT_DISABLE_RESOURCES_UPDATABILITY)) {
            return defaultIcon;
        }
        if (this.mService != null) {
            try {
                ParcelableResource resource = this.mService.getDrawable(drawableId, drawableStyle, drawableSource);
                if (resource == null) {
                    return defaultIcon;
                }
                return Icon.createWithResource(resource.getPackageName(), resource.getResourceId());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error getting the updated drawable from DevicePolicyManagerService.", e);
                return defaultIcon;
            }
        }
        return defaultIcon;
    }

    @Nullable
    public Icon getDrawableAsIcon(@NonNull String drawableId, @NonNull String drawableStyle, @Nullable Icon defaultIcon) {
        return this.getDrawableAsIcon(drawableId, drawableStyle, "UNDEFINED", defaultIcon);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DEVICE_MANAGEMENT_RESOURCES")
    public void setStrings(@NonNull Set<DevicePolicyStringResource> strings) {
        if (this.mService != null) {
            try {
                this.mService.setStrings(new ArrayList<DevicePolicyStringResource>(strings));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DEVICE_MANAGEMENT_RESOURCES")
    public void resetStrings(@NonNull Set<String> stringIds) {
        if (this.mService != null) {
            try {
                this.mService.resetStrings(new ArrayList<String>(stringIds));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Nullable
    public String getString(@NonNull String stringId, @NonNull Supplier<String> defaultStringLoader) {
        Objects.requireNonNull(stringId, "stringId can't be null");
        Objects.requireNonNull(defaultStringLoader, "defaultStringLoader can't be null");
        if (stringId.equals("UNDEFINED") || DeviceConfig.getBoolean("device_policy_manager", DISABLE_RESOURCES_UPDATABILITY_FLAG, DEFAULT_DISABLE_RESOURCES_UPDATABILITY)) {
            return ParcelableResource.loadDefaultString(defaultStringLoader);
        }
        if (this.mService != null) {
            try {
                ParcelableResource resource = this.mService.getString(stringId);
                if (resource == null) {
                    return ParcelableResource.loadDefaultString(defaultStringLoader);
                }
                return resource.getString(this.mContext, defaultStringLoader);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error getting the updated string from DevicePolicyManagerService.", e);
                return ParcelableResource.loadDefaultString(defaultStringLoader);
            }
        }
        return ParcelableResource.loadDefaultString(defaultStringLoader);
    }

    @Nullable
    @SuppressLint(value={"SamShouldBeLast"})
    public String getString(@NonNull String stringId, @NonNull Supplier<String> defaultStringLoader, Object ... formatArgs) {
        Objects.requireNonNull(stringId, "stringId can't be null");
        Objects.requireNonNull(defaultStringLoader, "defaultStringLoader can't be null");
        if (stringId.equals("UNDEFINED") || DeviceConfig.getBoolean("device_policy_manager", DISABLE_RESOURCES_UPDATABILITY_FLAG, DEFAULT_DISABLE_RESOURCES_UPDATABILITY)) {
            return ParcelableResource.loadDefaultString(defaultStringLoader);
        }
        if (this.mService != null) {
            try {
                ParcelableResource resource = this.mService.getString(stringId);
                if (resource == null) {
                    return ParcelableResource.loadDefaultString(defaultStringLoader);
                }
                return resource.getString(this.mContext, defaultStringLoader, formatArgs);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error getting the updated string from DevicePolicyManagerService.", e);
                return ParcelableResource.loadDefaultString(defaultStringLoader);
            }
        }
        return ParcelableResource.loadDefaultString(defaultStringLoader);
    }
}

