/*
 * Decompiled with CFR 0.152.
 */
package android.app.ambientcontext;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Parcelling;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;

@SystemApi
public class AmbientContextEvent
implements Parcelable {
    public static final int EVENT_UNKNOWN = 0;
    public static final int EVENT_COUGH = 1;
    public static final int EVENT_SNORE = 2;
    public static final int EVENT_BACK_DOUBLE_TAP = 3;
    public static final int EVENT_VENDOR_WEARABLE_START = 100000;
    public static final String KEY_VENDOR_WEARABLE_EVENT_NAME = "wearable_event_name";
    public static final int LEVEL_UNKNOWN = 0;
    public static final int LEVEL_LOW = 1;
    public static final int LEVEL_MEDIUM_LOW = 2;
    public static final int LEVEL_MEDIUM = 3;
    public static final int LEVEL_MEDIUM_HIGH = 4;
    public static final int LEVEL_HIGH = 5;
    private final int mEventType;
    @NonNull
    private final Instant mStartTime;
    @NonNull
    private final Instant mEndTime;
    private final int mConfidenceLevel;
    private final int mDensityLevel;
    @NonNull
    private final PersistableBundle mVendorData;
    static Parcelling<Instant> sParcellingForStartTime = Parcelling.Cache.get(Parcelling.BuiltIn.ForInstant.class);
    static Parcelling<Instant> sParcellingForEndTime;
    @NonNull
    public static final Parcelable.Creator<AmbientContextEvent> CREATOR;

    private static int defaultEventType() {
        return 0;
    }

    @NonNull
    private static Instant defaultStartTime() {
        return Instant.MIN;
    }

    @NonNull
    private static Instant defaultEndTime() {
        return Instant.MAX;
    }

    private static int defaultConfidenceLevel() {
        return 0;
    }

    private static int defaultDensityLevel() {
        return 0;
    }

    private static PersistableBundle defaultVendorData() {
        return new PersistableBundle();
    }

    public static String eventToString(int value) {
        switch (value) {
            case 0: {
                return "EVENT_UNKNOWN";
            }
            case 1: {
                return "EVENT_COUGH";
            }
            case 2: {
                return "EVENT_SNORE";
            }
            case 3: {
                return "EVENT_BACK_DOUBLE_TAP";
            }
            case 100000: {
                return "EVENT_VENDOR_WEARABLE_START";
            }
        }
        return Integer.toHexString(value);
    }

    public static String levelToString(int value) {
        switch (value) {
            case 0: {
                return "LEVEL_UNKNOWN";
            }
            case 1: {
                return "LEVEL_LOW";
            }
            case 2: {
                return "LEVEL_MEDIUM_LOW";
            }
            case 3: {
                return "LEVEL_MEDIUM";
            }
            case 4: {
                return "LEVEL_MEDIUM_HIGH";
            }
            case 5: {
                return "LEVEL_HIGH";
            }
        }
        return Integer.toHexString(value);
    }

    AmbientContextEvent(int eventType, @NonNull Instant startTime, @NonNull Instant endTime, int confidenceLevel, int densityLevel, @NonNull PersistableBundle vendorData) {
        this.mEventType = eventType;
        AnnotationValidations.validate(EventCode.class, null, this.mEventType);
        this.mStartTime = startTime;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mStartTime);
        this.mEndTime = endTime;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mEndTime);
        this.mConfidenceLevel = confidenceLevel;
        AnnotationValidations.validate(LevelValue.class, null, this.mConfidenceLevel);
        this.mDensityLevel = densityLevel;
        AnnotationValidations.validate(LevelValue.class, null, this.mDensityLevel);
        this.mVendorData = vendorData;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mVendorData);
    }

    public int getEventType() {
        return this.mEventType;
    }

    @NonNull
    public Instant getStartTime() {
        return this.mStartTime;
    }

    @NonNull
    public Instant getEndTime() {
        return this.mEndTime;
    }

    public int getConfidenceLevel() {
        return this.mConfidenceLevel;
    }

    public int getDensityLevel() {
        return this.mDensityLevel;
    }

    @NonNull
    public PersistableBundle getVendorData() {
        return this.mVendorData;
    }

    public String toString() {
        return "AmbientContextEvent { eventType = " + this.mEventType + ", startTime = " + this.mStartTime + ", endTime = " + this.mEndTime + ", confidenceLevel = " + this.mConfidenceLevel + ", densityLevel = " + this.mDensityLevel + ", vendorData = " + this.mVendorData + " }";
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mEventType);
        sParcellingForStartTime.parcel(this.mStartTime, dest, flags);
        sParcellingForEndTime.parcel(this.mEndTime, dest, flags);
        dest.writeInt(this.mConfidenceLevel);
        dest.writeInt(this.mDensityLevel);
        dest.writeTypedObject(this.mVendorData, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AmbientContextEvent(@NonNull Parcel in) {
        int eventType = in.readInt();
        Instant startTime = sParcellingForStartTime.unparcel(in);
        Instant endTime = sParcellingForEndTime.unparcel(in);
        int confidenceLevel = in.readInt();
        int densityLevel = in.readInt();
        PersistableBundle vendorData = in.readTypedObject(PersistableBundle.CREATOR);
        this.mEventType = eventType;
        AnnotationValidations.validate(EventCode.class, null, this.mEventType);
        this.mStartTime = startTime;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mStartTime);
        this.mEndTime = endTime;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mEndTime);
        this.mConfidenceLevel = confidenceLevel;
        AnnotationValidations.validate(LevelValue.class, null, this.mConfidenceLevel);
        this.mDensityLevel = densityLevel;
        AnnotationValidations.validate(LevelValue.class, null, this.mDensityLevel);
        this.mVendorData = vendorData;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mVendorData);
    }

    @Deprecated
    private void __metadata() {
    }

    static {
        if (sParcellingForStartTime == null) {
            sParcellingForStartTime = Parcelling.Cache.put(new Parcelling.BuiltIn.ForInstant());
        }
        if ((sParcellingForEndTime = Parcelling.Cache.get(Parcelling.BuiltIn.ForInstant.class)) == null) {
            sParcellingForEndTime = Parcelling.Cache.put(new Parcelling.BuiltIn.ForInstant());
        }
        CREATOR = new Parcelable.Creator<AmbientContextEvent>(){

            public AmbientContextEvent[] newArray(int size) {
                return new AmbientContextEvent[size];
            }

            @Override
            public AmbientContextEvent createFromParcel(@NonNull Parcel in) {
                return new AmbientContextEvent(in);
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LevelValue {
    }

    public static class Builder {
        private int mEventType;
        @NonNull
        private Instant mStartTime;
        @NonNull
        private Instant mEndTime;
        private int mConfidenceLevel;
        private int mDensityLevel;
        @NonNull
        private PersistableBundle mVendorData;
        private long mBuilderFieldsSet = 0L;

        @NonNull
        public Builder setEventType(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mEventType = value;
            return this;
        }

        @NonNull
        public Builder setStartTime(@NonNull Instant value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mStartTime = value;
            return this;
        }

        @NonNull
        public Builder setEndTime(@NonNull Instant value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mEndTime = value;
            return this;
        }

        @NonNull
        public Builder setConfidenceLevel(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mConfidenceLevel = value;
            return this;
        }

        @NonNull
        public Builder setDensityLevel(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mDensityLevel = value;
            return this;
        }

        @NonNull
        public Builder setVendorData(@NonNull PersistableBundle value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mVendorData = value;
            return this;
        }

        @NonNull
        public AmbientContextEvent build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mEventType = AmbientContextEvent.defaultEventType();
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mStartTime = AmbientContextEvent.defaultStartTime();
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mEndTime = AmbientContextEvent.defaultEndTime();
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mConfidenceLevel = AmbientContextEvent.defaultConfidenceLevel();
            }
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mDensityLevel = AmbientContextEvent.defaultDensityLevel();
            }
            if ((this.mBuilderFieldsSet & 0x20L) == 0L) {
                this.mVendorData = AmbientContextEvent.defaultVendorData();
            }
            AmbientContextEvent o = new AmbientContextEvent(this.mEventType, this.mStartTime, this.mEndTime, this.mConfidenceLevel, this.mDensityLevel, this.mVendorData);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x40L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Level {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Event {
    }
}

