/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appfunctions.GenericDocumentWrapper;
import android.app.appsearch.GenericDocument;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@FlaggedApi(value="android.app.appfunctions.flags.enable_app_function_manager")
public class ExecuteAppFunctionRequest
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<ExecuteAppFunctionRequest> CREATOR = new Parcelable.Creator<ExecuteAppFunctionRequest>(){

        @Override
        public ExecuteAppFunctionRequest createFromParcel(Parcel parcel) {
            String targetPackageName = parcel.readString8();
            String functionIdentifier = parcel.readString8();
            GenericDocumentWrapper parameters = GenericDocumentWrapper.CREATOR.createFromParcel(parcel);
            Bundle extras = parcel.readBundle(Bundle.class.getClassLoader());
            return new ExecuteAppFunctionRequest(targetPackageName, functionIdentifier, extras, parameters);
        }

        public ExecuteAppFunctionRequest[] newArray(int size) {
            return new ExecuteAppFunctionRequest[size];
        }
    };
    @NonNull
    private final String mTargetPackageName;
    @NonNull
    private final String mFunctionIdentifier;
    @NonNull
    private final Bundle mExtras;
    @NonNull
    private final GenericDocumentWrapper mParameters;

    private ExecuteAppFunctionRequest(@NonNull String targetPackageName, @NonNull String functionIdentifier, @NonNull Bundle extras, @NonNull GenericDocumentWrapper parameters) {
        this.mTargetPackageName = Objects.requireNonNull(targetPackageName);
        this.mFunctionIdentifier = Objects.requireNonNull(functionIdentifier);
        this.mExtras = Objects.requireNonNull(extras);
        this.mParameters = Objects.requireNonNull(parameters);
    }

    @NonNull
    public String getTargetPackageName() {
        return this.mTargetPackageName;
    }

    @NonNull
    public String getFunctionIdentifier() {
        return this.mFunctionIdentifier;
    }

    @NonNull
    public GenericDocument getParameters() {
        return this.mParameters.getValue();
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    public int getRequestDataSize() {
        return this.mTargetPackageName.getBytes().length + this.mFunctionIdentifier.getBytes().length + this.mParameters.getDataSize() + this.mExtras.getSize();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mTargetPackageName);
        dest.writeString8(this.mFunctionIdentifier);
        this.mParameters.writeToParcel(dest, flags);
        dest.writeBundle(this.mExtras);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        @NonNull
        private final String mTargetPackageName;
        @NonNull
        private final String mFunctionIdentifier;
        @NonNull
        private Bundle mExtras = Bundle.EMPTY;
        @NonNull
        private GenericDocument mParameters = new GenericDocument.Builder("", "", "").build();

        public Builder(@NonNull String targetPackageName, @NonNull String functionIdentifier) {
            this.mTargetPackageName = Objects.requireNonNull(targetPackageName);
            this.mFunctionIdentifier = Objects.requireNonNull(functionIdentifier);
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = Objects.requireNonNull(extras);
            return this;
        }

        @NonNull
        public Builder setParameters(@NonNull GenericDocument parameters) {
            Objects.requireNonNull(parameters);
            this.mParameters = parameters;
            return this;
        }

        @NonNull
        public ExecuteAppFunctionRequest build() {
            return new ExecuteAppFunctionRequest(this.mTargetPackageName, this.mFunctionIdentifier, this.mExtras, new GenericDocumentWrapper(this.mParameters));
        }
    }
}

