/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.safeparcel.PackageIdentifierParcel;
import java.util.Objects;

public class PackageIdentifier {
    @NonNull
    private final PackageIdentifierParcel mPackageIdentifierParcel;

    public PackageIdentifier(@NonNull String packageName, @NonNull byte[] sha256Certificate) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(sha256Certificate);
        this.mPackageIdentifierParcel = new PackageIdentifierParcel(packageName, sha256Certificate);
    }

    public PackageIdentifier(@NonNull PackageIdentifierParcel packageIdentifierParcel) {
        this.mPackageIdentifierParcel = Objects.requireNonNull(packageIdentifierParcel);
    }

    @NonNull
    public PackageIdentifierParcel getPackageIdentifierParcel() {
        return this.mPackageIdentifierParcel;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageIdentifierParcel.getPackageName();
    }

    @NonNull
    public byte[] getSha256Certificate() {
        return this.mPackageIdentifierParcel.getSha256Certificate();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PackageIdentifier)) {
            return false;
        }
        PackageIdentifier other = (PackageIdentifier)obj;
        return this.mPackageIdentifierParcel.equals(other.getPackageIdentifierParcel());
    }

    public int hashCode() {
        return this.mPackageIdentifierParcel.hashCode();
    }
}

