/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.JoinSpec;
import android.app.appsearch.SearchResult;
import android.app.appsearch.SearchResultPage;
import android.app.appsearch.SearchSessionUtil;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.aidl.AppSearchAttributionSource;
import android.app.appsearch.aidl.AppSearchResultCallback;
import android.app.appsearch.aidl.GetNextPageAidlRequest;
import android.app.appsearch.aidl.GlobalSearchAidlRequest;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.aidl.InvalidateNextPageTokenAidlRequest;
import android.app.appsearch.aidl.SearchAidlRequest;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.util.ExceptionUtil;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class SearchResults
implements Closeable {
    private static final String TAG = "SearchResults";
    private final IAppSearchManager mService;
    private final AppSearchAttributionSource mAttributionSource;
    @Nullable
    private final String mDatabaseName;
    private final String mQueryExpression;
    private final SearchSpec mSearchSpec;
    private final UserHandle mUserHandle;
    private final boolean mIsForEnterprise;
    private long mNextPageToken;
    private boolean mIsFirstLoad = true;
    private boolean mIsClosed = false;

    SearchResults(@NonNull IAppSearchManager service, @NonNull AppSearchAttributionSource attributionSource, @Nullable String databaseName, @NonNull String queryExpression, @NonNull SearchSpec searchSpec, @NonNull UserHandle userHandle, boolean isForEnterprise) {
        this.mService = Objects.requireNonNull(service);
        this.mAttributionSource = Objects.requireNonNull(attributionSource);
        this.mDatabaseName = databaseName;
        this.mQueryExpression = Objects.requireNonNull(queryExpression);
        this.mSearchSpec = Objects.requireNonNull(searchSpec);
        this.mUserHandle = Objects.requireNonNull(userHandle);
        this.mIsForEnterprise = isForEnterprise;
    }

    public void getNextPage(@NonNull Executor executor, @NonNull Consumer<AppSearchResult<List<SearchResult>>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "SearchResults has already been closed");
        try {
            long binderCallStartTimeMillis = SystemClock.elapsedRealtime();
            if (this.mIsFirstLoad) {
                this.mIsFirstLoad = false;
                if (this.mDatabaseName == null) {
                    this.mService.globalSearch(new GlobalSearchAidlRequest(this.mAttributionSource, this.mQueryExpression, this.mSearchSpec, this.mUserHandle, binderCallStartTimeMillis, this.mIsForEnterprise), this.wrapCallback(executor, callback));
                } else {
                    this.mService.search(new SearchAidlRequest(this.mAttributionSource, this.mDatabaseName, this.mQueryExpression, this.mSearchSpec, this.mUserHandle, binderCallStartTimeMillis), this.wrapCallback(executor, callback));
                }
            } else {
                int joinType = 0;
                JoinSpec joinSpec = this.mSearchSpec.getJoinSpec();
                if (joinSpec != null && !joinSpec.getChildPropertyExpression().isEmpty()) {
                    joinType = 1;
                }
                this.mService.getNextPage(new GetNextPageAidlRequest(this.mAttributionSource, this.mDatabaseName, this.mNextPageToken, joinType, this.mUserHandle, binderCallStartTimeMillis, this.mIsForEnterprise), this.wrapCallback(executor, callback));
            }
        }
        catch (RemoteException e) {
            ExceptionUtil.handleRemoteException(e);
        }
    }

    @Override
    public void close() {
        if (!this.mIsClosed) {
            try {
                this.mService.invalidateNextPageToken(new InvalidateNextPageTokenAidlRequest(this.mAttributionSource, this.mNextPageToken, this.mUserHandle, SystemClock.elapsedRealtime(), this.mIsForEnterprise));
                this.mIsClosed = true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to close the SearchResults", e);
            }
        }
    }

    private AppSearchResultCallback<SearchResultPage> wrapCallback(final @NonNull Executor executor, final @NonNull Consumer<AppSearchResult<List<SearchResult>>> callback) {
        return new AppSearchResultCallback<SearchResultPage>(){

            @Override
            public void onResult(@NonNull AppSearchResult<SearchResultPage> result) {
                SearchSessionUtil.safeExecute(executor, callback, () -> SearchResults.this.invokeCallback(result, callback));
            }
        };
    }

    private void invokeCallback(@NonNull AppSearchResult<SearchResultPage> searchResultPageResult, @NonNull Consumer<AppSearchResult<List<SearchResult>>> callback) {
        if (searchResultPageResult.isSuccess()) {
            try {
                SearchResultPage searchResultPage = Objects.requireNonNull(searchResultPageResult.getResultValue());
                this.mNextPageToken = searchResultPage.getNextPageToken();
                callback.accept(AppSearchResult.newSuccessfulResult(searchResultPage.getResults()));
            }
            catch (RuntimeException e) {
                callback.accept(AppSearchResult.throwableToFailedResult(e));
            }
        } else {
            callback.accept(AppSearchResult.newFailedResult(searchResultPageResult));
        }
    }
}

