/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.SuppressLint;
import android.app.appsearch.SchemaVisibilityConfig;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;

@FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
public class SetBlobVisibilityRequest {
    private final Set<String> mNamespacesNotDisplayedBySystem;
    private final Map<String, Set<SchemaVisibilityConfig>> mNamespacesVisibleToConfigs;

    SetBlobVisibilityRequest(@NonNull Set<String> namespacesNotDisplayedBySystem, @NonNull Map<String, Set<SchemaVisibilityConfig>> namespacesVisibleToConfigs) {
        this.mNamespacesNotDisplayedBySystem = Objects.requireNonNull(namespacesNotDisplayedBySystem);
        this.mNamespacesVisibleToConfigs = Objects.requireNonNull(namespacesVisibleToConfigs);
    }

    public @NonNull Set<String> getNamespacesNotDisplayedBySystem() {
        return Collections.unmodifiableSet(this.mNamespacesNotDisplayedBySystem);
    }

    public @NonNull Map<String, Set<SchemaVisibilityConfig>> getNamespacesVisibleToConfigs() {
        return Collections.unmodifiableMap(this.mNamespacesVisibleToConfigs);
    }

    public static class Builder {
        private final ArrayMap<String, Set<SchemaVisibilityConfig>> mNamespacesVisibleToConfigs = new ArrayMap();
        private final ArraySet<String> mNamespacesNotDisplayedBySystem = new ArraySet();

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public @NonNull Builder setNamespaceDisplayedBySystem(@NonNull String namespace, boolean displayed) {
            Objects.requireNonNull(namespace);
            if (displayed) {
                this.mNamespacesNotDisplayedBySystem.remove(namespace);
            } else {
                this.mNamespacesNotDisplayedBySystem.add(namespace);
            }
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public @NonNull Builder addNamespaceVisibleToConfig(@NonNull String namespace, @NonNull SchemaVisibilityConfig visibilityConfig) {
            Objects.requireNonNull(namespace);
            Objects.requireNonNull(visibilityConfig);
            Set<SchemaVisibilityConfig> visibleToConfigs = this.mNamespacesVisibleToConfigs.get(namespace);
            if (visibleToConfigs == null) {
                visibleToConfigs = new ArraySet<SchemaVisibilityConfig>();
                this.mNamespacesVisibleToConfigs.put(namespace, visibleToConfigs);
            }
            visibleToConfigs.add(visibilityConfig);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder clearNamespaceVisibleToConfigs(@NonNull String namespace) {
            Objects.requireNonNull(namespace);
            this.mNamespacesVisibleToConfigs.remove(namespace);
            return this;
        }

        public @NonNull SetBlobVisibilityRequest build() {
            return new SetBlobVisibilityRequest(new ArraySet<String>(this.mNamespacesNotDisplayedBySystem), new ArrayMap<String, Set<SchemaVisibilityConfig>>(this.mNamespacesVisibleToConfigs));
        }
    }
}

