/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.stats;

import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.app.appsearch.stats.SchemaMigrationStatsCreator;
import android.os.Parcel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

@SafeParcelable.Class(creator="SchemaMigrationStatsCreator")
public class SchemaMigrationStats
extends AbstractSafeParcelable {
    public static final  @NonNull Parcelable.Creator<SchemaMigrationStats> CREATOR = new SchemaMigrationStatsCreator();
    public static final int NO_MIGRATION = 0;
    public static final int FIRST_CALL_GET_INCOMPATIBLE = 1;
    public static final int SECOND_CALL_APPLY_NEW_SCHEMA = 2;
    @SafeParcelable.Field(id=1, getter="getPackageName")
    private final @NonNull String mPackageName;
    @SafeParcelable.Field(id=2, getter="getDatabase")
    private final @NonNull String mDatabase;
    @SafeParcelable.Field(id=3, getter="getStatusCode")
    private final int mStatusCode;
    @SafeParcelable.Field(id=4, getter="getExecutorAcquisitionLatencyMillis")
    private final int mExecutorAcquisitionLatencyMillis;
    @SafeParcelable.Field(id=5, getter="getTotalLatencyMillis")
    private final int mTotalLatencyMillis;
    @SafeParcelable.Field(id=6, getter="getGetSchemaLatencyMillis")
    private final int mGetSchemaLatencyMillis;
    @SafeParcelable.Field(id=7, getter="getQueryAndTransformLatencyMillis")
    private final int mQueryAndTransformLatencyMillis;
    @SafeParcelable.Field(id=8, getter="getFirstSetSchemaLatencyMillis")
    private final int mFirstSetSchemaLatencyMillis;
    @SafeParcelable.Field(id=9, getter="isFirstSetSchemaSuccess")
    private final boolean mIsFirstSetSchemaSuccess;
    @SafeParcelable.Field(id=10, getter="getSecondSetSchemaLatencyMillis")
    private final int mSecondSetSchemaLatencyMillis;
    @SafeParcelable.Field(id=11, getter="getSaveDocumentLatencyMillis")
    private final int mSaveDocumentLatencyMillis;
    @SafeParcelable.Field(id=12, getter="getTotalNeedMigratedDocumentCount")
    private final int mTotalNeedMigratedDocumentCount;
    @SafeParcelable.Field(id=13, getter="getMigrationFailureCount")
    private final int mMigrationFailureCount;
    @SafeParcelable.Field(id=14, getter="getTotalSuccessMigratedDocumentCount")
    private final int mTotalSuccessMigratedDocumentCount;
    @SafeParcelable.Field(id=15, getter="getEnabledFeatures")
    private final long mEnabledFeatures;

    @SafeParcelable.Constructor
    public SchemaMigrationStats(@SafeParcelable.Param(id=1) @NonNull String packageName, @SafeParcelable.Param(id=2) @NonNull String database, @SafeParcelable.Param(id=3) int statusCode, @SafeParcelable.Param(id=4) int executorAcquisitionLatencyMillis, @SafeParcelable.Param(id=5) int totalLatencyMillis, @SafeParcelable.Param(id=6) int getSchemaLatencyMillis, @SafeParcelable.Param(id=7) int queryAndTransformLatencyMillis, @SafeParcelable.Param(id=8) int firstSetSchemaLatencyMillis, @SafeParcelable.Param(id=9) boolean isFirstSetSchemaSuccess, @SafeParcelable.Param(id=10) int secondSetSchemaLatencyMillis, @SafeParcelable.Param(id=11) int saveDocumentLatencyMillis, @SafeParcelable.Param(id=12) int totalNeedMigratedDocumentCount, @SafeParcelable.Param(id=13) int migrationFailureCount, @SafeParcelable.Param(id=14) int totalSuccessMigratedDocumentCount, @SafeParcelable.Param(id=15) long enabledFeatures) {
        this.mPackageName = packageName;
        this.mDatabase = database;
        this.mStatusCode = statusCode;
        this.mExecutorAcquisitionLatencyMillis = executorAcquisitionLatencyMillis;
        this.mTotalLatencyMillis = totalLatencyMillis;
        this.mGetSchemaLatencyMillis = getSchemaLatencyMillis;
        this.mQueryAndTransformLatencyMillis = queryAndTransformLatencyMillis;
        this.mFirstSetSchemaLatencyMillis = firstSetSchemaLatencyMillis;
        this.mIsFirstSetSchemaSuccess = isFirstSetSchemaSuccess;
        this.mSecondSetSchemaLatencyMillis = secondSetSchemaLatencyMillis;
        this.mSaveDocumentLatencyMillis = saveDocumentLatencyMillis;
        this.mTotalNeedMigratedDocumentCount = totalNeedMigratedDocumentCount;
        this.mMigrationFailureCount = migrationFailureCount;
        this.mTotalSuccessMigratedDocumentCount = totalSuccessMigratedDocumentCount;
        this.mEnabledFeatures = enabledFeatures;
    }

    public @NonNull String getPackageName() {
        return this.mPackageName;
    }

    public @NonNull String getDatabase() {
        return this.mDatabase;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public int getExecutorAcquisitionLatencyMillis() {
        return this.mExecutorAcquisitionLatencyMillis;
    }

    public int getTotalLatencyMillis() {
        return this.mTotalLatencyMillis;
    }

    public int getGetSchemaLatencyMillis() {
        return this.mGetSchemaLatencyMillis;
    }

    public int getQueryAndTransformLatencyMillis() {
        return this.mQueryAndTransformLatencyMillis;
    }

    public int getFirstSetSchemaLatencyMillis() {
        return this.mFirstSetSchemaLatencyMillis;
    }

    public boolean isFirstSetSchemaSuccess() {
        return this.mIsFirstSetSchemaSuccess;
    }

    public int getSecondSetSchemaLatencyMillis() {
        return this.mSecondSetSchemaLatencyMillis;
    }

    public int getSaveDocumentLatencyMillis() {
        return this.mSaveDocumentLatencyMillis;
    }

    public int getTotalNeedMigratedDocumentCount() {
        return this.mTotalNeedMigratedDocumentCount;
    }

    public int getMigrationFailureCount() {
        return this.mMigrationFailureCount;
    }

    public int getTotalSuccessMigratedDocumentCount() {
        return this.mTotalSuccessMigratedDocumentCount;
    }

    public long getEnabledFeatures() {
        return this.mEnabledFeatures;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        SchemaMigrationStatsCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        String mPackageName;
        String mDatabase;
        int mStatusCode;
        int mExecutorAcquisitionLatencyMillis;
        int mTotalLatencyMillis;
        int mGetSchemaLatencyMillis;
        int mQueryAndTransformLatencyMillis;
        int mFirstSetSchemaLatencyMillis;
        boolean mIsFirstSetSchemaSuccess;
        int mSecondSetSchemaLatencyMillis;
        int mSaveDocumentLatencyMillis;
        int mTotalNeedMigratedDocumentCount;
        int mMigrationFailureCount;
        int mTotalSuccessMigratedDocumentCount;
        long mEnabledFeatures;

        public Builder(@NonNull String packageName, @NonNull String database) {
            this.mPackageName = Objects.requireNonNull(packageName);
            this.mDatabase = Objects.requireNonNull(database);
        }

        public Builder(@NonNull SchemaMigrationStats stats) {
            Objects.requireNonNull(stats);
            this.mPackageName = stats.mPackageName;
            this.mDatabase = stats.mDatabase;
            this.mStatusCode = stats.mStatusCode;
            this.mExecutorAcquisitionLatencyMillis = stats.mExecutorAcquisitionLatencyMillis;
            this.mTotalLatencyMillis = stats.mTotalLatencyMillis;
            this.mGetSchemaLatencyMillis = stats.mGetSchemaLatencyMillis;
            this.mQueryAndTransformLatencyMillis = stats.mQueryAndTransformLatencyMillis;
            this.mFirstSetSchemaLatencyMillis = stats.mFirstSetSchemaLatencyMillis;
            this.mIsFirstSetSchemaSuccess = stats.mIsFirstSetSchemaSuccess;
            this.mSecondSetSchemaLatencyMillis = stats.mSecondSetSchemaLatencyMillis;
            this.mSaveDocumentLatencyMillis = stats.mSaveDocumentLatencyMillis;
            this.mTotalNeedMigratedDocumentCount = stats.mTotalNeedMigratedDocumentCount;
            this.mMigrationFailureCount = stats.mMigrationFailureCount;
            this.mTotalSuccessMigratedDocumentCount = stats.mTotalSuccessMigratedDocumentCount;
            this.mEnabledFeatures = stats.mEnabledFeatures;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setStatusCode(int statusCode) {
            this.mStatusCode = statusCode;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setExecutorAcquisitionLatencyMillis(int executorAcquisitionLatencyMillis) {
            this.mExecutorAcquisitionLatencyMillis = executorAcquisitionLatencyMillis;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setTotalLatencyMillis(int totalLatencyMillis) {
            this.mTotalLatencyMillis = totalLatencyMillis;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setGetSchemaLatencyMillis(int getSchemaLatencyMillis) {
            this.mGetSchemaLatencyMillis = getSchemaLatencyMillis;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setQueryAndTransformLatencyMillis(int queryAndTransformLatencyMillis) {
            this.mQueryAndTransformLatencyMillis = queryAndTransformLatencyMillis;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setFirstSetSchemaLatencyMillis(int firstSetSchemaLatencyMillis) {
            this.mFirstSetSchemaLatencyMillis = firstSetSchemaLatencyMillis;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setIsFirstSetSchemaSuccess(boolean isFirstSetSchemaSuccess) {
            this.mIsFirstSetSchemaSuccess = isFirstSetSchemaSuccess;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setSecondSetSchemaLatencyMillis(int secondSetSchemaLatencyMillis) {
            this.mSecondSetSchemaLatencyMillis = secondSetSchemaLatencyMillis;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setSaveDocumentLatencyMillis(int saveDocumentLatencyMillis) {
            this.mSaveDocumentLatencyMillis = saveDocumentLatencyMillis;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setTotalNeedMigratedDocumentCount(int migratedDocumentCount) {
            this.mTotalNeedMigratedDocumentCount = migratedDocumentCount;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setTotalSuccessMigratedDocumentCount(int totalSuccessMigratedDocumentCount) {
            this.mTotalSuccessMigratedDocumentCount = totalSuccessMigratedDocumentCount;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setMigrationFailureCount(int migrationFailureCount) {
            this.mMigrationFailureCount = migrationFailureCount;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setEnabledFeatures(long enabledFeatures) {
            this.mEnabledFeatures = enabledFeatures;
            return this;
        }

        public @NonNull SchemaMigrationStats build() {
            return new SchemaMigrationStats(this.mPackageName, this.mDatabase, this.mStatusCode, this.mExecutorAcquisitionLatencyMillis, this.mTotalLatencyMillis, this.mGetSchemaLatencyMillis, this.mQueryAndTransformLatencyMillis, this.mFirstSetSchemaLatencyMillis, this.mIsFirstSetSchemaSuccess, this.mSecondSetSchemaLatencyMillis, this.mSaveDocumentLatencyMillis, this.mTotalNeedMigratedDocumentCount, this.mMigrationFailureCount, this.mTotalSuccessMigratedDocumentCount, this.mEnabledFeatures);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SchemaMigrationCallType {
    }
}

