/*
 * Decompiled with CFR 0.152.
 */
package android.app.contextualsearch;

import android.annotation.FlaggedApi;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.contextualsearch.IContextualSearchManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@FlaggedApi(value="android.app.contextualsearch.flags.self_invocation")
public class ContextualSearchManager {
    @SystemApi
    public static final String EXTRA_ENTRYPOINT = "android.app.contextualsearch.extra.ENTRYPOINT";
    @SystemApi
    public static final String EXTRA_FLAG_SECURE_FOUND = "android.app.contextualsearch.extra.FLAG_SECURE_FOUND";
    @SystemApi
    public static final String EXTRA_SCREENSHOT = "android.app.contextualsearch.extra.SCREENSHOT";
    @SystemApi
    public static final String EXTRA_IS_MANAGED_PROFILE_VISIBLE = "android.app.contextualsearch.extra.IS_MANAGED_PROFILE_VISIBLE";
    @SystemApi
    public static final String EXTRA_VISIBLE_PACKAGE_NAMES = "android.app.contextualsearch.extra.VISIBLE_PACKAGE_NAMES";
    public static final String EXTRA_INVOCATION_TIME_MS = "android.app.contextualsearch.extra.INVOCATION_TIME_MS";
    @SystemApi
    public static final String EXTRA_TOKEN = "android.app.contextualsearch.extra.TOKEN";
    public static final String EXTRA_IS_AUDIO_PLAYING = "android.app.contextualsearch.extra.IS_AUDIO_PLAYING";
    @SystemApi
    public static final String ACTION_LAUNCH_CONTEXTUAL_SEARCH = "android.app.contextualsearch.action.LAUNCH_CONTEXTUAL_SEARCH";
    public static final String FEATURE_CONTEXTUAL_SEARCH = "com.google.android.feature.CONTEXTUAL_SEARCH";
    @SystemApi
    public static final int ENTRYPOINT_LONG_PRESS_NAV_HANDLE = 1;
    @SystemApi
    public static final int ENTRYPOINT_LONG_PRESS_HOME = 2;
    @SystemApi
    public static final int ENTRYPOINT_LONG_PRESS_OVERVIEW = 3;
    @SystemApi
    public static final int ENTRYPOINT_OVERVIEW_ACTION = 4;
    @SystemApi
    public static final int ENTRYPOINT_OVERVIEW_MENU = 5;
    @SystemApi
    public static final int ENTRYPOINT_SYSTEM_ACTION = 9;
    @SystemApi
    public static final int ENTRYPOINT_LONG_PRESS_META = 10;
    private static final Set<Integer> VALID_ENTRYPOINT_VALUES = new HashSet<Integer>(Arrays.asList(1, 2, 3, 4, 5, 9, 10));
    private static final String TAG = ContextualSearchManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final IContextualSearchManager mService;

    public ContextualSearchManager() {
        IBinder b = ServiceManager.getService("contextual_search");
        this.mService = IContextualSearchManager.Stub.asInterface(b);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_CONTEXTUAL_SEARCH")
    public void startContextualSearch(int entrypoint) {
        if (!VALID_ENTRYPOINT_VALUES.contains(entrypoint)) {
            throw new IllegalArgumentException("Invalid entrypoint: " + entrypoint);
        }
        try {
            this.mService.startContextualSearch(entrypoint);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.app.contextualsearch.flags.self_invocation")
    public void startContextualSearch() {
        try {
            this.mService.startContextualSearchForForegroundApp();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Entrypoint {
    }
}

