/*
 * Decompiled with CFR 0.152.
 */
package android.app.ondeviceintelligence;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;

public interface IDownloadCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.ondeviceintelligence.IDownloadCallback";

    public void onDownloadStarted(long var1) throws RemoteException;

    public void onDownloadProgress(long var1) throws RemoteException;

    public void onDownloadFailed(int var1, String var2, PersistableBundle var3) throws RemoteException;

    public void onDownloadCompleted(PersistableBundle var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDownloadCallback {
        static final int TRANSACTION_onDownloadStarted = 2;
        static final int TRANSACTION_onDownloadProgress = 3;
        static final int TRANSACTION_onDownloadFailed = 4;
        static final int TRANSACTION_onDownloadCompleted = 5;

        public Stub() {
            this.attachInterface(this, IDownloadCallback.DESCRIPTOR);
        }

        public static IDownloadCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDownloadCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IDownloadCallback) {
                return (IDownloadCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 2: {
                    return "onDownloadStarted";
                }
                case 3: {
                    return "onDownloadProgress";
                }
                case 4: {
                    return "onDownloadFailed";
                }
                case 5: {
                    return "onDownloadCompleted";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDownloadCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 2: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onDownloadStarted(_arg0);
                    break;
                }
                case 3: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onDownloadProgress(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDownloadFailed(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDownloadCompleted(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IDownloadCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDownloadCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDownloadStarted(long bytesToDownload) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDownloadCallback.DESCRIPTOR);
                    _data.writeLong(bytesToDownload);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDownloadProgress(long bytesDownloaded) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDownloadCallback.DESCRIPTOR);
                    _data.writeLong(bytesDownloaded);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDownloadFailed(int failureStatus, String errorMessage, PersistableBundle errorParams) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDownloadCallback.DESCRIPTOR);
                    _data.writeInt(failureStatus);
                    _data.writeString(errorMessage);
                    _data.writeTypedObject(errorParams, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDownloadCompleted(PersistableBundle downloadParams) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDownloadCallback.DESCRIPTOR);
                    _data.writeTypedObject(downloadParams, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDownloadCallback {
        @Override
        public void onDownloadStarted(long bytesToDownload) throws RemoteException {
        }

        @Override
        public void onDownloadProgress(long bytesDownloaded) throws RemoteException {
        }

        @Override
        public void onDownloadFailed(int failureStatus, String errorMessage, PersistableBundle errorParams) throws RemoteException {
        }

        @Override
        public void onDownloadCompleted(PersistableBundle downloadParams) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

